require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_EXTERN_H_)) {
    eval 'sub _UVM_UVM_EXTERN_H_ () {1;}' unless defined(&_UVM_UVM_EXTERN_H_);
    eval 'sub UVM_PROT_MASK () {0x7;}' unless defined(&UVM_PROT_MASK);
    eval 'sub UVM_PROT_NONE () {0x;}' unless defined(&UVM_PROT_NONE);
    eval 'sub UVM_PROT_ALL () {0x7;}' unless defined(&UVM_PROT_ALL);
    eval 'sub UVM_PROT_READ () {0x1;}' unless defined(&UVM_PROT_READ);
    eval 'sub UVM_PROT_WRITE () {0x2;}' unless defined(&UVM_PROT_WRITE);
    eval 'sub UVM_PROT_EXEC () {0x4;}' unless defined(&UVM_PROT_EXEC);
    eval 'sub UVM_PROT_R () {0x1;}' unless defined(&UVM_PROT_R);
    eval 'sub UVM_PROT_W () {0x2;}' unless defined(&UVM_PROT_W);
    eval 'sub UVM_PROT_RW () {0x3;}' unless defined(&UVM_PROT_RW);
    eval 'sub UVM_PROT_X () {0x4;}' unless defined(&UVM_PROT_X);
    eval 'sub UVM_PROT_RX () {0x5;}' unless defined(&UVM_PROT_RX);
    eval 'sub UVM_PROT_WX () {0x6;}' unless defined(&UVM_PROT_WX);
    eval 'sub UVM_PROT_RWX () {0x7;}' unless defined(&UVM_PROT_RWX);
    eval 'sub UVM_INH_MASK () {0x30;}' unless defined(&UVM_INH_MASK);
    eval 'sub UVM_INH_SHARE () {0x;}' unless defined(&UVM_INH_SHARE);
    eval 'sub UVM_INH_COPY () {0x10;}' unless defined(&UVM_INH_COPY);
    eval 'sub UVM_INH_NONE () {0x20;}' unless defined(&UVM_INH_NONE);
    eval 'sub UVM_INH_DONATE () {0x30;}' unless defined(&UVM_INH_DONATE);
    eval 'sub VM_PROT_NONE () {(( &vm_prot_t) 0x);}' unless defined(&VM_PROT_NONE);
    eval 'sub VM_PROT_READ () {(( &vm_prot_t) 0x1);}' unless defined(&VM_PROT_READ);
    eval 'sub VM_PROT_WRITE () {(( &vm_prot_t) 0x2);}' unless defined(&VM_PROT_WRITE);
    eval 'sub VM_PROT_EXECUTE () {(( &vm_prot_t) 0x4);}' unless defined(&VM_PROT_EXECUTE);
    eval 'sub VM_PROT_DEFAULT () {( &VM_PROT_READ| &VM_PROT_WRITE| &VM_PROT_EXECUTE);}' unless defined(&VM_PROT_DEFAULT);
    eval 'sub VM_PROT_ALL () {( &VM_PROT_READ| &VM_PROT_WRITE| &VM_PROT_EXECUTE);}' unless defined(&VM_PROT_ALL);
    eval 'sub UVM_ADV_NORMAL () {0x;}' unless defined(&UVM_ADV_NORMAL);
    eval 'sub UVM_ADV_RANDOM () {0x1;}' unless defined(&UVM_ADV_RANDOM);
    eval 'sub UVM_ADV_SEQUENTIAL () {0x2;}' unless defined(&UVM_ADV_SEQUENTIAL);
    eval 'sub UVM_ADV_MASK () {0x7;}' unless defined(&UVM_ADV_MASK);
    eval 'sub UVM_FLAG_FIXED () {0x10000;}' unless defined(&UVM_FLAG_FIXED);
    eval 'sub UVM_FLAG_OVERLAY () {0x20000;}' unless defined(&UVM_FLAG_OVERLAY);
    eval 'sub UVM_FLAG_NOMERGE () {0x40000;}' unless defined(&UVM_FLAG_NOMERGE);
    eval 'sub UVM_FLAG_COPYONW () {0x80000;}' unless defined(&UVM_FLAG_COPYONW);
    eval 'sub UVM_FLAG_AMAPPAD () {0x100000;}' unless defined(&UVM_FLAG_AMAPPAD);
    eval 'sub UVM_FLAG_TRYLOCK () {0x200000;}' unless defined(&UVM_FLAG_TRYLOCK);
    eval 'sub UVM_FLAG_HOLE () {0x400000;}' unless defined(&UVM_FLAG_HOLE);
    eval 'sub UVM_PROTECTION {
        my($X) = @_;
	    eval q((($X) &  &UVM_PROT_MASK));
    }' unless defined(&UVM_PROTECTION);
    eval 'sub UVM_INHERIT {
        my($X) = @_;
	    eval q(((($X) &  &UVM_INH_MASK) >> 4));
    }' unless defined(&UVM_INHERIT);
    eval 'sub UVM_MAXPROTECTION {
        my($X) = @_;
	    eval q(((($X) >> 8) &  &UVM_PROT_MASK));
    }' unless defined(&UVM_MAXPROTECTION);
    eval 'sub UVM_ADVICE {
        my($X) = @_;
	    eval q(((($X) >> 12) &  &UVM_ADV_MASK));
    }' unless defined(&UVM_ADVICE);
    eval 'sub UVM_MAPFLAG {
        my($PROT,$MAXPROT,$INH,$ADVICE,$FLAGS) = @_;
	    eval q((($MAXPROT << 8)|($PROT)|($INH)|(($ADVICE) << 12)|($FLAGS)));
    }' unless defined(&UVM_MAPFLAG);
    eval 'sub UVM_UNKNOWN_OFFSET () {(( &voff_t) -1);}' unless defined(&UVM_UNKNOWN_OFFSET);
    eval 'sub UVM_KMF_NOWAIT () {0x1;}' unless defined(&UVM_KMF_NOWAIT);
    eval 'sub UVM_KMF_VALLOC () {0x2;}' unless defined(&UVM_KMF_VALLOC);
    eval 'sub UVM_KMF_CANFAIL () {0x4;}' unless defined(&UVM_KMF_CANFAIL);
    eval 'sub UVM_KMF_ZERO () {0x8;}' unless defined(&UVM_KMF_ZERO);
    eval 'sub UVM_KMF_TRYLOCK () { &UVM_FLAG_TRYLOCK;}' unless defined(&UVM_KMF_TRYLOCK);
    eval 'sub UVM_PGA_STRAT_NORMAL () {0;}' unless defined(&UVM_PGA_STRAT_NORMAL);
    eval 'sub UVM_PGA_STRAT_ONLY () {1;}' unless defined(&UVM_PGA_STRAT_ONLY);
    eval 'sub UVM_PGA_STRAT_FALLBACK () {2;}' unless defined(&UVM_PGA_STRAT_FALLBACK);
    eval 'sub UVM_PGA_USERESERVE () {0x1;}' unless defined(&UVM_PGA_USERESERVE);
    eval 'sub UVM_PGA_ZERO () {0x2;}' unless defined(&UVM_PGA_ZERO);
    eval 'sub UVM_PLA_WAITOK () {0x1;}' unless defined(&UVM_PLA_WAITOK);
    eval 'sub UVM_PLA_NOWAIT () {0x2;}' unless defined(&UVM_PLA_NOWAIT);
    eval 'sub UVM_PLA_ZERO () {0x4;}' unless defined(&UVM_PLA_ZERO);
    eval 'sub UVM_PLA_TRYCONTIG () {0x8;}' unless defined(&UVM_PLA_TRYCONTIG);
    eval 'sub UVM_LK_ENTER () {0x1;}' unless defined(&UVM_LK_ENTER);
    eval 'sub UVM_LK_EXIT () {0x2;}' unless defined(&UVM_LK_EXIT);
    eval 'sub PHYSLOAD_DEVICE () {0x1;}' unless defined(&PHYSLOAD_DEVICE);
    if(defined(&_KERNEL)) {
    }
    require 'sys/vmmeter.ph';
    require 'sys/queue.ph';
    require 'sys/tree.ph';
    require 'uvm/uvm_param.ph';
    require 'sys/lock.ph';
    require 'sys/mutex.ph';
    require 'uvm/uvm_page.ph';
    require 'uvm/uvm_pmap.ph';
    require 'uvm/uvm_map.ph';
    require 'uvm/uvm_fault.ph';
    require 'uvm/uvm_pager.ph';
    eval 'sub vm_startcopy () { &vm_rssize;}' unless defined(&vm_startcopy);
    if(defined(&_KERNEL)) {
	eval 'sub UVM_COREDUMP_STACK () {0x1;}' unless defined(&UVM_COREDUMP_STACK);
	eval 'sub uvm_km_zalloc {
	    my($MAP,$SIZE) = @_;
    	    eval q( &uvm_km_alloc1($MAP,$SIZE,0, &TRUE));
	}' unless defined(&uvm_km_zalloc);
	eval 'sub uvm_km_alloc {
	    my($MAP,$SIZE) = @_;
    	    eval q( &uvm_km_alloc1($MAP,$SIZE,0, &FALSE));
	}' unless defined(&uvm_km_alloc);
    }
    if(defined(&pmap_resident_count)) {
	eval 'sub vm_resident_count {
	    my($vm) = @_;
    	    eval q(( &pmap_resident_count(($vm)-> ($vm_map->{pmap}))));
	}' unless defined(&vm_resident_count);
    } else {
	eval 'sub vm_resident_count {
	    my($vm) = @_;
    	    eval q((($vm)-> &vm_rssize));
	}' unless defined(&vm_resident_count);
    }
    if(defined(&_KERNEL)) {
	if(defined(&KGDB)) {
	}
	eval 'sub UVM_IO_FIXPROT () {0x1;}' unless defined(&UVM_IO_FIXPROT);
	eval 'sub uvm_km_kmemalloc {
	    my($map, $obj, $sz, $flags) = @_;
    	    eval q( &uvm_km_kmemalloc_pla($map, $obj, $sz, 0, $flags, 0, ( &paddr_t)-1, 0, 0, 0));
	}' unless defined(&uvm_km_kmemalloc);
	eval 'sub uvm_km_getpage {
	    my($waitok, $slowdown) = @_;
    	    eval q( &uvm_km_getpage_pla((($waitok) ? 0:  &UVM_KMF_NOWAIT), ($slowdown), ( &paddr_t)0, ( &paddr_t)-1, 0, 0));
	}' unless defined(&uvm_km_getpage);
	eval 'sub uvm_map {
	    my($_m, $_a, $_sz, $_u, $_f, $_al, $_fl) = @_;
    	    eval q( &uvm_map_p($_m, $_a, $_sz, $_u, $_f, $_al, $_fl, 0));
	}' unless defined(&uvm_map);
	eval 'sub uvm_page_physload {
	    my($s, $e, $as, $ae, $fl) = @_;
    	    eval q( &uvm_page_physload_flags($s, $e, $as, $ae, $fl, 0));
	}' unless defined(&uvm_page_physload);
    }
}
1;
