require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&BSD)) {
    sub BSD () {	199306;}
}
unless(defined(&BSD4_3)) {
    sub BSD4_3 () {	1;}
}
unless(defined(&BSD4_4)) {
    sub BSD4_4 () {	1;}
}
unless(defined(&OpenBSD)) {
    sub OpenBSD () {	201105;}
}
unless(defined(&OpenBSD4_9)) {
    sub OpenBSD4_9 () {	1;}
}
unless(defined(&NULL)) {
    if(defined(&__GNUG__)) {
	eval 'sub NULL () { &__null;}' unless defined(&NULL);
    } else {
	eval 'sub NULL () {0;}' unless defined(&NULL);
    }
}
unless(defined(&_LOCORE)) {
    require 'sys/types.ph';
}
require 'sys/syslimits.ph';
unless(defined(&MAXCOMLEN)) {
    sub MAXCOMLEN () {	16;}
}
unless(defined(&MAXINTERP)) {
    sub MAXINTERP () {	128;}
}
unless(defined(&MAXLOGNAME)) {
    sub MAXLOGNAME () {	 &LOGIN_NAME_MAX;}
}
unless(defined(&MAXUPRC)) {
    sub MAXUPRC () {	 &CHILD_MAX;}
}
unless(defined(&NCARGS)) {
    sub NCARGS () {	 &ARG_MAX;}
}
unless(defined(&NGROUPS)) {
    sub NGROUPS () {	 &NGROUPS_MAX;}
}
unless(defined(&NOFILE)) {
    sub NOFILE () {	 &OPEN_MAX;}
}
unless(defined(&NOFILE_MAX)) {
    sub NOFILE_MAX () {	1024;}
}
unless(defined(&NOGROUP)) {
    sub NOGROUP () {	65535;}
}
unless(defined(&MAXHOSTNAMELEN)) {
    sub MAXHOSTNAMELEN () {	256;}
}
if(defined(&_KERNEL)) {
    require 'sys/cdefs.ph';
    require 'sys/errno.ph';
    require 'sys/time.ph';
    require 'sys/resource.ph';
    require 'sys/ucred.ph';
    require 'sys/uio.ph';
}
require 'sys/signal.ph';
require 'sys/limits.ph';
require 'machine/param.ph';
unless(defined(&PSWP)) {
    sub PSWP () {	0;}
}
unless(defined(&PVM)) {
    sub PVM () {	4;}
}
unless(defined(&PINOD)) {
    sub PINOD () {	8;}
}
unless(defined(&PRIBIO)) {
    sub PRIBIO () {	16;}
}
unless(defined(&PVFS)) {
    sub PVFS () {	20;}
}
unless(defined(&PZERO)) {
    sub PZERO () {	22;}
}
unless(defined(&PSOCK)) {
    sub PSOCK () {	24;}
}
unless(defined(&PWAIT)) {
    sub PWAIT () {	32;}
}
unless(defined(&PLOCK)) {
    sub PLOCK () {	36;}
}
unless(defined(&PPAUSE)) {
    sub PPAUSE () {	40;}
}
unless(defined(&PUSER)) {
    sub PUSER () {	50;}
}
unless(defined(&MAXPRI)) {
    sub MAXPRI () {	127;}
}
unless(defined(&PRIMASK)) {
    sub PRIMASK () {	0xff;}
}
unless(defined(&PCATCH)) {
    sub PCATCH () {	0x100;}
}
unless(defined(&PNORELOCK)) {
    sub PNORELOCK () {	0x200;}
}
unless(defined(&CMASK)) {
    sub CMASK () {	022;}
}
unless(defined(&NODEV)) {
    sub NODEV () {	( &dev_t)(-1);}
}
unless(defined(&NETDEV)) {
    sub NETDEV () {	( &dev_t)(-2);}
}
unless(defined(&CBLOCK)) {
    sub CBLOCK () {	64;}
}
unless(defined(&CBQSIZE)) {
    sub CBQSIZE () {	( &CBLOCK/ &NBBY);}
}
unless(defined(&CBSIZE)) {
    sub CBSIZE () {	( &CBLOCK - $sizeof{'struct cblock' } -  &CBQSIZE);}
}
unless(defined(&CROUND)) {
    sub CROUND () {	( &CBLOCK - 1);}
}
unless(defined(&MSIZE)) {
    sub MSIZE () {	256;}
}
unless(defined(&MCLSHIFT)) {
    sub MCLSHIFT () {	11;}
}
unless(defined(&MCLBYTES)) {
    sub MCLBYTES () {	(1<<  &MCLSHIFT);}
}
unless(defined(&MCLOFSET)) {
    sub MCLOFSET () {	( &MCLBYTES - 1);}
}
unless(defined(&MAXBSIZE)) {
    eval 'sub MAXBSIZE () { &MAXPHYS;}' unless defined(&MAXBSIZE);
}
unless(defined(&MAXFRAG)) {
    sub MAXFRAG () {	8;}
}
unless(defined(&MAXPATHLEN)) {
    sub MAXPATHLEN () {	 &PATH_MAX;}
}
unless(defined(&MAXSYMLINKS)) {
    sub MAXSYMLINKS () {	 &SYMLOOP_MAX;}
}
if(defined(&_KERNEL)) {
    eval 'sub SET {
        my($t, $f) = @_;
	    eval q((($t) |= ($f)));
    }' unless defined(&SET);
    eval 'sub CLR {
        my($t, $f) = @_;
	    eval q((($t) &= ~($f)));
    }' unless defined(&CLR);
    eval 'sub ISSET {
        my($t, $f) = @_;
	    eval q((($t) & ($f)));
    }' unless defined(&ISSET);
}
unless(defined(&setbit)) {
    sub setbit {
	my($a,$i) = @_;
	eval q((($a)[($i)>>3] |= 1<<(($i)( &NBBY-1))));
    }
}
unless(defined(&clrbit)) {
    sub clrbit {
	my($a,$i) = @_;
	eval q((($a)[($i)>>3] &= ~(1<<(($i)( &NBBY-1)))));
    }
}
unless(defined(&isset)) {
    sub isset {
	my($a,$i) = @_;
	eval q((($a)[($i)>>3] & (1<<(($i)( &NBBY-1)))));
    }
}
unless(defined(&isclr)) {
    sub isclr {
	my($a,$i) = @_;
	eval q(((($a)[($i)>>3] & (1<<(($i)( &NBBY-1)))) == 0));
    }
}
unless(defined(&howmany)) {
    eval 'sub howmany {
        my($x, $y) = @_;
	    eval q(((($x)+(($y)-1))/($y)));
    }' unless defined(&howmany);
}
unless(defined(&roundup)) {
    sub roundup {
	my($x, $y) = @_;
	eval q((((($x)+(($y)-1))/($y))*($y)));
    }
}
unless(defined(&powerof2)) {
    sub powerof2 {
	my($x) = @_;
	eval q((((($x)-1)($x))==0));
    }
}
unless(defined(&MIN)) {
    sub MIN {
	my($a,$b) = @_;
	eval q(((($a)<($b))?($a):($b)));
    }
}
unless(defined(&MAX)) {
    sub MAX {
	my($a,$b) = @_;
	eval q(((($a)>($b))?($a):($b)));
    }
}
if(!defined(&offsetof)  && defined(&_KERNEL)) {
    eval 'sub offsetof {
        my($s, $e) = @_;
	    eval q(((($s *)0)->$e));
    }' unless defined(&offsetof);
}
unless(defined(&nitems)) {
    sub nitems {
	my($_a) = @_;
	eval q(($sizeof{($_a)} / $sizeof{($_a)[0]}));
    }
}
unless(defined(&MINBUCKET)) {
    sub MINBUCKET () {	4;}
}
unless(defined(&MAXALLOCSAVE)) {
    sub MAXALLOCSAVE () {	(2*  &PAGE_SIZE);}
}
unless(defined(&FSHIFT)) {
    sub FSHIFT () {	11;}
}
unless(defined(&FSCALE)) {
    sub FSCALE () {	(1<< &FSHIFT);}
}
unless(defined(&MAXSLP)) {
    sub MAXSLP () {	20;}
}
unless(defined(&RFNAMEG)) {
    sub RFNAMEG () {	(1<<0);}
}
unless(defined(&RFENVG)) {
    sub RFENVG () {	(1<<1);}
}
unless(defined(&RFFDG)) {
    sub RFFDG () {	(1<<2);}
}
unless(defined(&RFNOTEG)) {
    sub RFNOTEG () {	(1<<3);}
}
unless(defined(&RFPROC)) {
    sub RFPROC () {	(1<<4);}
}
unless(defined(&RFMEM)) {
    sub RFMEM () {	(1<<5);}
}
unless(defined(&RFNOWAIT)) {
    sub RFNOWAIT () {	(1<<6);}
}
unless(defined(&RFCNAMEG)) {
    sub RFCNAMEG () {	(1<<10);}
}
unless(defined(&RFCENVG)) {
    sub RFCENVG () {	(1<<11);}
}
unless(defined(&RFCFDG)) {
    sub RFCFDG () {	(1<<12);}
}
unless(defined(&RFTHREAD)) {
    sub RFTHREAD () {	(1<<13);}
}
1;
