require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&P9000_SYSTEM_CONFIG)) {
    sub P9000_SYSTEM_CONFIG () {	0x4;}
}
unless(defined(&SCR_PIXEL_MASK)) {
    sub SCR_PIXEL_MASK () {	0x1c000000;}
}
unless(defined(&SCR_PIXEL_8BPP)) {
    sub SCR_PIXEL_8BPP () {	0x8000000;}
}
unless(defined(&SCR_PIXEL_16BPP)) {
    sub SCR_PIXEL_16BPP () {	0xc000000;}
}
unless(defined(&SCR_PIXEL_24BPP)) {
    sub SCR_PIXEL_24BPP () {	0x1c000000;}
}
unless(defined(&SCR_PIXEL_32BPP)) {
    sub SCR_PIXEL_32BPP () {	0x14000000;}
}
unless(defined(&SCR_SWAP_WORDS)) {
    sub SCR_SWAP_WORDS () {	0x2000;}
}
unless(defined(&SCR_SWAP_BYTES)) {
    sub SCR_SWAP_BYTES () {	0x1000;}
}
unless(defined(&SCR_SWAP_BITS)) {
    sub SCR_SWAP_BITS () {	0x800;}
}
unless(defined(&SCR_READ_BUFFER_MASK)) {
    sub SCR_READ_BUFFER_MASK () {	0x400;}
}
unless(defined(&SCR_WRITE_BUFFER_MASK)) {
    sub SCR_WRITE_BUFFER_MASK () {	0x200;}
}
unless(defined(&SCR_ID_MASK)) {
    sub SCR_ID_MASK () {	0x7;}
}
unless(defined(&SCR_SC)) {
    sub SCR_SC {
	my($sc0, $sc1, $sc2, $sc3) = @_;
	eval q(((($sc0) << 14) | (($sc1) << 17) | (($sc2) << 20) | (($sc3) << 29)));
    }
}
unless(defined(&P9000_INTERRUPT)) {
    sub P9000_INTERRUPT () {	0x8;}
}
unless(defined(&P9000_INTERRUPT_ENABLE)) {
    sub P9000_INTERRUPT_ENABLE () {	0xc;}
}
unless(defined(&IER_MASTER_ENABLE)) {
    sub IER_MASTER_ENABLE () {	0x80;}
}
unless(defined(&IER_MASTER_INTERRUPT)) {
    sub IER_MASTER_INTERRUPT () {	0x40;}
}
unless(defined(&IER_VBLANK_ENABLE)) {
    sub IER_VBLANK_ENABLE () {	0x20;}
}
unless(defined(&IER_VBLANK_INTERRUPT)) {
    sub IER_VBLANK_INTERRUPT () {	0x10;}
}
unless(defined(&IER_PICK_ENABLE)) {
    sub IER_PICK_ENABLE () {	0x8;}
}
unless(defined(&IER_PICK_INTERRUPT)) {
    sub IER_PICK_INTERRUPT () {	0x4;}
}
unless(defined(&IER_IDLE_ENABLE)) {
    sub IER_IDLE_ENABLE () {	0x2;}
}
unless(defined(&IER_IDLE_INTERRUPT)) {
    sub IER_IDLE_INTERRUPT () {	0x1;}
}
unless(defined(&P9000_ALTBANK_READ)) {
    sub P9000_ALTBANK_READ () {	0x10;}
}
unless(defined(&P9000_ALTBANK_WRITE)) {
    sub P9000_ALTBANK_WRITE () {	0x14;}
}
unless(defined(&P9000_HCR)) {
    sub P9000_HCR () {	0x104;}
}
unless(defined(&P9000_HTR)) {
    sub P9000_HTR () {	0x108;}
}
unless(defined(&P9000_HSRE)) {
    sub P9000_HSRE () {	0x10c;}
}
unless(defined(&P9000_HBRE)) {
    sub P9000_HBRE () {	0x110;}
}
unless(defined(&P9000_HBFE)) {
    sub P9000_HBFE () {	0x114;}
}
unless(defined(&P9000_HCP)) {
    sub P9000_HCP () {	0x118;}
}
unless(defined(&P9000_VCR)) {
    sub P9000_VCR () {	0x11c;}
}
unless(defined(&P9000_VL)) {
    sub P9000_VL () {	0x120;}
}
unless(defined(&P9000_VSRE)) {
    sub P9000_VSRE () {	0x124;}
}
unless(defined(&P9000_VBRE)) {
    sub P9000_VBRE () {	0x128;}
}
unless(defined(&P9000_VBFE)) {
    sub P9000_VBFE () {	0x12c;}
}
unless(defined(&P9000_VCP)) {
    sub P9000_VCP () {	0x130;}
}
unless(defined(&P9000_SRA)) {
    sub P9000_SRA () {	0x134;}
}
unless(defined(&P9000_SRTC1)) {
    sub P9000_SRTC1 () {	0x138;}
}
unless(defined(&SRTC1_VSYNC_INTERNAL)) {
    sub SRTC1_VSYNC_INTERNAL () {	0x100;}
}
unless(defined(&SRTC1_HSYNC_INTERNAL)) {
    sub SRTC1_HSYNC_INTERNAL () {	0x80;}
}
unless(defined(&SRTC1_VIDEN)) {
    sub SRTC1_VIDEN () {	0x20;}
}
unless(defined(&SRTC1_RESTRICTED)) {
    sub SRTC1_RESTRICTED () {	0x10;}
}
unless(defined(&SRTC1_BUFFER1)) {
    sub SRTC1_BUFFER1 () {	0x8;}
}
unless(defined(&P9000_QSF)) {
    sub P9000_QSF () {	0x13c;}
}
unless(defined(&P9000_SRTC2)) {
    sub P9000_SRTC2 () {	0x140;}
}
unless(defined(&P9000_MCR)) {
    sub P9000_MCR () {	0x184;}
}
unless(defined(&P9000_REFRESH_PERIOD)) {
    sub P9000_REFRESH_PERIOD () {	0x188;}
}
unless(defined(&P9000_REFRESH_COUNT)) {
    sub P9000_REFRESH_COUNT () {	0x18c;}
}
unless(defined(&P9000_RASLOW_MAXIMUM)) {
    sub P9000_RASLOW_MAXIMUM () {	0x190;}
}
unless(defined(&P9000_RASLOW_CURRENT)) {
    sub P9000_RASLOW_CURRENT () {	0x194;}
}
unless(defined(&P9000_POWERUP_CONFIG)) {
    sub P9000_POWERUP_CONFIG () {	0x198;}
}
unless(defined(&P9100_FREE_FIFO)) {
    sub P9100_FREE_FIFO () {	0x198;}
}
unless(defined(&P9100_RAMDAC_REGISTER)) {
    sub P9100_RAMDAC_REGISTER {
	my($index) = @_;
	eval q((0x200 + (($index) << 2)));
    }
}
unless(defined(&P9000_PE_STATUS)) {
    sub P9000_PE_STATUS () {	0x;}
}
unless(defined(&STATUS_QUAD_BUSY)) {
    sub STATUS_QUAD_BUSY () {	0x80000000;}
}
unless(defined(&STATUS_BLIT_BUSY)) {
    sub STATUS_BLIT_BUSY () {	0x40000000;}
}
unless(defined(&STATUS_PICK_DETECTED)) {
    sub STATUS_PICK_DETECTED () {	0x80;}
}
unless(defined(&STATUS_PIXEL_ERROR)) {
    sub STATUS_PIXEL_ERROR () {	0x40;}
}
unless(defined(&STATUS_BLIT_ERROR)) {
    sub STATUS_BLIT_ERROR () {	0x20;}
}
unless(defined(&STATUS_QUAD_ERROR)) {
    sub STATUS_QUAD_ERROR () {	0x10;}
}
unless(defined(&STATUS_QUAD_CONCAVE)) {
    sub STATUS_QUAD_CONCAVE () {	0x8;}
}
unless(defined(&STATUS_QUAD_OUTSIDE)) {
    sub STATUS_QUAD_OUTSIDE () {	0x4;}
}
unless(defined(&STATUS_QUAD_INSIDE)) {
    sub STATUS_QUAD_INSIDE () {	0x2;}
}
unless(defined(&STATUS_QUAD_STRADDLE)) {
    sub STATUS_QUAD_STRADDLE () {	0x1;}
}
unless(defined(&P9000_PE_BLIT)) {
    sub P9000_PE_BLIT () {	0x4;}
}
unless(defined(&P9000_PE_QUAD)) {
    sub P9000_PE_QUAD () {	0x8;}
}
unless(defined(&P9000_PE_PIXEL8)) {
    sub P9000_PE_PIXEL8 () {	0xc;}
}
unless(defined(&P9000_PE_NEXTPIXELS)) {
    sub P9000_PE_NEXTPIXELS () {	0x14;}
}
unless(defined(&P9000_PE_PIXEL1)) {
    sub P9000_PE_PIXEL1 {
	my($index) = @_;
	eval q((0x80 + (($index) << 2)));
    }
}
unless(defined(&P9000_PE_OOR)) {
    sub P9000_PE_OOR () {	0x184;}
}
unless(defined(&P9000_PE_INDEX)) {
    sub P9000_PE_INDEX () {	0x18c;}
}
unless(defined(&P9000_PE_WINOFFSET)) {
    sub P9000_PE_WINOFFSET () {	0x190;}
}
unless(defined(&P9000_PE_WINMIN)) {
    sub P9000_PE_WINMIN () {	0x194;}
}
unless(defined(&P9000_PE_WINMAX)) {
    sub P9000_PE_WINMAX () {	0x198;}
}
unless(defined(&P9000_X_CLIPPING)) {
    sub P9000_X_CLIPPING () {	0x1a0;}
}
unless(defined(&P9000_Y_CLIPPING)) {
    sub P9000_Y_CLIPPING () {	0x1a4;}
}
unless(defined(&P9000_X_EDGE_LESS)) {
    sub P9000_X_EDGE_LESS () {	0x1a8;}
}
unless(defined(&P9000_X_EDGE_GREATER)) {
    sub P9000_X_EDGE_GREATER () {	0x1ac;}
}
unless(defined(&P9000_Y_EDGE_LESS)) {
    sub P9000_Y_EDGE_LESS () {	0x1b0;}
}
unless(defined(&P9000_Y_EDGE_GREATER)) {
    sub P9000_Y_EDGE_GREATER () {	0x1b4;}
}
unless(defined(&P9000_DE_FG_COLOR)) {
    sub P9000_DE_FG_COLOR () {	0x200;}
}
unless(defined(&P9000_DE_BG_COLOR)) {
    sub P9000_DE_BG_COLOR () {	0x204;}
}
unless(defined(&P9100_DE_COLOR0)) {
    sub P9100_DE_COLOR0 () {	0x200;}
}
unless(defined(&P9100_DE_COLOR1)) {
    sub P9100_DE_COLOR1 () {	0x204;}
}
unless(defined(&P9100_DE_COLOR2)) {
    sub P9100_DE_COLOR2 () {	0x238;}
}
unless(defined(&P9100_DE_COLOR3)) {
    sub P9100_DE_COLOR3 () {	0x23c;}
}
unless(defined(&P9100_COLOR8)) {
    sub P9100_COLOR8 {
	my($c) = @_;
	eval q((($c) | (($c) << 8) | (($c) << 16) | (($c) << 24)));
    }
}
unless(defined(&P9100_COLOR16)) {
    sub P9100_COLOR16 {
	my($c) = @_;
	eval q((($c) | (($c) << 16)));
    }
}
unless(defined(&P9000_DE_PLANEMASK)) {
    sub P9000_DE_PLANEMASK () {	0x208;}
}
unless(defined(&P9000_DE_DRAWMODE)) {
    sub P9000_DE_DRAWMODE () {	0x20c;}
}
unless(defined(&DM_PICK_CONTROL)) {
    sub DM_PICK_CONTROL () {	0x8;}
}
unless(defined(&DM_PICK_ENABLE)) {
    sub DM_PICK_ENABLE () {	0x4;}
}
unless(defined(&DM_BUFFER_CONTROL)) {
    sub DM_BUFFER_CONTROL () {	0x2;}
}
unless(defined(&DM_BUFFER_ENABLE0)) {
    sub DM_BUFFER_ENABLE0 () {	0x;}
}
unless(defined(&DM_BUFFER_ENABLE1)) {
    sub DM_BUFFER_ENABLE1 () {	0x1;}
}
unless(defined(&P9000_DE_PATTERN_ORIGIN_X)) {
    sub P9000_DE_PATTERN_ORIGIN_X () {	0x210;}
}
unless(defined(&P9000_DE_PATTERN_ORIGIN_Y)) {
    sub P9000_DE_PATTERN_ORIGIN_Y () {	0x214;}
}
unless(defined(&P9000_DE_RASTER)) {
    sub P9000_DE_RASTER () {	0x218;}
}
unless(defined(&P9100_RASTER_NO_SOLID)) {
    sub P9100_RASTER_NO_SOLID () {	0x2000;}
}
unless(defined(&P9100_RASTER_PATTERN_4COLOR)) {
    sub P9100_RASTER_PATTERN_4COLOR () {	0x4000;}
}
unless(defined(&P9100_RASTER_PIXEL1_TRANSPARENT)) {
    sub P9100_RASTER_PIXEL1_TRANSPARENT () {	0x8000;}
}
unless(defined(&P9000_RASTER_QUAD_OVERSIZE)) {
    sub P9000_RASTER_QUAD_OVERSIZE () {	0x10000;}
}
unless(defined(&P9000_RASTER_QUAD_PATTERN)) {
    sub P9000_RASTER_QUAD_PATTERN () {	0x20000;}
}
unless(defined(&P9000_RASTER_SRC)) {
    sub P9000_RASTER_SRC () {	0xcccc;}
}
unless(defined(&P9000_RASTER_DST)) {
    sub P9000_RASTER_DST () {	0xaaaa;}
}
unless(defined(&P9000_RASTER_PATTERN)) {
    sub P9000_RASTER_PATTERN () {	0xff00;}
}
unless(defined(&P9000_RASTER_MASK)) {
    sub P9000_RASTER_MASK () {	0xffff;}
}
unless(defined(&P9100_RASTER_SRC)) {
    sub P9100_RASTER_SRC () {	0xcc;}
}
unless(defined(&P9100_RASTER_DST)) {
    sub P9100_RASTER_DST () {	0xaa;}
}
unless(defined(&P9100_RASTER_PATTERN)) {
    sub P9100_RASTER_PATTERN () {	0xf0;}
}
unless(defined(&P9100_RASTER_MASK)) {
    sub P9100_RASTER_MASK () {	0xff;}
}
unless(defined(&P9000_DE_PIXEL8)) {
    sub P9000_DE_PIXEL8 () {	0x21c;}
}
unless(defined(&P9000_DE_WINMIN)) {
    sub P9000_DE_WINMIN () {	0x220;}
}
unless(defined(&P9000_DE_WINMAX)) {
    sub P9000_DE_WINMAX () {	0x224;}
}
unless(defined(&P9000_DE_PATTERN)) {
    sub P9000_DE_PATTERN {
	my($index) = @_;
	eval q((0x280 + (($index) << 2)));
    }
}
unless(defined(&P9000_DE_USER)) {
    sub P9000_DE_USER {
	my($index) = @_;
	eval q((0x290 + (($index) << 2)));
    }
}
unless(defined(&P9100_DE_B_WINMIN)) {
    sub P9100_DE_B_WINMIN () {	0x2a0;}
}
unless(defined(&P9100_DE_B_WINMAX)) {
    sub P9100_DE_B_WINMAX () {	0x2a4;}
}
unless(defined(&P9000_COORD_X)) {
    sub P9000_COORD_X () {	0x8;}
}
unless(defined(&P9000_COORD_Y)) {
    sub P9000_COORD_Y () {	0x10;}
}
unless(defined(&P9000_COORD_XY)) {
    sub P9000_COORD_XY () {	0x18;}
}
unless(defined(&P9000_COORD_ABS)) {
    sub P9000_COORD_ABS () {	0x;}
}
unless(defined(&P9000_COORD_REL)) {
    sub P9000_COORD_REL () {	0x20;}
}
unless(defined(&P9000_COORDS)) {
    sub P9000_COORDS {
	my($x,$y) = @_;
	eval q((((($x) & 0xfff) << 16) | (($y) & 0xfff)));
    }
}
unless(defined(&P9000_DC_COORD)) {
    sub P9000_DC_COORD {
	my($index) = @_;
	eval q((0x1000 + (($index) * 0x40)));
    }
}
unless(defined(&P9000_LC_POINT)) {
    sub P9000_LC_POINT () {	0x1200;}
}
unless(defined(&P9000_LC_LINE)) {
    sub P9000_LC_LINE () {	0x1240;}
}
unless(defined(&P9000_LC_TRI)) {
    sub P9000_LC_TRI () {	0x1280;}
}
unless(defined(&P9000_LC_QUAD)) {
    sub P9000_LC_QUAD () {	0x12c0;}
}
unless(defined(&P9000_LC_RECT)) {
    sub P9000_LC_RECT () {	0x1300;}
}
1;
