require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_CONF_H_)) {
    eval 'sub _SYS_CONF_H_ () {1;}' unless defined(&_SYS_CONF_H_);
    eval 'sub D_TAPE () {1;}' unless defined(&D_TAPE);
    eval 'sub D_DISK () {2;}' unless defined(&D_DISK);
    eval 'sub D_TTY () {3;}' unless defined(&D_TTY);
    eval 'sub D_KQFILTER () {0x1;}' unless defined(&D_KQFILTER);
    eval 'sub D_CLONE () {0x2;}' unless defined(&D_CLONE);
    if(defined(&_KERNEL)) {
	eval 'sub dev_type_open {
	    my($n) = @_;
    	    eval q(\'int\' $n( &dev_t, \'int\', \'int\', \'struct proc\' *));
	}' unless defined(&dev_type_open);
	eval 'sub dev_type_close {
	    my($n) = @_;
    	    eval q(\'int\' $n( &dev_t, \'int\', \'int\', \'struct proc\' *));
	}' unless defined(&dev_type_close);
	eval 'sub dev_type_strategy {
	    my($n) = @_;
    	    eval q( &void $n);
	}' unless defined(&dev_type_strategy);
	eval 'sub dev_type_ioctl {
	    my($n) = @_;
    	    eval q(\'int\' $n( &dev_t, \'u_long\', \'caddr_t\', \'int\', \'struct proc\' *));
	}' unless defined(&dev_type_ioctl);
	eval 'sub dev_decl {
	    my($n,$t) = @_;
    	    eval q( &__CONCAT( &dev_type_,$t)( &__CONCAT($n,$t)));
	}' unless defined(&dev_decl);
	eval 'sub dev_init {
	    my($c,$n,$t) = @_;
    	    eval q((($c) > 0?  &__CONCAT($n,$t) : ( &__CONCAT( &dev_type_,$t)((*)))  &enxio));
	}' unless defined(&dev_init);
    }
    if(defined(&_KERNEL)) {
	eval 'sub dev_type_dump {
	    my($n) = @_;
    	    eval q(\'int\' $n( &dev_t,  &daddr64_t, \'caddr_t\', \'size_t\'));
	}' unless defined(&dev_type_dump);
	eval 'sub dev_type_size {
	    my($n) = @_;
    	    eval q( &daddr64_t $n( &dev_t));
	}' unless defined(&dev_type_size);
	eval 'sub dev_size_init {
	    my($c,$n) = @_;
    	    eval q(($c > 0?  &__CONCAT($n, &size) : 0));
	}' unless defined(&dev_size_init);
	eval 'sub bdev_decl {
	    my($n) = @_;
    	    eval q( &dev_decl($n, &open);  &dev_decl($n, &close);  &dev_decl($n, &strategy);  &dev_decl($n, &ioctl);  &dev_decl($n, &dump);  &dev_decl($n, &size));
	}' unless defined(&bdev_decl);
	eval 'sub bdev_disk_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &strategy),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &dump),  &dev_size_init($c,$n),  &D_DISK });
	}' unless defined(&bdev_disk_init);
	eval 'sub bdev_tape_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &strategy),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &dump), 0,  &D_TAPE });
	}' unless defined(&bdev_tape_init);
	eval 'sub bdev_swap_init {
	    my($c,$n) = @_;
    	    eval q({ ( &dev_type_open((*)))  &enodev, ( &dev_type_close((*)))  &enodev,  &dev_init($c,$n, &strategy), ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_dump((*)))  &enodev, 0});
	}' unless defined(&bdev_swap_init);
	eval 'sub bdev_lkm_dummy () {
	    eval q({ ( &dev_type_open((*)))  &lkmenodev, ( &dev_type_close((*)))  &enodev, ( &dev_type_strategy((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_dump((*)))  &enodev, 0});
	}' unless defined(&bdev_lkm_dummy);
	eval 'sub bdev_notdef () {
	    eval q({ ( &dev_type_open((*)))  &enodev, ( &dev_type_close((*)))  &enodev, ( &dev_type_strategy((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_dump((*)))  &enodev, 0});
	}' unless defined(&bdev_notdef);
    }
    if(defined(&_KERNEL)) {
	eval 'sub dev_type_read {
	    my($n) = @_;
    	    eval q(\'int\' $n( &dev_t, \'struct uio\' *, \'int\'));
	}' unless defined(&dev_type_read);
	eval 'sub dev_type_write {
	    my($n) = @_;
    	    eval q(\'int\' $n( &dev_t, \'struct uio\' *, \'int\'));
	}' unless defined(&dev_type_write);
	eval 'sub dev_type_stop {
	    my($n) = @_;
    	    eval q(\'int\' $n(\'struct tty\' *, \'int\'));
	}' unless defined(&dev_type_stop);
	eval 'sub dev_type_tty {
	    my($n) = @_;
    	    eval q(\'struct tty\' *$n( &dev_t));
	}' unless defined(&dev_type_tty);
	eval 'sub dev_type_poll {
	    my($n) = @_;
    	    eval q(\'int\' $n( &dev_t, \'int\', \'struct proc\' *));
	}' unless defined(&dev_type_poll);
	eval 'sub dev_type_mmap {
	    my($n) = @_;
    	    eval q( &paddr_t $n( &dev_t,  &off_t, \'int\'));
	}' unless defined(&dev_type_mmap);
	eval 'sub dev_type_kqfilter {
	    my($n) = @_;
    	    eval q(\'int\' $n( &dev_t, \'struct knote\' *));
	}' unless defined(&dev_type_kqfilter);
	eval 'sub cdev_decl {
	    my($n) = @_;
    	    eval q( &dev_decl($n, &open);  &dev_decl($n, &close);  &dev_decl($n, &read);  &dev_decl($n, &write);  &dev_decl($n, &ioctl);  &dev_decl($n, &stop);  &dev_decl($n, &tty);  &dev_decl($n, &poll);  &dev_decl($n, &mmap);  &dev_decl($n, &kqfilter));
	}' unless defined(&cdev_decl);
	eval 'sub cdev_disk_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev,  &D_DISK,  &D_KQFILTER,  &seltrue_kqfilter });
	}' unless defined(&cdev_disk_init);
	eval 'sub cdev_tape_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev,  &D_TAPE,  &D_KQFILTER,  &seltrue_kqfilter });
	}' unless defined(&cdev_tape_init);
	eval 'sub cdev_tty_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &stop),  &dev_init($c,$n, &tty),  &ttpoll, ( &dev_type_mmap((*)))  &enodev,  &D_TTY,  &D_KQFILTER,  &ttkqfilter });
	}' unless defined(&cdev_tty_init);
	eval 'sub cdev_mouse_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_mouse_init);
	eval 'sub cdev_mousewr_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_mousewr_init);
	eval 'sub cdev_lkm_dummy () {
	    eval q({ ( &dev_type_open((*)))  &lkmenodev, ( &dev_type_close((*)))  &enodev, ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_lkm_dummy);
	eval 'sub cdev_notdef () {
	    eval q({ ( &dev_type_open((*)))  &enodev, ( &dev_type_close((*)))  &enodev, ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_notdef);
	eval 'sub cdev_cn_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &stop), 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev,  &D_TTY,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_cn_init);
	eval 'sub cdev_ctty_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open), ( &dev_type_close((*)))  &nullop,  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &nullop, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev,  &D_TTY,  &D_KQFILTER,  &ttkqfilter });
	}' unless defined(&cdev_ctty_init);
	eval 'sub cdev_mm_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue,  &dev_init($c,$n, &mmap), 0,  &D_KQFILTER,  &seltrue_kqfilter });
	}' unless defined(&cdev_mm_init);
	eval 'sub cdev_crypto_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_crypto_init);
	eval 'sub cdev_systrace_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_systrace_init);
	eval 'sub cdev_ptc_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &nullop,  &dev_init($c,$n, &tty),  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev,  &D_TTY,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_ptc_init);
	eval 'sub cdev_ptm_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_ptm_init);
	eval 'sub cdev_log_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_log_init);
	eval 'sub cdev_fd_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open), ( &dev_type_close((*)))  &enodev, ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_fd_init);
	eval 'sub cdev_tun_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_tun_init);
	eval 'sub cdev_vscsi_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_vscsi_init);
	eval 'sub cdev_bpf_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_bpf_init);
	eval 'sub cdev_lkm_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_lkm_init);
	eval 'sub cdev_ch_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_ch_init);
	eval 'sub cdev_uk_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_uk_init);
	eval 'sub cdev_fb_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse,  &dev_init($c,$n, &mmap) });
	}' unless defined(&cdev_fb_init);
	eval 'sub cdev_audio_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll),  &dev_init($c,$n, &mmap), 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_audio_init);
	eval 'sub cdev_midi_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_midi_init);
	eval 'sub cdev_svr4_net_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open), ( &dev_type_close((*)))  &enodev, ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &nullop, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_svr4_net_init);
	eval 'sub cdev_nnpfs_init {
	    my($c, $n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_nnpfs_init);
	eval 'sub cdev_ksyms_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev, ( &dev_type_ioctl((*)))  &enodev, ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &seltrue_kqfilter });
	}' unless defined(&cdev_ksyms_init);
	eval 'sub cdev_wsdisplay_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl),  &dev_init($c,$n, &stop),  &dev_init($c,$n, &tty),  &ttpoll,  &dev_init($c,$n, &mmap), 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_wsdisplay_init);
	eval 'sub cdev_random_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_random_init);
	eval 'sub cdev_usb_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_usb_init);
	eval 'sub cdev_ulpt_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev,  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_ulpt_init);
	eval 'sub cdev_pf_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_pf_init);
	eval 'sub cdev_urio_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_urio_init);
	eval 'sub cdev_usbdev_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read),  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_usbdev_init);
	eval 'sub cdev_pci_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_pci_init);
	eval 'sub cdev_iop_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_iop_init);
	eval 'sub cdev_radio_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_radio_init);
	eval 'sub cdev_video_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll),  &dev_init($c,$n, &mmap) });
	}' unless defined(&cdev_video_init);
	eval 'sub cdev_spkr_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev,  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &seltrue_kqfilter });
	}' unless defined(&cdev_spkr_init);
	eval 'sub cdev_lpt_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev,  &dev_init($c,$n, &write),  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue, ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &seltrue_kqfilter });
	}' unless defined(&cdev_lpt_init);
	eval 'sub cdev_bktr_init {
	    my($c, $n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &seltrue,  &dev_init($c,$n, &mmap), 0,  &D_KQFILTER,  &seltrue_kqfilter });
	}' unless defined(&cdev_bktr_init);
	eval 'sub cdev_hotplug_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c,$n, &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll), ( &dev_type_mmap((*)))  &enodev, 0,  &D_KQFILTER,  &dev_init($c,$n, &kqfilter) });
	}' unless defined(&cdev_hotplug_init);
	eval 'sub cdev_gpio_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_gpio_init);
	eval 'sub cdev_bio_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_bio_init);
	eval 'sub cdev_bthub_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_bthub_init);
	eval 'sub cdev_agp_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse,  &dev_init($c,$n, &mmap) });
	}' unless defined(&cdev_agp_init);
	eval 'sub cdev_drm_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close),  &dev_init($c, $n,  &read), ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &dev_init($c,$n, &poll),  &dev_init($c,$n, &mmap), 0,  &D_CLONE });
	}' unless defined(&cdev_drm_init);
	eval 'sub cdev_amdmsr_init {
	    my($c,$n) = @_;
    	    eval q({  &dev_init($c,$n, &open),  &dev_init($c,$n, &close), ( &dev_type_read((*)))  &enodev, ( &dev_type_write((*)))  &enodev,  &dev_init($c,$n, &ioctl), ( &dev_type_stop((*)))  &enodev, 0,  &selfalse, ( &dev_type_mmap((*)))  &enodev });
	}' unless defined(&cdev_amdmsr_init);
    }
    if(defined(&_KERNEL)) {
    }
    eval 'sub SW_FREED () {0x1;}' unless defined(&SW_FREED);
    eval 'sub SW_SEQUENTIAL () {0x2;}' unless defined(&SW_SEQUENTIAL);
    eval 'sub sw_freed () { &sw_flags;}' unless defined(&sw_freed);
    if(defined(&_KERNEL)) {
	unless(defined(&LKM)) {
	    eval 'sub NLKM () {0;}' unless defined(&NLKM);
	    eval 'sub lkmenodev () { &enodev;}' unless defined(&lkmenodev);
	} else {
	    eval 'sub NLKM () {1;}' unless defined(&NLKM);
	}
	eval 'sub ptstty () { &ptytty;}' unless defined(&ptstty);
	eval 'sub ptsioctl () { &ptyioctl;}' unless defined(&ptsioctl);
	eval 'sub ptctty () { &ptytty;}' unless defined(&ptctty);
	eval 'sub ptcioctl () { &ptyioctl;}' unless defined(&ptcioctl);
	if(defined(&COMPAT_SVR4)) {
	    eval 'sub NSVR4_NET () {1;}' unless defined(&NSVR4_NET);
	} else {
	    eval 'sub NSVR4_NET () {0;}' unless defined(&NSVR4_NET);
	}
    }
}
1;
