# Copyright (c) 2008 Landry Breuil <landry@openbsd.org>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

use strict;
use warnings;
package OpenBSD::PackageManager::Controller;
use Term::ReadKey;

$|=1;

sub new
{
	my($class, $m) = @_;
	my $self = {};
	$self->{model} = $m;
	bless $self, $class;
	return $self;
}

sub my_system
{
	my ($self, $cmd) = @_;
	print "Executing $cmd...\n";
	my $r = system($cmd);
	print "Type a key.\n";
	ReadMode('cbreak');
	my $key = ReadKey(0);
	ReadMode('normal');
	return $r;
}
1;
