/* ethos-error.h
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#ifndef __ETHOS_ERROR_H__
#define __ETHOS_ERROR_H__

#include <glib-object.h>

#define ETHOS_TYPE_ERROR (ethos_error_get_type())

/**
 * ETHOS_ERROR:
 *
 * #EthosError #GError domain.
 */
#define ETHOS_ERROR (ethos_error_quark())

/**
 * EthosError:
 * @ETHOS_ERROR_FILE_NOT_FOUND: File did not exist or was invalid.
 * @ETHOS_ERROR_INVALID_KEY_FILE: The plugin #GKeyFile is invalid.
 * @ETHOS_ERROR_PLUGIN: An error with a plugin.
 * @ETHOS_ERROR_PLUGIN_LOADER: An error with a plugin-loader.
 *
 * #EthosError error enumeration.
 */
typedef enum {
	ETHOS_ERROR_FILE_NOT_FOUND,
	ETHOS_ERROR_INVALID_KEY_FILE,
	ETHOS_ERROR_PLUGIN,
	ETHOS_ERROR_PLUGIN_LOADER,
} EthosError;

GType  ethos_error_get_type (void);
GQuark ethos_error_quark    (void);

#endif /* __ETHOS_ERROR_H__ */
