'\"
'\" Generated from file 'doc/treectrl.man' by tcllib/doctools with format 'nroff'
'\"
'\" Copyright (c) 2002-2003 Christian Krone.
'\"
'\"   See the file "license.terms" for information on usage and redistribution
'\"   of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\"   $Id: treectrl.n,v 1.76 2009/05/17 19:35:58 treectrl Exp $
.so man.macros
.TH "treectrl" n 2.2.9 treectrl "Tk Commands"
.BS
.SH NAME
treectrl \- Create and manipulate hierarchical multicolumn widgets
.SH SYNOPSIS
package require \fBtreectrl  2.2.9\fR
.sp
\fBtreectrl\fR \fIpathName\fR ?\fIoptions\fR?
.sp
\fIpathName\fR \fBactivate\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBbbox\fR ?\fIarea\fR?
.sp
\fIpathName\fR \fBcanvasx\fR \fIscreenx\fR
.sp
\fIpathName\fR \fBcanvasy\fR \fIscreeny\fR
.sp
\fIpathName\fR \fBcget\fR \fIoption\fR
.sp
\fIpathName\fR \fBcollapse\fR ?\fB-recurse\fR? ?\fIitemDesc ...\fR?
.sp
\fIpathName\fR \fBcolumn\fR \fIoption\fR \fIcolumn\fR ?\fIarg ...\fR?
.sp
\fIpathName\fR \fBcolumn bbox\fR \fIcolumnDesc\fR
.sp
\fIpathName\fR \fBcolumn cget\fR \fIcolumnDesc\fR \fIoption\fR
.sp
\fIpathName\fR \fBcolumn configure\fR \fIcolumnDesc\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBcolumn compare\fR \fIcolumn1\fR \fIop\fR \fIcolumn2\fR
.sp
\fIpathName\fR \fBcolumn count\fR ?\fIcolumnDesc\fR?
.sp
\fIpathName\fR \fBcolumn create\fR ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBcolumn delete\fR \fIfirst\fR ?\fIlast\fR?
.sp
\fIpathName\fR \fBcolumn dragcget\fR \fIoption\fR
.sp
\fIpathName\fR \fBcolumn dragconfigure\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBcolumn index\fR \fIcolumnDesc\fR
.sp
\fIpathName\fR \fBcolumn id\fR \fIcolumnDesc\fR
.sp
\fIpathName\fR \fBcolumn list\fR ?\fI-visible\fR?
.sp
\fIpathName\fR \fBcolumn move\fR \fIcolumnDesc\fR \fIbeforeDesc\fR
.sp
\fIpathName\fR \fBcolumn neededwidth\fR \fIcolumnDesc\fR
.sp
\fIpathName\fR \fBcolumn order\fR \fIcolumnDesc\fR ?\fI-visible\fR?
.sp
\fIpathName\fR \fBcolumn tag\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIpathName\fR \fBcolumn tag add\fR \fIcolumnDesc\fR \fItagList\fR
.sp
\fIpathName\fR \fBcolumn tag expr\fR \fIcolumnDesc\fR \fItagExpr\fR
.sp
\fIpathName\fR \fBcolumn tag names\fR \fIcolumnDesc\fR
.sp
\fIpathName\fR \fBcolumn tag remove\fR \fIcolumnDesc\fR \fItagList\fR
.sp
\fIpathName\fR \fBcolumn width\fR \fIcolumnDesc\fR
.sp
\fIpathName\fR \fBcompare\fR \fIitemDesc1\fR \fIop\fR \fIitemDesc2\fR
.sp
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
.sp
\fIpathName\fR \fBcontentbox\fR
.sp
\fIpathName\fR \fBdebug\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIpathName\fR \fBdebug alloc\fR
.sp
\fIpathName\fR \fBdebug cget\fR \fIoption\fR
.sp
\fIpathName\fR \fBdebug configure\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBdebug dinfo\fR \fIoption\fR
.sp
\fIpathName\fR \fBdebug expose\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
.sp
\fIpathName\fR \fBdebug scroll\fR
.sp
\fIpathName\fR \fBdepth\fR ?\fIitemDesc\fR?
.sp
\fIpathName\fR \fBdragimage\fR \fIoption\fR ?\fIarg ...\fR?
.sp
\fIpathName\fR \fBdragimage add\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fIelement\fR?
.sp
\fIpathName\fR \fBdragimage cget\fR \fIoption\fR
.sp
\fIpathName\fR \fBdragimage clear\fR
.sp
\fIpathName\fR \fBdragimage configure\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBdragimage offset\fR ?\fIx y\fR?
.sp
\fIpathName\fR \fBelement\fR \fIoption\fR ?\fIelement\fR? ?\fIarg arg ...\fR?
.sp
\fIpathName\fR \fBelement cget\fR \fIelement\fR \fIoption\fR
.sp
\fIpathName\fR \fBelement configure\fR \fIelement\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBelement create\fR \fIelement\fR \fItype\fR ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBelement delete\fR ?\fIelement ...\fR?
.sp
\fIpathName\fR \fBelement names\fR
.sp
\fIpathName\fR \fBelement perstate\fR \fIelement\fR \fIoption\fR \fIstateList\fR
.sp
\fIpathName\fR \fBelement type\fR \fIelement\fR
.sp
\fIpathName\fR \fBexpand\fR ?\fB-recurse\fR? ?\fIitemDesc ...\fR?
.sp
\fIpathName\fR \fBidentify\fR \fIx\fR \fIy\fR
.sp
\fIpathName\fR \fBindex\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem\fR \fIoption\fR ?\fIarg ...\fR?
.sp
\fIpathName\fR \fBitem ancestors\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem bbox\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fIelement\fR?
.sp
\fIpathName\fR \fBitem cget\fR \fIitemDesc\fR \fIoption\fR
.sp
\fIpathName\fR \fBitem children\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem collapse\fR \fIitemDesc\fR ?\fB-recurse\fR?
.sp
\fIpathName\fR \fBitem compare\fR \fIitemDesc1\fR \fIop\fR \fIitemDesc2\fR
.sp
\fIpathName\fR \fBitem complex\fR \fIitemDesc\fR ?\fIlist...\fR?
.sp
\fIpathName\fR \fBitem configure\fR \fIitemDesc\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBitem count\fR ?\fIitemDesc\fR?
.sp
\fIpathName\fR \fBitem create\fR ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBitem delete\fR \fIfirst\fR ?\fIlast\fR?
.sp
\fIpathName\fR \fBitem descendants\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem dump\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem element\fR \fIcommand\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR ?\fIarg ...\fR?
.sp
\fIpathName\fR \fBitem element actual\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR \fIoption\fR
.sp
\fIpathName\fR \fBitem element cget\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR \fIoption\fR
.sp
\fIpathName\fR \fBitem element configure\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBitem element perstate\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR \fIoption\fR ?\fIstateList\fR?
.sp
\fIpathName\fR \fBitem enabled\fR \fIitemDesc\fR ?\fIboolean\fR?
.sp
\fIpathName\fR \fBitem expand\fR \fIitemDesc\fR ?\fB-recurse\fR?
.sp
\fIpathName\fR \fBitem firstchild\fR \fIparent\fR ?\fIchild\fR?
.sp
\fIpathName\fR \fBitem id\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem image\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fIimage\fR? ?\fIcolumn image ...\fR?
.sp
\fIpathName\fR \fBitem isancestor\fR \fIitemDesc\fR \fIdescendant\fR
.sp
\fIpathName\fR \fBitem isopen\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem lastchild\fR \fIparent\fR ?\fIchild\fR?
.sp
\fIpathName\fR \fBitem nextsibling\fR \fIsibling\fR ?\fInext\fR?
.sp
\fIpathName\fR \fBitem numchildren\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem order\fR \fIitemDesc\fR ?\fI-visible\fR?
.sp
\fIpathName\fR \fBitem parent\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem prevsibling\fR \fIsibling\fR ?\fIprev\fR?
.sp
\fIpathName\fR \fBitem range\fR \fIfirst\fR \fIlast\fR
.sp
\fIpathName\fR \fBitem remove\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem rnc\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem sort\fR \fIitemDesc\fR ?\fIoption ...\fR?
.sp
\fIpathName\fR \fBitem span\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fInumColumns\fR? ?\fIcolumn numColumns ...\fR?
.sp
\fIpathName\fR \fBitem state\fR \fIcommand\fR \fIitemDesc\fR ?\fIarg ...\fR?
.sp
\fIpathName\fR \fBitem state forcolumn\fR \fIitemDesc\fR \fIcolumn\fR ?\fIstateDescList\fR?
.sp
\fIpathName\fR \fBitem state get\fR \fIitemDesc\fR ?\fIstateName\fR?
.sp
\fIpathName\fR \fBitem state set\fR \fIitemDesc\fR ?\fIlastItem\fR? \fIstateDescList\fR
.sp
\fIpathName\fR \fBitem style\fR \fIcommand\fR \fIitemDesc\fR ?\fIarg ...\fR?
.sp
\fIpathName\fR \fBitem style elements\fR \fIitemDesc\fR \fIcolumn\fR
.sp
\fIpathName\fR \fBitem style map\fR \fIitemDesc\fR \fIcolumn\fR \fIstyle\fR \fImap\fR
.sp
\fIpathName\fR \fBitem style set\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fIstyle\fR? ?\fIcolumn style ...\fR?
.sp
\fIpathName\fR \fBitem tag\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIpathName\fR \fBitem tag add\fR \fIitemDesc\fR \fItagList\fR
.sp
\fIpathName\fR \fBitem tag expr\fR \fIitemDesc\fR \fItagExpr\fR
.sp
\fIpathName\fR \fBitem tag names\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBitem tag remove\fR \fIitemDesc\fR \fItagList\fR
.sp
\fIpathName\fR \fBitem text\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fItext\fR? ?\fIcolumn text ...\fR?
.sp
\fIpathName\fR \fBitem toggle\fR \fIitemDesc\fR ?\fB-recurse\fR?
.sp
\fIpathName\fR \fBmarquee\fR \fIoption\fR ?\fIarg ...\fR?
.sp
\fIpathName\fR \fBmarquee anchor\fR ?\fIx y\fR?
.sp
\fIpathName\fR \fBmarquee cget\fR \fIoption\fR
.sp
\fIpathName\fR \fBmarquee configure\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBmarquee coords\fR ?\fIx1 y1 x2 y2\fR?
.sp
\fIpathName\fR \fBmarquee corner\fR ?\fIx y\fR?
.sp
\fIpathName\fR \fBmarquee identify\fR
.sp
\fIpathName\fR \fBnotify\fR \fIoption\fR ?\fIarg ...\fR?
.sp
\fIpathName\fR \fBnotify bind\fR ?\fIobject\fR? ?\fIpattern\fR? ?+??\fIscript\fR?
.sp
\fIpathName\fR \fBnotify configure\fR \fIobject\fR \fIpattern\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBnotify detailnames\fR \fIeventName\fR
.sp
\fIpathName\fR \fBnotify eventnames\fR
.sp
\fIpathName\fR \fBnotify generate\fR \fIpattern\fR ?\fIcharMap\fR? ?\fIpercentsCommand\fR?
.sp
\fIpathName\fR \fBnotify install\fR \fIpattern\fR ?\fIpercentsCommand\fR?
.sp
\fIpathName\fR \fBnotify install detail\fR \fIeventName\fR \fIdetail\fR ?\fIpercentsCommand\fR?
.sp
\fIpathName\fR \fBnotify install event\fR \fIeventName\fR ?\fIpercentsCommand\fR?
.sp
\fIpathName\fR \fBnotify linkage\fR \fIpattern\fR
.sp
\fIpathName\fR \fBnotify linkage\fR \fIeventName\fR ?\fIdetail\fR?
.sp
\fIpathName\fR \fBnotify unbind\fR \fIobject\fR ?\fIpattern\fR?
.sp
\fIpathName\fR \fBnotify uninstall\fR \fIpattern\fR
.sp
\fIpathName\fR \fBnotify uninstall detail\fR \fIeventName\fR \fIdetail\fR
.sp
\fIpathName\fR \fBnotify uninstall event\fR \fIeventName\fR
.sp
\fIpathName\fR \fBnumcolumns\fR
.sp
\fIpathName\fR \fBnumitems\fR
.sp
\fIpathName\fR \fBorphans\fR
.sp
\fIpathName\fR \fBrange\fR \fIfirst\fR \fIlast\fR
.sp
\fIpathName\fR \fBscan\fR \fIoption\fR \fIargs\fR
.sp
\fIpathName\fR \fBscan mark\fR \fIx\fR \fIy\fR
.sp
\fIpathName\fR \fBscan dragto\fR \fIx\fR \fIy\fR ?\fIgain\fR?
.sp
\fIpathName\fR \fBsee\fR \fIitemDesc\fR ?\fIcolumnDesc\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBselection\fR \fIoption\fR \fIargs\fR
.sp
\fIpathName\fR \fBselection add\fR \fIfirst\fR ?\fIlast\fR?
.sp
\fIpathName\fR \fBselection anchor\fR ?\fIitemDesc\fR?
.sp
\fIpathName\fR \fBselection clear\fR ?\fIfirst\fR? ?\fIlast\fR?
.sp
\fIpathName\fR \fBselection count\fR
.sp
\fIpathName\fR \fBselection get\fR ?\fIfirst\fR? ?\fIlast\fR?
.sp
\fIpathName\fR \fBselection includes\fR \fIitemDesc\fR
.sp
\fIpathName\fR \fBselection modify\fR \fIselect\fR \fIdeselect\fR
.sp
\fIpathName\fR \fBstate\fR \fIoption\fR \fIargs\fR
.sp
\fIpathName\fR \fBstate define\fR \fIstateName\fR
.sp
\fIpathName\fR \fBstate linkage\fR \fIstateName\fR
.sp
\fIpathName\fR \fBstate names\fR
.sp
\fIpathName\fR \fBstate undefine\fR ?\fIstateName ...\fR?
.sp
\fIpathName\fR \fBstyle\fR \fIoption\fR ?\fIelement\fR? ?\fIarg arg ...\fR?
.sp
\fIpathName\fR \fBstyle cget\fR \fIstyle\fR \fIoption\fR
.sp
\fIpathName\fR \fBstyle configure\fR \fIstyle\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBstyle create\fR \fIstyle\fR ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBstyle delete\fR ?\fIstyle ...\fR?
.sp
\fIpathName\fR \fBstyle elements\fR \fIstyle\fR ?\fIelementList\fR?
.sp
\fIpathName\fR \fBstyle layout\fR \fIstyle\fR \fIelement\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
.sp
\fIpathName\fR \fBstyle names\fR
.sp
\fIpathName\fR \fBtoggle\fR ?\fB-recurse\fR? ?\fIitemDesc ...\fR?
.sp
\fIpathName\fR \fBxview\fR ?\fIargs\fR?
.sp
\fIpathName\fR \fBxview\fR
.sp
\fIpathName\fR \fBxview moveto\fR \fIfraction\fR
.sp
\fIpathName\fR \fBxview scroll\fR \fInumber\fR \fIwhat\fR
.sp
\fIpathName\fR \fByview\fR ?\fIargs\fR?
.sp
\fIpathName\fR \fByview\fR
.sp
\fIpathName\fR \fByview moveto\fR \fIfraction\fR
.sp
\fIpathName\fR \fByview scroll\fR \fInumber\fR \fIwhat\fR
.sp
.BE
.SH DESCRIPTION
.TP
\fBtreectrl\fR \fIpathName\fR ?\fIoptions\fR?
.PP
The \fBtreectrl\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a treectrl widget.
Additional options, described above, may be specified on the
command line or in the option database
to configure aspects of the treectrl such as its background color
and relief.  The \fBtreectrl\fR command returns the
path name of the new window.
At the time this command is invoked, there must not
exist a window named \fIpathName\fR, but \fIpathName\fR's parent must exist.
.PP
A treectrl is a widget which displays items in a one- or two-dimensional arrangement.
Items have a parent-child relationship with other items.
Items have a set of states, which are boolean properties.
Items may be spread about one or more columns.
For each column of an item there is a style associated,
which determines how to display the item's column
taking into account the item's current state set.
One column can be defined to display the data in a hierarchical structure.
.PP
Normally the origin of the coordinate system is at the
upper-left corner of the window containing the treectrl.
It is possible to adjust the origin of the coordinate system
relative to the origin of the window using the
\fBxview\fR and \fByview\fR widget commands;
this is typically used for scrolling.
.PP
A treectrl widget can be horizontal or vertical oriented
like many other Tk widgets.
For displaying hierarchical data only vertical orientation is useful,
since only then the children of an item
are displayed directly below their parent.
If the treectrl widget is used only
to display data in a multicolumn listbox,
the specification of an orientation will give useful results.
.SH "STANDARD OPTIONS"
.TP
\fB\fB-background\fR\fR
.TP
\fB\fB-borderwidth\fR\fR
.TP
\fB\fB-cursor\fR\fR
.TP
\fB\fB-font\fR\fR
.TP
\fB\fB-highlightbackground\fR\fR
.TP
\fB\fB-highlightcolor\fR\fR
.TP
\fB\fB-highlightthickness\fR\fR
.TP
\fB\fB-orient\fR\fR
.TP
\fB\fB-relief\fR\fR
.TP
\fB\fB-takefocus\fR\fR
.TP
\fB\fB-xscrollcommand\fR\fR
.TP
\fB\fB-yscrollcommand\fR\fR
.TP
\fB\fB-foreground\fR\fR
See the \fBoption\fR manual entry for details on the standard options.
.SH "WIDGET SPECIFIC OPTIONS"
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-backgroundimage\fR
Database Name:	\fBbackgroundImage\fR
Database Class:	\fBBackgroundImage\fR

.fi
.IP
Specifies the name of an image to draw as the list background. The image is
tiled horizontally and vertically to fill the content area of the list. If
the image is transparent it is drawn on top of the background color(s).
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-backgroundmode\fR
Database Name:	\fBbackgroundMode\fR
Database Class:	\fBBackgroundMode\fR

.fi
.IP
Specifies how the background color of items is chosen in each column.
The value should be one of \fBrow\fR, \fBcolumn\fR, \fBorder\fR,
or \fBordervisible\fR. The default is \fBrow\fR.
This option has only an effect
for columns which have \fB-itembackground\fR defined as list of two or more
colors (see section \fBCOLUMNS\fR below for more on this). If \fBrow\fR or
\fBcolumn\fR is specified, the background color is chosen based on the location
of the item in the 1- or 2-dimensional grid of items as layed out on the screen;
this layout of items is affected by the \fB-orient\fR and \fB-wrap\fR options as
well as item visibility.
When \fBorder\fR or \fBordervisible\fR is specified,
the background color is chosen based on the result of the \fBitem order\fR
command, regardless of the layout of items.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-buttonbitmap\fR
Database Name:	\fBbuttonBitmap\fR
Database Class:	\fBButtonBitmap\fR

.fi
.IP
Specifies the bitmap to be used as the expand/collapse button to the left of
an item. This is a \fBper-state\fR option. If
a bitmap is specified for a certain item state, it overrides the effects of
-usetheme.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-buttoncolor\fR
Database Name:	\fBbuttonColor\fR
Database Class:	\fBButtonColor\fR

.fi
.IP
Specifies the foreground color which should be used for drawing the outline
and the plus or minus sign of the button to the left of an item.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-buttonimage\fR
Database Name:	\fBbuttonImage\fR
Database Class:	\fBButtonImage\fR

.fi
.IP
Specifies the image to be used as the expand/collapse button to the left of
an item. This is a \fBper-state\fR option.
If an image is specified for a certain item state, it overrides the effects of
-buttonbitmap and -usetheme.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-buttonsize\fR
Database Name:	\fBbuttonSize\fR
Database Class:	\fBButtonSize\fR

.fi
.IP
Specifies the width and height of the button drawn to the left of an item
in any of the forms acceptable to \fBTk_GetPixels\fR.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-buttonthickness\fR
Database Name:	\fBbuttonThickness\fR
Database Class:	\fBButtonThickness\fR

.fi
.IP
Specifies the width of the outline and the plus or minus sign
of the button to the left of an item
in any of the forms acceptable to \fBTk_GetPixels\fR.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-columnprefix\fR
Database Name:	\fBcolumnPrefix\fR
Database Class:	\fBColumnPrefix\fR

.fi
.IP
Specifies an ascii string that changes the way column ids are reported and
processed. If this option is a non-empty string, the usual integer value
of a column id is prefixed with the given string. This can aid debugging
but it is important your code doesn't assume column ids are integers if you
use it.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-columnproxy\fR
Database Name:	\fBcolumnProxy\fR
Database Class:	\fBColumnProxy\fR

.fi
.IP
If this option specifies a non empty value,
it should be a screen distance
in any of the forms acceptable to \fBTk_GetPixels\fR.
Then a 1 pixel thick vertical line will be drawn
at the specified screen distance from the left edge of the treectrl widget,
which reaches from top to bottom of the treectrl widget
and uses an inverting color
(i.e black on lighter background, white on darker background).
This line can be used to give the user a visual feedback
during column resizing.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-columnresizemode\fR
Database Name:	\fBcolumnResizeMode\fR
Database Class:	\fBColumnResizeMode\fR

.fi
.IP
Specifies the visual feedback used when resizing columns. The value should be
one of \fBproxy\fR or \fBrealtime\fR. For \fBproxy\fR, a 1-pixel thick
vertical line is drawn representing where the right edge of the column will
be after resizing. For \fBrealtime\fR, the column's size is changed while
the user is dragging the right edge of the column.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-columntagexpr\fR
Database Name:	\fBcolumnTagExpr\fR
Database Class:	\fBColumnTagExpr\fR

.fi
.IP
Specifies a boolean that enables or disables tag expressions in column
descriptions. See \fBITEM AND COLUMN TAGS\fR.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-defaultstyle\fR
Database Name:	\fBdefaultStyle\fR
Database Class:	\fBDefaultStyle\fR

.fi
.IP
This option is deprecated; use the column option \fB-itemstyle\fR instead.
Specifies a list of styles, one per column, to apply to each item created by
the \fBitem create\fR command. The number of styles in the list can be
different from the number of tree columns.
Each list element should be a valid style name or an empty string to
indicate no style should be applied to a specific column. The list of styles
is updated if a style is deleted or if a column is moved.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-doublebuffer\fR
Database Name:	\fBdoubleBuffer\fR
Database Class:	\fBDoubleBuffer\fR

.fi
.IP
Specifies if double-buffering should be used to improve displaying.
The value should be one of \fBnone\fR, \fBwindow\fR, or \fBitem\fR.
For \fBnone\fR no double-buffering is used at all, which may be most memory
efficient, but will probably generate some flickering on the screen.
For \fBwindow\fR the complete tree is double-buffered, which requires
a buffer big enough to contain the complete widget.
For \fBitem\fR, which is the default, every item is separately
double-buffered, so it works with a buffer size as big as the biggest item.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-height\fR
Database Name:	\fBheight\fR
Database Class:	\fBHeight\fR

.fi
.IP
Specifies the desired height for the window
in any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 200 pixels.
If this option is less than or equal to zero then the window will
not request any size at all.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-indent\fR
Database Name:	\fBindent\fR
Database Class:	\fBIndent\fR

.fi
.IP
Specifies the screen distance an item is indented relative to its parent item
in any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 19 pixels.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-itemheight\fR
Database Name:	\fBitemHeight\fR
Database Class:	\fBItemHeight\fR

.fi
.IP
Specifies a fixed height for every item
in any of the forms acceptable to \fBTk_GetPixels\fR. If non-zero, this
option overrides the requested height of an item and the -minitemheight option.
The default is 0, which means that
every item has the height requested by the arrangement of elements
in each column. Items are never shorter than the maximum height of a button.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-itemprefix\fR
Database Name:	\fBitemPrefix\fR
Database Class:	\fBItemPrefix\fR

.fi
.IP
Specifies an ascii string that changes the way item ids are reported and
processed. If this option is a non-empty string, the usual integer value
of an item id is prefixed with the given string. This can aid debugging
but it is important your code doesn't assume item ids are integers if you
use it.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-itemtagexpr\fR
Database Name:	\fBitemTagExpr\fR
Database Class:	\fBItemTagExpr\fR

.fi
.IP
Specifies a boolean that enables or disables tag expressions in item
descriptions. See \fBITEM AND COLUMN TAGS\fR.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-itemwidth\fR
Database Name:	\fBitemWidth\fR
Database Class:	\fBItemWidth\fR

.fi
.IP
Specifies a fixed width for every item in any of the forms acceptable to \fBTk_GetPixels\fR.
If more than one column is visible, then this option has no effect.
If the -orient option is vertical, and the -wrap option is unspecified, then this
option has no effect (in that case all items are as wide as the column).
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-itemwidthequal\fR
Database Name:	\fBitemWidthEqual\fR
Database Class:	\fBItemWidthEqual\fR

.fi
.IP
Specifies a boolean that says whether all items should have the same width.
If more than one column is visible, then this option has no effect.
If the -orient option is vertical, and the -wrap option is unspecified, then this
option has no effect (in that case all items are as wide as the column).
If the -itemwidth option is specified, then this option has no effect.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-itemwidthmultiple\fR
Database Name:	\fBitemWidthMultiple\fR
Database Class:	\fBItemWidthMultiple\fR

.fi
.IP
Specifies a screen distance that every item's width will be evenly divisible by in any of the forms acceptable to \fBTk_GetPixels\fR.
If more than one column is visible, then this option has no effect.
If the -orient option is vertical, and the -wrap option is unspecified, then this
option has no effect (in that case all items are as wide as the column).
If the -itemwidth option is specified, then this option has no effect.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linecolor\fR
Database Name:	\fBlineColor\fR
Database Class:	\fBLineColor\fR

.fi
.IP
Specifies the color which should be used for drawing
the connecting lines between related items.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linestyle\fR
Database Name:	\fBlineStyle\fR
Database Class:	\fBLineStyle\fR

.fi
.IP
Specifies the style of the connecting lines between related items,
should be \fBdot\fR which is the default, or \fBsolid\fR.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linethickness\fR
Database Name:	\fBlineThickness\fR
Database Class:	\fBLineThickness\fR

.fi
.IP
Specifies the thickness of the connecting lines between related items
in any of the forms acceptable to \fBTk_GetPixels\fR.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-minitemheight\fR
Database Name:	\fBminItemHeight\fR
Database Class:	\fBMinItemHeight\fR

.fi
.IP
Specifies a minimum height for every item
in any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 0, which means that
every item has the height requested by the arrangement of elements
in each column. This option has no effect if the -itemheight option is specified.
Items are never shorter than the maximum height of a button.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-rowproxy\fR
Database Name:	\fBrowProxy\fR
Database Class:	\fBRowProxy\fR

.fi
.IP
If this option specifies a non empty value,
it should be a screen distance
in any of the forms acceptable to \fBTk_GetPixels\fR.
Then a 1 pixel thick horizontal line will be drawn
at the specified screen distance from the top edge of the treectrl widget,
which reaches from left to right of the treectrl widget
and uses an inverting color
(i.e black on lighter background, white on darker background).
This line can be used to give the user a visual feedback
during row resizing.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-scrollmargin\fR
Database Name:	\fBscrollMargin\fR
Database Class:	\fBScrollMargin\fR

.fi
.IP
Specifies a positive screen distance
in any of the forms acceptable to \fBTk_GetPixels\fR.
This option is used by the default bindings to determine how close to the
edges of the contentbox the mouse pointer must be before scrolling occurs.
Specifying a positive value is useful when items may be drag-and-dropped.
Defaults to 0.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-selectmode\fR
Database Name:	\fBselectMode\fR
Database Class:	\fBSelectMode\fR

.fi
.IP
Specifies one of several styles for manipulating the selection.
The value of the option may be arbitrary, but the default bindings
expect it to be either \fBsingle\fR, \fBbrowse\fR, \fBmultiple\fR,
or \fBextended\fR;  the default value is \fBbrowse\fR.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-showbuttons\fR
Database Name:	\fBshowButtons\fR
Database Class:	\fBShowButtons\fR

.fi
.IP
Specifies a boolean value that determines whether this widget
leaves indentation space to display the expand/collapse buttons next to items.
The default value is true.
The item option \fB-button\fR determines whether any item has a button.
See also the treectrl option \fB-showrootbutton\fR.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-showheader\fR
Database Name:	\fBshowHeader\fR
Database Class:	\fBShowHeader\fR

.fi
.IP
Specifies a boolean value that determines whether this widget
should display the header line with the column names at the top of the widget.
The default value is true.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-showlines\fR
Database Name:	\fBshowLines\fR
Database Class:	\fBShowLines\fR

.fi
.IP
Specifies a boolean value that determines whether this widget
should draw the connecting lines between related items.
The default value is true.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-showroot\fR
Database Name:	\fBshowRoot\fR
Database Class:	\fBShowRoot\fR

.fi
.IP
Specifies a boolean value that determines whether this widget
should draw the root item.
By suppressing the drawing of the root item the widget can have
multiple items that appear as \fItoplevel\fR items.
The default value is true.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-showrootbutton\fR
Database Name:	\fBshowRootButton\fR
Database Class:	\fBShowRootButton\fR

.fi
.IP
Specifies a boolean value that determines whether this widget
leaves indentation space to display the expand/collapse button next to the
root item. The default value is false.
The item option \fB-button\fR determines whether the root item has a button.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-showrootchildbuttons\fR
Database Name:	\fBshowRootChildButtons\fR
Database Class:	\fBShowRootChildButtons\fR

.fi
.IP
Specifies a boolean value that determines whether this widget
should draw the expand/collapse buttons next to children of the root item.
The default value is true.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-showrootlines\fR
Database Name:	\fBshowRootLines\fR
Database Class:	\fBShowRootLines\fR

.fi
.IP
Specifies a boolean value that determines whether this widget
should draw the connecting lines between children of the root item.
The default value is true.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-treecolumn\fR
Database Name:	\fBtreeColumn\fR
Database Class:	\fBTreeColumn\fR

.fi
.IP
Specifies a \fBcolumn description\fR that determines which
column displays the buttons and lines.
The default is unspecified.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-usetheme\fR
Database Name:	\fBuseTheme\fR
Database Class:	\fBUseTheme\fR

.fi
.IP
Specifies a boolean value that determines whether this widget should draw
parts of itself using a platform-specific theme manager.
The default is false.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-width\fR
Database Name:	\fBwidth\fR
Database Class:	\fBWidth\fR

.fi
.IP
Specifies the desired width for the window
in any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 200 pixel.
If this option is less than or equal to zero then the window will
not request any size at all.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-wrap\fR
Database Name:	\fBwrap\fR
Database Class:	\fBWrap\fR

.fi
.IP
Specifies whether items are arranged in a 1- or 2-dimensional layout.
.sp
If the value is an empty string (the default), then items are arranged from top
to bottom (-orient vertical) or from left to right (-orient horizontal) in
a 1-dimensional layout.
.sp
If the value is "\fIN\fR \fBitems\fR", then no more than \fIN\fR items will appear in
a vertical group (-orient vertical) or horizontal group (-orient horizontal).
.sp
If the value is "\fIN\fR \fBpixels\fR", then no vertical group of items will be
taller than \fIN\fR pixels (-orient vertical) or no horizontal group of items will
be wider than \fIN\fR pixels (-orient horizontal).
.sp
If the value is \fBwindow\fR, then a no vertical group of items will be
taller than the window (-orient vertical) or no horizontal group of items will
be wider than the window (-orient horizontal).
.sp
It is also possible to cause wrapping to occur on a per-item basis by using
the item option -wrap.  See the \fBitem create\fR command for that option.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-xscrolldelay\fR
Database Name:	\fBxScrollDelay\fR
Database Class:	\fBScrollDelay\fR

.fi
.IP
This option controls how quickly horizontal scrolling occurs while dragging
the mouse with button 1 pressed.
The value should be a list of 1 or 2 integers interpreted as microseconds.
If 2 values are specified, then the first value determines the intial delay
after the first scroll, and the second value determines the delay for all
scrolling after the first. If only 1 value is specified, each scroll takes
place after that delay.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-xscrollincrement\fR
Database Name:	\fBxScrollIncrement\fR
Database Class:	\fBScrollIncrement\fR

.fi
.IP
Specifies an increment for horizontal scrolling, in any of the usual forms
permitted for screen distances.  If the value of this option is greater
than zero, the horizontal view in the window will be constrained so that
the x coordinate at the left edge of the window is always an even
multiple of \fB-xscrollincrement\fR;  furthermore, the units for scrolling
(e.g., the change in view when the left and right arrows of a scrollbar
are selected) will also be \fB-xscrollincrement\fR.  If the value of
this option is less than or equal to zero, then horizontal scrolling
snaps to the left of an item, or part of an item if items are wider than the
contentbox.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-yscrolldelay\fR
Database Name:	\fByScrollDelay\fR
Database Class:	\fBScrollDelay\fR

.fi
.IP
This option controls how quickly vertical scrolling occurs while dragging
the mouse with button 1 pressed.
The value should be a list of 1 or 2 integers interpreted as microseconds.
If 2 values are specified, then the first value determines the intial delay
after the first scroll, and the second value determines the delay for all
scrolling after the first. If only 1 value is specified, each scroll takes
place after that delay.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-yscrollincrement\fR
Database Name:	\fByScrollIncrement\fR
Database Class:	\fBScrollIncrement\fR

.fi
.IP
Specifies an increment for vertical scrolling, in any of the usual forms
permitted for screen distances.  If the value of this option is greater
than zero, the vertical view in the window will be constrained so that
the y coordinate at the top edge of the window is always an even
multiple of \fB-yscrollincrement\fR;  furthermore, the units for scrolling
(e.g., the change in view when the top and bottom arrows of a scrollbar
are selected) will also be \fB-yscrollincrement\fR.  If the value of
this option is less than or equal to zero, then vertical scrolling
snaps to the top of an item, or part of an item if items are taller than the
contentbox.
.SH "ITEM AND COLUMN TAGS"
Columns and items may have any number of tags associated with them.
A tag is just a string of characters, and it may take any form,
including that of an integer, although the characters '(', ')', '&', '|', '^'
and '!' should be avoided.
.PP
The same tag may be associated with many columns or items. This is commonly done to group
items in various interesting ways; for example, in a file browser all directories
might be given the tag "directory".
.PP
Tag expressions are used in \fBcolumn descriptions\fR
and \fBitem descriptions\fR to specify which columns
and items to operate on.
A tag expression can be a single tag name or a logical expression of tags
using operators '&&', '||', '^' and '!', and parenthesized subexpressions.
For example:
.nf

.t item id "tag {(a && !b) || (!a && b)}"

.fi
or equivalently:
.nf

.t item id "tag {a ^ b}"

.fi
will return the unique ids of any items with either "a" or "b" tags, but not both.
.PP
Within a tag expression a tag name may be enclosed in double quotes to avoid special
processing of the operator characters. For example:
.nf

.t item id {tag {"a&&b"||c}}

.fi
will return the unique ids of any items with either "a&&b" or "c" tags; in this
example the && is not treated as an operator. A double-quote may be escaped within
a quoted tag name using a backslash '\\'.
.PP
Tag operators may be bypassed completely by setting the \fB-columntagexpr\fR and
\fB-itemtagexpr\fR options. This can be useful if your application has column
or item tags containing arbitrary text.
.nf

.t configure -itemtagexpr false
.t item delete "tag a&&b"

.fi
.SH "WIDGET COMMAND"
The \fBtreectrl\fR command creates a new Tcl command whose
name is the same as the path name of the treectrl's window.
This command may be used to invoke various
operations on the widget.  It has the following general form:
.PP
\fIpathName\fR \fIoption\fR ?\fIarg arg ...\fR?
.PP
\fIPathName\fR is the name of the command, which is the same as
the treectrl widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for treectrl widgets:
.TP
\fIpathName\fR \fBactivate\fR \fIitemDesc\fR
Sets the active item to the one described by \fIitemDesc\fR,
and switches on the state \fBactive\fR for this item.
From now on the item can be retrieved with the item description \fBactive\fR.
An \fB<ActiveItem>\fR event is generated.
.TP
\fIpathName\fR \fBbbox\fR ?\fIarea\fR?
Returns a list with four elements giving the bounding box (left, top, right
and bottom) of an area of the window. If \fIarea\fR is not specified, then
the result is the bounding box of the entire window.
If \fIarea\fR is \fBcontent\fR, then the result is the part of the window
not including borders, headers, or locked columns.
If \fIarea\fR is \fBheader\fR, then the result is the part of the window
not including borders where column titles are displayed.
If \fIarea\fR is \fBleft\fR, then the result is the part of the window
not including borders or headers where left-locked columns are displayed.
If \fIarea\fR is \fBright\fR, then the result is the part of the window
not including borders or headers where right-locked columns are displayed.
An empty string is returned if the display area has
no height or width, which can be true for various reasons such as the window
is too small, or the header is not displayed, or there aren't any locked
columns.
.TP
\fIpathName\fR \fBcanvasx\fR \fIscreenx\fR
Given a window x-coordinate in the treectrl \fIscreenx\fR,
this command returns the treectrl x-coordinate
that is displayed at that location.
.TP
\fIpathName\fR \fBcanvasy\fR \fIscreeny\fR
Given a window y-coordinate in the treectrl \fIscreeny\fR,
this command returns the treectrl y-coordinate
that is displayed at that location.
.TP
\fIpathName\fR \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBtree\fR
command.
.TP
\fIpathName\fR \fBcollapse\fR ?\fB-recurse\fR? ?\fIitemDesc ...\fR?
Use \fBitem collapse\fR instead.
.TP
\fIpathName\fR \fBcolumn\fR \fIoption\fR \fIcolumn\fR ?\fIarg ...\fR?
This command is used to manipulate the columns of the treectrl widget
(see section \fBCOLUMNS\fR below).
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBcolumn\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBcolumn bbox\fR \fIcolumnDesc\fR
Returns a list with four elements giving the bounding box
of the header of the column specified by the
\fBcolumn description\fR \fIcolumnDesc\fR.
If the treectrl is configured not to display the column headers
by means of the \fB-showheader\fR option, then
an empty list is returned instead.
.TP
\fIpathName\fR \fBcolumn cget\fR \fIcolumnDesc\fR \fIoption\fR
This command returns the current value of the option named \fIoption\fR
for the column specified by the
\fBcolumn description\fR \fIcolumnDesc\fR,
\fIColumnDesc\fR may also be the string \fBtail\fR to specify the tail column.
\fIOption\fR may have any of the values accepted by the
\fBcolumn configure\fR widget command.
.TP
\fIpathName\fR \fBcolumn configure\fR \fIcolumnDesc\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies options associated with the columns specified by the
\fBcolumn description\fR \fIcolumnDesc\fR
instead of modifying options for the overall treectrl widget.
\fIColumnDesc\fR may be the string \fBtail\fR to specify the tail column.
If \fIcolumnDesc\fR refers to more than one column, then at least one option-value pair
must be given.
If no \fIoption\fR is specified, the command returns a list describing
all of the available options for \fIcolumnDesc\fR (see \fBTk_ConfigureInfo\fR
for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no \fIoption\fR
is specified).
If one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s) for \fIcolumnDesc\fR;
in this case the command returns an empty string.
.sp
See \fBCOLUMNS\fR below for details on the options available for columns.
.TP
\fIpathName\fR \fBcolumn compare\fR \fIcolumn1\fR \fIop\fR \fIcolumn2\fR
For both \fBcolumn descriptions\fR \fIcolumn1\fR
and \fIcolumn2\fR the index is retrieved
(as returned from the \fBcolumn order\fR widget command).
Then these indexes are compared using the operator \fIop\fR, which must
be either \fB<\fR,  \fB<=\fR,  \fB==\fR, \fB>=\fR, \fB>\fR,
or \fB!=\fR.
The return value of this command is 1 if the comparison evaluated to true,
0 otherwise.
.TP
\fIpathName\fR \fBcolumn count\fR ?\fIcolumnDesc\fR?
If no additional arguments are given, the result is a decimal string giving the number of
columns created by the \fBcolumn create\fR widget command which haven't been
deleted by the \fBcolumn delete\fR widget command; in this case the \fBtail\fR column
is not counted.
If \fIcolumnDesc\fR is given, then the result is the number of columns that
match that \fBcolumn description\fR.
.TP
\fIpathName\fR \fBcolumn create\fR ?\fIoption value ...\fR?
This command creates a new column in the treectrl widget. The new column is
placed to the right of all other columns (except the \fBtail\fR column). Any
\fIoption\fR-\fIvalue\fR arguments configure the new column according to the
\fBcolumn configure\fR command. The return value is the unique identifier
of the new column.
.TP
\fIpathName\fR \fBcolumn delete\fR \fIfirst\fR ?\fIlast\fR?
Deletes the specified column(s). \fIFirst\fR and \fIlast\fR must be valid
\fBcolumn descriptions\fR. If both \fIfirst\fR
and \fIlast\fR are specified, then they may refer to a single column only.
The \fBtail\fR column cannot be deleted and it is an error to specify it.
The order of \fIfirst\fR and \fIlast\fR doesn't matter, and \fIfirst\fR may
be equal to \fIlast\fR.
.TP
\fIpathName\fR \fBcolumn dragcget\fR \fIoption\fR
.TP
\fIpathName\fR \fBcolumn dragconfigure\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
The user can move a column within a treectrl by drag-and-drop. Feedback consists
of a semi-transparent photo image of the header of the column being dragged
and a 2-pixel-thick vertical line to indicate where the column may be dropped.
The drag image consists of a colored background rectangle plus the image and/or
text displayed in the column header. The 2-pixel-thick line will be drawn
over the left edge of the column before which the dragged column may be dropped.
.sp
The library scripts generate a <ColumnDrag-accept> event when the user has
successfully drag-and-drop'd a column. You will have to bind a script to this
event if you want to move the dragged column.
.sp
The following configuration options are supported:
.RS
.TP
\fB\fB-enable\fR\fR \fIboolean\fR
Controls whether the user is allowed to rearrange columns by drag-and-drop.
.TP
\fB\fB-imagealpha\fR\fR \fIalpha\fR
\fIAlpha\fR is an integer from 0 (invisible) to 255 (opaque) controlling the
transparency of the drag image. Any value outside this range is clipped.
.TP
\fB\fB-imagecolor\fR\fR \fIbackground\fR
\fIBackground\fR is the color of the drag image background rectangle.
.TP
\fB\fB-imagecolumn\fR\fR \fIcolumn\fR
\fIColumn\fR specifies the column to create the drag image from.
.TP
\fB\fB-imageoffset\fR\fR \fIoffset\fR
\fIOffset\fR is the horizontal screen distance the drag image is offset from its
starting position.
.TP
\fB\fB-indicatorcolor\fR\fR \fIcolor\fR
\fIColor\fR is the color of the 2-pixel-thick line.
.TP
\fB\fB-indicatorcolumn\fR\fR \fIcolumn\fR
The 2-pixel-thick line will be drawn over the left or right edge of \fIcolumn\fR.
.TP
\fB\fB-indicatorside\fR\fR \fIside\fR
Specifies whether the 2-pixel-thick line will be drawn over the \fBleft\fR
or \fBright\fR edge of the column specified by \fB-indicatorcolumn\fR.
.RE
.TP
\fIpathName\fR \fBcolumn index\fR \fIcolumnDesc\fR
Deprecated. Use \fBcolumn id\fR instead.
.TP
\fIpathName\fR \fBcolumn id\fR \fIcolumnDesc\fR
This command resolves the \fBcolumn description\fR
\fIcolumnDesc\fR into a list of unique column identifiers. If the column(s) described by
\fIcolumnDesc\fR don't exist, this command returns an empty list.
.TP
\fIpathName\fR \fBcolumn list\fR ?\fI-visible\fR?
This command returns a list of identifiers for every column (except the tail)
from left to right. If \fI-visible\fR is given, only columns whose -visible
option is true are returned.
.TP
\fIpathName\fR \fBcolumn move\fR \fIcolumnDesc\fR \fIbeforeDesc\fR
Moves the column specified by \fIcolumnDesc\fR to the left of the column
specified by \fIbeforeDesc\fR. Both \fIcolumnDesc\fR and \fIbeforeDesc\fR
must be valid \fBcolumn descriptions\fR.
If \fIbeforeDesc\fR is the string \fBtail\fR,
the column \fIcolumnDesc\fR will become the last column.
.TP
\fIpathName\fR \fBcolumn neededwidth\fR \fIcolumnDesc\fR
This command returns a decimal string giving the needed width
of the column specified by the \fBcolumn description\fR
\fIcolumnDesc\fR.
The needed width is the maximum of the width of the column header
and the width of the widest style in any visible item.
.TP
\fIpathName\fR \fBcolumn order\fR \fIcolumnDesc\fR ?\fI-visible\fR?
This command returns a decimal string giving the position of the column
specified by the \fBcolumn description\fR
\fIcolumnDesc\fR
in the list of columns starting from zero for the leftmost column.
If \fI-visible\fR is given, only columns whose -visible
option is true are considered, and -1 is returned if \fIcolumnDesc\fR's -visible
option is false.
.TP
\fIpathName\fR \fBcolumn tag\fR \fIoption\fR ?\fIarg arg ...\fR?
This command is used to manipulate tags on columns.
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBcolumn tag\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBcolumn tag add\fR \fIcolumnDesc\fR \fItagList\fR
Adds each tag in \fItagList\fR to the columns specified by the
\fBcolumn description\fR \fIcolumnDesc\fR.
Duplicate tags are ignored. The list of tags for a column can also be
changed via a column's \fB-tags\fR option.
.TP
\fIpathName\fR \fBcolumn tag expr\fR \fIcolumnDesc\fR \fItagExpr\fR
Evaluates the tag expression \fItagExpr\fR against every column
specified by the \fBcolumn description\fR
\fIcolumnDesc\fR. The result is 1 if the tag expression evaluates to true
for every column, 0 otherwise.
.TP
\fIpathName\fR \fBcolumn tag names\fR \fIcolumnDesc\fR
Returns a list of tag names assigned to the columns
specified by the \fBcolumn description\fR
\fIcolumnDesc\fR. The result is the union of any tags assigned to the
columns.
.TP
\fIpathName\fR \fBcolumn tag remove\fR \fIcolumnDesc\fR \fItagList\fR
Removes each tag in \fItagList\fR from the columns specified by the
\fBcolumn description\fR \fIcolumnDesc\fR.
It is not an error if any of the columns do not use any of the tags.
The list of tags for a column can also be changed via a column's
\fB-tags\fR option.
.RE
.TP
\fIpathName\fR \fBcolumn width\fR \fIcolumnDesc\fR
This command returns a decimal string giving the width in pixels
of the column specified by the \fBcolumn description\fR
\fIcolumnDesc\fR,
even if the treectrl is configured to not display the column headers
by means of the \fB-showheader\fR option.
.RE
.TP
\fIpathName\fR \fBcompare\fR \fIitemDesc1\fR \fIop\fR \fIitemDesc2\fR
Deprecated. Use the \fBitem compare\fR command instead.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBtreectrl\fR
command.
.TP
\fIpathName\fR \fBcontentbox\fR
Returns a list with four elements giving the bounding box
of the screen area used to display items.
This is the area of the window not including borders, column headers, or
locked columns. An empty string is returned if the display area has
no height or width, which can happen if the window is too small.
.TP
\fIpathName\fR \fBdebug\fR \fIoption\fR ?\fIarg arg ...\fR?
This command is used to facilitate debugging of the treectrl widget.
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBdebug\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBdebug alloc\fR
Returns a string giving partial statistics on memory allocations, if the package
was built with TREECTRL_DEBUG defined.
.TP
\fIpathName\fR \fBdebug cget\fR \fIoption\fR
This command returns the current value of the debugging option
named \fIoption\fR.
\fIOption\fR may have any of the values accepted by the
\fBdebug configure\fR widget command.
.TP
\fIpathName\fR \fBdebug configure\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies debugging options
instead of modifying options for the overall treectrl widget.
If no \fIoption\fR is specified, the command returns a list describing
all of the available debugging options (see \fBTk_ConfigureInfo\fR
for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no \fIoption\fR
is specified).
If one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given debugging option(s) to have the given value(s);
in this case the command returns an empty string.
.sp
The following debugging options are supported:
.RS
.TP
\fB\fB-displaydelay\fR\fR \fImillis\fR
Specifies a time duration in milliseconds, which should be waited
after something has been drawn to the screen.
Setting this option has only an effect, if the
debugging options \fB-enable\fR and \fB-display\fR are switched on.
.TP
\fB\fB-data\fR\fR \fIboolean\fR
If this option is switched on
(together with the debugging option \fB-enable\fR),
at various places a consistence check
on the internal data structure is made
(e.g. for every item is checked,
if the registered number of children is equal to the number of child items).
If an inconsistency was found, a Tcl background error is raised.
.TP
\fB\fB-display\fR\fR \fIboolean\fR
If this option is switched on
(together with the debugging option \fB-enable\fR),
at varios places additional debugging output is printed to stdout.
.TP
\fB\fB-drawcolor\fR\fR \fIcolor\fR
When specified, areas of the window are painted with this color when drawing
in those areas is about to occur.
Setting this option has only an effect if the
debugging options \fB-enable\fR and \fB-display\fR are switched on.
.TP
\fB\fB-enable\fR\fR \fIboolean\fR
All other debugging options only take effect
if this option is also switched on.
.TP
\fB\fB-erasecolor\fR\fR \fIcolor\fR
When specified, areas of the window which have been marked as "invalid"
(for example, when part of the window is exposed) are
painted with this color.
If you use an unusual color for this option (like \fBpink\fR),
superflous screen redraws can be spotted more easily.
Setting this option has only an effect if the
debugging options \fB-enable\fR and \fB-display\fR are switched on.
.TP
\fB\fB-span\fR\fR \fIboolean\fR
Debugging related to column spanning.
.TP
\fB\fB-textlayout\fR\fR \fIboolean\fR
Debugging related to text-element layout.
.RE
.TP
\fIpathName\fR \fBdebug dinfo\fR \fIoption\fR
Returns a string describing display-related stuff. \fIOption\fR must be one
of \fBalloc\fR, \fBditem\fR, \fBonscreen\fR or \fBrange\fR.
.TP
\fIpathName\fR \fBdebug expose\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
Causes the area of the window bounded by the given window-coords to be
marked as invalid. This simulates uncovering part of the window.
.TP
\fIpathName\fR \fBdebug scroll\fR
Returns a string useful for debugging vertical scrolling.
.RE
.TP
\fIpathName\fR \fBdepth\fR ?\fIitemDesc\fR?
If the additional argument \fIitemDesc\fR is given,
then the result is a decimal string giving the depth of
the item described by \fIitemDesc\fR.
If no \fIitemDesc\fR is specified, then the maximum depth of all
items in the treectrl widget is returned instead.
Depth is defined as the number of ancestors an item has.
.TP
\fIpathName\fR \fBdragimage\fR \fIoption\fR ?\fIarg ...\fR?
This command is used to manipulate the dragimage,
one or more dotted lines around rectangular regions of the treectrl widget.
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBdragimage\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBdragimage add\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fIelement\fR?
Adds the shapes of the item described by \fIitemDesc\fR
to the shapes of the dragimage.
Specifying additional arguments reduces
the number of rectangles that are added to the dragimage.
If no additional arguments is specified,
for every element of the item in every column a dotted rectangles is added.
If \fIcolumn\fR is specified, all elements in other columns are ignored.
If also \fIelement\fR is specified, only a rectangle for this one element
of the specified item in the given column is added.
.TP
\fIpathName\fR \fBdragimage cget\fR \fIoption\fR
This command returns the current value of the dragimage option
named \fIoption\fR.
\fIOption\fR may have any of the values accepted by the
\fBdragimage configure\fR widget command.
.TP
\fIpathName\fR \fBdragimage clear\fR
Removes all shapes (if there are any) from the dragimage.
This command does not modify the dragimage offset.
.TP
\fIpathName\fR \fBdragimage configure\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies the dragimage options
instead of modifying options for the overall treectrl widget.
If no \fIoption\fR is specified, the command returns a list describing
all of the available dragimage options (see \fBTk_ConfigureInfo\fR
for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
a list describing the one named dragimage option (this list will be identical
to the corresponding sublist of the value returned if no \fIoption\fR
is specified).
If one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given dragimage option(s) to have the given value(s);
in this case the command returns an empty string.
.sp
The following dragimage options are supported:
.RS
.TP
\fB\fB-visible\fR\fR \fIboolean\fR
Specifies a boolean value which determines
whether the dragimage should currently be visible.
.RE
.TP
\fIpathName\fR \fBdragimage offset\fR ?\fIx y\fR?
Returns a list containing the x and y offsets of the dragimage,
if no additional arguments are specified.
The dragimage offset is the screen distance, the image is displayed
relative to the item its shape is derived from.
If two coordinates are specified,
sets the dragimage offset to the given coordinates \fIx\fR and \fIy\fR.
.RE
.TP
\fIpathName\fR \fBelement\fR \fIoption\fR ?\fIelement\fR? ?\fIarg arg ...\fR?
This command is used to manipulate elements (see \fBELEMENTS\fR below).
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBelement\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBelement cget\fR \fIelement\fR \fIoption\fR
This command returns the current value of the option named \fIoption\fR
associated with the element given by \fIelement\fR.
\fIOption\fR may have any of the values accepted by the
\fBelement configure\fR widget command.
.TP
\fIpathName\fR \fBelement configure\fR \fIelement\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies options associated with the element given by \fIelement\fR
instead of modifying options for the overall treectrl widget.
If no \fIoption\fR is specified, the command returns a list describing
all of the available options for \fIelement\fR (see \fBTk_ConfigureInfo\fR
for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no \fIoption\fR
is specified).
If one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s) in \fIelement\fR;
in this case the command returns an empty string.
See \fBELEMENTS\fR below for details on the options available for elements.
.TP
\fIpathName\fR \fBelement create\fR \fIelement\fR \fItype\fR ?\fIoption value ...\fR?
Create a new elememt in \fIpathName\fR of type \fItype\fR
with name \fIelement\fR.
The exact format of the arguments after \fItype\fR depends on \fItype\fR,
but generally consist of specifications for zero or more element options.
See the subsections on individual element types below for more
on the syntax of this command.
This command returns the name for the new element.
.TP
\fIpathName\fR \fBelement delete\fR ?\fIelement ...\fR?
Deletes each of the named elements and returns an empty string.
If an element is deleted while it is still configured
as an element of one or more styles
by means of the \fBstyle elements\fR widget command,
it is also removed from the element lists of these styles.
.TP
\fIpathName\fR \fBelement names\fR
Returns a list containing the names of all existing elements.
.TP
\fIpathName\fR \fBelement perstate\fR \fIelement\fR \fIoption\fR \fIstateList\fR
This command returns the value of the \fBper-state\fR
option named \fIoption\fR for \fIelement\fR for a certain state.
\fIStateList\fR is a list of state names (static and dynamic, see \fBSTATES\fR)
which specifies the state to use.
.TP
\fIpathName\fR \fBelement type\fR \fIelement\fR
Returns the type of the element given by \fIelement\fR,
such as \fBrect\fR or \fBtext\fR.
.RE
.TP
\fIpathName\fR \fBexpand\fR ?\fB-recurse\fR? ?\fIitemDesc ...\fR?
Use \fBitem expand\fR instead.
.TP
\fIpathName\fR \fBidentify\fR \fIx\fR \fIy\fR
Returns a list describing what
is displayed at the given window coordinates \fIx\fR and \fIy\fR.
If the coordinates are outside the window, over the borders, or over any
whitespace in the window, then the result is an empty string;
otherwise the first word of the result is \fBheader\fR or \fBitem\fR.
.sp
If the coordinates are over a column header, then
the first word of the result is \fBheader\fR, followed by
the unique id of the column (or the string \fBtail\fR).
If the x coordinate is near the left or right end of a column, then
a third word \fBleft\fR or \fBright\fR is appended to the result.
.sp
If the coordinates are over an item, then the first word of the result
is \fBitem\fR followed by the unique id of that item.
If the coordinates are not over the area for displaying buttons and lines,
then \fBcolumn\fR and a unique column id are the
3rd and 4th words of the result. If the coordinates are over an element within
that column, then \fBelement\fR and an element name are the 5th and 6th
words of the result.
.sp
If the coordinates are over a button, then the first word of the result is
\fBitem\fR, followed by the unique id of that item, followed by the word
\fBbutton\fR.
.sp
If the coordinates are over a line descending from an ancestor of an item
(but not the parent of that item), then the first word of the result is
\fBitem\fR, followed by the unique id of that item, followed by the word
\fBline\fR, followed by the unique id of the item the line is coming
from. This is used to collapse the ancestor when the line is clicked on.
.TP
\fIpathName\fR \fBindex\fR \fIitemDesc\fR
Deprecated. Use \fBitem id\fR instead.
.TP
\fIpathName\fR \fBitem\fR \fIoption\fR ?\fIarg ...\fR?
This command is used to manipulate items.
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBitem\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBitem ancestors\fR \fIitemDesc\fR
Returns a list containing the item ids of the ancestors
of the item specified by \fIitemDesc\fR. The first list value is the parent,
the second is the parent's parent, an so on. The last list value will be the
root item if \fIitemDesc\fR is a descendant of the root item.
.TP
\fIpathName\fR \fBitem bbox\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fIelement\fR?
Returns a list with four elements giving the bounding box
of the item described by \fIitemDesc\fR.
If no further argument is specified, the bbox spans the area of the item
over all non-locked columns. If a \fIcolumn\fR is specified, only the area of the item
in this column is considered. If an additional \fIelement\fR is specified,
the area of this \fIelement\fR in \fIcolumn\fR of the specified item is
returned.
.TP
\fIpathName\fR \fBitem cget\fR \fIitemDesc\fR \fIoption\fR
Returns the current value of the configuration option for the item specified by
\fIitemDesc\fR whose name is \fIoption\fR. \fIOption\fR may have any of the
values accepted by the \fBitem configure\fR command.
.TP
\fIpathName\fR \fBitem children\fR \fIitemDesc\fR
Returns a list containing the item ids of all children
of the item specified by \fIitemDesc\fR in the correct order from
the first child to the last child.
.TP
\fIpathName\fR \fBitem collapse\fR \fIitemDesc\fR ?\fB-recurse\fR?
Switches off the \fBopen\fR state of the item(s) described by \fIitemDesc\fR.
If an item has descendants, then they are no longer displayed.
If an item is already closed, then this command has no effect on that item.
If \fB-recurse\fR is specified, then all descendants of the items described
by \fIitemDesc\fR will also be collapsed.
For every item that actually will be collapsed, two events are generated:
a \fB<Collapse-before>\fR event before the item state is changed,
and a \fB<Collapse-after>\fR event after the item state was changed.
.TP
\fIpathName\fR \fBitem compare\fR \fIitemDesc1\fR \fIop\fR \fIitemDesc2\fR
From both items described by the \fIitemDesc\fRs the index is retrieved
(as returned from the \fBitem order\fR widget command).
Then these indexes are compared using the operator \fIop\fR, which must
be either \fB<\fR,  \fB<=\fR,  \fB==\fR, \fB>=\fR, \fB>\fR,
or \fB!=\fR.
The return value of this command is 1 if the comparison evaluated to true,
0 otherwise.
.TP
\fIpathName\fR \fBitem complex\fR \fIitemDesc\fR ?\fIlist...\fR?
This horrible command is now deprecated. Use \fBitem element configure\fR
instead. For every column of the treectrl there may be specified one \fIlist\fR.
Each \fIlist\fR should look like this:
.nf

{ {element option value ...} {element option value ...} ...}

.fi
Every \fIoption\fR must be known by the element's type
(see \fBELEMENTS\fR below).
Each \fIoption\fR will be set to \fIvalue\fR for the element in this
one column in this item.
.TP
\fIpathName\fR \fBitem configure\fR \fIitemDesc\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
If no \fIoption\fR is specified, returns a list describing all of the available
options for the item given by \fIitemDesc\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list). If \fIoption\fR is specified with no
value, then the command returns a list describing the one named option (this
list will be identical to the corresponding sublist of the value returned if
no \fIoption\fR is specified).
.sp
If one or more \fIoption\fR-\fIvalue\fR pairs
are specified, then the command modifies the given item option(s) to have the
given value(s); in this case the command returns an empty string. This is the
only case where \fIitemDesc\fR may refer to multiple items.
.sp
The following options are supported by this command (see \fBitem create\fR for
the meaning of each option):
.RS
.TP
\fB\fB-button\fR\fR \fIboolean|auto\fR
.TP
\fB\fB-height\fR\fR \fIheight\fR
.TP
\fB\fB-tags\fR\fR \fItagList\fR
.TP
\fB\fB-visible\fR\fR \fIboolean\fR
.TP
\fB\fB-wrap\fR\fR \fIboolean\fR
.RE
.TP
\fIpathName\fR \fBitem count\fR ?\fIitemDesc\fR?
If no additional arguments are given, the result is a decimal string giving the number of
items created by the \fBitem create\fR widget command which haven't been
deleted by the \fBitem delete\fR widget command, plus 1 for the ever-present
root item.
If the optional argument \fIitemDesc\fR is given, then the result is the
number of items that match that \fBitem description\fR.
.TP
\fIpathName\fR \fBitem create\fR ?\fIoption value ...\fR?
Creates some new items and optionally returns a list of unique identifiers for
those items.
The new items have the states \fBopen\fR and \fBenabled\fR set by default.
If the treectrl widget currently has the focus,
the state \fBfocus\fR is also set.
.sp
The following options are supported by this command:
.RS
.TP
\fB\fB-button\fR\fR \fIboolean|auto\fR
The value of this option must have one of the forms accepted by \fBTcl_GetBoolean\fR
or be the word \fBauto\fR (or any abbreviation of it). It indicates whether or not an expand/collapse
button should be drawn next to the item, typically to indicate that the item has
children.
If the value of this option is \fBauto\fR, then a button is displayed next to the
item whenever the item has any children whose item option \fB-visible\fR is true.
The button will only be displayed if:
.RS
.IP [1]
the column specified by the treectrl option \fB-treecolumn\fR is visible, and
.IP [2]
the treectrl option \fB-showbuttons\fR is true, and
.IP [3]
for the root item, the treectrl option \fB-showrootbutton\fR is true.
.RE
.TP
\fB\fB-count\fR\fR \fInumItems\fR
Specifies the number of items to create. Must be >= 0. Defaults to 1.
.TP
\fB\fB-height\fR\fR \fIheight\fR
Specifies a fixed height in any of the forms acceptable to \fBTk_GetPixels\fR.
Must be >= 0. If \fIheight\fR is zero then the item's height is unspecified.
Defaults to 0.
.TP
\fB\fB-nextsibling\fR\fR \fIitemDesc\fR
Specifies the item before which the new items will be inserted. The new items
will have the same parent as \fIitemDesc\fR.
.TP
\fB\fB-open\fR\fR \fIboolean\fR
Specifies whether the items should be open or closed. Default is true.
.TP
\fB\fB-parent\fR\fR \fIitemDesc\fR
Specifies the item which the new items will be the children of. The new items
will be appended to the list of children of \fIitemDesc\fR.
.TP
\fB\fB-prevsibling\fR\fR \fIitemDesc\fR
Specifies the item after which the new items will be inserted. The new items
will have the same parent as \fIitemDesc\fR.
.TP
\fB\fB-returnid\fR\fR \fIboolean\fR
Specifies whether or not to return a list of item identifiers for the newly
created items. Specifying false is useful when creating a large number of items in the
console or to improve performance. Default is true.
.TP
\fB\fB-tags\fR\fR \fItagList\fR
\fITagList\fR is a list of tag names to be added to the new items.
.TP
\fB\fB-visible\fR\fR \fIboolean\fR
\fIBoolean\fR must have one of the forms accepted by \fBTcl_GetBoolean\fR. It
indicates that the item should be displayed in the list. The item will only be
displayed if:
a) each ancestor is a descendant of the root item (not an orphan);
and b) each ancestor's \fB-visible\fR option is true
.TP
\fB\fB-wrap\fR\fR \fIboolean\fR
\fIBoolean\fR must have one of the forms accepted by \fBTcl_GetBoolean\fR. It
indicates that this item should be the first one in a horizontal range or
vertical range of items. See also the widget option \fB-wrap\fR.
.RE
.TP
\fIpathName\fR \fBitem delete\fR \fIfirst\fR ?\fIlast\fR?
Deletes the specified item(s).
\fIFirst\fR and \fIlast\fR must be valid
\fBitem descriptions\fR.
If \fIlast\fR isn't specified, then \fIfirst\fR may specify multiple items.
If both \fIfirst\fR and \fIlast\fR are specified,
they must each decribe a single item with a common ancestor;
then the range of items between \fIfirst\fR and \fIlast\fR is deleted.
The order of \fIfirst\fR and \fIlast\fR doesn't matter.
.sp
Deleting an item deletes any child items of the deleted item recursively.
If the current \fBactive\fR item is deleted, the root item becomes the new active item.
If the current selection \fBanchor\fR item is deleted, the root item becomes the new anchor item.
There is no way to delete the root item of the treectrl widget;
in all cases the specification of the root item is ignored.
.sp
For each call to this command, two events may be generated.
If any of the deleted items are selected, then a \fB<Selection>\fR event
is generated just before the items are deleted.
If any items are going to be deleted, then an \fB<ItemDelete>\fR event event is generated just before the items
are deleted.
.TP
\fIpathName\fR \fBitem descendants\fR \fIitemDesc\fR
Returns a list containing the item ids of the descendants
of the item specified by \fIitemDesc\fR, i.e. the children, grandchildren,
great-grandchildren etc, of the item.
.TP
\fIpathName\fR \fBitem dump\fR \fIitemDesc\fR
Returns a list with 4 words in the form
\fBindex\fR \fIindex\fR \fBindexVis\fR \fIindexVis\fR.
.TP
\fIpathName\fR \fBitem element\fR \fIcommand\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR ?\fIarg ...\fR?
This command is used to manipulate elements of the item.
The exact behavior of the command depends on the \fIcommand\fR argument
that follows the \fBelement\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBitem element actual\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR \fIoption\fR
Deprecated. Use \fBitem element perstate\fR instead.
.TP
\fIpathName\fR \fBitem element cget\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR \fIoption\fR
This command returns the value of the option named \fIoption\fR
associated with \fIelement\fR inside \fIcolumn\fR of the item described by
\fIitemDesc\fR, if it was already configured for the actual item.
\fIOption\fR may have any of the values accepted by the type of the
specified element (see \fBELEMENTS\fR below)
.TP
\fIpathName\fR \fBitem element configure\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command modifies configuration options for an element in a column of
an item.
If no \fIoption\fR is specified, the command returns a list describing
all of the available options for the element (see \fBTk_ConfigureInfo\fR
for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no \fIoption\fR
is specified).
.sp
If one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s) in the
\fIelement\fR inside \fIcolumn\fR of the item(s) described by \fIitemDesc\fR;
in this case the command returns an empty string. This is the only case where
\fIitemDesc\fR may refer to multiple items.
.sp
It is possible to configure multiple elements in multiple columns with
a single call. To configure another element in the same column, append a
\'\fB+\fR' argument followed by the element name. To configure elements in
another column, append a '\fB,\fR' argument followed by the column.
For example:
.nf

.t item element configure $I \\
	$C1 $E1 -text "hello" + $E2 -text "world" , \\
	$C2 $E3 -fill Blue , \\
	$C3 $E1 -text "apples and oranges"

.fi
Each of the \fBcolumn description\fR arguments
to this command may refer to multiple columns if at least one
\fIoption\fR-\fIvalue\fR pair is given.
.TP
\fIpathName\fR \fBitem element perstate\fR \fIitemDesc\fR \fIcolumn\fR \fIelement\fR \fIoption\fR ?\fIstateList\fR?
This command returns the current value of the \fBper-state\fR
option named \fIoption\fR for \fIelement\fR inside \fIcolumn\fR of the item described by
\fIitemDesc\fR. If \fIstateList\fR is specified, the list of state names (static
and dynamic, see \fBSTATES\fR) is used in place of the current state for
\fIitem\fR and \fIcolumn.\fR
.RE
.TP
\fIpathName\fR \fBitem enabled\fR \fIitemDesc\fR ?\fIboolean\fR?
Returns 1 if the item described by \fIitemDesc\fR has the
state \fBenabled\fR switched on, 0 otherwise. If \fIboolean\fR is specified,
then the \fBenabled\fR state of every item described by the
\fBitem description\fR \fIitemDesc\fR is set accordingly.
All items are enabled when first created. Disabled items cannot be selected,
and are ignored by the default key-navigation and mouse bindings.
.TP
\fIpathName\fR \fBitem expand\fR \fIitemDesc\fR ?\fB-recurse\fR?
Switches on the \fBopen\fR state of the item(s) described by \fIitemDesc\fR.
If an item has descendants, then they are now displayed.
If an item is already open, then this command has no effect on that item.
If \fB-recurse\fR is specified, then all descendants of the items described by
\fIitemDesc\fR will also be expanded.
For every item that actually will be expanded, two events are generated:
an \fB<Expand-before>\fR event before the item state is changed,
and an \fB<Expand-after>\fR event after the item state was changed.
.TP
\fIpathName\fR \fBitem firstchild\fR \fIparent\fR ?\fIchild\fR?
If \fIchild\fR is not specified, returns the item id of the first
child of the item described by \fIparent\fR.
If \fIchild\fR is specified, it must describe an item
that is neither the root item nor an ancestor of \fIparent\fR.
Then it will become the new first child of \fIparent\fR.
.TP
\fIpathName\fR \fBitem id\fR \fIitemDesc\fR
This command resolves the \fBitem description\fR
\fIitemDesc\fR into a list of unique item identifiers. If \fIitemDesc\fR
doesn't refer to any existing items, then this command returns an empty list.
.TP
\fIpathName\fR \fBitem image\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fIimage\fR? ?\fIcolumn image ...\fR?
This command sets or retrieves the value of the \fBper-state\fR
-image option for the first image element in one or more columns.
If no \fIcolumn\fR is specified, this command returns a list of values,
one per column.
If no \fIimage\fR is specified, this command returns the value for \fIcolumn\fR.
.sp
If one or more \fIcolumn\fR-\fIimage\fR pairs is specified,
then the value of the -image option in each \fIcolumn\fR is set to \fIimage\fR.
In this case \fIitemDesc\fR may refer to multiple items and each \fIcolumn\fR
may refer to multiple columns.
.sp
Note that this command is provided as a convenience. Use the
\fBitem element configure\fR or \fBitem element cget\fR commands if you want
to set or retrieve the value of the -image option for a specific image element.
.TP
\fIpathName\fR \fBitem isancestor\fR \fIitemDesc\fR \fIdescendant\fR
Returns 1 if the item described by \fIitemDesc\fR is a direct or indirect
parent of the item decribed by \fIdescendant\fR, 0 otherwise.
.TP
\fIpathName\fR \fBitem isopen\fR \fIitemDesc\fR
Returns 1 if the item described by \fIitemDesc\fR has the
state \fBopen\fR switched on, 0 otherwise.
.TP
\fIpathName\fR \fBitem lastchild\fR \fIparent\fR ?\fIchild\fR?
If \fIchild\fR is not specified, returns the item id of the last
child of the item described by \fIparent\fR.
If \fIchild\fR is specified, it must describe an item
that is not an ancestor of \fIparent\fR.
Then it will become the new last child of \fIparent\fR.
.TP
\fIpathName\fR \fBitem nextsibling\fR \fIsibling\fR ?\fInext\fR?
If \fInext\fR is not specified, returns the item id of the next
sibling of the item described by \fIsibling\fR.
If \fInext\fR is specified, it must describe an item
that is not an ancestor of \fIsibling\fR.
Then it will become the new next sibling of \fIsibling\fR.
.TP
\fIpathName\fR \fBitem numchildren\fR \fIitemDesc\fR
Returns the number of children of the item described by \fIitemDesc\fR.
.TP
\fIpathName\fR \fBitem order\fR \fIitemDesc\fR ?\fI-visible\fR?
This command returns the position of the item \fIitemDesc\fR relative to
its toplevel ancestor (usually the root item, unless the ancestor is an
orphan). If you imagine all the items flattened into a vertical list, the
result of this command is the row the item falls in. If the optional argument
\fI-visible\fR is given, only the items whose ancestors are expanded, and whose
-visible option is true, get counted; in this case -1 is returned if the item
is not visible.
.TP
\fIpathName\fR \fBitem parent\fR \fIitemDesc\fR
Returns the item id of the parent of the item
described by \fIitemDesc\fR.
.TP
\fIpathName\fR \fBitem prevsibling\fR \fIsibling\fR ?\fIprev\fR?
If \fIprev\fR is not specified, returns the item id of the previous
sibling of the item described by \fIsibling\fR.
If \fIprev\fR is specified, it must describe an item
that is not an ancestor of \fIsibling\fR.
Then it will become the new previous sibling of \fIsibling\fR.
.TP
\fIpathName\fR \fBitem range\fR \fIfirst\fR \fIlast\fR
Returns a list containing the item ids of all items
in the range between \fIfirst\fR and \fIlast\fR, inclusive.
The order between \fIfirst\fR and \fIlast\fR doesn't matter,
and the result is always sorted by the increasing order of the items (as
returned by the \fBitem order\fR command).
The items specified by \fIfirst\fR and \fIlast\fR must share a common
ancestor.
.TP
\fIpathName\fR \fBitem remove\fR \fIitemDesc\fR
Removes the item described by \fIitemDesc\fR
from the list of children of its parent, so that it will become an orphan.
.TP
\fIpathName\fR \fBitem rnc\fR \fIitemDesc\fR
Returns a list of two integers, which corresponds to the row and column
of the item described by \fIitemDesc\fR. The row and column corresponds to
the on-screen arrangement of items as determined by the -orient and -wrap
options. If the item is not displayed, this command returns an empty string.
.TP
\fIpathName\fR \fBitem sort\fR \fIitemDesc\fR ?\fIoption ...\fR?
Sorts the children of the item described by \fIitemDesc\fR,
and redisplays the tree with the items in the new order.
.sp
The range of items which should be sorted can be restricted
by means of the \fB-first\fR and/or \fB-last\fR options,
which should be children of the item described by \fIitemDesc\fR;
the order between these two limiting items doesn't matter.
.sp
The sort column can be specified by means of the \fB-column\fR option;
this option can be used repeatedly to define a multicolumn sort.
The sorting is done by looking at the \fItext\fR
of the element specified by the \fB-element\fR option,
which must be a text element defined in the style of the sorting column,
by default the first text element is used.
.sp
If the \fB-notreally\fR option is specified,
no rearranging of the items is done;
instead the sorted items are returned as result of the command.
.sp
By default ASCII sorting is used with the result returned in increasing order.
Any of the following options may be specified to control
the sorting process of the previously specified column
(unique abbreviations are accepted):
.RS
.TP
\fB\fB-ascii\fR\fR
Use string comparison with ASCII collation order. This is the default.
.TP
\fB\fB-command\fR\fR \fIcommand\fR
Use \fIcommand\fR as a comparison command.
To compare two items, evaluate a Tcl script consisting of
\fIcommand\fR with the numerical ids of the two items appended as additional
arguments.  The script should return an integer less than,
equal to, or greater than zero if the first item is to
be considered less than, equal to, or greater than the second,
respectively.
.TP
\fB\fB-decreasing\fR\fR
Sort the items in decreasing order ("largest" items first).
.TP
\fB\fB-dictionary\fR\fR
Use dictionary-style comparison. This is the same as \fB-ascii\fR
except (a) case is ignored except as a tie-breaker and (b) if two
strings contain embedded numbers, the numbers compare as integers,
not characters.  For example, in \fB-dictionary\fR mode, \fIbigBoy\fR
sorts between \fIbigbang\fR and \fIbigboy\fR, and \fIx10y\fR
sorts between \fIx9y\fR and \fIx11y\fR.
.TP
\fB\fB-increasing\fR\fR
Sort the items in increasing order ("smallest" items first). This is the default.
.TP
\fB\fB-integer\fR\fR
Convert to integers and use integer comparison.
.TP
\fB\fB-real\fR\fR
Convert to floating-point values and use floating comparison.
.RE
.TP
\fIpathName\fR \fBitem span\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fInumColumns\fR? ?\fIcolumn numColumns ...\fR?
This command sets or retrieves the number of columns that a style covers.
If no \fIcolumn\fR is specified, the return value is a list of spans, one per column.
If no \fInumColumns\fR is specified, the return value is the span for \fIcolumn\fR.
.sp
If one or more \fIcolumn\fR-\fInumColumns\fR pairs is specified, the
span for each \fIcolumn\fR is set to \fInumColumns\fR. In this case \fIitemDesc\fR
may refer to multiple items and each \fIcolumn\fR may refer to multiple
columns.
.TP
\fIpathName\fR \fBitem state\fR \fIcommand\fR \fIitemDesc\fR ?\fIarg ...\fR?
This command is used to manipulate the states of an item.
The exact behavior of the command depends on the \fIcommand\fR argument
that follows the \fBstyle\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBitem state forcolumn\fR \fIitemDesc\fR \fIcolumn\fR ?\fIstateDescList\fR?
Just like \fBitem state set\fR but manipulates dynamic states for a single
item column, not the item as a whole. If \fIstateDescList\fR is unspecified,
this command returns a list containing the names of all the dynamic states
which are switched on in \fIcolumn\fR.
.sp
If \fIstateDescList\fR is specified, then \fIitemDesc\fR may refer to multiple
items and \fIcolumn\fR may refer to multiple columns.
.TP
\fIpathName\fR \fBitem state get\fR \fIitemDesc\fR ?\fIstateName\fR?
If no \fIstateName\fR is specified, returns a list containing
the names of all (static and dynamic) states
which are currently switched on for the item described by \fIitemDesc\fR.
If a \fIstateName\fR is specified,
1 is returned if the specified state is currently switched on for the item,
0 otherwise.
.TP
\fIpathName\fR \fBitem state set\fR \fIitemDesc\fR ?\fIlastItem\fR? \fIstateDescList\fR
Every element of \fIstateDescList\fR
must be the name of a dynamic state (see \fBSTATES\fR below),
optionally preceded by a \fB~\fR or \fB!\fR character.
Every state with a leading \fB!\fR will be switched off for the
item described by \fIitemDesc\fR,
every state with a leading \fB~\fR will be toggled, and
every state without leading \fB!\fR or \fB~\fR will be switched on.
If \fIlastItem\fR is specified, the state changes will be made for all items
in the range between \fIitemDesc\fR and \fIlastItem\fR.
If \fIlastItem\fR unspecified,
then the state changes are made for all items described by \fIitemDesc\fR.
.RE
.TP
\fIpathName\fR \fBitem style\fR \fIcommand\fR \fIitemDesc\fR ?\fIarg ...\fR?
This command is used to manipulate the styles of an item.
The exact behavior of the command depends on the \fIcommand\fR argument
that follows the \fBstyle\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBitem style elements\fR \fIitemDesc\fR \fIcolumn\fR
This command returns a list containing the names of elements which were
configured by the \fBitem element configure\fR command for the item
described by \fIitemDesc\fR in \fIcolumn\fR. If there is no style assigned
to \fIcolumn\fR an error is returned.
.TP
\fIpathName\fR \fBitem style map\fR \fIitemDesc\fR \fIcolumn\fR \fIstyle\fR \fImap\fR
Like the \fBitem style set\fR command, this command may be used to assign a
style to a specific column of an item. Unlike \fBitem style set\fR, this
command can transfer configuration values of elements in the current style
to elements in the new style specified by \fIstyle\fR.
\fIMap\fR must be a list of \fIelementOld\fR-\fIelementNew\fR pairs, where
\fIelementOld\fR is an element in the current style, and \fIelementNew\fR is
an element in the style specified by \fIstyle\fR. Both \fIelementOld\fR and
\fIelementNew\fR must be of the same type (\fBbitmap\fR, \fBtext\fR etc).
\fIItemDesc\fR may refer to multiple items and \fIcolumn\fR may refer to
multiple columns.
.TP
\fIpathName\fR \fBitem style set\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fIstyle\fR? ?\fIcolumn style ...\fR?
This command sets or retrieves the style assigned to one or more columns.
If no \fIcolumn\fR is specified, this command returns a list containing the names of the
styles set for all columns of the item described by \fIitemDesc\fR.
If no \fIstyle\fR is specified, this command
returns the name of the style set for the item described by
\fIitemDesc\fR in \fIcolumn\fR.
.sp
If one or more \fIcolumn\fR-\fIstyle\fR pairs is specified,
then the style in each \fIcolumn\fR is set to \fIstyle\fR. In this case
\fIitemDesc\fR may refer to multiple items and each \fIcolumn\fR may refer to
multiple columns.
.RE
.TP
\fIpathName\fR \fBitem tag\fR \fIoption\fR ?\fIarg arg ...\fR?
This command is used to manipulate tags on items.
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBitem tag\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBitem tag add\fR \fIitemDesc\fR \fItagList\fR
Adds each tag in \fItagList\fR to the items specified by the
\fBitem description\fR \fIitemDesc\fR.
Duplicate tags are ignored. The list of tags for an item can also be
changed via an item's \fB-tags\fR option.
.TP
\fIpathName\fR \fBitem tag expr\fR \fIitemDesc\fR \fItagExpr\fR
Evaluates the tag expression \fItagExpr\fR against every item
specified by the \fBitem description\fR
\fIitemDesc\fR. The result is 1 if the tag expression evaluates to true
for every item, 0 otherwise.
.TP
\fIpathName\fR \fBitem tag names\fR \fIitemDesc\fR
Returns a list of tag names assigned to the items
specified by the \fBitem description\fR
\fIitemDesc\fR. The result is the union of any tags assigned to the
items.
.TP
\fIpathName\fR \fBitem tag remove\fR \fIitemDesc\fR \fItagList\fR
Removes each tag in \fItagList\fR from the items specified by the
\fBitem description\fR \fIitemDesc\fR.
It is not an error if any of the items do not use any of the tags.
The list of tags for an item can also be changed via an item's
\fB-tags\fR option.
.RE
.TP
\fIpathName\fR \fBitem text\fR \fIitemDesc\fR ?\fIcolumn\fR? ?\fItext\fR? ?\fIcolumn text ...\fR?
This command sets or retrieves the value of the -text option for the first
text element in one or more columns.
If no \fIcolumn\fR is specified, this command returns a list of values,
one per column.
If no \fItext\fR is specified, this command returns the value for \fIcolumn\fR.
.sp
If one or more \fIcolumn\fR-\fItext\fR pairs is specified,
then the value of the -text option in each \fIcolumn\fR is set to \fItext\fR.
In this case \fIitemDesc\fR may refer to multiple items and each \fIcolumn\fR
may refer to multiple columns.
.sp
Note that this command is provided as a convenience. Use the
\fBitem element configure\fR or \fBitem element cget\fR commands if you
want to set or retrieve the value of the -text option for a specific text element.
.TP
\fIpathName\fR \fBitem toggle\fR \fIitemDesc\fR ?\fB-recurse\fR?
Changes the \fBopen\fR state of the item(s) described by \fIitemDesc\fR.
If the \fBopen\fR state is currently switched off, then
this command does the same as the \fBitem expand\fR widget command;
otherwise the same as the \fBitem collapse\fR widget command.
If \fB-recurse\fR is specified, then the \fBopen\fR state of all descendants of
the items described by \fIitemDesc\fR will also be toggled.
.RE
.TP
\fIpathName\fR \fBmarquee\fR \fIoption\fR ?\fIarg ...\fR?
This command is used to manipulate the marquee,
a rectangular region of the treectrl widget
optionally marked with a surrounding dotted line.
One corner point of the marquee is fixed as long as the marquee is visible
and called the anchor; the diagonally opposite corner is dragged with the
mouse while resizing the marquee and simply called the corner.
All coordinates handled by this widget command are treectrl coordinates,
i.e. the \fBcanvasx\fR or \fBcanvasy\fR widget command should be
used before any window coordinates can be used.
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBmarquee\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBmarquee anchor\fR ?\fIx y\fR?
Returns a list containing the x and y coordinates of the anchor,
if no additional arguments are specified.
If two coordinates are specified,
sets the anchor to the given coordinates \fIx\fR and \fIy\fR.
.TP
\fIpathName\fR \fBmarquee cget\fR \fIoption\fR
This command returns the current value of the marquee option
named \fIoption\fR.
\fIOption\fR may have any of the values accepted by the
\fBmarquee configure\fR widget command.
.TP
\fIpathName\fR \fBmarquee configure\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies the marquee options
instead of modifying options for the overall treectrl widget.
If no \fIoption\fR is specified, the command returns a list describing
all of the available marquee options (see \fBTk_ConfigureInfo\fR
for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
a list describing the one named marquee option (this list will be identical to
the corresponding sublist of the value returned if no \fIoption\fR
is specified).
If one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given marquee option(s) to have the given value(s);
in this case the command returns an empty string.
.sp
The following marquee options are supported:
.RS
.TP
\fB\fB-visible\fR\fR \fIboolean\fR
Specifies a boolean value which determines
whether the dotted line surrounding the region of the marquee
should currently be visible.
.RE
.TP
\fIpathName\fR \fBmarquee coords\fR ?\fIx1 y1 x2 y2\fR?
Returns a list containing the x and y coordinates of the anchor
followed by the x and y coordinates of the corner,
if no additional arguments are specified.
If four coordinates are specified,
sets the anchor to the given coordinates \fIx1\fR and \fIy1\fR
and the corner to the coordinates \fIx2\fR and \fIy2\fR.
.TP
\fIpathName\fR \fBmarquee corner\fR ?\fIx y\fR?
Returns a list containing the x and y coordinates of the corner,
if no additional arguments are specified.
If two coordinates are specified,
sets the corner to the given coordinates \fIx\fR and \fIy\fR.
.TP
\fIpathName\fR \fBmarquee identify\fR
Returns a list with information about any items intersecting the marquee.
The format of the returned list is:
.nf

{
    {item {column element element ...} {column element element ...} ...}
    {item {column element element ...} {column element element ...} ...}
    ...
}

.fi
There may be zero sublists following an item id if the marquee is in the
button/line area of an item. There may be zero element names following a
column id if the item-column has no style or if the marquee does not
intersect any elements in that column.
.RE
.TP
\fIpathName\fR \fBnotify\fR \fIoption\fR ?\fIarg ...\fR?
Many Tk widgets communicate with the outside world via \fB-command\fR
callbacks and/or virtual events. For example, the Text widget
evaluates its \fB-yscrollcommand\fR when the view in the widget changes,
and generates a <<Modified>> virtual event when text is inserted or deleted.
A treectrl widget replaces both methods of communication with its own event
mechanism accessed through the \fBnotify\fR subcommands.
.sp
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBnotify\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBnotify bind\fR ?\fIobject\fR? ?\fIpattern\fR? ?+??\fIscript\fR?
This command associates Tcl scripts with events generated by a
treectrl widget.
If all three arguments are specified, \fBnotify bind\fR will arrange for
\fIscript\fR (a Tcl script) to be evaluated whenever the event(s) specified
by \fIpattern\fR are generated by this treectrl widget.
If \fIscript\fR is prefixed with a "+", then it is appended to any existing
binding for \fIpattern\fR;  otherwise \fIscript\fR replaces any existing binding.
If \fIscript\fR is an empty string then the current binding for \fIpattern\fR
is destroyed, leaving \fIpattern\fR unbound. In all of the cases where a script
argument is provided, \fBnotify bind\fR returns an empty string.
.sp
If \fIpattern\fR is specified without a \fIscript\fR, then the script currently
bound to \fIpattern\fR is returned, or an empty string is returned if there is
no binding for \fIpattern\fR. If neither \fIpattern\fR nor \fIscript\fR is
specified, then the return value is a list whose elements are all the patterns
for which there exist bindings for \fIobject\fR.
.sp
The \fIobject\fR argument determines which window(s) the binding applies to.
If \fIobject\fR begins with a dot, as in .a.b.c, then it must be the path name
for a window; otherwise it may be an arbitrary string. Like the regular
\fBbind\fR command, bindings on window names are automatically removed if
that window is destroyed.
.TP
\fIpathName\fR \fBnotify configure\fR \fIobject\fR \fIpattern\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command sets and retrieves options for bindings created by the
\fBnotify bind\fR command.
.sp
If no \fIoption\fR is specified, the command returns a list with
\fIoption\fR-\fIvalue\fR pairs describing all
the available binding options for \fIpattern\fR on \fIobject\fR.
If \fIoption\fR is specified with no \fIvalue\fR,
then the command returns the current value of that option.
If one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s) for the binding;
in this case the command returns an empty string.
.sp
The following binding options are supported:
.RS
.TP
\fB\fB-active\fR\fR \fIboolean\fR
Specifies if the binding should be active.
As long as this option is specified as false,
a binding script will not be evaluated when the corresponding event is
generated.
.RE
.TP
\fIpathName\fR \fBnotify detailnames\fR \fIeventName\fR
Returns a list containing the names of all details,
which are installed for the event with the name \fIeventName\fR
by means of the \fBnotify install\fR widget command
or by the treectrl widget itself.
.TP
\fIpathName\fR \fBnotify eventnames\fR
Returns a list containing the names of all events,
which are installed by means of the \fBnotify install\fR widget command
or by the treectrl widget itself.
.TP
\fIpathName\fR \fBnotify generate\fR \fIpattern\fR ?\fIcharMap\fR? ?\fIpercentsCommand\fR?
This command causes the treectrl widget to generate an event. This command is
typically used to generate dynamic events created by the \fBnotify install\fR
command, but may be used to generate static events also.
The event specified by \fIpattern\fR is generated, and any active binding
scripts on the event are evaluated after undergoing %-substitution.
If there are details defined for the event,
\fIpattern\fR must describe an <\fIeventName\fR-\fIdetail\fR> pair,
otherwise \fIpattern\fR should be <\fIeventName\fR>.
.sp
The optional \fIcharMap\fR is a list of \fIchar\fR-\fIvalue\fR pairs
as in the form returned by \fBarray get\fR.
Each \fIchar\fR has to be exactly one character.
The \fIcharMap\fR is used in %-substitution.
.sp
If \fIpercentsCommand\fR is specified, then it will be used to perform %-substitution
on any scripts bound to the event. If \fIpercentsCommand\fR is not specified and
the event is dynamic, then the %-subtitution command passed to \fBnotify install\fR
will be used if it was provided. If the event is static or no %-substitution
command is available, then all %-substitution is done using \fIcharMap\fR only .
See \fBnotify install\fR for a description of \fIpercentsCommand\fR.
.TP
\fIpathName\fR \fBnotify install\fR \fIpattern\fR ?\fIpercentsCommand\fR?
This command installs a new event or detail specified by \fIpattern\fR.
Events created by this command are called dynamic,
whereas events created by the treectrl widget itself are called static.
This command may be called to set or retrieve the \fIpercentsCommand\fR for
an existing dynamic event.
.sp
The optional \fIpercentsCommand\fR is a list containing the name of a Tcl
command, plus any optional arguments, to which five additional arguments
will be appended. The command will be called to perform %-substitution on any
scripts bound to the event specified by \fIpattern\fR (see \fBEVENTS AND SCRIPT SUBSTITUTIONS\fR).
\fIPercentsCommand\fR should be defined as follows:
.nf

proc percentsCommand {?arg arg ...? char object event detail charMap} {
	switch -- $char {
		...
	}
	return $value
}

.fi
The optional \fIarg\fR arguments are part of the \fIpercentsCommand\fR list.
\fIChar\fR is the %-character to be substituted. \fIObject\fR is the same
as the argument to \fBnotify bind\fR. \fIEvent\fR and \fIdetail\fR specify
the event. \fICharMap\fR is the same as the argument to \fBnotify generate\fR.
\fIPercentsCommand\fR should return the value to replace the %-character by.
If an error occurs evaluating \fIpercentsCommand\fR, the %-character is replaced
by itself.
.sp
\fBnotify install\fR returns the current \fIpercentsCommand\fR for the event,
or an error if the event is not dynamic.
.TP
\fIpathName\fR \fBnotify install detail\fR \fIeventName\fR \fIdetail\fR ?\fIpercentsCommand\fR?
Deprecated.
Use \fBnotify install\fR with a \fIpattern\fR of <\fIeventName\fR-\fIdetail\fR> instead.
.TP
\fIpathName\fR \fBnotify install event\fR \fIeventName\fR ?\fIpercentsCommand\fR?
Deprecated.
Use \fBnotify install\fR with a \fIpattern\fR of <\fIeventName\fR> instead.
.TP
\fIpathName\fR \fBnotify linkage\fR \fIpattern\fR
Returns a string indicating
whether the specified event or detail is created
by means of the \fBnotify install\fR widget command (\fBdynamic\fR)
or by the treectrl widget itself (\fBstatic\fR).
.TP
\fIpathName\fR \fBnotify linkage\fR \fIeventName\fR ?\fIdetail\fR?
Deprecated.
Use \fBnotify linkage\fR with a \fIpattern\fR of <\fIeventName\fR> or
<\fIeventName\fR-\fIdetail\fR> instead.
.TP
\fIpathName\fR \fBnotify unbind\fR \fIobject\fR ?\fIpattern\fR?
If no \fIpattern\fR is specified, all bindings on \fIobject\fR are removed.
If \fIpattern\fR is specified, then the current binding for \fIpattern\fR
is destroyed, leaving \fIpattern\fR unbound.
.TP
\fIpathName\fR \fBnotify uninstall\fR \fIpattern\fR
If the event or detail specified by \fIpattern\fR is static
(i.e. created by the treectrl widget itself), an error is generated.
Otherwise the dynamic event or detail is removed. If an event name is specified
without a detail, all details for that event are also removed.
.TP
\fIpathName\fR \fBnotify uninstall detail\fR \fIeventName\fR \fIdetail\fR
Deprecated.
Use \fBnotify uninstall\fR with a \fIpattern\fR of <\fIeventName\fR-\fIdetail\fR> instead.
.TP
\fIpathName\fR \fBnotify uninstall event\fR \fIeventName\fR
Deprecated.
Use \fBnotify uninstall\fR with a \fIpattern\fR of <\fIeventName\fR> instead.
.RE
.TP
\fIpathName\fR \fBnumcolumns\fR
Deprecated. Use the \fBcolumn count\fR command instead.
.TP
\fIpathName\fR \fBnumitems\fR
Deprecated. Use the \fBitem count\fR command instead.
.TP
\fIpathName\fR \fBorphans\fR
Returns a list containing the item ids of all items
which have no parent.
When an item is created, it has no parent by default,
and can later become an orphan
by means of the \fBitem remove\fR widget command. The root item is not returned.
.TP
\fIpathName\fR \fBrange\fR \fIfirst\fR \fIlast\fR
Deprecated. Use the \fBitem range\fR command instead.
.TP
\fIpathName\fR \fBscan\fR \fIoption\fR \fIargs\fR
This command is used to implement scanning on treectrls. It has two forms,
depending on \fIoption\fR:
.RS
.TP
\fIpathName\fR \fBscan mark\fR \fIx\fR \fIy\fR
Records \fIx\fR and \fIy\fR and the treectrl's current view;  used in conjunction with
later \fBscan dragto\fR commands. Typically this command is associated with a
mouse button press in the widget and \fIx\fR and \fIy\fR are the coordinates of the
mouse. It returns an empty string.
.TP
\fIpathName\fR \fBscan dragto\fR \fIx\fR \fIy\fR ?\fIgain\fR?
This command computes the difference between its \fIx\fR and \fIy\fR arguments (which
are typically mouse coordinates) and the \fIx\fR and \fIy\fR arguments to the last
\fBscan mark\fR command for the widget. It then adjusts the view by \fIgain\fR
times the difference in coordinates, where \fIgain\fR defaults to 10. This
command is typically associated with mouse motion events in the widget,
to produce the effect of dragging the treectrl at high speed through its window.
The return value is an empty string.
.RE
.TP
\fIpathName\fR \fBsee\fR \fIitemDesc\fR ?\fIcolumnDesc\fR? ?\fIoption value ...\fR?
Adjust the view in the treectrl so that the item described by \fIitemDesc\fR
is visible.
If the item is already visible then the command has no effect;
otherwise the treectrl scrolls to bring the item into view,
and the corresponding \fB<Scroll-x>\fR and/or \fB<Scroll-y>\fR
events are generated. If \fIcolumnDesc\fR is specified then a specific column
of the item is scrolled into view instead of the entire item.
.sp
The following options are supported:
.RS
.TP
\fB\fB-center\fR\fR \fIflags\fR
\fIFlags\fR is a string that contains zero or more of the characters \fBx\fR
or \fBy\fR. This option is used to center the item horizontally and/or
vertically in the window.  The item will be centered regardless of whether it
is already visible.
.RE
.TP
\fIpathName\fR \fBselection\fR \fIoption\fR \fIargs\fR
This command is used to adjust the selection within a treectrl.
It has several forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName\fR \fBselection add\fR \fIfirst\fR ?\fIlast\fR?
\fIFirst\fR and \fIlast\fR (if specified)
must be valid \fBitem descriptions\fR. If both
\fIfirst\fR and \fIlast\fR are specified, then they may refer to a single
item only; in this case
the command adds every unselected item in the range between
\fIfirst\fR and \fIlast\fR, inclusive, to the selection
without affecting the selected state of items outside that range.
If only \fIfirst\fR is specified, then
every unselected item specified by \fIfirst\fR is added to the selection.
A \fB<Selection>\fR event is generated if any items were added to the
selection.
.TP
\fIpathName\fR \fBselection anchor\fR ?\fIitemDesc\fR?
If \fIitemDesc\fR is specified,
the selection anchor is set to the described item.
The selection anchor is the end of the selection that is fixed
while dragging out a selection with the mouse.
The item description \fBanchor\fR may be used to refer to the anchor item.
This command doesn't modify the selection state of any item.
Returns the unique id of the selection anchor item.
.TP
\fIpathName\fR \fBselection clear\fR ?\fIfirst\fR? ?\fIlast\fR?
\fIFirst\fR and \fIlast\fR (if specified)
must be valid \fBitem descriptions\fR. If both
\fIfirst\fR and \fIlast\fR are specified, then they may refer to a single
item only; in this case any selected items between \fIfirst\fR and \fIlast\fR
(inclusive) are removed from the selection without affecting
the selected state of items outside that range.
If only \fIfirst\fR is specified, then
every selected item specified by \fIfirst\fR is removed from the selection.
If neither \fIfirst\fR nor \fIlast\fR are specified,
then all selected items are removed from the selection.
A \fB<Selection>\fR event is generated if any items were removed from the
selection.
.TP
\fIpathName\fR \fBselection count\fR
Returns an integer indicating the number
of items in the treectrl that are currently selected.
.TP
\fIpathName\fR \fBselection get\fR ?\fIfirst\fR? ?\fIlast\fR?
When no additional arguments are given, the result is an unsorted list
containing the item ids of all of the items in the treectrl that are currently selected.
If there are no items selected in the treectrl, then an empty string is returned.
The optional arguments \fIfirst\fR and \fIlast\fR are treated as indices into
the sorted list of selected items; these arguments allow in-place \fBlindex\fR
and \fBlrange\fR operations on the selection. For example:
.nf

.t selection get 0       ; # return the first selected item
.t selection get end     ; # return the last selected item
.t selection get 1 end-1 ; # return every selected item except the first and last

.fi
.TP
\fIpathName\fR \fBselection includes\fR \fIitemDesc\fR
Returns 1 if the item described by \fIitemDesc\fR is currently
selected, 0 if it isn't.
.TP
\fIpathName\fR \fBselection modify\fR \fIselect\fR \fIdeselect\fR
Both arguments \fIselect\fR and \fIdeselect\fR are
a possibly-empty list of \fBitem descriptions\fR.
Any unselected items in \fIselect\fR are added to the selection,
and any selected items in \fIdeselect\fR are removed from the selection (except
for those items which are also in \fIselect\fR).
A \fB<Selection>\fR event is generated if any items were selected or deselected.
.RE
.TP
\fIpathName\fR \fBstate\fR \fIoption\fR \fIargs\fR
This command is used to manipulate the list of user-defined states,
see section \fBSTATES\fR below.
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBstate\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBstate define\fR \fIstateName\fR
Defines a new state with the name \fIstateName\fR,
which must not be the name of an existing state.
.TP
\fIpathName\fR \fBstate linkage\fR \fIstateName\fR
Returns a string indicating
whether the specified state is user-defined
by means of the \fBstate define\fR widget command (\fBdynamic\fR)
or predefined by the treectrl widget itself (\fBstatic\fR).
.TP
\fIpathName\fR \fBstate names\fR
Returns a list containing the names of all user-defined states.
.TP
\fIpathName\fR \fBstate undefine\fR ?\fIstateName ...\fR?
Every \fIstateName\fR must be the name of a user-defined state.
Removes this state from the list of user-defined states.
.RE
.TP
\fIpathName\fR \fBstyle\fR \fIoption\fR ?\fIelement\fR? ?\fIarg arg ...\fR?
This command is used to manipulate styles, which can be thought of
as a geometry manager for elements.
The exact behavior of the command depends on the \fIoption\fR argument
that follows the \fBstyle\fR argument.
The following forms of the command are supported:
.RS
.TP
\fIpathName\fR \fBstyle cget\fR \fIstyle\fR \fIoption\fR
This command returns the current value of the option named \fIoption\fR
associated with the style given by \fIstyle\fR.
\fIOption\fR may have any of the values accepted by the
\fBstyle configure\fR widget command.
.TP
\fIpathName\fR \fBstyle configure\fR \fIstyle\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies options associated with the style given by \fIstyle\fR
instead of modifying options for the overall treectrl widget.
If no \fIoption\fR is specified, the command returns a list describing
all of the available options for \fIstyle\fR (see \fBTk_ConfigureInfo\fR
for information on the format of this list).
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
a list describing the one named option (this list will be identical to
the corresponding sublist of the value returned if no \fIoption\fR
is specified).
If one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s) in \fIstyle\fR;
in this case the command returns an empty string.
.sp
The options of a style have effect on all elements managed by the style.
The following options are supported:
.RS
.TP
\fB\fB-orient\fR\fR \fIvarName\fR
This option specifies which orientation should be used
when laying out the elements associated with this style.
Must be either \fBhorizontal\fR (the default)
or \fBvertical\fR or an abbreviation of one of these.
.RE
.TP
\fIpathName\fR \fBstyle create\fR \fIstyle\fR ?\fIoption value ...\fR?
Create a new style in \fIpathName\fR with name \fIstyle\fR.
After \fIstyle\fR there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the style.  These same \fIoption\fR-\fIvalue\fR pairs may be
used in \fBstyle configure\fR widget commands to change the style's
configuration.
Returns the name of the new style.
.TP
\fIpathName\fR \fBstyle delete\fR ?\fIstyle ...\fR?
Deletes each of the named styles and returns an empty string.
If a style is deleted while it is still used to display
one or more items,
it is also removed from the style list of these items.
.TP
\fIpathName\fR \fBstyle elements\fR \fIstyle\fR ?\fIelementList\fR?
Specifies the elements which should be layed out by this style.
Each element of \fIelementList\fR must be the name of an element
created by the widget command \fBelement create\fR.
Duplicate names in \fIelementList\fR are ignored.
An element which was specified in a former call of this command
for \fIstyle\fR but is not included in \fIelementList\fR,
will be deleted from the elements layed out by \fIstyle\fR.
.sp
If the \fIelementList\fR argument is not specified, a list is returned
containing the currently defined elements of \fIstyle\fR.
.TP
\fIpathName\fR \fBstyle layout\fR \fIstyle\fR \fIelement\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except
that it modifies options used by \fIstyle\fR for laying out \fIelement\fR
instead of modifying options for the overall treectrl widget.
If no \fIoption\fR is specified, the command returns a list with
\fIoption\fR-\fIvalue\fR pairs describing
all of the available options for the layout.
If \fIoption\fR is specified with no \fIvalue\fR, then the command returns
the value of the named option.
If one or more \fIoption\fR-\fIvalue\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s) for the layout;
in this case the command returns an empty string.
.sp
The options of a layout have effect on exactly the one element \fIelement\fR
managed by \fIstyle\fR.
The following options are supported:
.RS
.TP
\fB\fB-detach\fR\fR \fIboolean\fR
Specifies whether the element should be positioned by itself,
i.e. independent from the other elements.
.TP
\fB\fB-draw\fR\fR \fIboolean\fR
This is a \fBper-state\fR option that determines whether
an element should be drawn. If the value of the option evaluates to false for a given
item state, then the element is not drawn, although it still consumes space in
the layout.
.TP
\fB\fB-expand\fR\fR \fIflags\fR
This option allows the external padding around the element
to increase when a style has more screen space than it needs.
\fIFlags\fR is a string that contains zero or more of the characters
\fBn\fR, \fBs\fR, \fBw\fR or \fBe\fR.
Each letter refers to the padding on the top, bottom,
left, or right that should be allowed to increase.
This option is typically used to justify an element.
.TP
\fB\fB-iexpand\fR\fR \fIflags\fR
This option allows the internal padding of the element
and the display area of the element to increase
when a style has more screen space than it needs.
\fIFlags\fR  is a string that contains zero or more of the characters
\fBx\fR, \fBy\fR, \fBn\fR, \fBs\fR, \fBw\fR or \fBe\fR.
For \fBn\fR, \fBs\fR, \fBw\fR and \fBe\fR, each letter refers to the
padding on the top, bottom, left, or right that should be allowed to increase.
For \fBx\fR and \fBy\fR, each letter refers to the horizontal and
vertical screen space the element can display itself in (i.e., the space
between the padding). Note that if the
\fB-union\fR option is specified for this element, then the \fBx\fR and
\fBy\fR flags have no effect, since the size of an element with
\fB-union\fR layout is determined by the elements it surrounds.
.TP
\fB\fB-indent\fR\fR \fIboolean\fR
Specifies whether the element should be positioned to the right of the
button/line area in the tree column. This option is ignored unless the
\fB-detach\fR option is true.
.TP
\fB\fB-ipadx\fR\fR \fIamount\fR
.TP
\fB\fB-ipady\fR\fR \fIamount\fR
\fIAmount\fR specifies how much internal padding to
leave on the left and right (for \fB-ipadx\fR)
or top and bottom (for \fB-ipady\fR) side of the element.
\fIAmount\fR may be a list
of two values to specify padding for the two sides separately,
it defaults to 0.
.TP
\fB\fB-minheight\fR\fR \fIpixels\fR
.TP
\fB\fB-height\fR\fR \fIpixels\fR
.TP
\fB\fB-maxheight\fR\fR \fIpixels\fR
Specifies the minimum, fixed, and maximum height of the element.
.TP
\fB\fB-minwidth\fR\fR \fIpixels\fR
.TP
\fB\fB-width\fR\fR \fIpixels\fR
.TP
\fB\fB-maxwidth\fR\fR \fIpixels\fR
Specifies the minimum, fixed, and maximum width of the element.
.TP
\fB\fB-padx\fR\fR \fIamount\fR
.TP
\fB\fB-pady\fR\fR \fIamount\fR
\fIAmount\fR specifies how much external padding to
leave on the left and right (for \fB-padx\fR)
or top and bottom (for \fB-pady\fR) side of the element.
\fIAmount\fR may be a list
of two values to specify padding for the two sides separately,
it defaults to 0.
.TP
\fB\fB-squeeze\fR\fR \fIflags\fR
This option allows the display area of an element to decrease when a
style has less space than it needs.
\fIFlags\fR is a string that contains zero or more of the characters
\fBx\fR or \fBy\fR.
\fBx\fR allows display area to decrease horizontally,
\fBy\fR allows display area to decrease vertically.
This option is typically used for \fBtext\fR elements and will cause
the text element to display an ellipsis (...) and/or wrap lines.
.TP
\fB\fB-sticky\fR\fR \fIflags\fR
This option controls how the actual display information (image, text, etc)
of an element is positioned (or stretched) within its display area.
\fIFlags\fR is a
string that contains zero or more of the characters \fBn\fR, \fBs\fR,
\fBw\fR or \fBe\fR. Each letter refers to the top, bottom, left or right
side of the display area that the display information should "stick" to.
.TP
\fB\fB-union\fR\fR \fIelementList\fR
Specifies a list of other elements which this element will surround.
The size of an element with \fB-union\fR layout is determined by the
size and position of the elements in \fIelementList\fR.
The \fB-ipadx\fR and \fB-ipady\fR options in this case refer to the
distance of the edges of the display area of this element from those elements
it surrounds. This option is typically used to display a selection rectangle
around a piece of text. If none of the elements in \fIelementList\fR are
visible, then the element is not displayed.
.TP
\fB\fB-visible\fR\fR \fIboolean\fR
This is a \fBper-state\fR option that controls visibility
of an element. If the value of the option evaluates to false for a given
item state, then the element is not displayed and consumes no space in the layout.
.RE
.TP
\fIpathName\fR \fBstyle names\fR
Returns a list containing the names of all existing styles.
.RE
.TP
\fIpathName\fR \fBtoggle\fR ?\fB-recurse\fR? ?\fIitemDesc ...\fR?
Use \fBitem toggle\fR instead.
.TP
\fIpathName\fR \fBxview\fR ?\fIargs\fR?
This command is used to query and change the horizontal position of the
information displayed in the treectrl's window.
It can take any of the following forms:
.RS
.TP
\fIpathName\fR \fBxview\fR
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the horizontal span that is visible in the window.
For example, if the first element is .2 and the second element is .6,
20% of the tree's area
is off-screen to the left, the middle 40% is visible
in the window, and 40% of the tree is off-screen to the right.
These are the same values passed to scrollbars via the \fB-xscrollcommand\fR
option.
.TP
\fIpathName\fR \fBxview moveto\fR \fIfraction\fR
Adjusts the view in the window so that \fIfraction\fR of the
total width of the tree is off-screen to the left.
\fIFraction\fR must be a fraction between 0 and 1.
A \fB<Scroll-x>\fR event is generated.
.TP
\fIpathName\fR \fBxview scroll\fR \fInumber\fR \fIwhat\fR
This command shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an abbreviation
of one of these.
If \fIwhat\fR is \fBunits\fR, the view adjusts left or right in units
determined by the \fB-xscrollincrement\fR option (which may be zero,
see the description of that option).
If \fIwhat\fR is \fBpages\fR then the view
adjusts in units of nine-tenths the window's width.
If \fInumber\fR is negative then information farther to the left
becomes visible;  if it is positive then information farther to the right
becomes visible.
A \fB<Scroll-x>\fR event is generated.
.RE
.TP
\fIpathName\fR \fByview\fR ?\fIargs\fR?
This command is used to query and change the vertical position of the
information displayed in the treectrl's window.
It can take any of the following forms:
.RS
.TP
\fIpathName\fR \fByview\fR
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the vertical span that is visible in the window.
For example, if the first element is .6 and the second element is 1.0,
the lowest 40% of the tree's area is visible in the window.
These are the same values passed to scrollbars via the \fB-yscrollcommand\fR
option.
.TP
\fIpathName\fR \fByview moveto\fR \fIfraction\fR
Adjusts the view in the window so that \fIfraction\fR of the tree's
area is off-screen to the top.
\fIFraction\fR is a fraction between 0 and 1.
A \fB<Scroll-y>\fR event is generated.
.TP
\fIpathName\fR \fByview scroll\fR \fInumber\fR \fIwhat\fR
This command adjusts the view in the window up or down according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR.
If \fIwhat\fR is \fBunits\fR, the view adjusts up or down in units
of the \fB-yscrollincrement\fR option (which may be zero,
see the description of that option).
If \fIwhat\fR is \fBpages\fR then
the view adjusts in units of nine-tenths the window's height.
If \fInumber\fR is negative then higher information becomes
visible;  if it is positive then lower information
becomes visible.
A \fB<Scroll-y>\fR event is generated.
.RE
.SH COLUMNS
A treectrl widget is capable of displaying multiple columns next to each
other.
An item can be considered as a row, which reaches over all columns.
.PP
Columns in a treectrl may be specified in a number of ways.
See \fBCOLUMN DESCRIPTION\fR below.
.PP
There is always one special column, the \fBtail\fR column, which fills
all space to the right of the last ordinary column.
This column has no number;
it can only be specified by the keyword \fBtail\fR.
.PP
When a column configuration option is specified as \fBper-state\fR,
the state names are \fBnormal\fR, \fBactive\fR, \fBpressed\fR or \fBup\fR, i.e.
do not use item state names.
.PP
The following options are supported for columns:
.TP
\fB\fB-arrow\fR\fR \fIdirection\fR
Indicates whether or not an arrow should be drawn in the column header.
\fIDirection\fR must have one of the values
\fBnone\fR (the default), \fBup\fR, or \fBdown\fR.
.TP
\fB\fB-arrowbitmap\fR\fR \fIbitmap\fR
Specifies as a \fBper-state\fR option the bitmap to
use to draw the arrow if this column's -arrow option is not \fBnone\fR.
.TP
\fB\fB-arrowimage\fR\fR \fIimage\fR
Specifies as a \fBper-state\fR option the image to
use to draw the arrow if this column's -arrow option is not \fBnone\fR.
If an image is specified for a certain state, it overrides the -arrowbitmap option.
.TP
\fB\fB-arrowside\fR\fR \fIside\fR
Indicates on which side of the bitmap/image/text the arrow should be drawn.
\fISide\fR must be either \fBleft\fR or \fBright\fR (the default).
.TP
\fB\fB-arrowgravity\fR\fR \fIside\fR
Indicates onto which side an arrow should be packed,
if there is more space available for drawing the arrow then needed.
\fISide\fR must be either \fBleft\fR (the default) or \fBright\fR.
.TP
\fB\fB-arrowpadx\fR\fR \fIamount\fR
\fIAmount\fR specifies how much padding to
leave on the left and right of the arrow.
\fIAmount\fR may be a list
of two values to specify padding for left and right separately;
it defaults to 6.
.TP
\fB\fB-arrowpady\fR\fR \fIamount\fR
\fIAmount\fR specifies how much padding to
leave on the top and bottom of the arrow.
\fIAmount\fR may be a list
of two values to specify padding for top and bottom separately;
it defaults to 0.
.TP
\fB\fB-bitmap\fR\fR \fIbitmap\fR
Specifies the bitmap to display in the element
to the left of the column title.
.TP
\fB\fB-background\fR\fR \fIcolor\fR
Specifies as a \fBper-state\fR option the color to
use for the background of the column header.
.TP
\fB\fB-borderwidth\fR\fR \fIsize\fR
Specifies a non-negative value indicating the width
of the 3-D border to draw around the outside of the column header
(if such a border is being drawn;  the \fB-relief\fR column option
determines this).
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.TP
\fB\fB-button\fR\fR \fIboolean\fR
Indicates whether or not the column header should be treated like a pushbutton.
When this option is true, the default bindings track <Button-1> events
in the header and generate a <Header-invoke> event when a <ButtonRelease-1>
event occurs in the header. See \fBDYNAMIC EVENTS\fR.
.TP
\fB\fB-expand\fR\fR \fIboolean\fR
Indicates whether or not any extra horizontal space should be distributed
to this column.
This option has no effect if the \fB-width\fR option is set.
.TP
\fB\fB-font\fR\fR \fIfontName\fR
Specifies the font to use for the column title inside the column header.
.TP
\fB\fB-image\fR\fR \fIimage\fR
Specifies the image to display in the element
to the left of the column title.
This option overrides the \fB-bitmap\fR column option.
.TP
\fB\fB-imagepadx\fR\fR \fIamount\fR
\fIAmount\fR specifies how much padding to
leave on the left and right of the image (or bitmap).
\fIAmount\fR may be a list
of two values to specify padding for left and right separately;
it defaults to 6.
.TP
\fB\fB-imagepady\fR\fR \fIamount\fR
\fIAmount\fR specifies how much padding to
leave on the top and bottom of the image (or bitmap).
\fIAmount\fR may be a list
of two values to specify padding for top and bottom separately;
it defaults to 0.
.TP
\fB\fB-itembackground\fR\fR \fIcolorList\fR
Specifies a list of zero or more colors, which are used as
alternating background colors for items in this column.
See also the \fB-backgroundmode\fR widget option for more on this.
.TP
\fB\fB-itemjustify\fR\fR \fIjustification\fR
This option determines how the item styles in this column line up with each other.
Must be one of \fBleft\fR, \fBcenter\fR, or \fBright\fR. The default
value is an empty string (for compatibility with older versions), in which
case the column option \fB-justify\fR is used to align item styles in this
column.
.TP
\fB\fB-itemstyle\fR\fR \fIstyle\fR
\fIStyle\fR is the name of a style that should be set in this column
for newly-created items.
.TP
\fB\fB-justify\fR\fR \fIjustification\fR
This option determines how the image and text in the column header are
positioned. It also affects the position of item styles in this column unless
the column option \fB-itemjustify\fR is specified.
Must be one of \fBleft\fR (the default), \fBcenter\fR, or \fBright\fR.
.TP
\fB\fB-lock\fR\fR \fIlock\fR
This option allows a column to stick to the left or right edge of the window.
A locked column scrolls vertically but not horizontally.
Must be one of \fBnone\fR (the default), \fBleft\fR, or \fBright\fR.
.TP
\fB\fB-maxwidth\fR\fR \fIsize\fR
Specifies the maximum size, in screen units, that will be permitted for this column.
If \fIsize\fR is an empty string, then there is no limit on the maximum size of the column.
This option has no effect if the \fB-width\fR option is set.
.TP
\fB\fB-minwidth\fR\fR \fIsize\fR
Specifies the minimum size, in screen units, that will be permitted for this column.
If \fIsize\fR is an empty string, then the minimum size of the column is zero.
This option has no effect if the \fB-width\fR option is set.
.TP
\fB\fB-resize\fR\fR \fIboolean\fR
Specifies a boolean value that indicates whether the user should be allowed to
resize the column by dragging the edge of the column's header. Default is true.
.TP
\fB\fB-squeeze\fR\fR \fIboolean\fR
Specifies a boolean value that indicates whether or not the column should
shrink when the content width of the treectrl is less than the total needed width
of all visible columns. Defaults to false, which means the column will not get
smaller than its needed width. The column will not get smaller than the value
of its \fB-minwidth\fR option, if specified. This option has no effect if the
\fB-width\fR option is set.
.TP
\fB\fB-state\fR\fR \fIstate\fR
Specifies one of three states for the column header: \fBnormal\fR, \fBactive\fR,
or \fBpressed\fR. The active state is used when the mouse is over the header.
The pressed state is used when the mouse button is pressed in the header.
.TP
\fB\fB-stepwidth\fR\fR \fIsize\fR
Deprecated. Use the treectrl's \fB-itemwidthmultiple\fR option instead.
.TP
\fB\fB-tags\fR\fR \fItagList\fR
\fITagList\fR is a list of tag names that can be used to identify the column.
See also the \fBcolumn tag\fR command.
.TP
\fB\fB-text\fR\fR \fItext\fR
Specifies a text string to be displayed as the column title.
.TP
\fB\fB-textcolor\fR\fR \fIcolor\fR
Specifies a color, which should be used as foreground color
to display the column title.
.TP
\fB\fB-textlines\fR\fR \fIcount\fR
Specifies the maximum number of lines of text to display in the column title.
If this value is zero, the number of lines displayed is determined by any newline
characters and the effects of wrapping when the column width is less than
needed. The default is 1. Note: Under OSX/Aqua this value is always set to 1 when the
treectrl's \fB-usetheme\fR option is true, because the Appearance Manager
uses a fixed height for the column header; there is only room for a single line
of text.
.TP
\fB\fB-textpadx\fR\fR \fIamount\fR
\fIAmount\fR specifies how much padding to
leave on the left and right of the text.
\fIAmount\fR may be a list
of two values to specify padding for left and right separately;
it defaults to 6.
.TP
\fB\fB-textpady\fR\fR \fIamount\fR
\fIAmount\fR specifies how much padding to
leave on the top and bottom of the text.
\fIAmount\fR may be a list
of two values to specify padding for top and bottom separately;
it defaults to 0.
.TP
\fB\fB-uniform\fR\fR \fIgroup\fR
When a non-empty value is supplied, this option places the column in a
\fIuniform group\fR with other columns that have the same value for
\fB-uniform\fR. The space for columns belonging to a uniform group is
allocated so that their sizes are always in strict proportion to their
\fB-weight\fR values.
This option is based on the grid geometry manager.
.TP
\fB\fB-visible\fR\fR \fIboolean\fR
Indicates whether or not the column should be displayed.
.TP
\fB\fB-weight\fR\fR \fIinteger\fR
Sets the relative weight for apportioning any extra space among columns.
A weight of zero (0) indicates the column will not deviate from its requested
size.  A column whose weight is two will grow at twice the rate as a column of
weight one when extra space is allocated to columns.
This option is based on the grid geometry manager.
.TP
\fB\fB-width\fR\fR \fIsize\fR
Specifies a fixed width for the column. If this value is an empty string,
then the column width is calculated as the maximum of:
a) the width requested by items;
b) the width requested by the column's header;
and c) the column's \fB-minwidth\fR option.
This calculated width is also affected by the \fB-expand\fR,
\fB-squeeze\fR, \fB-uniform\fR and \fB-weight\fR options. In any case,
the calculated width will not be greater than the \fB-maxwidth\fR option,
if specified.
.TP
\fB\fB-widthhack\fR\fR \fIboolean\fR
Deprecated. Use the treectrl's \fB-itemwidthequal\fR option instead.
.SH "COLUMN DESCRIPTION"
Many of the commands and options for a treectrl take as an argument a
description of which column to operate on.
See the \fBEXAMPLES\fR section for examples.
The initial part of a column description must begin with one of the following terms:
.TP
\fIid\fR
Specifies the unique column identifier, where \fIid\fR should be
the return value of a prior call of the \fBcolumn create\fR widget command.
See also the \fB-columnprefix\fR option.
.TP
\fIQUALIFIERS\fR
Specifies a list of qualifiers. This gives the same result as \fBall\fR followed
by \fIQUALIFIERS\fR; i.e., every column is tested for a match.
.TP
\fItagExpr\fR \fIQUALIFIERS\fR
\fITagExpr\fR is a tag expression (see \fBITEM AND COLUMN TAGS\fR) against which
every column's tags are tested for a match.
This keyword cannot be followed by any modifiers unless a single column is
matched. You may run into trouble if \fItagExpr\fR looks like a column id
or other keyword; also, \fItagExpr\fR must look like a single list element
since column descriptions are properly-formed lists. To be safe you may want to
use the \fBtag\fR qualifier followed by \fItagExpr\fR.
.TP
\fBall\fR \fIQUALIFIERS\fR
Indicates every column, including the tail column if the command allows it,
which match \fIQUALIFIERS\fR.
.TP
\fBfirst\fR \fIQUALIFIERS\fR
Indicates the leftmost column of the treectrl which matches \fIQUALIFIERS\fR.
.TP
\fBend\fR \fIQUALIFIERS\fR
.TP
\fBlast\fR \fIQUALIFIERS\fR
Indicates the rightmost column of the treectrl (but not the tail column)
which matches \fIQUALIFIERS\fR.
.TP
\fBlist\fR \fIcolumnDescs\fR
\fIColumnDescs\fR is a list (a single argument, i.e. "list {a b c}" not "list a b c")
of other column descriptions.
This keyword cannot be followed by any modifiers unless a single column is matched.
.TP
\fBorder\fR \fIn\fR \fIQUALIFIERS\fR
Indicates the \fIn\fRth column in the list of columns as returned by the
\fBcolumn order\fR command.
.TP
\fBrange\fR \fIfirst last\fR \fIQUALIFIERS\fR
\fIFirst\fR and \fIlast\fR specify a range of columns.
This keyword cannot be followed by any modifiers unless a single column is specified.
.TP
\fBtail\fR
Indicates the ever-present tail column of the treectrl.
.TP
\fBtree\fR
Indicates the column specified by the -treecolumn option of the treectrl.
.PP
The initial part of the column description (matching any of the values above)
may be followed by one or more \fImodifier\fRs.
A modifier changes the column used relative to
the description up to this point.
It may be specified in any of the following forms:
.TP
\fBnext\fR \fIQUALIFIERS\fR
Use the column to the right matching \fIQUALIFIERS\fR.
.TP
\fBprev\fR \fIQUALIFIERS\fR
Use the column to the left matching \fIQUALIFIERS\fR.
The word \fIQUALIFIERS\fR above represents a sequence of zero or more of the
following terms that changes which column is chosen:
.TP
\fBstate\fR \fIstateList\fR
\fIStateList\fR is a list of column state names.
Only columns that have the given states set (or unset if the '!' prefix is used)
are considered.
.TP
\fBtag\fR \fItagExpr\fR
\fITagExpr\fR is a tag expression (see \fBITEM AND COLUMN TAGS\fR) against which
a column's tags are tested for a match.
.TP
\fB!tail\fR
When this qualifier is given, the tail column is not matched.
.TP
\fBvisible\fR
When this qualifier is given, only columns whose \fB-visible\fR option is
TRUE are considered.
.TP
\fB!visible\fR
When this qualifier is given, only columns whose \fB-visible\fR option is
FALSE are considered.
.SH STATES
For every item a set of boolean states is managed. These states play an
integral role in the appearance of each item.
The following states are predefined for every item:
.TP
\fBactive\fR
At all times this state is set for exactly one item. The active item is
used with keyboard navigation.
When the treectrl widget is created or when the active item is deleted,
the root item will become the active item.
This state can be modified by means of the widget command \fBactivate\fR.
.TP
\fBenabled\fR
This state is set for every item when it is created.
Disabled items cannot be selected and are ignored by the default bindings
when navigating via the keyboard.
This state can be modified by means of the widget command \fBitem enabled\fR.
.TP
\fBfocus\fR
This state is set for every item,
if the treectrl widget currently has the focus.
It cannot be modified by means of a widget command,
but is maintained in reaction to the <FocusIn> and <FocusOut> events.
.TP
\fBopen\fR
If this state is switched on,
the descendants of the item are displayed
- the item is expanded.
If this state is switched off,
the descendants of the item are not displayed
- the item is collapsed.
For a new item this state is switched on by default.
This state can be modified by means of the widget commands
\fBitem expand\fR, \fBitem collapse\fR, or \fBitem toggle\fR.
.TP
\fBselected\fR
This state is set for every item included in the selection.
It can be modified by means of the widget command \fBselection\fR.
.PP
By means of the \fBstate define\fR widget command
up to 27 additional states can be defined.
.SH "PER-STATE OPTIONS"
The visual appearance of an item can change depending on the state the item
is in, such as being the active item, being included in the selection, being
collapsed, or some combination of those or other states. When a configuration
option is described as \fIper-state\fR, it means the option describes a
value which varies depending on the state of the item. If a per-state option is
specified as a single value, the value is used for all states. Otherwise
the per-state option must be specified as an even-numbered list. For example,
to use the font "Times 12 bold" in a \fBtext\fR element regardless of the
item state you can write:
.nf

$T element configure MyTextElement -font {{Times 12 bold}}

.fi
However, to use a different font when the item is selected you could write:
.nf

$T element configure MyTextElement -font {{Courier 10} selected {Times 12 bold} {}}

.fi
In the example above, the -font option reads "value stateList value stateList".
If \fIstateList\fR is an empty list, the preceding \fIvalue\fR is used regardless
of the item state. A non-empty stateList specifies a list of states which must be
set for the item in order to use the preceding value. Each stateList can also
include state names preceded by a ! sign, indicating the state must *not* be
set for the item. For example:
.nf

$T element configure MyRectElement -fill {blue {selected focus} gray {selected !focus}}

.fi
In the example above, the \fBrect\fR element is filled with blue when the treectrl
has the focus and the item is selected. If the treectrl does not have the focus, the
example specifies that gray should be used for selected items. Also note that if the
item is not selected, no color is specified for the -fill option.
.PP
Each value-stateList pair is checked in order from left to right. The value
associated with the first stateList that matches the current item state is
used. So stateLists should be listed from most-specific to least-specific.
.nf

$T element configure MyRectElement -fill {gray {selected} blue {selected focus}}

.fi
Written this way, gray will always be used for selected items since
it appears first, and blue will never be used for selected items regardless
of the focus.
.PP
A value followed by an empty stateList should always be last since it will be
chosen regardless of the item's state.
.SH ELEMENTS
Elements are the smallest building blocks
which are handled by a treectrl widget.
One or more elements together can be combined to a style,
which can be considered as a blueprint for an item.
An element can be of type \fBbitmap\fR, \fBborder\fR, \fBimage\fR,
\fBrect\fR, \fBtext\fR or \fBwindow\fR.
For each element type there is a section below describing the options
which can modify an element of that type.
.PP
All of the element configuration options described below are unspecified
by default, meaning that no value whatsoever has been given to the option.
It may seem strange to you that a boolean option would be unspecified
instead of simply "true" or "false". The reason for this is that when an
element displayed by an item has no value specified for an option, the element refers
to the master element created by the \fBelement create\fR command for a
value for that option. This allows items which are displaying a certain
element to be redisplayed when the master element's options change.
The \fBitem element configure\fR command can be used to override the
master element's configuration options for a specific item.
.SH "BITMAP ELEMENT"
An element of type \fBbitmap\fR can be used to display a bitmap in an item.
The following options are supported for bitmap elements:
.TP
\fB\fB-background\fR\fR \fIcolor\fR
Specifies as a \fBper-state\fR option
the color to use for each of the bitmap's '0' valued pixels.
If the value for a certain state is an empty string (the default),
the bitmap is drawn transparent.
.TP
\fB\fB-bitmap\fR\fR \fIbitmap\fR
Specifies as a \fBper-state\fR option
the bitmap to display in the element.
.TP
\fB\fB-draw\fR\fR \fIboolean\fR
Deprecated; use the style layout option \fB-draw\fR instead.
Specifies as a \fBper-state\fR option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.
.TP
\fB\fB-foreground\fR\fR \fIcolor\fR
Specifies as a \fBper-state\fR option
the color to use for each of the bitmap's '1' valued pixels.
If the value for a certain state is an empty string (the default),
the bitmap's foreground color is black.
.SH "BORDER ELEMENT"
An element of type \fBborder\fR can be used to display a 3D border in an item.
The following options are supported for border elements:
.TP
\fB\fB-background\fR\fR \fIcolor\fR
Specifies as a \fBper-state\fR option
the color to use for the background of the border.
If the value for a certain state is an empty string (the default), the
element will not be drawn.
.TP
\fB\fB-draw\fR\fR \fIboolean\fR
Deprecated; use the style layout option \fB-draw\fR instead.
Specifies as a \fBper-state\fR option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.
.TP
\fB\fB-filled\fR\fR \fIboolean\fR
Specifies whether the interior of the border should be filled with
the background color. If this option is unspecified (the default),
it it treated as false which means that only the edges of the
border will be drawn.
.TP
\fB\fB-height\fR\fR \fIsize\fR
Specifies the height of the border. If this value is unspecified
(the default), the border will be exactly as tall as its display area as
determined by the style layout options.
.TP
\fB\fB-relief\fR\fR \fIrelief\fR
Specifies as a \fBper-state\fR option the
relief of the border. If the value for a certain state is an empty string
(the default), it is treated as flat.
For acceptable values see the description of the
\fB-relief\fR option in the \fBoptions\fR manual page.
.TP
\fB\fB-thickness\fR\fR \fIthickness\fR
Specifies the thickness of the edges of the border.
.TP
\fB\fB-width\fR\fR \fIsize\fR
Specifies the width of the border. If this value is unspecified
(the default), the border will be exactly as wide as its display area as
determined by the style layout options.
.SH "IMAGE ELEMENT"
An element of type \fBimage\fR can be used to display an image in an item.
The following options are supported for image elements:
.TP
\fB\fB-draw\fR\fR \fIboolean\fR
Deprecated; use the style layout option \fB-draw\fR instead.
Specifies as a \fBper-state\fR option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.
.TP
\fB\fB-height\fR\fR \fIsize\fR
Specifies the requested height of the display area for this element.
If unspecified (the default), the element requests a height equal to the
height of the image, or zero if there is no image.
.TP
\fB\fB-image\fR\fR \fIimage\fR
Specifies as a \fBper-state\fR option
the image to display in the element.
.TP
\fB\fB-width\fR\fR \fIsize\fR
Specifies the requested width of the display area for this element.
If unspecified (the default), the element requests a width equal to the
width of the image, or zero if there is no image.
.SH "RECTANGLE ELEMENT"
An element of type \fBrect\fR can be used to display a rectangle in an item.
The following options are supported for rectangle elements:
.TP
\fB\fB-draw\fR\fR \fIboolean\fR
Deprecated; use the style layout option \fB-draw\fR instead.
Specifies as a \fBper-state\fR option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.
.TP
\fB\fB-fill\fR\fR \fIcolor\fR
Specifies as a \fBper-state\fR option the color to
be used to fill the rectangle's area.
If the color for a certain state is an empty string (the default), then
the rectangle will not be filled (but the outline may still be drawn).
.TP
\fB\fB-height\fR\fR \fIsize\fR
Specifies the height of the rectangle. If this value is unspecified
(the default), the rectangle will be exactly as tall as its display area as
determined by the style layout options.
.TP
\fB\fB-open\fR\fR \fIopen\fR
This option may be used to get an incomplete drawing of the outline.
\fIOpen\fR is a string that contains zero or more of the characters
\fBn\fR, \fBs\fR, \fBe\fR or \fBw\fR.
Each letter refers to a side (north, south, east, or west) that the outline
will not be drawn.
The default is the empty string, which causes the outline to be drawn completely.
.TP
\fB\fB-outline\fR\fR \fIcolor\fR
Specifies as a \fBper-state\fR option the color to
be used to draw the outline of the rectangle.
If the color for a certain state is an empty string (the default),
then no outline is drawn for the rectangle.
.TP
\fB\fB-outlinewidth\fR\fR \fIoutlineWidth\fR
Specifies the width of the outline to be drawn around the rectangle's region.
\fIoutlineWidth\fR may be in any of the forms acceptable to \fBTk_GetPixels\fR.
If this option is specified as an empty string (the default), then no outline
is drawn.
.TP
\fB\fB-showfocus\fR\fR \fIboolean\fR
Specifies a boolean value indicating whether
a "focus ring" should be drawn around the rectangle,
if the item containing the rectangle is the active item
and the treectrl widget currently has the focus.
If this option is specified as an empty string (the default),
then a focus rectangle is not drawn.
.TP
\fB\fB-width\fR\fR \fIsize\fR
Specifies the width of the rectangle. If this value is unspecified
(the default), the rectangle will be exactly as wide as its display area as
determined by the style layout options.
.SH "TEXT ELEMENT"
An element of type \fBtext\fR can be used to display a text in an item.
The following options are supported for text elements:
.TP
\fB\fB-draw\fR\fR \fIboolean\fR
Deprecated; use the style layout option \fB-draw\fR instead.
Specifies as a \fBper-state\fR option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.
.TP
\fB\fB-data\fR\fR \fIdata\fR
Specifies a value that together with the \fB-datatype\fR and \fB-format\fR
options will be displayed as text.
.TP
\fB\fB-datatype\fR\fR \fIdataType\fR
Specifies the type of information in the \fB-data\fR option.
Acceptable values are \fBdouble\fR, \fBinteger\fR, \fBlong\fR,
\fBstring\fR, or \fBtime\fR.
.TP
\fB\fB-fill\fR\fR \fIcolor\fR
Specifies as a \fBper-state\fR option the
foreground color to use when displaying the text.
If the color for a certain state is an empty string (the default), then
the text will be displayed using the color specified by the treectrl's
\fB-foreground\fR option.
.TP
\fB\fB-format\fR\fR \fIformatString\fR
This option specifies the format string used to display the value of the \fB-data\fR option.
If \fB-datatype\fR is \fBtime\fR, \fIformatString\fR should be
a valid format string for the Tcl \fBclock\fR command.
For all other \fB-datatype\fR values \fIformatString\fR should be
a valid format string for the Tcl \fBformat\fR command.
If this value is unspecified the following defaults are used:
for -datatype double "%g", for -datatype integer "%d", for -datatype long "%ld",
for -datatype string "%s", and for -datatype time the default format string of the Tcl \fBclock\fR
command.
.TP
\fB\fB-font\fR\fR \fIfont\fR
Specifies as a \fBper-state\fR option the font to
use when displaying the text.
If the font for a certain state is an empty string, the text is displayed
using the font specified by the treectrl's \fB-font\fR option.
.TP
\fB\fB-justify\fR\fR \fIhow\fR
Specifies how to justify the text when multiple lines are displayed.
\fIHow\fR must be one of the values \fBleft\fR, \fBright\fR, or \fBcenter\fR.
If this option is specified as an empty string (the default), \fBleft\fR is used.
.TP
\fB\fB-lines\fR\fR \fIlineCount\fR
Specifies the maximum number of lines to display.
If more than \fIlineCount\fR lines would be displayed, the last line will
be truncated with an ellipsis at the right.
If this option is specified as zero or an empty string (the default),
there is no limit to the number of lines displayed.
.TP
\fB\fB-text\fR\fR \fIstring\fR
\fIString\fR specifies a string to be displayed by the element.
\fIString\fR may contain newline characters in which case multiple lines of text
will be displayed.
If this option is specified, the \fB-data\fR, \fB-datatype\fR,
\fB-format\fR, and \fB-textvariable\fR options are ignored.
.TP
\fB\fB-textvariable\fR\fR \fIvarName\fR
Specifies the name of a variable.  The value of the variable is a string
to be displayed by the element;  if the variable value changes then the element
will automatically update itself to display the new value.
If this option is specified, the \fB-data\fR, \fB-datatype\fR,
and \fB-format\fR options are ignored.
.TP
\fB\fB-underline\fR\fR \fIcharIndex\fR
Specifies the integer index of a character to underline.
0 corresponds to the first character.
If \fIcharIndex\fR is unspecified (the default), less than zero or greater
than the index of the last displayed character, the underline is not drawn.
.TP
\fB\fB-width\fR\fR \fIsize\fR
Specifies the maximum line length in any of the forms acceptable to \fBTk_GetPixels\fR.
For text to wrap lines the value of the \fB-width\fR
option must be less than the needed width of the text, or the display area
for this element must be less than the needed width of the text.
For the display area to be less than the needed width of the text,
one of the style layout options \fB-maxwidth\fR, \fB-width\fR or
\fB-squeeze\fR must be used.
.TP
\fB\fB-wrap\fR\fR \fImode\fR
\fIMode\fR specifies how to handle lines in the text that are longer than the
maximum line length.
Acceptable values are \fBnone\fR, \fBchar\fR or \fBword\fR.
If this option is unspecified (the default), \fBword\fR is used.
See the \fB-width\fR option for a description of how the maximum line
length is determined.
.SH "WINDOW ELEMENT"
An element of type \fBwindow\fR can be used to display a Tk window in an item.
The following options are supported for window elements:
.TP
\fB\fB-clip\fR\fR \fIboolean\fR
Specifies whether the associated Tk window is a borderless frame which should
be used to clip its child window so it doesn't overlap the header, borders, or
other items or columns. When this option is true, the treectrl manages the
geometry of both the \fB-window\fR widget and its first child widget; in
this case the \fB-window\fR widget (which should be a borderless frame) is
kept sized and positioned so that it is never out-of-bounds.
.TP
\fB\fB-destroy\fR\fR \fIboolean\fR
Specifies whether the associated Tk window should be destroyed when the
element is deleted. The element is deleted when the item containing the
element is deleted, when the column containing the element is deleted,
or when the style assigned to the item's column is changed. If this option
is unspecified (the default), it is treated as false and the Tk window
will not be destroyed.
.TP
\fB\fB-draw\fR\fR \fIboolean\fR
Deprecated; use the style layout option \fB-draw\fR instead.
Specifies as a \fBper-state\fR option
whether to draw the element. If the value for a certain state is an empty
string (the default), it is treated as true and the element will be drawn.
.TP
\fB\fB-window\fR\fR \fIpathName\fR
Specifies the window to associate with this element. The window specified by
\fIpathName\fR must either be a child of the treectrl widget or a child of
some ancestor of the treectrl widget. \fIPathName\fR may not refer to a
top-level window. This option cannot be specified by
the \fBelement create\fR or \fBelement configure\fR commands, only by the
\fBitem element configure\fR command; i.e., the element must be associated
with a particular item.
.SH "ITEM DESCRIPTION"
Many of the commands for a treectrl take as an argument a
description of which items to operate on. An item description is a properly-formed
tcl list of keywords and arguments.
The first word of an item description must be one of the following:
.TP
\fIid\fR
Specifies the unique item identifier, where \fIid\fR should be
the return value of a prior call of the \fBitem create\fR widget command,
or \fB0\fR to specify the ever-present root item. See also the
\fB-itemprefix\fR option.
.TP
\fIQUALIFIERS\fR
Specifies a list of qualifiers. This gives the same result as \fBall\fR followed
by \fIQUALIFIERS\fR; i.e., every item is tested for a match.
.TP
\fItagExpr\fR \fIQUALIFIERS\fR
\fITagExpr\fR is a tag expression (see \fBITEM AND COLUMN TAGS\fR) against which
every item's tags are tested for a match.
This keyword cannot be followed by any modifiers unless a single item is
matched. You may run into trouble if \fItagExpr\fR looks like an item id
or other keyword; also, \fItagExpr\fR must look like a single list element
since item descriptions are properly-formed lists. To be safe you may want to
use the \fBtag\fR qualifier followed by \fItagExpr\fR.
.TP
\fBactive\fR
Indicates the item that is currently active, i.e. normally
the item specified as argument of the last successful \fBactivate\fR
widget command, or the root item if no such call happened yet.
.TP
\fBanchor\fR
Indicates the anchor item of the selection, i.e. normally
the item specified as argument of the last successful \fBselection anchor\fR
widget command, or the root item if no such call happened yet.
.TP
\fBall\fR \fIQUALIFIERS\fR
Indicates every item including orphans which match \fIQUALIFIERS\fR.
This keyword cannot be followed by any modifiers unless a single item is matched.
.TP
\fBfirst\fR \fIQUALIFIERS\fR
Indicates the first item of the treectrl (the root item),
or the first item matching \fIQUALIFIERS\fR.
.TP
\fBend\fR \fIQUALIFIERS\fR
.TP
\fBlast\fR \fIQUALIFIERS\fR
Indicates the last item which matches \fIQUALIFIERS\fR.
.TP
\fBlist\fR \fIitemDescs\fR
\fIItemDescs\fR is a list (a single argument, i.e. "list {a b c}" not "list a b c")
of other item descriptions.
This keyword cannot be followed by any modifiers unless a single item is matched.
.TP
\fBnearest\fR \fIx y\fR
Indicates the item nearest to the point given by \fIx\fR and \fIy\fR.
.TP
\fBrnc\fR \fIrow column\fR
Indicates the item in the given \fIrow\fR and \fIcolumn\fR.
The row and column corresponds to
the on-screen arrangement of items as determined by the -orient and -wrap
options.
You can memorize \fBrnc\fR as an abbreviation of "row 'n' column".
.TP
\fBrange\fR \fIfirst last\fR \fIQUALIFIERS\fR
\fIFirst\fR and \fIlast\fR specify a range of items.
This keyword cannot be followed by any modifiers unless a single item is matched.
.TP
\fBroot\fR
Indicates the root item of the treectrl.
.PP
The initial part of the item description (matching any of the values above)
may be followed by one or more \fImodifier\fRs.
A modifier changes the item used relative to
the description up to this point.
It may be specified in any of the following forms:
.TP
\fBabove\fR
Use the item one row above in this column.
.TP
\fBancestors\fR \fIQUALIFIERS\fR
Use the ancestors of the item (like \fBitem ancestors\fR but QUALIFIERS
may change which ancestors match).
This keyword cannot be followed by any modifiers.
.TP
\fBbelow\fR
Use the item one row below in this column.
.TP
\fBbottom\fR
Use the item in the last row of this column.
.TP
\fBchild\fR \fIn\fR \fIQUALIFIERS\fR
Use the \fIn\fRth child of the item.
.TP
\fBchildren\fR \fIQUALIFIERS\fR
Use the children of the item (like \fBitem children\fR but QUALIFIERS
may change which children match).
This keyword cannot be followed by any modifiers.
.TP
\fBdescendants\fR \fIQUALIFIERS\fR
Use the descendants of the item (like \fBitem descendants\fR but QUALIFIERS
may change which descendants match).
This keyword cannot be followed by any modifiers.
.TP
\fBfirstchild\fR \fIQUALIFIERS\fR
Use the first child of the item.
.TP
\fBlastchild\fR \fIQUALIFIERS\fR
Use the last child of the item.
.TP
\fBleft\fR
Use the item one column to the left in the same row.
.TP
\fBleftmost\fR
Use the item of the first column in the same row.
.TP
\fBnext\fR \fIQUALIFIERS\fR
Use the next item, which is the first item from the
following list: the first child, the next sibling or the next sibling of
the nearest ancestor which has one.
.TP
\fBnextsibling\fR \fIQUALIFIERS\fR
Use the next sibling of the item.
.TP
\fBparent\fR
Use the parent of the item.
.TP
\fBprev\fR \fIQUALIFIERS\fR
Use the last child of the previous sibling,
or the parent if there is no previous sibling.
.TP
\fBprevsibling\fR \fIQUALIFIERS\fR
Use the previous sibling of the item.
.TP
\fBright\fR
Use the item one column to the right in the same row.
.TP
\fBrightmost\fR
Use the item of the last column in the same row.
.TP
\fBsibling\fR \fIn\fR \fIQUALIFIERS\fR
Use the \fIn\fRth child of the item's parent.
.TP
\fBtop\fR
Use the item in the first row of this column.
The word \fIQUALIFIERS\fR above represents a series of zero or more of the
following terms that changes which item is chosen:
.TP
\fBdepth\fR \fIdepth\fR
Matches items whose depth (as returned by the \fBdepth\fR command) is equal to
\fIdepth\fR.
.TP
\fBstate\fR \fIstateList\fR
\fIStateList\fR is a list of item state names (static and dynamic, see \fBSTATES\fR).
Only items that have the given states set (or unset if the '!' prefix is used)
are considered.
.TP
\fBtag\fR \fItagExpr\fR
\fITagExpr\fR is a tag expression (see \fBITEM AND COLUMN TAGS\fR) against which
an item's tags are tested for a match.
.TP
\fBvisible\fR
When this qualifier is given, only items that are displayed are considered.
.TP
\fB!visible\fR
When this qualifier is given, only items that are *not* displayed are considered.
To get the first item in the list that is enabled:
.nf

$T item id "first state enabled"

.fi
To get the ancestors that are not open of the last item in the list:
.nf

$T item id "last ancestors state !open"

.fi
To get the visible descendants of the root item:
.nf

$T item id "root descendants visible"

.fi
To get the every hidden item with tag "a" or "b":
.nf

$T item id "all !visible tag a||b"
$T item id "!visible tag a||b"
$T item id "tag a||b !visible"
$T item id "a||b !visible"

.fi
.SH "EVENTS AND SCRIPT SUBSTITUTIONS"
The \fIscript\fR argument to \fBnotify bind\fR is a Tcl script, which will be
evaluated whenever the given event is generated. \fIScript\fR will be executed
in the same interpreter that the \fBnotify bind\fR command was executed in,
and it will run at global level (only global variables will be accessible).
If \fIscript\fR contains any \fB%\fR characters, then the script will not be
evaluated directly.  Instead, a new script will be generated by replacing each
\fB%\fR, and the character following it, with information from the current
event. Unlike the regular Tk \fBbind\fR mechanism, each event generated by
a treectrl widget has its own set of %-substitutions.
.PP
The following %-substitutions are valid for all static events:
.TP
\fB%%\fR Replaced with a single %
.TP
\fB%d\fR The detail name
.TP
\fB%e\fR The event name
.TP
\fB%P\fR The pattern, either <event> or <event-detail>
.TP
\fB%W\fR The object argument to the \fBnotify bind\fR command
.TP
\fB%T\fR The treectrl widget which generated the event
.TP
\fB%?\fR A list of the format {char value char value ...} for each
%-substitution character and the value it is replaced by
.PP
The following events may be generated by a treectrl widget:
.TP
\fB<ActiveItem>\fR
Generated whenever the active item changes.
.RS
.TP
\fB%c\fR The current active item
.TP
\fB%p\fR The previous active item
.RE
.TP
\fB<Collapse-before>\fR
Generated before an item is collapsed.
.RS
.TP
\fB%I\fR The item id
.RE
.TP
\fB<Collapse-after>\fR
Generated after an item is collapsed.
.RS
.TP
\fB%I\fR The item id
.RE
.TP
\fB<Expand-before>\fR
Generated before an item is expanded. This event is useful if you want to add
child items to the item just before the item is expanded.
.RS
.TP
\fB%I\fR The item id
.RE
.TP
\fB<Expand-after>\fR
Generated after an item is expanded.
.RS
.TP
\fB%I\fR The item id
.RE
.TP
\fB<ItemDelete>\fR
Generated when items are about to be deleted by the \fBitem delete\fR command.
.RS
.TP
\fB%i\fR List of items ids being deleted.
.RE
.TP
\fB<ItemVisibility>\fR
Generated when items become visible on screen and when items are no longer visible on screen.
This event is useful if you have a very large number of items and want to assign
styles only when items are actually going to be displayed.
.RS
.TP
\fB%h\fR List of items ids which are no longer visible.
.TP
\fB%v\fR List of items ids which are now visible.
.RE
.TP
\fB<Scroll-x>\fR
Generated whenever the view in the treectrl changes in such a way that a
horizontal scrollbar should be redisplayed.
.RS
.TP
\fB%l\fR Same as the first fraction appended to \fB-xscrollcommand\fR. Think \fIlower\fR.
.TP
\fB%u\fR Same as the second fraction appended to \fB-xscrollcommand\fR. Think \fIupper\fR.
.RE
.TP
\fB<Scroll-y>\fR
Generated whenever the view in the treectrl changes in such a way that a
vertical scrollbar should be redisplayed.
.RS
.TP
\fB%l\fR Same as the first fraction appended to \fB-yscrollcommand\fR. Think \fIlower\fR.
.TP
\fB%u\fR Same as the second fraction appended to \fB-yscrollcommand\fR. Think \fIupper\fR.
.RE
.TP
\fB<Selection>\fR
Generated whenever the selection changes. This event gives information about
how the selection changed.
.RS
.TP
\fB%c\fR Same as the \fBselection count\fR widget command
.TP
\fB%D\fR List of newly-deselected item ids
.TP
\fB%S\fR List of newly-selected item ids
.RE
.SH "DYNAMIC EVENTS"
In addition to the pre-defined static events such as <ActiveItem>
and <Selection>, new dynamic events can be created by using the
\fBnotify install\fR command.
.PP
The following events may be generated by the library scripts:
.TP
\fB<ColumnDrag-begin>\fR
.TP
\fB<ColumnDrag-receive>\fR
.TP
\fB<ColumnDrag-end>\fR
Generated whenever the user drag-and-drops a column header. The library scripts
do not actually move a dragged column. You must bind to the receive event to
move the column. See \fBEXAMPLES\fR.
.RS
.TP
\fB%C\fR The column that was dragged
.TP
\fB%b\fR The column to move the dragged column before
.RE
.TP
\fB<Drag-begin>\fR
.TP
\fB<Drag-receive>\fR
.TP
\fB<Drag-end>\fR
Generated whenever the user drag-and-drops a file into a directory. This
event is generated by the filelist-bindings.tcl library code, which is not
used by default. See the "Explorer" demos.
.RS
.TP
\fB%I\fR The item that the user dropped the dragged items on.
.TP
\fB%l\fR (lowercase L) The list of dragged items.
.RE
.TP
\fB<Edit-begin>\fR
.TP
\fB<Edit-accept>\fR
.TP
\fB<Edit-end>\fR
The filelist-bindings.tcl code will display a text-editing window if the user
clicks on a selected file/folder name. See the "Explorer" demos.
.RS
.TP
\fB%I\fR The item containing the edited text element
.TP
\fB%C\fR The column containing the edited text element
.TP
\fB%E\fR The name of the edited text element
.TP
\fB%t\fR The edited text
.RE
.TP
\fB<Header-invoke>\fR
Generated whenever the user clicks and releases the left mouse button
in a column header if the column's -button option is true. You can bind a
script to this event to sort the list.
.RS
.TP
\fB%C\fR The column whose header was clicked
.RE
The library scripts provide an example
of using a dynamic event called <Header-invoke>, which is generated when
the mouse button is released over a column header.
.nf

treectrl .t
.t notify install <Header-invoke>
.t notify bind ConsoleTag <Header-invoke> {
	puts "header %C clicked in treectrl %T"
}
proc ::TreeCtrl::Release1 {w x y} {
	...
	$w notify generate <Header-invoke> [list C $Priv(column)] \\
		[list ::TreeCtrl::PercentsCmd $w]
	...
}

.fi
In the example a new treectrl widget is created and the <Header-invoke> event
is installed. For convenience there is no \fIpercentsCommand\fR argument to
\fBnotify install\fR; instead the call to \fBnotify generate\fR specifies
the %-substitution command. A script is
bound to the event with \fBnotify bind\fR which will print out the column
number and widget
name to the console (in the demos, <Header-invoke> is used to sort the list
based on the column that was clicked). The \fIcharMap\fR argument to
\fBnotify generate\fR
provides a list of %-substitution characters and values which is used by
::TreeCtrl::PercentsCmd. In this example any %C in any script bound to the
<Header-invoke> event will be replaced by the value of $Priv(column).
.SH "DEFAULT BINDINGS"
Tk automatically creates class bindings for treectrl widgets that give them
the following default behavior.
.IP [1]
Clicking mouse button 1 over an item positions the active cursor
on the item, sets the input focus to this widget,
and resets the selection of the widget to this item, if it is not
already in the selection.
.IP [2]
Clicking mouse button 1 with the Control key down will reposition the
active cursor and add the item to the selection
without ever removing any items from the selection.
.IP [3]
If the mouse is dragged out of the widget
while button 1 is pressed, the treectrl will automatically scroll to
make more items visible (if there are more items off-screen on the side
where the mouse left the window).
.IP [4]
The Left and Right keys move the active cursor one item to the left or right;
for an hierarchical tree with vertical orientation nothing will happen,
since it has no two items in the same row.
The selection is set to include only the active item.
If Left or Right is typed with the Shift key down, then the active
cursor moves and the selection is extended to include the new item.
.IP [5]
The Up and Down keys move the active cursor one item up or down.
The selection is set to include only the active item.
If Up or Down is typed with the Shift key down, then the active
cursor moves and the selection is extended to include the new item.
.IP [6]
The Next and Prior keys move the active cursor forward or backwards
by one screenful, without affecting the selection.
.IP [7]
Control-Next and Control-Prior scroll the view right or left by one page
without moving the active cursor or affecting the selection.
Control-Left and Control-Right behave the same.
.IP [8]
The Home and End keys scroll to the left or right end of the widget
without moving the active cursor or affecting the selection.
.IP [9]
The Control-Home and Control-End keys scroll to the top or bottom
of the widget, they also activate and select the first or last item.
If also the Shift key is down, then the active
cursor moves and the selection is extended to include the new item.
.IP [10]
The Space and Select keys set the selection to the active item.
.IP [11]
Control-/ selects the entire contents of the widget.
.IP [12]
Control-\\\\ clears any selection in the widget.
.IP [13]
The + and - keys expand or collapse the active item,
the Return key toggles the active item.
.IP [14]
The mousewheel scrolls the view of the widget four lines up or down
depending on the direction, the wheel was turned.
The active cursor or the selection is not affected.
.SH EXAMPLES
Get the unique identifier for the leftmost visible column:
.nf

set id [$T column index "first visible"]

.fi
Delete the leftmost column:
.nf

$T column delete "order 0"

.fi
Take the visible column that is to the left of the last column, and move that
column in front of the tail column:
.nf

$T column move "last prev visible" tail

.fi
Get the unique identifier for the first visible item:
.nf

set id [$T item index "first visible"]

.fi
Delete the parent of the item that is under the point x,y:
.nf

$T item delete "nearest $x $y parent"

.fi
Add the 10th child of the second child of the root item to the selection:
.nf

$T selection add "root firstchild nextsibling child 10"

.fi
Move a column that the user drag-and-dropped:
.nf

$T column dragconfigure -enable yes
$T notify install <ColumnDrag-receive>
$T notify bind MyTag <ColumnDrag-receive> {
	%T column move %C %b
}

.fi
.SH "SEE ALSO"
bind(n), bitmap(n), image(n), listbox(n), options(n)
.SH KEYWORDS
tree, widget