# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

"""
Controller combining an input entry and an on-screen keyboard. Results
are passed to another controller.
"""

from elisa.plugins.pigment.graph.text import Text
from elisa.plugins.poblesec.search_controller import SearchController
import pgm

class SimpleSearchController(SearchController):
    live_search = False

    def initialize(self, mediatype, title_text=None, subtitle_text=None,
                   prefilled_text=None):
        self.title_text = title_text or 'Enter Your Search Query'
        self.subtitle_text = subtitle_text or ''
        self.prefilled_text = prefilled_text
        return super(SimpleSearchController, self).initialize(mediatype)

    def set_frontend(self, frontend):
        if hasattr(self, 'frontend') and self.frontend == frontend:
            return

        super(SimpleSearchController, self).set_frontend(frontend)

        # FIXME: move all these style constants to CSS properties
        self.title.markup = self.title_text
        self.title.weight = pgm.TEXT_WEIGHT_BOLD
        self.title.fg_color = (195, 194, 194, 255)
        self.title.bg_color = (0, 0, 0, 0)
        self.title.alignment = pgm.TEXT_ALIGN_CENTER
        self.title.size = (1.0, 0.18)
        self.title.position = (0.0, 0.15, 0.0)
        self.title.multiline = True
        self.title.font_size = 'medium'
        self.title.visible = True

        self.subtitle = Text()
        self.widget.add(self.subtitle)
        self.subtitle.markup = self.subtitle_text
        self.subtitle.fg_color = (195, 194, 194, 255)
        self.subtitle.bg_color = (0, 0, 0, 0)
        self.subtitle.alignment = pgm.TEXT_ALIGN_CENTER
        self.subtitle.size = (1.0, 0.04)
        self.subtitle.position = (0.0, 0.3, 0.0)
        self.subtitle.visible = True

        if self.prefilled_text:
            self.entry.text = self.prefilled_text

    def title_text_set(self, text):
        self._title_text = text
        if hasattr(self, 'title'):
            self.title.markup = text

    def title_text_get(self):
        return self._title_text

    title_text = property(fget=title_text_get, fset=title_text_set)

    def subtitle_text_set(self, text):
        self._subtitle_text = text
        if hasattr(self, 'subtitle'):
            self.subtitle.markup = text

    def subtitle_text_get(self):
        return self._subtitle_text

    subtitle_text = property(fget=subtitle_text_get, fset=subtitle_text_set)


    def _search(self, focus=False):
        frontend = self.frontend
        controllers = frontend.retrieve_controllers('/poblesec/browser')
        history = controllers[0].history
        search_string = self.entry.text.strip()
        return self.do_search(search_string, history)

    def do_search(self, search_term, history):
        pass
