% ASINH ASINH Inverse Hyperbolic Sine Function
% 
% Usage
% 
% Computes the inverse hyperbolic sine of its argument.  The general
% syntax for its use is
% 
%   y = asinh(x)
% 
% where x is an n-dimensional array of numerical type.


% Copyright (c) 2002-2007 Samit Basu
% Licensed under the GPL

function y = asinh(x)
  if (nargin == 0 || ~isnumeric(x))
    error('asinh expects a single, numeric input');
  end
  if (isinttype(x)) x = double(x); end
  y = log(x+(x.*x+1.0f).^(0.5f));
  
