/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.io.Serializable;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.Methods;
import org.jhotdraw.util.ResourceBundleUtil;

public class AttributeKey<T>
implements Serializable {
    private String key;
    private T defaultValue;
    private boolean isNullValueAllowed;
    private ResourceBundleUtil labels;
    private Class<T> clazz;

    public AttributeKey(String string, Class<T> clazz) {
        this(string, clazz, null, true);
    }

    public AttributeKey(String string, Class<T> clazz, T t) {
        this(string, clazz, t, true);
    }

    public AttributeKey(String string, Class<T> clazz, T t, boolean bl) {
        this(string, clazz, t, bl, null);
    }

    public AttributeKey(String string, Class<T> clazz, T t, boolean bl, ResourceBundleUtil resourceBundleUtil) {
        this.key = string;
        this.clazz = clazz;
        this.defaultValue = t;
        this.isNullValueAllowed = bl;
        this.labels = resourceBundleUtil == null ? ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels") : resourceBundleUtil;
    }

    public String getKey() {
        return this.key;
    }

    public String getPresentationName() {
        return this.labels == null ? this.key : this.labels.getString("attribute." + this.key + ".text");
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getClone(Figure figure) {
        Object t = figure.get(this);
        try {
            return t == null ? null : (T)this.clazz.cast(Methods.invoke(t, "clone"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            InternalError internalError = new InternalError();
            internalError.initCause(noSuchMethodException);
            throw internalError;
        }
    }

    public T get(Figure figure) {
        return figure.get(this);
    }

    public T get(Map<AttributeKey, Object> map) {
        return (T)(map.containsKey(this) ? map.get(this) : this.defaultValue);
    }

    public void set(Figure figure, T t) {
        if (t == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        figure.set(this, t);
    }

    public UndoableEdit setUndoable(final Figure figure, final T t) {
        if (t == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        final Object object = figure.getAttributesRestoreData();
        figure.set(this, t);
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return AttributeKey.this.getPresentationName();
            }

            @Override
            public void undo() {
                super.undo();
                figure.willChange();
                figure.restoreAttributesTo(object);
                figure.changed();
            }

            @Override
            public void redo() {
                super.redo();
                figure.willChange();
                figure.set(AttributeKey.this, t);
                figure.changed();
            }
        };
        return abstractUndoableEdit;
    }

    public void setClone(Figure figure, T t) {
        try {
            figure.set(this, t == null ? null : (Object)this.clazz.cast(Methods.invoke(t, "clone")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            InternalError internalError = new InternalError();
            internalError.initCause(noSuchMethodException);
            throw internalError;
        }
    }

    public void putClone(Map<AttributeKey, Object> map, T t) {
        try {
            this.put(map, t == null ? null : (T)this.clazz.cast(Methods.invoke(t, "clone")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            InternalError internalError = new InternalError();
            internalError.initCause(noSuchMethodException);
            throw internalError;
        }
    }

    public T put(Map<AttributeKey, Object> map, T t) {
        if (t == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        return (T)map.put(this, t);
    }

    public boolean isNullValueAllowed() {
        return this.isNullValueAllowed;
    }

    public boolean isAssignable(Object object) {
        if (object == null) {
            return this.isNullValueAllowed();
        }
        return this.clazz.isInstance(object);
    }

    public String toString() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AttributeKey) {
            return ((AttributeKey)object).key.equals(this.key);
        }
        return false;
    }
}

