/*
*******************************************************************************
*   Copyright (C) 2002-2010, International Business Machines
*   Corporation and others.  All Rights Reserved.
*******************************************************************************
*
*   file name:  urename.h
*   encoding:   US-ASCII
*   tab size:   8 (not used)
*   indentation:4
*
*   Created by: Perl script written by Vladimir Weinstein
*
*  Contains data for renaming ICU exports.
*  Gets included by umachine.h
*
*  THIS FILE IS MACHINE-GENERATED, DON'T PLAY WITH IT IF YOU DON'T KNOW WHAT
*  YOU ARE DOING, OTHERWISE VERY BAD THINGS WILL HAPPEN!
*/

#ifndef URENAME_H
#define URENAME_H

/* Uncomment the following line to disable renaming on platforms
   that do not use Autoconf. */
/* #define U_DISABLE_RENAMING 1 */

#if !U_DISABLE_RENAMING

/* We need the U_ICU_ENTRY_POINT_RENAME definition. There's a default one in unicode/uvernum.h we can use, but we will give
   the platform a chance to define it first.
   Normally (if utypes.h or umachine.h was included first) this will not be necessary as it will already be defined.
 */
#ifndef U_ICU_ENTRY_POINT_RENAME
#include "unicode/umachine.h"
#endif

/* If we still don't have U_ICU_ENTRY_POINT_RENAME use the default. */
#ifndef U_ICU_ENTRY_POINT_RENAME
#include "unicode/uvernum.h"
#endif

/* Error out before the following defines cause very strange and unexpected code breakage */
#ifndef U_ICU_ENTRY_POINT_RENAME
#error U_ICU_ENTRY_POINT_RENAME is not defined - cannot continue. Consider defining U_DISABLE_RENAMING if renaming should not be used.
#endif


/* C exports renaming data */

#define DECPOWERS U_ICU_ENTRY_POINT_RENAME(DECPOWERS)
#define DECSTICKYTAB U_ICU_ENTRY_POINT_RENAME(DECSTICKYTAB)
#define LNnn U_ICU_ENTRY_POINT_RENAME(LNnn)
#define T_CString_int64ToString U_ICU_ENTRY_POINT_RENAME(T_CString_int64ToString)
#define T_CString_integerToString U_ICU_ENTRY_POINT_RENAME(T_CString_integerToString)
#define T_CString_stricmp U_ICU_ENTRY_POINT_RENAME(T_CString_stricmp)
#define T_CString_stringToInteger U_ICU_ENTRY_POINT_RENAME(T_CString_stringToInteger)
#define T_CString_strnicmp U_ICU_ENTRY_POINT_RENAME(T_CString_strnicmp)
#define T_CString_toLowerCase U_ICU_ENTRY_POINT_RENAME(T_CString_toLowerCase)
#define T_CString_toUpperCase U_ICU_ENTRY_POINT_RENAME(T_CString_toUpperCase)
#define UCNV_FROM_U_CALLBACK_ESCAPE U_ICU_ENTRY_POINT_RENAME(UCNV_FROM_U_CALLBACK_ESCAPE)
#define UCNV_FROM_U_CALLBACK_SKIP U_ICU_ENTRY_POINT_RENAME(UCNV_FROM_U_CALLBACK_SKIP)
#define UCNV_FROM_U_CALLBACK_STOP U_ICU_ENTRY_POINT_RENAME(UCNV_FROM_U_CALLBACK_STOP)
#define UCNV_FROM_U_CALLBACK_SUBSTITUTE U_ICU_ENTRY_POINT_RENAME(UCNV_FROM_U_CALLBACK_SUBSTITUTE)
#define UCNV_TO_U_CALLBACK_ESCAPE U_ICU_ENTRY_POINT_RENAME(UCNV_TO_U_CALLBACK_ESCAPE)
#define UCNV_TO_U_CALLBACK_SKIP U_ICU_ENTRY_POINT_RENAME(UCNV_TO_U_CALLBACK_SKIP)
#define UCNV_TO_U_CALLBACK_STOP U_ICU_ENTRY_POINT_RENAME(UCNV_TO_U_CALLBACK_STOP)
#define UCNV_TO_U_CALLBACK_SUBSTITUTE U_ICU_ENTRY_POINT_RENAME(UCNV_TO_U_CALLBACK_SUBSTITUTE)
#define UDataMemory_createNewInstance U_ICU_ENTRY_POINT_RENAME(UDataMemory_createNewInstance)
#define UDataMemory_init U_ICU_ENTRY_POINT_RENAME(UDataMemory_init)
#define UDataMemory_isLoaded U_ICU_ENTRY_POINT_RENAME(UDataMemory_isLoaded)
#define UDataMemory_normalizeDataPointer U_ICU_ENTRY_POINT_RENAME(UDataMemory_normalizeDataPointer)
#define UDataMemory_setData U_ICU_ENTRY_POINT_RENAME(UDataMemory_setData)
#define UDatamemory_assign U_ICU_ENTRY_POINT_RENAME(UDatamemory_assign)
#define _ASCIIData U_ICU_ENTRY_POINT_RENAME(_ASCIIData)
#define _Bocu1Data U_ICU_ENTRY_POINT_RENAME(_Bocu1Data)
#define _CESU8Data U_ICU_ENTRY_POINT_RENAME(_CESU8Data)
#define _HZData U_ICU_ENTRY_POINT_RENAME(_HZData)
#define _IMAPData U_ICU_ENTRY_POINT_RENAME(_IMAPData)
#define _ISCIIData U_ICU_ENTRY_POINT_RENAME(_ISCIIData)
#define _ISO2022Data U_ICU_ENTRY_POINT_RENAME(_ISO2022Data)
#define _LMBCSData1 U_ICU_ENTRY_POINT_RENAME(_LMBCSData1)
#define _LMBCSData11 U_ICU_ENTRY_POINT_RENAME(_LMBCSData11)
#define _LMBCSData16 U_ICU_ENTRY_POINT_RENAME(_LMBCSData16)
#define _LMBCSData17 U_ICU_ENTRY_POINT_RENAME(_LMBCSData17)
#define _LMBCSData18 U_ICU_ENTRY_POINT_RENAME(_LMBCSData18)
#define _LMBCSData19 U_ICU_ENTRY_POINT_RENAME(_LMBCSData19)
#define _LMBCSData2 U_ICU_ENTRY_POINT_RENAME(_LMBCSData2)
#define _LMBCSData3 U_ICU_ENTRY_POINT_RENAME(_LMBCSData3)
#define _LMBCSData4 U_ICU_ENTRY_POINT_RENAME(_LMBCSData4)
#define _LMBCSData5 U_ICU_ENTRY_POINT_RENAME(_LMBCSData5)
#define _LMBCSData6 U_ICU_ENTRY_POINT_RENAME(_LMBCSData6)
#define _LMBCSData8 U_ICU_ENTRY_POINT_RENAME(_LMBCSData8)
#define _Latin1Data U_ICU_ENTRY_POINT_RENAME(_Latin1Data)
#define _MBCSData U_ICU_ENTRY_POINT_RENAME(_MBCSData)
#define _SCSUData U_ICU_ENTRY_POINT_RENAME(_SCSUData)
#define _UTF16BEData U_ICU_ENTRY_POINT_RENAME(_UTF16BEData)
#define _UTF16Data U_ICU_ENTRY_POINT_RENAME(_UTF16Data)
#define _UTF16LEData U_ICU_ENTRY_POINT_RENAME(_UTF16LEData)
#define _UTF32BEData U_ICU_ENTRY_POINT_RENAME(_UTF32BEData)
#define _UTF32Data U_ICU_ENTRY_POINT_RENAME(_UTF32Data)
#define _UTF32LEData U_ICU_ENTRY_POINT_RENAME(_UTF32LEData)
#define _UTF7Data U_ICU_ENTRY_POINT_RENAME(_UTF7Data)
#define _UTF8Data U_ICU_ENTRY_POINT_RENAME(_UTF8Data)
#define bms_close U_ICU_ENTRY_POINT_RENAME(bms_close)
#define bms_empty U_ICU_ENTRY_POINT_RENAME(bms_empty)
#define bms_getData U_ICU_ENTRY_POINT_RENAME(bms_getData)
#define bms_open U_ICU_ENTRY_POINT_RENAME(bms_open)
#define bms_search U_ICU_ENTRY_POINT_RENAME(bms_search)
#define bms_setTargetString U_ICU_ENTRY_POINT_RENAME(bms_setTargetString)
#define buildWSConfusableData U_ICU_ENTRY_POINT_RENAME(buildWSConfusableData)
#define cmemory_cleanup U_ICU_ENTRY_POINT_RENAME(cmemory_cleanup)
#define cmemory_inUse U_ICU_ENTRY_POINT_RENAME(cmemory_inUse)
#define d2utable U_ICU_ENTRY_POINT_RENAME(d2utable)
#define deleteCEList U_ICU_ENTRY_POINT_RENAME(deleteCEList)
#define deleteChars U_ICU_ENTRY_POINT_RENAME(deleteChars)
#define deleteCollDataCacheEntry U_ICU_ENTRY_POINT_RENAME(deleteCollDataCacheEntry)
#define deleteStringList U_ICU_ENTRY_POINT_RENAME(deleteStringList)
#define deleteUnicodeStringKey U_ICU_ENTRY_POINT_RENAME(deleteUnicodeStringKey)
#define izrule_clone U_ICU_ENTRY_POINT_RENAME(izrule_clone)
#define izrule_close U_ICU_ENTRY_POINT_RENAME(izrule_close)
#define izrule_equals U_ICU_ENTRY_POINT_RENAME(izrule_equals)
#define izrule_getDSTSavings U_ICU_ENTRY_POINT_RENAME(izrule_getDSTSavings)
#define izrule_getDynamicClassID U_ICU_ENTRY_POINT_RENAME(izrule_getDynamicClassID)
#define izrule_getFinalStart U_ICU_ENTRY_POINT_RENAME(izrule_getFinalStart)
#define izrule_getFirstStart U_ICU_ENTRY_POINT_RENAME(izrule_getFirstStart)
#define izrule_getName U_ICU_ENTRY_POINT_RENAME(izrule_getName)
#define izrule_getNextStart U_ICU_ENTRY_POINT_RENAME(izrule_getNextStart)
#define izrule_getPreviousStart U_ICU_ENTRY_POINT_RENAME(izrule_getPreviousStart)
#define izrule_getRawOffset U_ICU_ENTRY_POINT_RENAME(izrule_getRawOffset)
#define izrule_getStaticClassID U_ICU_ENTRY_POINT_RENAME(izrule_getStaticClassID)
#define izrule_isEquivalentTo U_ICU_ENTRY_POINT_RENAME(izrule_isEquivalentTo)
#define izrule_open U_ICU_ENTRY_POINT_RENAME(izrule_open)
#define le_close U_ICU_ENTRY_POINT_RENAME(le_close)
#define le_create U_ICU_ENTRY_POINT_RENAME(le_create)
#define le_getCharIndices U_ICU_ENTRY_POINT_RENAME(le_getCharIndices)
#define le_getCharIndicesWithBase U_ICU_ENTRY_POINT_RENAME(le_getCharIndicesWithBase)
#define le_getGlyphCount U_ICU_ENTRY_POINT_RENAME(le_getGlyphCount)
#define le_getGlyphPosition U_ICU_ENTRY_POINT_RENAME(le_getGlyphPosition)
#define le_getGlyphPositions U_ICU_ENTRY_POINT_RENAME(le_getGlyphPositions)
#define le_getGlyphs U_ICU_ENTRY_POINT_RENAME(le_getGlyphs)
#define le_layoutChars U_ICU_ENTRY_POINT_RENAME(le_layoutChars)
#define le_reset U_ICU_ENTRY_POINT_RENAME(le_reset)
#define locale_getKeywords U_ICU_ENTRY_POINT_RENAME(locale_getKeywords)
#define locale_get_default U_ICU_ENTRY_POINT_RENAME(locale_get_default)
#define locale_set_default U_ICU_ENTRY_POINT_RENAME(locale_set_default)
#define pl_addFontRun U_ICU_ENTRY_POINT_RENAME(pl_addFontRun)
#define pl_addLocaleRun U_ICU_ENTRY_POINT_RENAME(pl_addLocaleRun)
#define pl_addValueRun U_ICU_ENTRY_POINT_RENAME(pl_addValueRun)
#define pl_close U_ICU_ENTRY_POINT_RENAME(pl_close)
#define pl_closeFontRuns U_ICU_ENTRY_POINT_RENAME(pl_closeFontRuns)
#define pl_closeLine U_ICU_ENTRY_POINT_RENAME(pl_closeLine)
#define pl_closeLocaleRuns U_ICU_ENTRY_POINT_RENAME(pl_closeLocaleRuns)
#define pl_closeValueRuns U_ICU_ENTRY_POINT_RENAME(pl_closeValueRuns)
#define pl_countLineRuns U_ICU_ENTRY_POINT_RENAME(pl_countLineRuns)
#define pl_create U_ICU_ENTRY_POINT_RENAME(pl_create)
#define pl_getAscent U_ICU_ENTRY_POINT_RENAME(pl_getAscent)
#define pl_getDescent U_ICU_ENTRY_POINT_RENAME(pl_getDescent)
#define pl_getFontRunCount U_ICU_ENTRY_POINT_RENAME(pl_getFontRunCount)
#define pl_getFontRunFont U_ICU_ENTRY_POINT_RENAME(pl_getFontRunFont)
#define pl_getFontRunLastLimit U_ICU_ENTRY_POINT_RENAME(pl_getFontRunLastLimit)
#define pl_getFontRunLimit U_ICU_ENTRY_POINT_RENAME(pl_getFontRunLimit)
#define pl_getLeading U_ICU_ENTRY_POINT_RENAME(pl_getLeading)
#define pl_getLineAscent U_ICU_ENTRY_POINT_RENAME(pl_getLineAscent)
#define pl_getLineDescent U_ICU_ENTRY_POINT_RENAME(pl_getLineDescent)
#define pl_getLineLeading U_ICU_ENTRY_POINT_RENAME(pl_getLineLeading)
#define pl_getLineVisualRun U_ICU_ENTRY_POINT_RENAME(pl_getLineVisualRun)
#define pl_getLineWidth U_ICU_ENTRY_POINT_RENAME(pl_getLineWidth)
#define pl_getLocaleRunCount U_ICU_ENTRY_POINT_RENAME(pl_getLocaleRunCount)
#define pl_getLocaleRunLastLimit U_ICU_ENTRY_POINT_RENAME(pl_getLocaleRunLastLimit)
#define pl_getLocaleRunLimit U_ICU_ENTRY_POINT_RENAME(pl_getLocaleRunLimit)
#define pl_getLocaleRunLocale U_ICU_ENTRY_POINT_RENAME(pl_getLocaleRunLocale)
#define pl_getParagraphLevel U_ICU_ENTRY_POINT_RENAME(pl_getParagraphLevel)
#define pl_getTextDirection U_ICU_ENTRY_POINT_RENAME(pl_getTextDirection)
#define pl_getValueRunCount U_ICU_ENTRY_POINT_RENAME(pl_getValueRunCount)
#define pl_getValueRunLastLimit U_ICU_ENTRY_POINT_RENAME(pl_getValueRunLastLimit)
#define pl_getValueRunLimit U_ICU_ENTRY_POINT_RENAME(pl_getValueRunLimit)
#define pl_getValueRunValue U_ICU_ENTRY_POINT_RENAME(pl_getValueRunValue)
#define pl_getVisualRunAscent U_ICU_ENTRY_POINT_RENAME(pl_getVisualRunAscent)
#define pl_getVisualRunDescent U_ICU_ENTRY_POINT_RENAME(pl_getVisualRunDescent)
#define pl_getVisualRunDirection U_ICU_ENTRY_POINT_RENAME(pl_getVisualRunDirection)
#define pl_getVisualRunFont U_ICU_ENTRY_POINT_RENAME(pl_getVisualRunFont)
#define pl_getVisualRunGlyphCount U_ICU_ENTRY_POINT_RENAME(pl_getVisualRunGlyphCount)
#define pl_getVisualRunGlyphToCharMap U_ICU_ENTRY_POINT_RENAME(pl_getVisualRunGlyphToCharMap)
#define pl_getVisualRunGlyphs U_ICU_ENTRY_POINT_RENAME(pl_getVisualRunGlyphs)
#define pl_getVisualRunLeading U_ICU_ENTRY_POINT_RENAME(pl_getVisualRunLeading)
#define pl_getVisualRunPositions U_ICU_ENTRY_POINT_RENAME(pl_getVisualRunPositions)
#define pl_isComplex U_ICU_ENTRY_POINT_RENAME(pl_isComplex)
#define pl_nextLine U_ICU_ENTRY_POINT_RENAME(pl_nextLine)
#define pl_openEmptyFontRuns U_ICU_ENTRY_POINT_RENAME(pl_openEmptyFontRuns)
#define pl_openEmptyLocaleRuns U_ICU_ENTRY_POINT_RENAME(pl_openEmptyLocaleRuns)
#define pl_openEmptyValueRuns U_ICU_ENTRY_POINT_RENAME(pl_openEmptyValueRuns)
#define pl_openFontRuns U_ICU_ENTRY_POINT_RENAME(pl_openFontRuns)
#define pl_openLocaleRuns U_ICU_ENTRY_POINT_RENAME(pl_openLocaleRuns)
#define pl_openValueRuns U_ICU_ENTRY_POINT_RENAME(pl_openValueRuns)
#define pl_reflow U_ICU_ENTRY_POINT_RENAME(pl_reflow)
#define pl_resetFontRuns U_ICU_ENTRY_POINT_RENAME(pl_resetFontRuns)
#define pl_resetLocaleRuns U_ICU_ENTRY_POINT_RENAME(pl_resetLocaleRuns)
#define pl_resetValueRuns U_ICU_ENTRY_POINT_RENAME(pl_resetValueRuns)
#define res_countArrayItems U_ICU_ENTRY_POINT_RENAME(res_countArrayItems)
#define res_findResource U_ICU_ENTRY_POINT_RENAME(res_findResource)
#define res_getAlias U_ICU_ENTRY_POINT_RENAME(res_getAlias)
#define res_getArrayItem U_ICU_ENTRY_POINT_RENAME(res_getArrayItem)
#define res_getBinary U_ICU_ENTRY_POINT_RENAME(res_getBinary)
#define res_getIntVector U_ICU_ENTRY_POINT_RENAME(res_getIntVector)
#define res_getPublicType U_ICU_ENTRY_POINT_RENAME(res_getPublicType)
#define res_getResource U_ICU_ENTRY_POINT_RENAME(res_getResource)
#define res_getString U_ICU_ENTRY_POINT_RENAME(res_getString)
#define res_getTableItemByIndex U_ICU_ENTRY_POINT_RENAME(res_getTableItemByIndex)
#define res_getTableItemByKey U_ICU_ENTRY_POINT_RENAME(res_getTableItemByKey)
#define res_load U_ICU_ENTRY_POINT_RENAME(res_load)
#define res_read U_ICU_ENTRY_POINT_RENAME(res_read)
#define res_unload U_ICU_ENTRY_POINT_RENAME(res_unload)
#define triedict_swap U_ICU_ENTRY_POINT_RENAME(triedict_swap)
#define u_UCharsToChars U_ICU_ENTRY_POINT_RENAME(u_UCharsToChars)
#define u_austrcpy U_ICU_ENTRY_POINT_RENAME(u_austrcpy)
#define u_austrncpy U_ICU_ENTRY_POINT_RENAME(u_austrncpy)
#define u_catclose U_ICU_ENTRY_POINT_RENAME(u_catclose)
#define u_catgets U_ICU_ENTRY_POINT_RENAME(u_catgets)
#define u_catopen U_ICU_ENTRY_POINT_RENAME(u_catopen)
#define u_charAge U_ICU_ENTRY_POINT_RENAME(u_charAge)
#define u_charDigitValue U_ICU_ENTRY_POINT_RENAME(u_charDigitValue)
#define u_charDirection U_ICU_ENTRY_POINT_RENAME(u_charDirection)
#define u_charFromName U_ICU_ENTRY_POINT_RENAME(u_charFromName)
#define u_charMirror U_ICU_ENTRY_POINT_RENAME(u_charMirror)
#define u_charName U_ICU_ENTRY_POINT_RENAME(u_charName)
#define u_charType U_ICU_ENTRY_POINT_RENAME(u_charType)
#define u_charsToUChars U_ICU_ENTRY_POINT_RENAME(u_charsToUChars)
#define u_cleanup U_ICU_ENTRY_POINT_RENAME(u_cleanup)
#define u_countChar32 U_ICU_ENTRY_POINT_RENAME(u_countChar32)
#define u_digit U_ICU_ENTRY_POINT_RENAME(u_digit)
#define u_enumCharNames U_ICU_ENTRY_POINT_RENAME(u_enumCharNames)
#define u_enumCharTypes U_ICU_ENTRY_POINT_RENAME(u_enumCharTypes)
#define u_errorName U_ICU_ENTRY_POINT_RENAME(u_errorName)
#define u_fadopt U_ICU_ENTRY_POINT_RENAME(u_fadopt)
#define u_fclose U_ICU_ENTRY_POINT_RENAME(u_fclose)
#define u_feof U_ICU_ENTRY_POINT_RENAME(u_feof)
#define u_fflush U_ICU_ENTRY_POINT_RENAME(u_fflush)
#define u_fgetConverter U_ICU_ENTRY_POINT_RENAME(u_fgetConverter)
#define u_fgetc U_ICU_ENTRY_POINT_RENAME(u_fgetc)
#define u_fgetcodepage U_ICU_ENTRY_POINT_RENAME(u_fgetcodepage)
#define u_fgetcx U_ICU_ENTRY_POINT_RENAME(u_fgetcx)
#define u_fgetfile U_ICU_ENTRY_POINT_RENAME(u_fgetfile)
#define u_fgetlocale U_ICU_ENTRY_POINT_RENAME(u_fgetlocale)
#define u_fgets U_ICU_ENTRY_POINT_RENAME(u_fgets)
#define u_file_read U_ICU_ENTRY_POINT_RENAME(u_file_read)
#define u_file_write U_ICU_ENTRY_POINT_RENAME(u_file_write)
#define u_file_write_flush U_ICU_ENTRY_POINT_RENAME(u_file_write_flush)
#define u_finit U_ICU_ENTRY_POINT_RENAME(u_finit)
#define u_foldCase U_ICU_ENTRY_POINT_RENAME(u_foldCase)
#define u_fopen U_ICU_ENTRY_POINT_RENAME(u_fopen)
#define u_forDigit U_ICU_ENTRY_POINT_RENAME(u_forDigit)
#define u_formatMessage U_ICU_ENTRY_POINT_RENAME(u_formatMessage)
#define u_formatMessageWithError U_ICU_ENTRY_POINT_RENAME(u_formatMessageWithError)
#define u_fprintf U_ICU_ENTRY_POINT_RENAME(u_fprintf)
#define u_fprintf_u U_ICU_ENTRY_POINT_RENAME(u_fprintf_u)
#define u_fputc U_ICU_ENTRY_POINT_RENAME(u_fputc)
#define u_fputs U_ICU_ENTRY_POINT_RENAME(u_fputs)
#define u_frewind U_ICU_ENTRY_POINT_RENAME(u_frewind)
#define u_fscanf U_ICU_ENTRY_POINT_RENAME(u_fscanf)
#define u_fscanf_u U_ICU_ENTRY_POINT_RENAME(u_fscanf_u)
#define u_fsetcodepage U_ICU_ENTRY_POINT_RENAME(u_fsetcodepage)
#define u_fsetlocale U_ICU_ENTRY_POINT_RENAME(u_fsetlocale)
#define u_fsettransliterator U_ICU_ENTRY_POINT_RENAME(u_fsettransliterator)
#define u_fstropen U_ICU_ENTRY_POINT_RENAME(u_fstropen)
#define u_fungetc U_ICU_ENTRY_POINT_RENAME(u_fungetc)
#define u_getCombiningClass U_ICU_ENTRY_POINT_RENAME(u_getCombiningClass)
#define u_getDataDirectory U_ICU_ENTRY_POINT_RENAME(u_getDataDirectory)
#define u_getDataVersion U_ICU_ENTRY_POINT_RENAME(u_getDataVersion)
#define u_getDefaultConverter U_ICU_ENTRY_POINT_RENAME(u_getDefaultConverter)
#define u_getFC_NFKC_Closure U_ICU_ENTRY_POINT_RENAME(u_getFC_NFKC_Closure)
#define u_getISOComment U_ICU_ENTRY_POINT_RENAME(u_getISOComment)
#define u_getIntPropertyMaxValue U_ICU_ENTRY_POINT_RENAME(u_getIntPropertyMaxValue)
#define u_getIntPropertyMinValue U_ICU_ENTRY_POINT_RENAME(u_getIntPropertyMinValue)
#define u_getIntPropertyValue U_ICU_ENTRY_POINT_RENAME(u_getIntPropertyValue)
#define u_getNumericValue U_ICU_ENTRY_POINT_RENAME(u_getNumericValue)
#define u_getPropertyEnum U_ICU_ENTRY_POINT_RENAME(u_getPropertyEnum)
#define u_getPropertyName U_ICU_ENTRY_POINT_RENAME(u_getPropertyName)
#define u_getPropertyValueEnum U_ICU_ENTRY_POINT_RENAME(u_getPropertyValueEnum)
#define u_getPropertyValueName U_ICU_ENTRY_POINT_RENAME(u_getPropertyValueName)
#define u_getUnicodeProperties U_ICU_ENTRY_POINT_RENAME(u_getUnicodeProperties)
#define u_getUnicodeVersion U_ICU_ENTRY_POINT_RENAME(u_getUnicodeVersion)
#define u_getVersion U_ICU_ENTRY_POINT_RENAME(u_getVersion)
#define u_hasBinaryProperty U_ICU_ENTRY_POINT_RENAME(u_hasBinaryProperty)
#define u_init U_ICU_ENTRY_POINT_RENAME(u_init)
#define u_isDataOlder U_ICU_ENTRY_POINT_RENAME(u_isDataOlder)
#define u_isIDIgnorable U_ICU_ENTRY_POINT_RENAME(u_isIDIgnorable)
#define u_isIDPart U_ICU_ENTRY_POINT_RENAME(u_isIDPart)
#define u_isIDStart U_ICU_ENTRY_POINT_RENAME(u_isIDStart)
#define u_isISOControl U_ICU_ENTRY_POINT_RENAME(u_isISOControl)
#define u_isJavaIDPart U_ICU_ENTRY_POINT_RENAME(u_isJavaIDPart)
#define u_isJavaIDStart U_ICU_ENTRY_POINT_RENAME(u_isJavaIDStart)
#define u_isJavaSpaceChar U_ICU_ENTRY_POINT_RENAME(u_isJavaSpaceChar)
#define u_isMirrored U_ICU_ENTRY_POINT_RENAME(u_isMirrored)
#define u_isUAlphabetic U_ICU_ENTRY_POINT_RENAME(u_isUAlphabetic)
#define u_isULowercase U_ICU_ENTRY_POINT_RENAME(u_isULowercase)
#define u_isUUppercase U_ICU_ENTRY_POINT_RENAME(u_isUUppercase)
#define u_isUWhiteSpace U_ICU_ENTRY_POINT_RENAME(u_isUWhiteSpace)
#define u_isWhitespace U_ICU_ENTRY_POINT_RENAME(u_isWhitespace)
#define u_isalnum U_ICU_ENTRY_POINT_RENAME(u_isalnum)
#define u_isalnumPOSIX U_ICU_ENTRY_POINT_RENAME(u_isalnumPOSIX)
#define u_isalpha U_ICU_ENTRY_POINT_RENAME(u_isalpha)
#define u_isbase U_ICU_ENTRY_POINT_RENAME(u_isbase)
#define u_isblank U_ICU_ENTRY_POINT_RENAME(u_isblank)
#define u_iscntrl U_ICU_ENTRY_POINT_RENAME(u_iscntrl)
#define u_isdefined U_ICU_ENTRY_POINT_RENAME(u_isdefined)
#define u_isdigit U_ICU_ENTRY_POINT_RENAME(u_isdigit)
#define u_isgraph U_ICU_ENTRY_POINT_RENAME(u_isgraph)
#define u_isgraphPOSIX U_ICU_ENTRY_POINT_RENAME(u_isgraphPOSIX)
#define u_islower U_ICU_ENTRY_POINT_RENAME(u_islower)
#define u_isprint U_ICU_ENTRY_POINT_RENAME(u_isprint)
#define u_isprintPOSIX U_ICU_ENTRY_POINT_RENAME(u_isprintPOSIX)
#define u_ispunct U_ICU_ENTRY_POINT_RENAME(u_ispunct)
#define u_isspace U_ICU_ENTRY_POINT_RENAME(u_isspace)
#define u_istitle U_ICU_ENTRY_POINT_RENAME(u_istitle)
#define u_isupper U_ICU_ENTRY_POINT_RENAME(u_isupper)
#define u_isxdigit U_ICU_ENTRY_POINT_RENAME(u_isxdigit)
#define u_lengthOfIdenticalLevelRun U_ICU_ENTRY_POINT_RENAME(u_lengthOfIdenticalLevelRun)
#define u_locbund_close U_ICU_ENTRY_POINT_RENAME(u_locbund_close)
#define u_locbund_getNumberFormat U_ICU_ENTRY_POINT_RENAME(u_locbund_getNumberFormat)
#define u_locbund_init U_ICU_ENTRY_POINT_RENAME(u_locbund_init)
#define u_memcasecmp U_ICU_ENTRY_POINT_RENAME(u_memcasecmp)
#define u_memchr U_ICU_ENTRY_POINT_RENAME(u_memchr)
#define u_memchr32 U_ICU_ENTRY_POINT_RENAME(u_memchr32)
#define u_memcmp U_ICU_ENTRY_POINT_RENAME(u_memcmp)
#define u_memcmpCodePointOrder U_ICU_ENTRY_POINT_RENAME(u_memcmpCodePointOrder)
#define u_memcpy U_ICU_ENTRY_POINT_RENAME(u_memcpy)
#define u_memmove U_ICU_ENTRY_POINT_RENAME(u_memmove)
#define u_memrchr U_ICU_ENTRY_POINT_RENAME(u_memrchr)
#define u_memrchr32 U_ICU_ENTRY_POINT_RENAME(u_memrchr32)
#define u_memset U_ICU_ENTRY_POINT_RENAME(u_memset)
#define u_parseMessage U_ICU_ENTRY_POINT_RENAME(u_parseMessage)
#define u_parseMessageWithError U_ICU_ENTRY_POINT_RENAME(u_parseMessageWithError)
#define u_printf_parse U_ICU_ENTRY_POINT_RENAME(u_printf_parse)
#define u_releaseDefaultConverter U_ICU_ENTRY_POINT_RENAME(u_releaseDefaultConverter)
#define u_scanf_parse U_ICU_ENTRY_POINT_RENAME(u_scanf_parse)
#define u_setAtomicIncDecFunctions U_ICU_ENTRY_POINT_RENAME(u_setAtomicIncDecFunctions)
#define u_setDataDirectory U_ICU_ENTRY_POINT_RENAME(u_setDataDirectory)
#define u_setMemoryFunctions U_ICU_ENTRY_POINT_RENAME(u_setMemoryFunctions)
#define u_setMutexFunctions U_ICU_ENTRY_POINT_RENAME(u_setMutexFunctions)
#define u_shapeArabic U_ICU_ENTRY_POINT_RENAME(u_shapeArabic)
#define u_snprintf U_ICU_ENTRY_POINT_RENAME(u_snprintf)
#define u_snprintf_u U_ICU_ENTRY_POINT_RENAME(u_snprintf_u)
#define u_sprintf U_ICU_ENTRY_POINT_RENAME(u_sprintf)
#define u_sprintf_u U_ICU_ENTRY_POINT_RENAME(u_sprintf_u)
#define u_sscanf U_ICU_ENTRY_POINT_RENAME(u_sscanf)
#define u_sscanf_u U_ICU_ENTRY_POINT_RENAME(u_sscanf_u)
#define u_strCaseCompare U_ICU_ENTRY_POINT_RENAME(u_strCaseCompare)
#define u_strCompare U_ICU_ENTRY_POINT_RENAME(u_strCompare)
#define u_strCompareIter U_ICU_ENTRY_POINT_RENAME(u_strCompareIter)
#define u_strFindFirst U_ICU_ENTRY_POINT_RENAME(u_strFindFirst)
#define u_strFindLast U_ICU_ENTRY_POINT_RENAME(u_strFindLast)
#define u_strFoldCase U_ICU_ENTRY_POINT_RENAME(u_strFoldCase)
#define u_strFromJavaModifiedUTF8WithSub U_ICU_ENTRY_POINT_RENAME(u_strFromJavaModifiedUTF8WithSub)
#define u_strFromPunycode U_ICU_ENTRY_POINT_RENAME(u_strFromPunycode)
#define u_strFromUTF32 U_ICU_ENTRY_POINT_RENAME(u_strFromUTF32)
#define u_strFromUTF32WithSub U_ICU_ENTRY_POINT_RENAME(u_strFromUTF32WithSub)
#define u_strFromUTF8 U_ICU_ENTRY_POINT_RENAME(u_strFromUTF8)
#define u_strFromUTF8Lenient U_ICU_ENTRY_POINT_RENAME(u_strFromUTF8Lenient)
#define u_strFromUTF8WithSub U_ICU_ENTRY_POINT_RENAME(u_strFromUTF8WithSub)
#define u_strFromWCS U_ICU_ENTRY_POINT_RENAME(u_strFromWCS)
#define u_strHasMoreChar32Than U_ICU_ENTRY_POINT_RENAME(u_strHasMoreChar32Than)
#define u_strToJavaModifiedUTF8 U_ICU_ENTRY_POINT_RENAME(u_strToJavaModifiedUTF8)
#define u_strToLower U_ICU_ENTRY_POINT_RENAME(u_strToLower)
#define u_strToPunycode U_ICU_ENTRY_POINT_RENAME(u_strToPunycode)
#define u_strToTitle U_ICU_ENTRY_POINT_RENAME(u_strToTitle)
#define u_strToUTF32 U_ICU_ENTRY_POINT_RENAME(u_strToUTF32)
#define u_strToUTF32WithSub U_ICU_ENTRY_POINT_RENAME(u_strToUTF32WithSub)
#define u_strToUTF8 U_ICU_ENTRY_POINT_RENAME(u_strToUTF8)
#define u_strToUTF8WithSub U_ICU_ENTRY_POINT_RENAME(u_strToUTF8WithSub)
#define u_strToUpper U_ICU_ENTRY_POINT_RENAME(u_strToUpper)
#define u_strToWCS U_ICU_ENTRY_POINT_RENAME(u_strToWCS)
#define u_strcasecmp U_ICU_ENTRY_POINT_RENAME(u_strcasecmp)
#define u_strcat U_ICU_ENTRY_POINT_RENAME(u_strcat)
#define u_strchr U_ICU_ENTRY_POINT_RENAME(u_strchr)
#define u_strchr32 U_ICU_ENTRY_POINT_RENAME(u_strchr32)
#define u_strcmp U_ICU_ENTRY_POINT_RENAME(u_strcmp)
#define u_strcmpCodePointOrder U_ICU_ENTRY_POINT_RENAME(u_strcmpCodePointOrder)
#define u_strcmpFold U_ICU_ENTRY_POINT_RENAME(u_strcmpFold)
#define u_strcpy U_ICU_ENTRY_POINT_RENAME(u_strcpy)
#define u_strcspn U_ICU_ENTRY_POINT_RENAME(u_strcspn)
#define u_strlen U_ICU_ENTRY_POINT_RENAME(u_strlen)
#define u_strncasecmp U_ICU_ENTRY_POINT_RENAME(u_strncasecmp)
#define u_strncat U_ICU_ENTRY_POINT_RENAME(u_strncat)
#define u_strncmp U_ICU_ENTRY_POINT_RENAME(u_strncmp)
#define u_strncmpCodePointOrder U_ICU_ENTRY_POINT_RENAME(u_strncmpCodePointOrder)
#define u_strncpy U_ICU_ENTRY_POINT_RENAME(u_strncpy)
#define u_strpbrk U_ICU_ENTRY_POINT_RENAME(u_strpbrk)
#define u_strrchr U_ICU_ENTRY_POINT_RENAME(u_strrchr)
#define u_strrchr32 U_ICU_ENTRY_POINT_RENAME(u_strrchr32)
#define u_strrstr U_ICU_ENTRY_POINT_RENAME(u_strrstr)
#define u_strspn U_ICU_ENTRY_POINT_RENAME(u_strspn)
#define u_strstr U_ICU_ENTRY_POINT_RENAME(u_strstr)
#define u_strtok_r U_ICU_ENTRY_POINT_RENAME(u_strtok_r)
#define u_terminateChars U_ICU_ENTRY_POINT_RENAME(u_terminateChars)
#define u_terminateUChar32s U_ICU_ENTRY_POINT_RENAME(u_terminateUChar32s)
#define u_terminateUChars U_ICU_ENTRY_POINT_RENAME(u_terminateUChars)
#define u_terminateWChars U_ICU_ENTRY_POINT_RENAME(u_terminateWChars)
#define u_tolower U_ICU_ENTRY_POINT_RENAME(u_tolower)
#define u_totitle U_ICU_ENTRY_POINT_RENAME(u_totitle)
#define u_toupper U_ICU_ENTRY_POINT_RENAME(u_toupper)
#define u_uastrcpy U_ICU_ENTRY_POINT_RENAME(u_uastrcpy)
#define u_uastrncpy U_ICU_ENTRY_POINT_RENAME(u_uastrncpy)
#define u_unescape U_ICU_ENTRY_POINT_RENAME(u_unescape)
#define u_unescapeAt U_ICU_ENTRY_POINT_RENAME(u_unescapeAt)
#define u_versionFromString U_ICU_ENTRY_POINT_RENAME(u_versionFromString)
#define u_versionFromUString U_ICU_ENTRY_POINT_RENAME(u_versionFromUString)
#define u_versionToString U_ICU_ENTRY_POINT_RENAME(u_versionToString)
#define u_vformatMessage U_ICU_ENTRY_POINT_RENAME(u_vformatMessage)
#define u_vformatMessageWithError U_ICU_ENTRY_POINT_RENAME(u_vformatMessageWithError)
#define u_vfprintf U_ICU_ENTRY_POINT_RENAME(u_vfprintf)
#define u_vfprintf_u U_ICU_ENTRY_POINT_RENAME(u_vfprintf_u)
#define u_vfscanf U_ICU_ENTRY_POINT_RENAME(u_vfscanf)
#define u_vfscanf_u U_ICU_ENTRY_POINT_RENAME(u_vfscanf_u)
#define u_vparseMessage U_ICU_ENTRY_POINT_RENAME(u_vparseMessage)
#define u_vparseMessageWithError U_ICU_ENTRY_POINT_RENAME(u_vparseMessageWithError)
#define u_vsnprintf U_ICU_ENTRY_POINT_RENAME(u_vsnprintf)
#define u_vsnprintf_u U_ICU_ENTRY_POINT_RENAME(u_vsnprintf_u)
#define u_vsprintf U_ICU_ENTRY_POINT_RENAME(u_vsprintf)
#define u_vsprintf_u U_ICU_ENTRY_POINT_RENAME(u_vsprintf_u)
#define u_vsscanf U_ICU_ENTRY_POINT_RENAME(u_vsscanf)
#define u_vsscanf_u U_ICU_ENTRY_POINT_RENAME(u_vsscanf_u)
#define u_writeDiff U_ICU_ENTRY_POINT_RENAME(u_writeDiff)
#define u_writeIdenticalLevelRun U_ICU_ENTRY_POINT_RENAME(u_writeIdenticalLevelRun)
#define u_writeIdenticalLevelRunTwoChars U_ICU_ENTRY_POINT_RENAME(u_writeIdenticalLevelRunTwoChars)
#define ubidi_addPropertyStarts U_ICU_ENTRY_POINT_RENAME(ubidi_addPropertyStarts)
#define ubidi_close U_ICU_ENTRY_POINT_RENAME(ubidi_close)
#define ubidi_closeProps U_ICU_ENTRY_POINT_RENAME(ubidi_closeProps)
#define ubidi_countParagraphs U_ICU_ENTRY_POINT_RENAME(ubidi_countParagraphs)
#define ubidi_countRuns U_ICU_ENTRY_POINT_RENAME(ubidi_countRuns)
#define ubidi_getClass U_ICU_ENTRY_POINT_RENAME(ubidi_getClass)
#define ubidi_getClassCallback U_ICU_ENTRY_POINT_RENAME(ubidi_getClassCallback)
#define ubidi_getCustomizedClass U_ICU_ENTRY_POINT_RENAME(ubidi_getCustomizedClass)
#define ubidi_getDirection U_ICU_ENTRY_POINT_RENAME(ubidi_getDirection)
#define ubidi_getJoiningGroup U_ICU_ENTRY_POINT_RENAME(ubidi_getJoiningGroup)
#define ubidi_getJoiningType U_ICU_ENTRY_POINT_RENAME(ubidi_getJoiningType)
#define ubidi_getLength U_ICU_ENTRY_POINT_RENAME(ubidi_getLength)
#define ubidi_getLevelAt U_ICU_ENTRY_POINT_RENAME(ubidi_getLevelAt)
#define ubidi_getLevels U_ICU_ENTRY_POINT_RENAME(ubidi_getLevels)
#define ubidi_getLogicalIndex U_ICU_ENTRY_POINT_RENAME(ubidi_getLogicalIndex)
#define ubidi_getLogicalMap U_ICU_ENTRY_POINT_RENAME(ubidi_getLogicalMap)
#define ubidi_getLogicalRun U_ICU_ENTRY_POINT_RENAME(ubidi_getLogicalRun)
#define ubidi_getMaxValue U_ICU_ENTRY_POINT_RENAME(ubidi_getMaxValue)
#define ubidi_getMemory U_ICU_ENTRY_POINT_RENAME(ubidi_getMemory)
#define ubidi_getMirror U_ICU_ENTRY_POINT_RENAME(ubidi_getMirror)
#define ubidi_getParaLevel U_ICU_ENTRY_POINT_RENAME(ubidi_getParaLevel)
#define ubidi_getParagraph U_ICU_ENTRY_POINT_RENAME(ubidi_getParagraph)
#define ubidi_getParagraphByIndex U_ICU_ENTRY_POINT_RENAME(ubidi_getParagraphByIndex)
#define ubidi_getProcessedLength U_ICU_ENTRY_POINT_RENAME(ubidi_getProcessedLength)
#define ubidi_getReorderingMode U_ICU_ENTRY_POINT_RENAME(ubidi_getReorderingMode)
#define ubidi_getReorderingOptions U_ICU_ENTRY_POINT_RENAME(ubidi_getReorderingOptions)
#define ubidi_getResultLength U_ICU_ENTRY_POINT_RENAME(ubidi_getResultLength)
#define ubidi_getRuns U_ICU_ENTRY_POINT_RENAME(ubidi_getRuns)
#define ubidi_getSingleton U_ICU_ENTRY_POINT_RENAME(ubidi_getSingleton)
#define ubidi_getText U_ICU_ENTRY_POINT_RENAME(ubidi_getText)
#define ubidi_getVisualIndex U_ICU_ENTRY_POINT_RENAME(ubidi_getVisualIndex)
#define ubidi_getVisualMap U_ICU_ENTRY_POINT_RENAME(ubidi_getVisualMap)
#define ubidi_getVisualRun U_ICU_ENTRY_POINT_RENAME(ubidi_getVisualRun)
#define ubidi_invertMap U_ICU_ENTRY_POINT_RENAME(ubidi_invertMap)
#define ubidi_isBidiControl U_ICU_ENTRY_POINT_RENAME(ubidi_isBidiControl)
#define ubidi_isInverse U_ICU_ENTRY_POINT_RENAME(ubidi_isInverse)
#define ubidi_isJoinControl U_ICU_ENTRY_POINT_RENAME(ubidi_isJoinControl)
#define ubidi_isMirrored U_ICU_ENTRY_POINT_RENAME(ubidi_isMirrored)
#define ubidi_isOrderParagraphsLTR U_ICU_ENTRY_POINT_RENAME(ubidi_isOrderParagraphsLTR)
#define ubidi_open U_ICU_ENTRY_POINT_RENAME(ubidi_open)
#define ubidi_openSized U_ICU_ENTRY_POINT_RENAME(ubidi_openSized)
#define ubidi_orderParagraphsLTR U_ICU_ENTRY_POINT_RENAME(ubidi_orderParagraphsLTR)
#define ubidi_reorderLogical U_ICU_ENTRY_POINT_RENAME(ubidi_reorderLogical)
#define ubidi_reorderVisual U_ICU_ENTRY_POINT_RENAME(ubidi_reorderVisual)
#define ubidi_setClassCallback U_ICU_ENTRY_POINT_RENAME(ubidi_setClassCallback)
#define ubidi_setInverse U_ICU_ENTRY_POINT_RENAME(ubidi_setInverse)
#define ubidi_setLine U_ICU_ENTRY_POINT_RENAME(ubidi_setLine)
#define ubidi_setPara U_ICU_ENTRY_POINT_RENAME(ubidi_setPara)
#define ubidi_setReorderingMode U_ICU_ENTRY_POINT_RENAME(ubidi_setReorderingMode)
#define ubidi_setReorderingOptions U_ICU_ENTRY_POINT_RENAME(ubidi_setReorderingOptions)
#define ubidi_writeReordered U_ICU_ENTRY_POINT_RENAME(ubidi_writeReordered)
#define ubidi_writeReverse U_ICU_ENTRY_POINT_RENAME(ubidi_writeReverse)
#define ublock_getCode U_ICU_ENTRY_POINT_RENAME(ublock_getCode)
#define ubrk_close U_ICU_ENTRY_POINT_RENAME(ubrk_close)
#define ubrk_countAvailable U_ICU_ENTRY_POINT_RENAME(ubrk_countAvailable)
#define ubrk_current U_ICU_ENTRY_POINT_RENAME(ubrk_current)
#define ubrk_first U_ICU_ENTRY_POINT_RENAME(ubrk_first)
#define ubrk_following U_ICU_ENTRY_POINT_RENAME(ubrk_following)
#define ubrk_getAvailable U_ICU_ENTRY_POINT_RENAME(ubrk_getAvailable)
#define ubrk_getLocaleByType U_ICU_ENTRY_POINT_RENAME(ubrk_getLocaleByType)
#define ubrk_getRuleStatus U_ICU_ENTRY_POINT_RENAME(ubrk_getRuleStatus)
#define ubrk_getRuleStatusVec U_ICU_ENTRY_POINT_RENAME(ubrk_getRuleStatusVec)
#define ubrk_isBoundary U_ICU_ENTRY_POINT_RENAME(ubrk_isBoundary)
#define ubrk_last U_ICU_ENTRY_POINT_RENAME(ubrk_last)
#define ubrk_next U_ICU_ENTRY_POINT_RENAME(ubrk_next)
#define ubrk_open U_ICU_ENTRY_POINT_RENAME(ubrk_open)
#define ubrk_openRules U_ICU_ENTRY_POINT_RENAME(ubrk_openRules)
#define ubrk_preceding U_ICU_ENTRY_POINT_RENAME(ubrk_preceding)
#define ubrk_previous U_ICU_ENTRY_POINT_RENAME(ubrk_previous)
#define ubrk_safeClone U_ICU_ENTRY_POINT_RENAME(ubrk_safeClone)
#define ubrk_setText U_ICU_ENTRY_POINT_RENAME(ubrk_setText)
#define ubrk_setUText U_ICU_ENTRY_POINT_RENAME(ubrk_setUText)
#define ubrk_swap U_ICU_ENTRY_POINT_RENAME(ubrk_swap)
#define ucal_add U_ICU_ENTRY_POINT_RENAME(ucal_add)
#define ucal_clear U_ICU_ENTRY_POINT_RENAME(ucal_clear)
#define ucal_clearField U_ICU_ENTRY_POINT_RENAME(ucal_clearField)
#define ucal_clone U_ICU_ENTRY_POINT_RENAME(ucal_clone)
#define ucal_close U_ICU_ENTRY_POINT_RENAME(ucal_close)
#define ucal_countAvailable U_ICU_ENTRY_POINT_RENAME(ucal_countAvailable)
#define ucal_equivalentTo U_ICU_ENTRY_POINT_RENAME(ucal_equivalentTo)
#define ucal_get U_ICU_ENTRY_POINT_RENAME(ucal_get)
#define ucal_getAttribute U_ICU_ENTRY_POINT_RENAME(ucal_getAttribute)
#define ucal_getAvailable U_ICU_ENTRY_POINT_RENAME(ucal_getAvailable)
#define ucal_getCanonicalTimeZoneID U_ICU_ENTRY_POINT_RENAME(ucal_getCanonicalTimeZoneID)
#define ucal_getDSTSavings U_ICU_ENTRY_POINT_RENAME(ucal_getDSTSavings)
#define ucal_getDayOfWeekType U_ICU_ENTRY_POINT_RENAME(ucal_getDayOfWeekType)
#define ucal_getDefaultTimeZone U_ICU_ENTRY_POINT_RENAME(ucal_getDefaultTimeZone)
#define ucal_getGregorianChange U_ICU_ENTRY_POINT_RENAME(ucal_getGregorianChange)
#define ucal_getKeywordValuesForLocale U_ICU_ENTRY_POINT_RENAME(ucal_getKeywordValuesForLocale)
#define ucal_getLimit U_ICU_ENTRY_POINT_RENAME(ucal_getLimit)
#define ucal_getLocaleByType U_ICU_ENTRY_POINT_RENAME(ucal_getLocaleByType)
#define ucal_getMillis U_ICU_ENTRY_POINT_RENAME(ucal_getMillis)
#define ucal_getNow U_ICU_ENTRY_POINT_RENAME(ucal_getNow)
#define ucal_getTZDataVersion U_ICU_ENTRY_POINT_RENAME(ucal_getTZDataVersion)
#define ucal_getTimeZoneDisplayName U_ICU_ENTRY_POINT_RENAME(ucal_getTimeZoneDisplayName)
#define ucal_getType U_ICU_ENTRY_POINT_RENAME(ucal_getType)
#define ucal_getWeekendTransition U_ICU_ENTRY_POINT_RENAME(ucal_getWeekendTransition)
#define ucal_inDaylightTime U_ICU_ENTRY_POINT_RENAME(ucal_inDaylightTime)
#define ucal_isSet U_ICU_ENTRY_POINT_RENAME(ucal_isSet)
#define ucal_isWeekend U_ICU_ENTRY_POINT_RENAME(ucal_isWeekend)
#define ucal_open U_ICU_ENTRY_POINT_RENAME(ucal_open)
#define ucal_openCountryTimeZones U_ICU_ENTRY_POINT_RENAME(ucal_openCountryTimeZones)
#define ucal_openTimeZones U_ICU_ENTRY_POINT_RENAME(ucal_openTimeZones)
#define ucal_roll U_ICU_ENTRY_POINT_RENAME(ucal_roll)
#define ucal_set U_ICU_ENTRY_POINT_RENAME(ucal_set)
#define ucal_setAttribute U_ICU_ENTRY_POINT_RENAME(ucal_setAttribute)
#define ucal_setDate U_ICU_ENTRY_POINT_RENAME(ucal_setDate)
#define ucal_setDateTime U_ICU_ENTRY_POINT_RENAME(ucal_setDateTime)
#define ucal_setDefaultTimeZone U_ICU_ENTRY_POINT_RENAME(ucal_setDefaultTimeZone)
#define ucal_setGregorianChange U_ICU_ENTRY_POINT_RENAME(ucal_setGregorianChange)
#define ucal_setMillis U_ICU_ENTRY_POINT_RENAME(ucal_setMillis)
#define ucal_setTimeZone U_ICU_ENTRY_POINT_RENAME(ucal_setTimeZone)
#define ucase_addCaseClosure U_ICU_ENTRY_POINT_RENAME(ucase_addCaseClosure)
#define ucase_addPropertyStarts U_ICU_ENTRY_POINT_RENAME(ucase_addPropertyStarts)
#define ucase_addStringCaseClosure U_ICU_ENTRY_POINT_RENAME(ucase_addStringCaseClosure)
#define ucase_close U_ICU_ENTRY_POINT_RENAME(ucase_close)
#define ucase_fold U_ICU_ENTRY_POINT_RENAME(ucase_fold)
#define ucase_getCaseLocale U_ICU_ENTRY_POINT_RENAME(ucase_getCaseLocale)
#define ucase_getSingleton U_ICU_ENTRY_POINT_RENAME(ucase_getSingleton)
#define ucase_getType U_ICU_ENTRY_POINT_RENAME(ucase_getType)
#define ucase_getTypeOrIgnorable U_ICU_ENTRY_POINT_RENAME(ucase_getTypeOrIgnorable)
#define ucase_hasBinaryProperty U_ICU_ENTRY_POINT_RENAME(ucase_hasBinaryProperty)
#define ucase_isCaseSensitive U_ICU_ENTRY_POINT_RENAME(ucase_isCaseSensitive)
#define ucase_isSoftDotted U_ICU_ENTRY_POINT_RENAME(ucase_isSoftDotted)
#define ucase_toFullFolding U_ICU_ENTRY_POINT_RENAME(ucase_toFullFolding)
#define ucase_toFullLower U_ICU_ENTRY_POINT_RENAME(ucase_toFullLower)
#define ucase_toFullTitle U_ICU_ENTRY_POINT_RENAME(ucase_toFullTitle)
#define ucase_toFullUpper U_ICU_ENTRY_POINT_RENAME(ucase_toFullUpper)
#define ucase_tolower U_ICU_ENTRY_POINT_RENAME(ucase_tolower)
#define ucase_totitle U_ICU_ENTRY_POINT_RENAME(ucase_totitle)
#define ucase_toupper U_ICU_ENTRY_POINT_RENAME(ucase_toupper)
#define ucasemap_close U_ICU_ENTRY_POINT_RENAME(ucasemap_close)
#define ucasemap_getBreakIterator U_ICU_ENTRY_POINT_RENAME(ucasemap_getBreakIterator)
#define ucasemap_getLocale U_ICU_ENTRY_POINT_RENAME(ucasemap_getLocale)
#define ucasemap_getOptions U_ICU_ENTRY_POINT_RENAME(ucasemap_getOptions)
#define ucasemap_open U_ICU_ENTRY_POINT_RENAME(ucasemap_open)
#define ucasemap_setBreakIterator U_ICU_ENTRY_POINT_RENAME(ucasemap_setBreakIterator)
#define ucasemap_setLocale U_ICU_ENTRY_POINT_RENAME(ucasemap_setLocale)
#define ucasemap_setOptions U_ICU_ENTRY_POINT_RENAME(ucasemap_setOptions)
#define ucasemap_toTitle U_ICU_ENTRY_POINT_RENAME(ucasemap_toTitle)
#define ucasemap_utf8FoldCase U_ICU_ENTRY_POINT_RENAME(ucasemap_utf8FoldCase)
#define ucasemap_utf8ToLower U_ICU_ENTRY_POINT_RENAME(ucasemap_utf8ToLower)
#define ucasemap_utf8ToTitle U_ICU_ENTRY_POINT_RENAME(ucasemap_utf8ToTitle)
#define ucasemap_utf8ToUpper U_ICU_ENTRY_POINT_RENAME(ucasemap_utf8ToUpper)
#define ucd_close U_ICU_ENTRY_POINT_RENAME(ucd_close)
#define ucd_flushCache U_ICU_ENTRY_POINT_RENAME(ucd_flushCache)
#define ucd_freeCache U_ICU_ENTRY_POINT_RENAME(ucd_freeCache)
#define ucd_getCollator U_ICU_ENTRY_POINT_RENAME(ucd_getCollator)
#define ucd_open U_ICU_ENTRY_POINT_RENAME(ucd_open)
#define uchar_addPropertyStarts U_ICU_ENTRY_POINT_RENAME(uchar_addPropertyStarts)
#define uchar_swapNames U_ICU_ENTRY_POINT_RENAME(uchar_swapNames)
#define ucln_cleanupOne U_ICU_ENTRY_POINT_RENAME(ucln_cleanupOne)
#define ucln_common_registerCleanup U_ICU_ENTRY_POINT_RENAME(ucln_common_registerCleanup)
#define ucln_i18n_registerCleanup U_ICU_ENTRY_POINT_RENAME(ucln_i18n_registerCleanup)
#define ucln_io_registerCleanup U_ICU_ENTRY_POINT_RENAME(ucln_io_registerCleanup)
#define ucln_lib_cleanup U_ICU_ENTRY_POINT_RENAME(ucln_lib_cleanup)
#define ucln_registerCleanup U_ICU_ENTRY_POINT_RENAME(ucln_registerCleanup)
#define ucnv_MBCSFromUChar32 U_ICU_ENTRY_POINT_RENAME(ucnv_MBCSFromUChar32)
#define ucnv_MBCSFromUnicodeWithOffsets U_ICU_ENTRY_POINT_RENAME(ucnv_MBCSFromUnicodeWithOffsets)
#define ucnv_MBCSGetFilteredUnicodeSetForUnicode U_ICU_ENTRY_POINT_RENAME(ucnv_MBCSGetFilteredUnicodeSetForUnicode)
#define ucnv_MBCSGetType U_ICU_ENTRY_POINT_RENAME(ucnv_MBCSGetType)
#define ucnv_MBCSGetUnicodeSetForUnicode U_ICU_ENTRY_POINT_RENAME(ucnv_MBCSGetUnicodeSetForUnicode)
#define ucnv_MBCSIsLeadByte U_ICU_ENTRY_POINT_RENAME(ucnv_MBCSIsLeadByte)
#define ucnv_MBCSSimpleGetNextUChar U_ICU_ENTRY_POINT_RENAME(ucnv_MBCSSimpleGetNextUChar)
#define ucnv_MBCSToUnicodeWithOffsets U_ICU_ENTRY_POINT_RENAME(ucnv_MBCSToUnicodeWithOffsets)
#define ucnv_bld_countAvailableConverters U_ICU_ENTRY_POINT_RENAME(ucnv_bld_countAvailableConverters)
#define ucnv_bld_getAvailableConverter U_ICU_ENTRY_POINT_RENAME(ucnv_bld_getAvailableConverter)
#define ucnv_canCreateConverter U_ICU_ENTRY_POINT_RENAME(ucnv_canCreateConverter)
#define ucnv_cbFromUWriteBytes U_ICU_ENTRY_POINT_RENAME(ucnv_cbFromUWriteBytes)
#define ucnv_cbFromUWriteSub U_ICU_ENTRY_POINT_RENAME(ucnv_cbFromUWriteSub)
#define ucnv_cbFromUWriteUChars U_ICU_ENTRY_POINT_RENAME(ucnv_cbFromUWriteUChars)
#define ucnv_cbToUWriteSub U_ICU_ENTRY_POINT_RENAME(ucnv_cbToUWriteSub)
#define ucnv_cbToUWriteUChars U_ICU_ENTRY_POINT_RENAME(ucnv_cbToUWriteUChars)
#define ucnv_close U_ICU_ENTRY_POINT_RENAME(ucnv_close)
#define ucnv_compareNames U_ICU_ENTRY_POINT_RENAME(ucnv_compareNames)
#define ucnv_convert U_ICU_ENTRY_POINT_RENAME(ucnv_convert)
#define ucnv_convertEx U_ICU_ENTRY_POINT_RENAME(ucnv_convertEx)
#define ucnv_countAliases U_ICU_ENTRY_POINT_RENAME(ucnv_countAliases)
#define ucnv_countAvailable U_ICU_ENTRY_POINT_RENAME(ucnv_countAvailable)
#define ucnv_countStandards U_ICU_ENTRY_POINT_RENAME(ucnv_countStandards)
#define ucnv_createAlgorithmicConverter U_ICU_ENTRY_POINT_RENAME(ucnv_createAlgorithmicConverter)
#define ucnv_createConverter U_ICU_ENTRY_POINT_RENAME(ucnv_createConverter)
#define ucnv_createConverterFromPackage U_ICU_ENTRY_POINT_RENAME(ucnv_createConverterFromPackage)
#define ucnv_createConverterFromSharedData U_ICU_ENTRY_POINT_RENAME(ucnv_createConverterFromSharedData)
#define ucnv_detectUnicodeSignature U_ICU_ENTRY_POINT_RENAME(ucnv_detectUnicodeSignature)
#define ucnv_extContinueMatchFromU U_ICU_ENTRY_POINT_RENAME(ucnv_extContinueMatchFromU)
#define ucnv_extContinueMatchToU U_ICU_ENTRY_POINT_RENAME(ucnv_extContinueMatchToU)
#define ucnv_extGetUnicodeSet U_ICU_ENTRY_POINT_RENAME(ucnv_extGetUnicodeSet)
#define ucnv_extInitialMatchFromU U_ICU_ENTRY_POINT_RENAME(ucnv_extInitialMatchFromU)
#define ucnv_extInitialMatchToU U_ICU_ENTRY_POINT_RENAME(ucnv_extInitialMatchToU)
#define ucnv_extSimpleMatchFromU U_ICU_ENTRY_POINT_RENAME(ucnv_extSimpleMatchFromU)
#define ucnv_extSimpleMatchToU U_ICU_ENTRY_POINT_RENAME(ucnv_extSimpleMatchToU)
#define ucnv_fixFileSeparator U_ICU_ENTRY_POINT_RENAME(ucnv_fixFileSeparator)
#define ucnv_flushCache U_ICU_ENTRY_POINT_RENAME(ucnv_flushCache)
#define ucnv_fromAlgorithmic U_ICU_ENTRY_POINT_RENAME(ucnv_fromAlgorithmic)
#define ucnv_fromUChars U_ICU_ENTRY_POINT_RENAME(ucnv_fromUChars)
#define ucnv_fromUCountPending U_ICU_ENTRY_POINT_RENAME(ucnv_fromUCountPending)
#define ucnv_fromUWriteBytes U_ICU_ENTRY_POINT_RENAME(ucnv_fromUWriteBytes)
#define ucnv_fromUnicode U_ICU_ENTRY_POINT_RENAME(ucnv_fromUnicode)
#define ucnv_fromUnicode_UTF8 U_ICU_ENTRY_POINT_RENAME(ucnv_fromUnicode_UTF8)
#define ucnv_fromUnicode_UTF8_OFFSETS_LOGIC U_ICU_ENTRY_POINT_RENAME(ucnv_fromUnicode_UTF8_OFFSETS_LOGIC)
#define ucnv_getAlias U_ICU_ENTRY_POINT_RENAME(ucnv_getAlias)
#define ucnv_getAliases U_ICU_ENTRY_POINT_RENAME(ucnv_getAliases)
#define ucnv_getAvailableName U_ICU_ENTRY_POINT_RENAME(ucnv_getAvailableName)
#define ucnv_getCCSID U_ICU_ENTRY_POINT_RENAME(ucnv_getCCSID)
#define ucnv_getCanonicalName U_ICU_ENTRY_POINT_RENAME(ucnv_getCanonicalName)
#define ucnv_getCompleteUnicodeSet U_ICU_ENTRY_POINT_RENAME(ucnv_getCompleteUnicodeSet)
#define ucnv_getDefaultName U_ICU_ENTRY_POINT_RENAME(ucnv_getDefaultName)
#define ucnv_getDisplayName U_ICU_ENTRY_POINT_RENAME(ucnv_getDisplayName)
#define ucnv_getFromUCallBack U_ICU_ENTRY_POINT_RENAME(ucnv_getFromUCallBack)
#define ucnv_getInvalidChars U_ICU_ENTRY_POINT_RENAME(ucnv_getInvalidChars)
#define ucnv_getInvalidUChars U_ICU_ENTRY_POINT_RENAME(ucnv_getInvalidUChars)
#define ucnv_getMaxCharSize U_ICU_ENTRY_POINT_RENAME(ucnv_getMaxCharSize)
#define ucnv_getMinCharSize U_ICU_ENTRY_POINT_RENAME(ucnv_getMinCharSize)
#define ucnv_getName U_ICU_ENTRY_POINT_RENAME(ucnv_getName)
#define ucnv_getNextUChar U_ICU_ENTRY_POINT_RENAME(ucnv_getNextUChar)
#define ucnv_getNonSurrogateUnicodeSet U_ICU_ENTRY_POINT_RENAME(ucnv_getNonSurrogateUnicodeSet)
#define ucnv_getPlatform U_ICU_ENTRY_POINT_RENAME(ucnv_getPlatform)
#define ucnv_getStandard U_ICU_ENTRY_POINT_RENAME(ucnv_getStandard)
#define ucnv_getStandardName U_ICU_ENTRY_POINT_RENAME(ucnv_getStandardName)
#define ucnv_getStarters U_ICU_ENTRY_POINT_RENAME(ucnv_getStarters)
#define ucnv_getSubstChars U_ICU_ENTRY_POINT_RENAME(ucnv_getSubstChars)
#define ucnv_getToUCallBack U_ICU_ENTRY_POINT_RENAME(ucnv_getToUCallBack)
#define ucnv_getType U_ICU_ENTRY_POINT_RENAME(ucnv_getType)
#define ucnv_getUnicodeSet U_ICU_ENTRY_POINT_RENAME(ucnv_getUnicodeSet)
#define ucnv_incrementRefCount U_ICU_ENTRY_POINT_RENAME(ucnv_incrementRefCount)
#define ucnv_io_countKnownConverters U_ICU_ENTRY_POINT_RENAME(ucnv_io_countKnownConverters)
#define ucnv_io_getConverterName U_ICU_ENTRY_POINT_RENAME(ucnv_io_getConverterName)
#define ucnv_io_stripASCIIForCompare U_ICU_ENTRY_POINT_RENAME(ucnv_io_stripASCIIForCompare)
#define ucnv_io_stripEBCDICForCompare U_ICU_ENTRY_POINT_RENAME(ucnv_io_stripEBCDICForCompare)
#define ucnv_isAmbiguous U_ICU_ENTRY_POINT_RENAME(ucnv_isAmbiguous)
#define ucnv_load U_ICU_ENTRY_POINT_RENAME(ucnv_load)
#define ucnv_loadSharedData U_ICU_ENTRY_POINT_RENAME(ucnv_loadSharedData)
#define ucnv_open U_ICU_ENTRY_POINT_RENAME(ucnv_open)
#define ucnv_openAllNames U_ICU_ENTRY_POINT_RENAME(ucnv_openAllNames)
#define ucnv_openCCSID U_ICU_ENTRY_POINT_RENAME(ucnv_openCCSID)
#define ucnv_openPackage U_ICU_ENTRY_POINT_RENAME(ucnv_openPackage)
#define ucnv_openStandardNames U_ICU_ENTRY_POINT_RENAME(ucnv_openStandardNames)
#define ucnv_openU U_ICU_ENTRY_POINT_RENAME(ucnv_openU)
#define ucnv_reset U_ICU_ENTRY_POINT_RENAME(ucnv_reset)
#define ucnv_resetFromUnicode U_ICU_ENTRY_POINT_RENAME(ucnv_resetFromUnicode)
#define ucnv_resetToUnicode U_ICU_ENTRY_POINT_RENAME(ucnv_resetToUnicode)
#define ucnv_safeClone U_ICU_ENTRY_POINT_RENAME(ucnv_safeClone)
#define ucnv_setDefaultName U_ICU_ENTRY_POINT_RENAME(ucnv_setDefaultName)
#define ucnv_setFallback U_ICU_ENTRY_POINT_RENAME(ucnv_setFallback)
#define ucnv_setFromUCallBack U_ICU_ENTRY_POINT_RENAME(ucnv_setFromUCallBack)
#define ucnv_setSubstChars U_ICU_ENTRY_POINT_RENAME(ucnv_setSubstChars)
#define ucnv_setSubstString U_ICU_ENTRY_POINT_RENAME(ucnv_setSubstString)
#define ucnv_setToUCallBack U_ICU_ENTRY_POINT_RENAME(ucnv_setToUCallBack)
#define ucnv_swap U_ICU_ENTRY_POINT_RENAME(ucnv_swap)
#define ucnv_swapAliases U_ICU_ENTRY_POINT_RENAME(ucnv_swapAliases)
#define ucnv_toAlgorithmic U_ICU_ENTRY_POINT_RENAME(ucnv_toAlgorithmic)
#define ucnv_toUChars U_ICU_ENTRY_POINT_RENAME(ucnv_toUChars)
#define ucnv_toUCountPending U_ICU_ENTRY_POINT_RENAME(ucnv_toUCountPending)
#define ucnv_toUWriteCodePoint U_ICU_ENTRY_POINT_RENAME(ucnv_toUWriteCodePoint)
#define ucnv_toUWriteUChars U_ICU_ENTRY_POINT_RENAME(ucnv_toUWriteUChars)
#define ucnv_toUnicode U_ICU_ENTRY_POINT_RENAME(ucnv_toUnicode)
#define ucnv_unload U_ICU_ENTRY_POINT_RENAME(ucnv_unload)
#define ucnv_unloadSharedDataIfReady U_ICU_ENTRY_POINT_RENAME(ucnv_unloadSharedDataIfReady)
#define ucnv_usesFallback U_ICU_ENTRY_POINT_RENAME(ucnv_usesFallback)
#define ucnvsel_close U_ICU_ENTRY_POINT_RENAME(ucnvsel_close)
#define ucnvsel_open U_ICU_ENTRY_POINT_RENAME(ucnvsel_open)
#define ucnvsel_openFromSerialized U_ICU_ENTRY_POINT_RENAME(ucnvsel_openFromSerialized)
#define ucnvsel_selectForString U_ICU_ENTRY_POINT_RENAME(ucnvsel_selectForString)
#define ucnvsel_selectForUTF8 U_ICU_ENTRY_POINT_RENAME(ucnvsel_selectForUTF8)
#define ucnvsel_serialize U_ICU_ENTRY_POINT_RENAME(ucnvsel_serialize)
#define ucol_allocWeights U_ICU_ENTRY_POINT_RENAME(ucol_allocWeights)
#define ucol_assembleTailoringTable U_ICU_ENTRY_POINT_RENAME(ucol_assembleTailoringTable)
#define ucol_calcSortKey U_ICU_ENTRY_POINT_RENAME(ucol_calcSortKey)
#define ucol_calcSortKeySimpleTertiary U_ICU_ENTRY_POINT_RENAME(ucol_calcSortKeySimpleTertiary)
#define ucol_cloneBinary U_ICU_ENTRY_POINT_RENAME(ucol_cloneBinary)
#define ucol_cloneRuleData U_ICU_ENTRY_POINT_RENAME(ucol_cloneRuleData)
#define ucol_close U_ICU_ENTRY_POINT_RENAME(ucol_close)
#define ucol_closeElements U_ICU_ENTRY_POINT_RENAME(ucol_closeElements)
#define ucol_countAvailable U_ICU_ENTRY_POINT_RENAME(ucol_countAvailable)
#define ucol_createElements U_ICU_ENTRY_POINT_RENAME(ucol_createElements)
#define ucol_doCE U_ICU_ENTRY_POINT_RENAME(ucol_doCE)
#define ucol_equal U_ICU_ENTRY_POINT_RENAME(ucol_equal)
#define ucol_equals U_ICU_ENTRY_POINT_RENAME(ucol_equals)
#define ucol_forceHanImplicit U_ICU_ENTRY_POINT_RENAME(ucol_forceHanImplicit)
#define ucol_forgetUCA U_ICU_ENTRY_POINT_RENAME(ucol_forgetUCA)
#define ucol_freeOffsetBuffer U_ICU_ENTRY_POINT_RENAME(ucol_freeOffsetBuffer)
#define ucol_getAttribute U_ICU_ENTRY_POINT_RENAME(ucol_getAttribute)
#define ucol_getAttributeOrDefault U_ICU_ENTRY_POINT_RENAME(ucol_getAttributeOrDefault)
#define ucol_getAvailable U_ICU_ENTRY_POINT_RENAME(ucol_getAvailable)
#define ucol_getBound U_ICU_ENTRY_POINT_RENAME(ucol_getBound)
#define ucol_getCEStrengthDifference U_ICU_ENTRY_POINT_RENAME(ucol_getCEStrengthDifference)
#define ucol_getContractions U_ICU_ENTRY_POINT_RENAME(ucol_getContractions)
#define ucol_getContractionsAndExpansions U_ICU_ENTRY_POINT_RENAME(ucol_getContractionsAndExpansions)
#define ucol_getDisplayName U_ICU_ENTRY_POINT_RENAME(ucol_getDisplayName)
#define ucol_getFirstCE U_ICU_ENTRY_POINT_RENAME(ucol_getFirstCE)
#define ucol_getFunctionalEquivalent U_ICU_ENTRY_POINT_RENAME(ucol_getFunctionalEquivalent)
#define ucol_getKeywordValues U_ICU_ENTRY_POINT_RENAME(ucol_getKeywordValues)
#define ucol_getKeywordValuesForLocale U_ICU_ENTRY_POINT_RENAME(ucol_getKeywordValuesForLocale)
#define ucol_getKeywords U_ICU_ENTRY_POINT_RENAME(ucol_getKeywords)
#define ucol_getLocale U_ICU_ENTRY_POINT_RENAME(ucol_getLocale)
#define ucol_getLocaleByType U_ICU_ENTRY_POINT_RENAME(ucol_getLocaleByType)
#define ucol_getMaxExpansion U_ICU_ENTRY_POINT_RENAME(ucol_getMaxExpansion)
#define ucol_getNextCE U_ICU_ENTRY_POINT_RENAME(ucol_getNextCE)
#define ucol_getOffset U_ICU_ENTRY_POINT_RENAME(ucol_getOffset)
#define ucol_getPrevCE U_ICU_ENTRY_POINT_RENAME(ucol_getPrevCE)
#define ucol_getRules U_ICU_ENTRY_POINT_RENAME(ucol_getRules)
#define ucol_getRulesEx U_ICU_ENTRY_POINT_RENAME(ucol_getRulesEx)
#define ucol_getShortDefinitionString U_ICU_ENTRY_POINT_RENAME(ucol_getShortDefinitionString)
#define ucol_getSortKey U_ICU_ENTRY_POINT_RENAME(ucol_getSortKey)
#define ucol_getSortKeySize U_ICU_ENTRY_POINT_RENAME(ucol_getSortKeySize)
#define ucol_getSortKeyWithAllocation U_ICU_ENTRY_POINT_RENAME(ucol_getSortKeyWithAllocation)
#define ucol_getStrength U_ICU_ENTRY_POINT_RENAME(ucol_getStrength)
#define ucol_getTailoredSet U_ICU_ENTRY_POINT_RENAME(ucol_getTailoredSet)
#define ucol_getUCAVersion U_ICU_ENTRY_POINT_RENAME(ucol_getUCAVersion)
#define ucol_getUnsafeSet U_ICU_ENTRY_POINT_RENAME(ucol_getUnsafeSet)
#define ucol_getVariableTop U_ICU_ENTRY_POINT_RENAME(ucol_getVariableTop)
#define ucol_getVersion U_ICU_ENTRY_POINT_RENAME(ucol_getVersion)
#define ucol_greater U_ICU_ENTRY_POINT_RENAME(ucol_greater)
#define ucol_greaterOrEqual U_ICU_ENTRY_POINT_RENAME(ucol_greaterOrEqual)
#define ucol_initBuffers U_ICU_ENTRY_POINT_RENAME(ucol_initBuffers)
#define ucol_initCollator U_ICU_ENTRY_POINT_RENAME(ucol_initCollator)
#define ucol_initInverseUCA U_ICU_ENTRY_POINT_RENAME(ucol_initInverseUCA)
#define ucol_initUCA U_ICU_ENTRY_POINT_RENAME(ucol_initUCA)
#define ucol_inv_getNextCE U_ICU_ENTRY_POINT_RENAME(ucol_inv_getNextCE)
#define ucol_inv_getPrevCE U_ICU_ENTRY_POINT_RENAME(ucol_inv_getPrevCE)
#define ucol_isTailored U_ICU_ENTRY_POINT_RENAME(ucol_isTailored)
#define ucol_keyHashCode U_ICU_ENTRY_POINT_RENAME(ucol_keyHashCode)
#define ucol_looksLikeCollationBinary U_ICU_ENTRY_POINT_RENAME(ucol_looksLikeCollationBinary)
#define ucol_mergeSortkeys U_ICU_ENTRY_POINT_RENAME(ucol_mergeSortkeys)
#define ucol_next U_ICU_ENTRY_POINT_RENAME(ucol_next)
#define ucol_nextProcessed U_ICU_ENTRY_POINT_RENAME(ucol_nextProcessed)
#define ucol_nextSortKeyPart U_ICU_ENTRY_POINT_RENAME(ucol_nextSortKeyPart)
#define ucol_nextWeight U_ICU_ENTRY_POINT_RENAME(ucol_nextWeight)
#define ucol_normalizeShortDefinitionString U_ICU_ENTRY_POINT_RENAME(ucol_normalizeShortDefinitionString)
#define ucol_open U_ICU_ENTRY_POINT_RENAME(ucol_open)
#define ucol_openAvailableLocales U_ICU_ENTRY_POINT_RENAME(ucol_openAvailableLocales)
#define ucol_openBinary U_ICU_ENTRY_POINT_RENAME(ucol_openBinary)
#define ucol_openElements U_ICU_ENTRY_POINT_RENAME(ucol_openElements)
#define ucol_openFromShortString U_ICU_ENTRY_POINT_RENAME(ucol_openFromShortString)
#define ucol_openRules U_ICU_ENTRY_POINT_RENAME(ucol_openRules)
#define ucol_open_internal U_ICU_ENTRY_POINT_RENAME(ucol_open_internal)
#define ucol_prepareShortStringOpen U_ICU_ENTRY_POINT_RENAME(ucol_prepareShortStringOpen)
#define ucol_previous U_ICU_ENTRY_POINT_RENAME(ucol_previous)
#define ucol_previousProcessed U_ICU_ENTRY_POINT_RENAME(ucol_previousProcessed)
#define ucol_primaryOrder U_ICU_ENTRY_POINT_RENAME(ucol_primaryOrder)
#define ucol_prv_getSpecialCE U_ICU_ENTRY_POINT_RENAME(ucol_prv_getSpecialCE)
#define ucol_prv_getSpecialPrevCE U_ICU_ENTRY_POINT_RENAME(ucol_prv_getSpecialPrevCE)
#define ucol_reset U_ICU_ENTRY_POINT_RENAME(ucol_reset)
#define ucol_restoreVariableTop U_ICU_ENTRY_POINT_RENAME(ucol_restoreVariableTop)
#define ucol_safeClone U_ICU_ENTRY_POINT_RENAME(ucol_safeClone)
#define ucol_secondaryOrder U_ICU_ENTRY_POINT_RENAME(ucol_secondaryOrder)
#define ucol_setAttribute U_ICU_ENTRY_POINT_RENAME(ucol_setAttribute)
#define ucol_setOffset U_ICU_ENTRY_POINT_RENAME(ucol_setOffset)
#define ucol_setOptionsFromHeader U_ICU_ENTRY_POINT_RENAME(ucol_setOptionsFromHeader)
#define ucol_setReqValidLocales U_ICU_ENTRY_POINT_RENAME(ucol_setReqValidLocales)
#define ucol_setStrength U_ICU_ENTRY_POINT_RENAME(ucol_setStrength)
#define ucol_setText U_ICU_ENTRY_POINT_RENAME(ucol_setText)
#define ucol_setVariableTop U_ICU_ENTRY_POINT_RENAME(ucol_setVariableTop)
#define ucol_strcoll U_ICU_ENTRY_POINT_RENAME(ucol_strcoll)
#define ucol_strcollIter U_ICU_ENTRY_POINT_RENAME(ucol_strcollIter)
#define ucol_swap U_ICU_ENTRY_POINT_RENAME(ucol_swap)
#define ucol_swapBinary U_ICU_ENTRY_POINT_RENAME(ucol_swapBinary)
#define ucol_swapInverseUCA U_ICU_ENTRY_POINT_RENAME(ucol_swapInverseUCA)
#define ucol_tertiaryOrder U_ICU_ENTRY_POINT_RENAME(ucol_tertiaryOrder)
#define ucol_tok_assembleTokenList U_ICU_ENTRY_POINT_RENAME(ucol_tok_assembleTokenList)
#define ucol_tok_closeTokenList U_ICU_ENTRY_POINT_RENAME(ucol_tok_closeTokenList)
#define ucol_tok_getNextArgument U_ICU_ENTRY_POINT_RENAME(ucol_tok_getNextArgument)
#define ucol_tok_initTokenList U_ICU_ENTRY_POINT_RENAME(ucol_tok_initTokenList)
#define ucol_tok_parseNextToken U_ICU_ENTRY_POINT_RENAME(ucol_tok_parseNextToken)
#define ucol_updateInternalState U_ICU_ENTRY_POINT_RENAME(ucol_updateInternalState)
#define ucsdet_close U_ICU_ENTRY_POINT_RENAME(ucsdet_close)
#define ucsdet_detect U_ICU_ENTRY_POINT_RENAME(ucsdet_detect)
#define ucsdet_detectAll U_ICU_ENTRY_POINT_RENAME(ucsdet_detectAll)
#define ucsdet_enableInputFilter U_ICU_ENTRY_POINT_RENAME(ucsdet_enableInputFilter)
#define ucsdet_getAllDetectableCharsets U_ICU_ENTRY_POINT_RENAME(ucsdet_getAllDetectableCharsets)
#define ucsdet_getConfidence U_ICU_ENTRY_POINT_RENAME(ucsdet_getConfidence)
#define ucsdet_getLanguage U_ICU_ENTRY_POINT_RENAME(ucsdet_getLanguage)
#define ucsdet_getName U_ICU_ENTRY_POINT_RENAME(ucsdet_getName)
#define ucsdet_getUChars U_ICU_ENTRY_POINT_RENAME(ucsdet_getUChars)
#define ucsdet_isInputFilterEnabled U_ICU_ENTRY_POINT_RENAME(ucsdet_isInputFilterEnabled)
#define ucsdet_open U_ICU_ENTRY_POINT_RENAME(ucsdet_open)
#define ucsdet_setDeclaredEncoding U_ICU_ENTRY_POINT_RENAME(ucsdet_setDeclaredEncoding)
#define ucsdet_setText U_ICU_ENTRY_POINT_RENAME(ucsdet_setText)
#define ucurr_countCurrencies U_ICU_ENTRY_POINT_RENAME(ucurr_countCurrencies)
#define ucurr_forLocale U_ICU_ENTRY_POINT_RENAME(ucurr_forLocale)
#define ucurr_forLocaleAndDate U_ICU_ENTRY_POINT_RENAME(ucurr_forLocaleAndDate)
#define ucurr_getDefaultFractionDigits U_ICU_ENTRY_POINT_RENAME(ucurr_getDefaultFractionDigits)
#define ucurr_getKeywordValuesForLocale U_ICU_ENTRY_POINT_RENAME(ucurr_getKeywordValuesForLocale)
#define ucurr_getName U_ICU_ENTRY_POINT_RENAME(ucurr_getName)
#define ucurr_getPluralName U_ICU_ENTRY_POINT_RENAME(ucurr_getPluralName)
#define ucurr_getRoundingIncrement U_ICU_ENTRY_POINT_RENAME(ucurr_getRoundingIncrement)
#define ucurr_openISOCurrencies U_ICU_ENTRY_POINT_RENAME(ucurr_openISOCurrencies)
#define ucurr_register U_ICU_ENTRY_POINT_RENAME(ucurr_register)
#define ucurr_unregister U_ICU_ENTRY_POINT_RENAME(ucurr_unregister)
#define udat_applyPattern U_ICU_ENTRY_POINT_RENAME(udat_applyPattern)
#define udat_applyPatternRelative U_ICU_ENTRY_POINT_RENAME(udat_applyPatternRelative)
#define udat_clone U_ICU_ENTRY_POINT_RENAME(udat_clone)
#define udat_close U_ICU_ENTRY_POINT_RENAME(udat_close)
#define udat_countAvailable U_ICU_ENTRY_POINT_RENAME(udat_countAvailable)
#define udat_countSymbols U_ICU_ENTRY_POINT_RENAME(udat_countSymbols)
#define udat_format U_ICU_ENTRY_POINT_RENAME(udat_format)
#define udat_get2DigitYearStart U_ICU_ENTRY_POINT_RENAME(udat_get2DigitYearStart)
#define udat_getAvailable U_ICU_ENTRY_POINT_RENAME(udat_getAvailable)
#define udat_getCalendar U_ICU_ENTRY_POINT_RENAME(udat_getCalendar)
#define udat_getLocaleByType U_ICU_ENTRY_POINT_RENAME(udat_getLocaleByType)
#define udat_getNumberFormat U_ICU_ENTRY_POINT_RENAME(udat_getNumberFormat)
#define udat_getSymbols U_ICU_ENTRY_POINT_RENAME(udat_getSymbols)
#define udat_isLenient U_ICU_ENTRY_POINT_RENAME(udat_isLenient)
#define udat_open U_ICU_ENTRY_POINT_RENAME(udat_open)
#define udat_parse U_ICU_ENTRY_POINT_RENAME(udat_parse)
#define udat_parseCalendar U_ICU_ENTRY_POINT_RENAME(udat_parseCalendar)
#define udat_set2DigitYearStart U_ICU_ENTRY_POINT_RENAME(udat_set2DigitYearStart)
#define udat_setCalendar U_ICU_ENTRY_POINT_RENAME(udat_setCalendar)
#define udat_setLenient U_ICU_ENTRY_POINT_RENAME(udat_setLenient)
#define udat_setNumberFormat U_ICU_ENTRY_POINT_RENAME(udat_setNumberFormat)
#define udat_setSymbols U_ICU_ENTRY_POINT_RENAME(udat_setSymbols)
#define udat_toCalendarDateField U_ICU_ENTRY_POINT_RENAME(udat_toCalendarDateField)
#define udat_toPattern U_ICU_ENTRY_POINT_RENAME(udat_toPattern)
#define udat_toPatternRelativeDate U_ICU_ENTRY_POINT_RENAME(udat_toPatternRelativeDate)
#define udat_toPatternRelativeTime U_ICU_ENTRY_POINT_RENAME(udat_toPatternRelativeTime)
#define udata_checkCommonData U_ICU_ENTRY_POINT_RENAME(udata_checkCommonData)
#define udata_close U_ICU_ENTRY_POINT_RENAME(udata_close)
#define udata_closeSwapper U_ICU_ENTRY_POINT_RENAME(udata_closeSwapper)
#define udata_getHeaderSize U_ICU_ENTRY_POINT_RENAME(udata_getHeaderSize)
#define udata_getInfo U_ICU_ENTRY_POINT_RENAME(udata_getInfo)
#define udata_getInfoSize U_ICU_ENTRY_POINT_RENAME(udata_getInfoSize)
#define udata_getLength U_ICU_ENTRY_POINT_RENAME(udata_getLength)
#define udata_getMemory U_ICU_ENTRY_POINT_RENAME(udata_getMemory)
#define udata_getRawMemory U_ICU_ENTRY_POINT_RENAME(udata_getRawMemory)
#define udata_open U_ICU_ENTRY_POINT_RENAME(udata_open)
#define udata_openChoice U_ICU_ENTRY_POINT_RENAME(udata_openChoice)
#define udata_openSwapper U_ICU_ENTRY_POINT_RENAME(udata_openSwapper)
#define udata_openSwapperForInputData U_ICU_ENTRY_POINT_RENAME(udata_openSwapperForInputData)
#define udata_printError U_ICU_ENTRY_POINT_RENAME(udata_printError)
#define udata_readInt16 U_ICU_ENTRY_POINT_RENAME(udata_readInt16)
#define udata_readInt32 U_ICU_ENTRY_POINT_RENAME(udata_readInt32)
#define udata_setAppData U_ICU_ENTRY_POINT_RENAME(udata_setAppData)
#define udata_setCommonData U_ICU_ENTRY_POINT_RENAME(udata_setCommonData)
#define udata_setFileAccess U_ICU_ENTRY_POINT_RENAME(udata_setFileAccess)
#define udata_swapDataHeader U_ICU_ENTRY_POINT_RENAME(udata_swapDataHeader)
#define udata_swapInvStringBlock U_ICU_ENTRY_POINT_RENAME(udata_swapInvStringBlock)
#define udatpg_addPattern U_ICU_ENTRY_POINT_RENAME(udatpg_addPattern)
#define udatpg_clone U_ICU_ENTRY_POINT_RENAME(udatpg_clone)
#define udatpg_close U_ICU_ENTRY_POINT_RENAME(udatpg_close)
#define udatpg_getAppendItemFormat U_ICU_ENTRY_POINT_RENAME(udatpg_getAppendItemFormat)
#define udatpg_getAppendItemName U_ICU_ENTRY_POINT_RENAME(udatpg_getAppendItemName)
#define udatpg_getBaseSkeleton U_ICU_ENTRY_POINT_RENAME(udatpg_getBaseSkeleton)
#define udatpg_getBestPattern U_ICU_ENTRY_POINT_RENAME(udatpg_getBestPattern)
#define udatpg_getBestPatternWithOptions U_ICU_ENTRY_POINT_RENAME(udatpg_getBestPatternWithOptions)
#define udatpg_getDateTimeFormat U_ICU_ENTRY_POINT_RENAME(udatpg_getDateTimeFormat)
#define udatpg_getDecimal U_ICU_ENTRY_POINT_RENAME(udatpg_getDecimal)
#define udatpg_getPatternForSkeleton U_ICU_ENTRY_POINT_RENAME(udatpg_getPatternForSkeleton)
#define udatpg_getSkeleton U_ICU_ENTRY_POINT_RENAME(udatpg_getSkeleton)
#define udatpg_open U_ICU_ENTRY_POINT_RENAME(udatpg_open)
#define udatpg_openBaseSkeletons U_ICU_ENTRY_POINT_RENAME(udatpg_openBaseSkeletons)
#define udatpg_openEmpty U_ICU_ENTRY_POINT_RENAME(udatpg_openEmpty)
#define udatpg_openSkeletons U_ICU_ENTRY_POINT_RENAME(udatpg_openSkeletons)
#define udatpg_replaceFieldTypes U_ICU_ENTRY_POINT_RENAME(udatpg_replaceFieldTypes)
#define udatpg_replaceFieldTypesWithOptions U_ICU_ENTRY_POINT_RENAME(udatpg_replaceFieldTypesWithOptions)
#define udatpg_setAppendItemFormat U_ICU_ENTRY_POINT_RENAME(udatpg_setAppendItemFormat)
#define udatpg_setAppendItemName U_ICU_ENTRY_POINT_RENAME(udatpg_setAppendItemName)
#define udatpg_setDateTimeFormat U_ICU_ENTRY_POINT_RENAME(udatpg_setDateTimeFormat)
#define udatpg_setDecimal U_ICU_ENTRY_POINT_RENAME(udatpg_setDecimal)
#define uenum_close U_ICU_ENTRY_POINT_RENAME(uenum_close)
#define uenum_count U_ICU_ENTRY_POINT_RENAME(uenum_count)
#define uenum_next U_ICU_ENTRY_POINT_RENAME(uenum_next)
#define uenum_nextDefault U_ICU_ENTRY_POINT_RENAME(uenum_nextDefault)
#define uenum_openCharStringsEnumeration U_ICU_ENTRY_POINT_RENAME(uenum_openCharStringsEnumeration)
#define uenum_openFromStringEnumeration U_ICU_ENTRY_POINT_RENAME(uenum_openFromStringEnumeration)
#define uenum_reset U_ICU_ENTRY_POINT_RENAME(uenum_reset)
#define uenum_unext U_ICU_ENTRY_POINT_RENAME(uenum_unext)
#define uenum_unextDefault U_ICU_ENTRY_POINT_RENAME(uenum_unextDefault)
#define ufile_close_translit U_ICU_ENTRY_POINT_RENAME(ufile_close_translit)
#define ufile_fill_uchar_buffer U_ICU_ENTRY_POINT_RENAME(ufile_fill_uchar_buffer)
#define ufile_flush_translit U_ICU_ENTRY_POINT_RENAME(ufile_flush_translit)
#define ufile_getch U_ICU_ENTRY_POINT_RENAME(ufile_getch)
#define ufile_getch32 U_ICU_ENTRY_POINT_RENAME(ufile_getch32)
#define ufmt_64tou U_ICU_ENTRY_POINT_RENAME(ufmt_64tou)
#define ufmt_defaultCPToUnicode U_ICU_ENTRY_POINT_RENAME(ufmt_defaultCPToUnicode)
#define ufmt_digitvalue U_ICU_ENTRY_POINT_RENAME(ufmt_digitvalue)
#define ufmt_isdigit U_ICU_ENTRY_POINT_RENAME(ufmt_isdigit)
#define ufmt_ptou U_ICU_ENTRY_POINT_RENAME(ufmt_ptou)
#define ufmt_uto64 U_ICU_ENTRY_POINT_RENAME(ufmt_uto64)
#define ufmt_utop U_ICU_ENTRY_POINT_RENAME(ufmt_utop)
#define uhash_close U_ICU_ENTRY_POINT_RENAME(uhash_close)
#define uhash_compareCaselessUnicodeString U_ICU_ENTRY_POINT_RENAME(uhash_compareCaselessUnicodeString)
#define uhash_compareChars U_ICU_ENTRY_POINT_RENAME(uhash_compareChars)
#define uhash_compareIChars U_ICU_ENTRY_POINT_RENAME(uhash_compareIChars)
#define uhash_compareLong U_ICU_ENTRY_POINT_RENAME(uhash_compareLong)
#define uhash_compareUChars U_ICU_ENTRY_POINT_RENAME(uhash_compareUChars)
#define uhash_compareUnicodeString U_ICU_ENTRY_POINT_RENAME(uhash_compareUnicodeString)
#define uhash_count U_ICU_ENTRY_POINT_RENAME(uhash_count)
#define uhash_deleteHashtable U_ICU_ENTRY_POINT_RENAME(uhash_deleteHashtable)
#define uhash_deleteUVector U_ICU_ENTRY_POINT_RENAME(uhash_deleteUVector)
#define uhash_deleteUnicodeString U_ICU_ENTRY_POINT_RENAME(uhash_deleteUnicodeString)
#define uhash_equals U_ICU_ENTRY_POINT_RENAME(uhash_equals)
#define uhash_find U_ICU_ENTRY_POINT_RENAME(uhash_find)
#define uhash_freeBlock U_ICU_ENTRY_POINT_RENAME(uhash_freeBlock)
#define uhash_get U_ICU_ENTRY_POINT_RENAME(uhash_get)
#define uhash_geti U_ICU_ENTRY_POINT_RENAME(uhash_geti)
#define uhash_hashCaselessUnicodeString U_ICU_ENTRY_POINT_RENAME(uhash_hashCaselessUnicodeString)
#define uhash_hashChars U_ICU_ENTRY_POINT_RENAME(uhash_hashChars)
#define uhash_hashIChars U_ICU_ENTRY_POINT_RENAME(uhash_hashIChars)
#define uhash_hashLong U_ICU_ENTRY_POINT_RENAME(uhash_hashLong)
#define uhash_hashUChars U_ICU_ENTRY_POINT_RENAME(uhash_hashUChars)
#define uhash_hashUCharsN U_ICU_ENTRY_POINT_RENAME(uhash_hashUCharsN)
#define uhash_hashUnicodeString U_ICU_ENTRY_POINT_RENAME(uhash_hashUnicodeString)
#define uhash_iget U_ICU_ENTRY_POINT_RENAME(uhash_iget)
#define uhash_igeti U_ICU_ENTRY_POINT_RENAME(uhash_igeti)
#define uhash_init U_ICU_ENTRY_POINT_RENAME(uhash_init)
#define uhash_iput U_ICU_ENTRY_POINT_RENAME(uhash_iput)
#define uhash_iputi U_ICU_ENTRY_POINT_RENAME(uhash_iputi)
#define uhash_iremove U_ICU_ENTRY_POINT_RENAME(uhash_iremove)
#define uhash_iremovei U_ICU_ENTRY_POINT_RENAME(uhash_iremovei)
#define uhash_nextElement U_ICU_ENTRY_POINT_RENAME(uhash_nextElement)
#define uhash_open U_ICU_ENTRY_POINT_RENAME(uhash_open)
#define uhash_openSize U_ICU_ENTRY_POINT_RENAME(uhash_openSize)
#define uhash_put U_ICU_ENTRY_POINT_RENAME(uhash_put)
#define uhash_puti U_ICU_ENTRY_POINT_RENAME(uhash_puti)
#define uhash_remove U_ICU_ENTRY_POINT_RENAME(uhash_remove)
#define uhash_removeAll U_ICU_ENTRY_POINT_RENAME(uhash_removeAll)
#define uhash_removeElement U_ICU_ENTRY_POINT_RENAME(uhash_removeElement)
#define uhash_removei U_ICU_ENTRY_POINT_RENAME(uhash_removei)
#define uhash_setKeyComparator U_ICU_ENTRY_POINT_RENAME(uhash_setKeyComparator)
#define uhash_setKeyDeleter U_ICU_ENTRY_POINT_RENAME(uhash_setKeyDeleter)
#define uhash_setKeyHasher U_ICU_ENTRY_POINT_RENAME(uhash_setKeyHasher)
#define uhash_setResizePolicy U_ICU_ENTRY_POINT_RENAME(uhash_setResizePolicy)
#define uhash_setValueComparator U_ICU_ENTRY_POINT_RENAME(uhash_setValueComparator)
#define uhash_setValueDeleter U_ICU_ENTRY_POINT_RENAME(uhash_setValueDeleter)
#define uidna_IDNToASCII U_ICU_ENTRY_POINT_RENAME(uidna_IDNToASCII)
#define uidna_IDNToUnicode U_ICU_ENTRY_POINT_RENAME(uidna_IDNToUnicode)
#define uidna_compare U_ICU_ENTRY_POINT_RENAME(uidna_compare)
#define uidna_toASCII U_ICU_ENTRY_POINT_RENAME(uidna_toASCII)
#define uidna_toUnicode U_ICU_ENTRY_POINT_RENAME(uidna_toUnicode)
#define uiter_current32 U_ICU_ENTRY_POINT_RENAME(uiter_current32)
#define uiter_getState U_ICU_ENTRY_POINT_RENAME(uiter_getState)
#define uiter_next32 U_ICU_ENTRY_POINT_RENAME(uiter_next32)
#define uiter_previous32 U_ICU_ENTRY_POINT_RENAME(uiter_previous32)
#define uiter_setCharacterIterator U_ICU_ENTRY_POINT_RENAME(uiter_setCharacterIterator)
#define uiter_setReplaceable U_ICU_ENTRY_POINT_RENAME(uiter_setReplaceable)
#define uiter_setState U_ICU_ENTRY_POINT_RENAME(uiter_setState)
#define uiter_setString U_ICU_ENTRY_POINT_RENAME(uiter_setString)
#define uiter_setUTF16BE U_ICU_ENTRY_POINT_RENAME(uiter_setUTF16BE)
#define uiter_setUTF8 U_ICU_ENTRY_POINT_RENAME(uiter_setUTF8)
#define uldn_close U_ICU_ENTRY_POINT_RENAME(uldn_close)
#define uldn_getDialectHandling U_ICU_ENTRY_POINT_RENAME(uldn_getDialectHandling)
#define uldn_getLocale U_ICU_ENTRY_POINT_RENAME(uldn_getLocale)
#define uldn_keyDisplayName U_ICU_ENTRY_POINT_RENAME(uldn_keyDisplayName)
#define uldn_keyValueDisplayName U_ICU_ENTRY_POINT_RENAME(uldn_keyValueDisplayName)
#define uldn_languageDisplayName U_ICU_ENTRY_POINT_RENAME(uldn_languageDisplayName)
#define uldn_localeDisplayName U_ICU_ENTRY_POINT_RENAME(uldn_localeDisplayName)
#define uldn_open U_ICU_ENTRY_POINT_RENAME(uldn_open)
#define uldn_regionDisplayName U_ICU_ENTRY_POINT_RENAME(uldn_regionDisplayName)
#define uldn_scriptCodeDisplayName U_ICU_ENTRY_POINT_RENAME(uldn_scriptCodeDisplayName)
#define uldn_scriptDisplayName U_ICU_ENTRY_POINT_RENAME(uldn_scriptDisplayName)
#define uldn_variantDisplayName U_ICU_ENTRY_POINT_RENAME(uldn_variantDisplayName)
#define ulist_addItemBeginList U_ICU_ENTRY_POINT_RENAME(ulist_addItemBeginList)
#define ulist_addItemEndList U_ICU_ENTRY_POINT_RENAME(ulist_addItemEndList)
#define ulist_close_keyword_values_iterator U_ICU_ENTRY_POINT_RENAME(ulist_close_keyword_values_iterator)
#define ulist_containsString U_ICU_ENTRY_POINT_RENAME(ulist_containsString)
#define ulist_count_keyword_values U_ICU_ENTRY_POINT_RENAME(ulist_count_keyword_values)
#define ulist_createEmptyList U_ICU_ENTRY_POINT_RENAME(ulist_createEmptyList)
#define ulist_deleteList U_ICU_ENTRY_POINT_RENAME(ulist_deleteList)
#define ulist_getListFromEnum U_ICU_ENTRY_POINT_RENAME(ulist_getListFromEnum)
#define ulist_getListSize U_ICU_ENTRY_POINT_RENAME(ulist_getListSize)
#define ulist_getNext U_ICU_ENTRY_POINT_RENAME(ulist_getNext)
#define ulist_next_keyword_value U_ICU_ENTRY_POINT_RENAME(ulist_next_keyword_value)
#define ulist_resetList U_ICU_ENTRY_POINT_RENAME(ulist_resetList)
#define ulist_reset_keyword_values_iterator U_ICU_ENTRY_POINT_RENAME(ulist_reset_keyword_values_iterator)
#define uloc_acceptLanguage U_ICU_ENTRY_POINT_RENAME(uloc_acceptLanguage)
#define uloc_acceptLanguageFromHTTP U_ICU_ENTRY_POINT_RENAME(uloc_acceptLanguageFromHTTP)
#define uloc_addLikelySubtags U_ICU_ENTRY_POINT_RENAME(uloc_addLikelySubtags)
#define uloc_canonicalize U_ICU_ENTRY_POINT_RENAME(uloc_canonicalize)
#define uloc_countAvailable U_ICU_ENTRY_POINT_RENAME(uloc_countAvailable)
#define uloc_forLanguageTag U_ICU_ENTRY_POINT_RENAME(uloc_forLanguageTag)
#define uloc_getAvailable U_ICU_ENTRY_POINT_RENAME(uloc_getAvailable)
#define uloc_getBaseName U_ICU_ENTRY_POINT_RENAME(uloc_getBaseName)
#define uloc_getCharacterOrientation U_ICU_ENTRY_POINT_RENAME(uloc_getCharacterOrientation)
#define uloc_getCountry U_ICU_ENTRY_POINT_RENAME(uloc_getCountry)
#define uloc_getCurrentCountryID U_ICU_ENTRY_POINT_RENAME(uloc_getCurrentCountryID)
#define uloc_getCurrentLanguageID U_ICU_ENTRY_POINT_RENAME(uloc_getCurrentLanguageID)
#define uloc_getDefault U_ICU_ENTRY_POINT_RENAME(uloc_getDefault)
#define uloc_getDisplayCountry U_ICU_ENTRY_POINT_RENAME(uloc_getDisplayCountry)
#define uloc_getDisplayKeyword U_ICU_ENTRY_POINT_RENAME(uloc_getDisplayKeyword)
#define uloc_getDisplayKeywordValue U_ICU_ENTRY_POINT_RENAME(uloc_getDisplayKeywordValue)
#define uloc_getDisplayLanguage U_ICU_ENTRY_POINT_RENAME(uloc_getDisplayLanguage)
#define uloc_getDisplayName U_ICU_ENTRY_POINT_RENAME(uloc_getDisplayName)
#define uloc_getDisplayScript U_ICU_ENTRY_POINT_RENAME(uloc_getDisplayScript)
#define uloc_getDisplayVariant U_ICU_ENTRY_POINT_RENAME(uloc_getDisplayVariant)
#define uloc_getISO3Country U_ICU_ENTRY_POINT_RENAME(uloc_getISO3Country)
#define uloc_getISO3Language U_ICU_ENTRY_POINT_RENAME(uloc_getISO3Language)
#define uloc_getISOCountries U_ICU_ENTRY_POINT_RENAME(uloc_getISOCountries)
#define uloc_getISOLanguages U_ICU_ENTRY_POINT_RENAME(uloc_getISOLanguages)
#define uloc_getKeywordValue U_ICU_ENTRY_POINT_RENAME(uloc_getKeywordValue)
#define uloc_getLCID U_ICU_ENTRY_POINT_RENAME(uloc_getLCID)
#define uloc_getLanguage U_ICU_ENTRY_POINT_RENAME(uloc_getLanguage)
#define uloc_getLineOrientation U_ICU_ENTRY_POINT_RENAME(uloc_getLineOrientation)
#define uloc_getLocaleForLCID U_ICU_ENTRY_POINT_RENAME(uloc_getLocaleForLCID)
#define uloc_getName U_ICU_ENTRY_POINT_RENAME(uloc_getName)
#define uloc_getParent U_ICU_ENTRY_POINT_RENAME(uloc_getParent)
#define uloc_getScript U_ICU_ENTRY_POINT_RENAME(uloc_getScript)
#define uloc_getTableStringWithFallback U_ICU_ENTRY_POINT_RENAME(uloc_getTableStringWithFallback)
#define uloc_getVariant U_ICU_ENTRY_POINT_RENAME(uloc_getVariant)
#define uloc_minimizeSubtags U_ICU_ENTRY_POINT_RENAME(uloc_minimizeSubtags)
#define uloc_openKeywordList U_ICU_ENTRY_POINT_RENAME(uloc_openKeywordList)
#define uloc_openKeywords U_ICU_ENTRY_POINT_RENAME(uloc_openKeywords)
#define uloc_setDefault U_ICU_ENTRY_POINT_RENAME(uloc_setDefault)
#define uloc_setKeywordValue U_ICU_ENTRY_POINT_RENAME(uloc_setKeywordValue)
#define uloc_toLanguageTag U_ICU_ENTRY_POINT_RENAME(uloc_toLanguageTag)
#define ulocdata_close U_ICU_ENTRY_POINT_RENAME(ulocdata_close)
#define ulocdata_getCLDRVersion U_ICU_ENTRY_POINT_RENAME(ulocdata_getCLDRVersion)
#define ulocdata_getDelimiter U_ICU_ENTRY_POINT_RENAME(ulocdata_getDelimiter)
#define ulocdata_getExemplarSet U_ICU_ENTRY_POINT_RENAME(ulocdata_getExemplarSet)
#define ulocdata_getLocaleDisplayPattern U_ICU_ENTRY_POINT_RENAME(ulocdata_getLocaleDisplayPattern)
#define ulocdata_getLocaleSeparator U_ICU_ENTRY_POINT_RENAME(ulocdata_getLocaleSeparator)
#define ulocdata_getMeasurementSystem U_ICU_ENTRY_POINT_RENAME(ulocdata_getMeasurementSystem)
#define ulocdata_getNoSubstitute U_ICU_ENTRY_POINT_RENAME(ulocdata_getNoSubstitute)
#define ulocdata_getPaperSize U_ICU_ENTRY_POINT_RENAME(ulocdata_getPaperSize)
#define ulocdata_open U_ICU_ENTRY_POINT_RENAME(ulocdata_open)
#define ulocdata_setNoSubstitute U_ICU_ENTRY_POINT_RENAME(ulocdata_setNoSubstitute)
#define ulocimp_getCountry U_ICU_ENTRY_POINT_RENAME(ulocimp_getCountry)
#define ulocimp_getLanguage U_ICU_ENTRY_POINT_RENAME(ulocimp_getLanguage)
#define ulocimp_getScript U_ICU_ENTRY_POINT_RENAME(ulocimp_getScript)
#define umsg_applyPattern U_ICU_ENTRY_POINT_RENAME(umsg_applyPattern)
#define umsg_autoQuoteApostrophe U_ICU_ENTRY_POINT_RENAME(umsg_autoQuoteApostrophe)
#define umsg_clone U_ICU_ENTRY_POINT_RENAME(umsg_clone)
#define umsg_close U_ICU_ENTRY_POINT_RENAME(umsg_close)
#define umsg_format U_ICU_ENTRY_POINT_RENAME(umsg_format)
#define umsg_getLocale U_ICU_ENTRY_POINT_RENAME(umsg_getLocale)
#define umsg_open U_ICU_ENTRY_POINT_RENAME(umsg_open)
#define umsg_parse U_ICU_ENTRY_POINT_RENAME(umsg_parse)
#define umsg_setLocale U_ICU_ENTRY_POINT_RENAME(umsg_setLocale)
#define umsg_toPattern U_ICU_ENTRY_POINT_RENAME(umsg_toPattern)
#define umsg_vformat U_ICU_ENTRY_POINT_RENAME(umsg_vformat)
#define umsg_vparse U_ICU_ENTRY_POINT_RENAME(umsg_vparse)
#define umtx_atomic_dec U_ICU_ENTRY_POINT_RENAME(umtx_atomic_dec)
#define umtx_atomic_inc U_ICU_ENTRY_POINT_RENAME(umtx_atomic_inc)
#define umtx_cleanup U_ICU_ENTRY_POINT_RENAME(umtx_cleanup)
#define umtx_destroy U_ICU_ENTRY_POINT_RENAME(umtx_destroy)
#define umtx_init U_ICU_ENTRY_POINT_RENAME(umtx_init)
#define umtx_lock U_ICU_ENTRY_POINT_RENAME(umtx_lock)
#define umtx_unlock U_ICU_ENTRY_POINT_RENAME(umtx_unlock)
#define uniset_getUnicode32Instance U_ICU_ENTRY_POINT_RENAME(uniset_getUnicode32Instance)
#define unorm2_append U_ICU_ENTRY_POINT_RENAME(unorm2_append)
#define unorm2_close U_ICU_ENTRY_POINT_RENAME(unorm2_close)
#define unorm2_getInstance U_ICU_ENTRY_POINT_RENAME(unorm2_getInstance)
#define unorm2_hasBoundaryAfter U_ICU_ENTRY_POINT_RENAME(unorm2_hasBoundaryAfter)
#define unorm2_hasBoundaryBefore U_ICU_ENTRY_POINT_RENAME(unorm2_hasBoundaryBefore)
#define unorm2_isInert U_ICU_ENTRY_POINT_RENAME(unorm2_isInert)
#define unorm2_isNormalized U_ICU_ENTRY_POINT_RENAME(unorm2_isNormalized)
#define unorm2_normalize U_ICU_ENTRY_POINT_RENAME(unorm2_normalize)
#define unorm2_normalizeSecondAndAppend U_ICU_ENTRY_POINT_RENAME(unorm2_normalizeSecondAndAppend)
#define unorm2_openFiltered U_ICU_ENTRY_POINT_RENAME(unorm2_openFiltered)
#define unorm2_quickCheck U_ICU_ENTRY_POINT_RENAME(unorm2_quickCheck)
#define unorm2_spanQuickCheckYes U_ICU_ENTRY_POINT_RENAME(unorm2_spanQuickCheckYes)
#define unorm2_swap U_ICU_ENTRY_POINT_RENAME(unorm2_swap)
#define unorm_addPropertyStarts U_ICU_ENTRY_POINT_RENAME(unorm_addPropertyStarts)
#define unorm_closeIter U_ICU_ENTRY_POINT_RENAME(unorm_closeIter)
#define unorm_compare U_ICU_ENTRY_POINT_RENAME(unorm_compare)
#define unorm_concatenate U_ICU_ENTRY_POINT_RENAME(unorm_concatenate)
#define unorm_getCanonStartSet U_ICU_ENTRY_POINT_RENAME(unorm_getCanonStartSet)
#define unorm_getFCDTrieIndex U_ICU_ENTRY_POINT_RENAME(unorm_getFCDTrieIndex)
#define unorm_getQuickCheck U_ICU_ENTRY_POINT_RENAME(unorm_getQuickCheck)
#define unorm_haveData U_ICU_ENTRY_POINT_RENAME(unorm_haveData)
#define unorm_isCanonSafeStart U_ICU_ENTRY_POINT_RENAME(unorm_isCanonSafeStart)
#define unorm_isNormalized U_ICU_ENTRY_POINT_RENAME(unorm_isNormalized)
#define unorm_isNormalizedWithOptions U_ICU_ENTRY_POINT_RENAME(unorm_isNormalizedWithOptions)
#define unorm_next U_ICU_ENTRY_POINT_RENAME(unorm_next)
#define unorm_normalize U_ICU_ENTRY_POINT_RENAME(unorm_normalize)
#define unorm_openIter U_ICU_ENTRY_POINT_RENAME(unorm_openIter)
#define unorm_previous U_ICU_ENTRY_POINT_RENAME(unorm_previous)
#define unorm_quickCheck U_ICU_ENTRY_POINT_RENAME(unorm_quickCheck)
#define unorm_quickCheckWithOptions U_ICU_ENTRY_POINT_RENAME(unorm_quickCheckWithOptions)
#define unorm_setIter U_ICU_ENTRY_POINT_RENAME(unorm_setIter)
#define unum_applyPattern U_ICU_ENTRY_POINT_RENAME(unum_applyPattern)
#define unum_clone U_ICU_ENTRY_POINT_RENAME(unum_clone)
#define unum_close U_ICU_ENTRY_POINT_RENAME(unum_close)
#define unum_countAvailable U_ICU_ENTRY_POINT_RENAME(unum_countAvailable)
#define unum_format U_ICU_ENTRY_POINT_RENAME(unum_format)
#define unum_formatDouble U_ICU_ENTRY_POINT_RENAME(unum_formatDouble)
#define unum_formatDoubleCurrency U_ICU_ENTRY_POINT_RENAME(unum_formatDoubleCurrency)
#define unum_formatInt64 U_ICU_ENTRY_POINT_RENAME(unum_formatInt64)
#define unum_getAttribute U_ICU_ENTRY_POINT_RENAME(unum_getAttribute)
#define unum_getAvailable U_ICU_ENTRY_POINT_RENAME(unum_getAvailable)
#define unum_getDoubleAttribute U_ICU_ENTRY_POINT_RENAME(unum_getDoubleAttribute)
#define unum_getLocaleByType U_ICU_ENTRY_POINT_RENAME(unum_getLocaleByType)
#define unum_getSymbol U_ICU_ENTRY_POINT_RENAME(unum_getSymbol)
#define unum_getTextAttribute U_ICU_ENTRY_POINT_RENAME(unum_getTextAttribute)
#define unum_open U_ICU_ENTRY_POINT_RENAME(unum_open)
#define unum_parse U_ICU_ENTRY_POINT_RENAME(unum_parse)
#define unum_parseDouble U_ICU_ENTRY_POINT_RENAME(unum_parseDouble)
#define unum_parseDoubleCurrency U_ICU_ENTRY_POINT_RENAME(unum_parseDoubleCurrency)
#define unum_parseInt64 U_ICU_ENTRY_POINT_RENAME(unum_parseInt64)
#define unum_setAttribute U_ICU_ENTRY_POINT_RENAME(unum_setAttribute)
#define unum_setDoubleAttribute U_ICU_ENTRY_POINT_RENAME(unum_setDoubleAttribute)
#define unum_setSymbol U_ICU_ENTRY_POINT_RENAME(unum_setSymbol)
#define unum_setTextAttribute U_ICU_ENTRY_POINT_RENAME(unum_setTextAttribute)
#define unum_toPattern U_ICU_ENTRY_POINT_RENAME(unum_toPattern)
#define uplug_closeLibrary U_ICU_ENTRY_POINT_RENAME(uplug_closeLibrary)
#define uplug_findLibrary U_ICU_ENTRY_POINT_RENAME(uplug_findLibrary)
#define uplug_getConfiguration U_ICU_ENTRY_POINT_RENAME(uplug_getConfiguration)
#define uplug_getContext U_ICU_ENTRY_POINT_RENAME(uplug_getContext)
#define uplug_getCurrentLevel U_ICU_ENTRY_POINT_RENAME(uplug_getCurrentLevel)
#define uplug_getLibrary U_ICU_ENTRY_POINT_RENAME(uplug_getLibrary)
#define uplug_getLibraryName U_ICU_ENTRY_POINT_RENAME(uplug_getLibraryName)
#define uplug_getPlugInternal U_ICU_ENTRY_POINT_RENAME(uplug_getPlugInternal)
#define uplug_getPlugLevel U_ICU_ENTRY_POINT_RENAME(uplug_getPlugLevel)
#define uplug_getPlugLoadStatus U_ICU_ENTRY_POINT_RENAME(uplug_getPlugLoadStatus)
#define uplug_getPlugName U_ICU_ENTRY_POINT_RENAME(uplug_getPlugName)
#define uplug_getPluginFile U_ICU_ENTRY_POINT_RENAME(uplug_getPluginFile)
#define uplug_getSymbolName U_ICU_ENTRY_POINT_RENAME(uplug_getSymbolName)
#define uplug_init U_ICU_ENTRY_POINT_RENAME(uplug_init)
#define uplug_loadPlugFromEntrypoint U_ICU_ENTRY_POINT_RENAME(uplug_loadPlugFromEntrypoint)
#define uplug_loadPlugFromLibrary U_ICU_ENTRY_POINT_RENAME(uplug_loadPlugFromLibrary)
#define uplug_nextPlug U_ICU_ENTRY_POINT_RENAME(uplug_nextPlug)
#define uplug_openLibrary U_ICU_ENTRY_POINT_RENAME(uplug_openLibrary)
#define uplug_removePlug U_ICU_ENTRY_POINT_RENAME(uplug_removePlug)
#define uplug_setContext U_ICU_ENTRY_POINT_RENAME(uplug_setContext)
#define uplug_setPlugLevel U_ICU_ENTRY_POINT_RENAME(uplug_setPlugLevel)
#define uplug_setPlugName U_ICU_ENTRY_POINT_RENAME(uplug_setPlugName)
#define uplug_setPlugNoUnload U_ICU_ENTRY_POINT_RENAME(uplug_setPlugNoUnload)
#define upname_swap U_ICU_ENTRY_POINT_RENAME(upname_swap)
#define uprops_getSource U_ICU_ENTRY_POINT_RENAME(uprops_getSource)
#define upropsvec_addPropertyStarts U_ICU_ENTRY_POINT_RENAME(upropsvec_addPropertyStarts)
#define uprv_asciiFromEbcdic U_ICU_ENTRY_POINT_RENAME(uprv_asciiFromEbcdic)
#define uprv_asciitolower U_ICU_ENTRY_POINT_RENAME(uprv_asciitolower)
#define uprv_ceil U_ICU_ENTRY_POINT_RENAME(uprv_ceil)
#define uprv_cnttab_addContraction U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_addContraction)
#define uprv_cnttab_changeContraction U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_changeContraction)
#define uprv_cnttab_changeLastCE U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_changeLastCE)
#define uprv_cnttab_clone U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_clone)
#define uprv_cnttab_close U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_close)
#define uprv_cnttab_constructTable U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_constructTable)
#define uprv_cnttab_findCE U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_findCE)
#define uprv_cnttab_findCP U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_findCP)
#define uprv_cnttab_getCE U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_getCE)
#define uprv_cnttab_insertContraction U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_insertContraction)
#define uprv_cnttab_isTailored U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_isTailored)
#define uprv_cnttab_open U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_open)
#define uprv_cnttab_setContraction U_ICU_ENTRY_POINT_RENAME(uprv_cnttab_setContraction)
#define uprv_collIterateAtEnd U_ICU_ENTRY_POINT_RENAME(uprv_collIterateAtEnd)
#define uprv_compareASCIIPropertyNames U_ICU_ENTRY_POINT_RENAME(uprv_compareASCIIPropertyNames)
#define uprv_compareEBCDICPropertyNames U_ICU_ENTRY_POINT_RENAME(uprv_compareEBCDICPropertyNames)
#define uprv_compareInvAscii U_ICU_ENTRY_POINT_RENAME(uprv_compareInvAscii)
#define uprv_compareInvEbcdic U_ICU_ENTRY_POINT_RENAME(uprv_compareInvEbcdic)
#define uprv_compareInvEbcdicAsAscii U_ICU_ENTRY_POINT_RENAME(uprv_compareInvEbcdicAsAscii)
#define uprv_convertToLCID U_ICU_ENTRY_POINT_RENAME(uprv_convertToLCID)
#define uprv_convertToPosix U_ICU_ENTRY_POINT_RENAME(uprv_convertToPosix)
#define uprv_copyAscii U_ICU_ENTRY_POINT_RENAME(uprv_copyAscii)
#define uprv_copyEbcdic U_ICU_ENTRY_POINT_RENAME(uprv_copyEbcdic)
#define uprv_decContextClearStatus U_ICU_ENTRY_POINT_RENAME(uprv_decContextClearStatus)
#define uprv_decContextDefault U_ICU_ENTRY_POINT_RENAME(uprv_decContextDefault)
#define uprv_decContextGetRounding U_ICU_ENTRY_POINT_RENAME(uprv_decContextGetRounding)
#define uprv_decContextGetStatus U_ICU_ENTRY_POINT_RENAME(uprv_decContextGetStatus)
#define uprv_decContextRestoreStatus U_ICU_ENTRY_POINT_RENAME(uprv_decContextRestoreStatus)
#define uprv_decContextSaveStatus U_ICU_ENTRY_POINT_RENAME(uprv_decContextSaveStatus)
#define uprv_decContextSetRounding U_ICU_ENTRY_POINT_RENAME(uprv_decContextSetRounding)
#define uprv_decContextSetStatus U_ICU_ENTRY_POINT_RENAME(uprv_decContextSetStatus)
#define uprv_decContextSetStatusFromString U_ICU_ENTRY_POINT_RENAME(uprv_decContextSetStatusFromString)
#define uprv_decContextSetStatusFromStringQuiet U_ICU_ENTRY_POINT_RENAME(uprv_decContextSetStatusFromStringQuiet)
#define uprv_decContextSetStatusQuiet U_ICU_ENTRY_POINT_RENAME(uprv_decContextSetStatusQuiet)
#define uprv_decContextStatusToString U_ICU_ENTRY_POINT_RENAME(uprv_decContextStatusToString)
#define uprv_decContextTestEndian U_ICU_ENTRY_POINT_RENAME(uprv_decContextTestEndian)
#define uprv_decContextTestSavedStatus U_ICU_ENTRY_POINT_RENAME(uprv_decContextTestSavedStatus)
#define uprv_decContextTestStatus U_ICU_ENTRY_POINT_RENAME(uprv_decContextTestStatus)
#define uprv_decContextZeroStatus U_ICU_ENTRY_POINT_RENAME(uprv_decContextZeroStatus)
#define uprv_decNumberAbs U_ICU_ENTRY_POINT_RENAME(uprv_decNumberAbs)
#define uprv_decNumberAdd U_ICU_ENTRY_POINT_RENAME(uprv_decNumberAdd)
#define uprv_decNumberAnd U_ICU_ENTRY_POINT_RENAME(uprv_decNumberAnd)
#define uprv_decNumberClass U_ICU_ENTRY_POINT_RENAME(uprv_decNumberClass)
#define uprv_decNumberClassToString U_ICU_ENTRY_POINT_RENAME(uprv_decNumberClassToString)
#define uprv_decNumberCompare U_ICU_ENTRY_POINT_RENAME(uprv_decNumberCompare)
#define uprv_decNumberCompareSignal U_ICU_ENTRY_POINT_RENAME(uprv_decNumberCompareSignal)
#define uprv_decNumberCompareTotal U_ICU_ENTRY_POINT_RENAME(uprv_decNumberCompareTotal)
#define uprv_decNumberCompareTotalMag U_ICU_ENTRY_POINT_RENAME(uprv_decNumberCompareTotalMag)
#define uprv_decNumberCopy U_ICU_ENTRY_POINT_RENAME(uprv_decNumberCopy)
#define uprv_decNumberCopyAbs U_ICU_ENTRY_POINT_RENAME(uprv_decNumberCopyAbs)
#define uprv_decNumberCopyNegate U_ICU_ENTRY_POINT_RENAME(uprv_decNumberCopyNegate)
#define uprv_decNumberCopySign U_ICU_ENTRY_POINT_RENAME(uprv_decNumberCopySign)
#define uprv_decNumberDivide U_ICU_ENTRY_POINT_RENAME(uprv_decNumberDivide)
#define uprv_decNumberDivideInteger U_ICU_ENTRY_POINT_RENAME(uprv_decNumberDivideInteger)
#define uprv_decNumberExp U_ICU_ENTRY_POINT_RENAME(uprv_decNumberExp)
#define uprv_decNumberFMA U_ICU_ENTRY_POINT_RENAME(uprv_decNumberFMA)
#define uprv_decNumberFromInt32 U_ICU_ENTRY_POINT_RENAME(uprv_decNumberFromInt32)
#define uprv_decNumberFromString U_ICU_ENTRY_POINT_RENAME(uprv_decNumberFromString)
#define uprv_decNumberFromUInt32 U_ICU_ENTRY_POINT_RENAME(uprv_decNumberFromUInt32)
#define uprv_decNumberGetBCD U_ICU_ENTRY_POINT_RENAME(uprv_decNumberGetBCD)
#define uprv_decNumberInvert U_ICU_ENTRY_POINT_RENAME(uprv_decNumberInvert)
#define uprv_decNumberIsNormal U_ICU_ENTRY_POINT_RENAME(uprv_decNumberIsNormal)
#define uprv_decNumberIsSubnormal U_ICU_ENTRY_POINT_RENAME(uprv_decNumberIsSubnormal)
#define uprv_decNumberLn U_ICU_ENTRY_POINT_RENAME(uprv_decNumberLn)
#define uprv_decNumberLog10 U_ICU_ENTRY_POINT_RENAME(uprv_decNumberLog10)
#define uprv_decNumberLogB U_ICU_ENTRY_POINT_RENAME(uprv_decNumberLogB)
#define uprv_decNumberMax U_ICU_ENTRY_POINT_RENAME(uprv_decNumberMax)
#define uprv_decNumberMaxMag U_ICU_ENTRY_POINT_RENAME(uprv_decNumberMaxMag)
#define uprv_decNumberMin U_ICU_ENTRY_POINT_RENAME(uprv_decNumberMin)
#define uprv_decNumberMinMag U_ICU_ENTRY_POINT_RENAME(uprv_decNumberMinMag)
#define uprv_decNumberMinus U_ICU_ENTRY_POINT_RENAME(uprv_decNumberMinus)
#define uprv_decNumberMultiply U_ICU_ENTRY_POINT_RENAME(uprv_decNumberMultiply)
#define uprv_decNumberNextMinus U_ICU_ENTRY_POINT_RENAME(uprv_decNumberNextMinus)
#define uprv_decNumberNextPlus U_ICU_ENTRY_POINT_RENAME(uprv_decNumberNextPlus)
#define uprv_decNumberNextToward U_ICU_ENTRY_POINT_RENAME(uprv_decNumberNextToward)
#define uprv_decNumberNormalize U_ICU_ENTRY_POINT_RENAME(uprv_decNumberNormalize)
#define uprv_decNumberOr U_ICU_ENTRY_POINT_RENAME(uprv_decNumberOr)
#define uprv_decNumberPlus U_ICU_ENTRY_POINT_RENAME(uprv_decNumberPlus)
#define uprv_decNumberPower U_ICU_ENTRY_POINT_RENAME(uprv_decNumberPower)
#define uprv_decNumberQuantize U_ICU_ENTRY_POINT_RENAME(uprv_decNumberQuantize)
#define uprv_decNumberReduce U_ICU_ENTRY_POINT_RENAME(uprv_decNumberReduce)
#define uprv_decNumberRemainder U_ICU_ENTRY_POINT_RENAME(uprv_decNumberRemainder)
#define uprv_decNumberRemainderNear U_ICU_ENTRY_POINT_RENAME(uprv_decNumberRemainderNear)
#define uprv_decNumberRescale U_ICU_ENTRY_POINT_RENAME(uprv_decNumberRescale)
#define uprv_decNumberRotate U_ICU_ENTRY_POINT_RENAME(uprv_decNumberRotate)
#define uprv_decNumberSameQuantum U_ICU_ENTRY_POINT_RENAME(uprv_decNumberSameQuantum)
#define uprv_decNumberScaleB U_ICU_ENTRY_POINT_RENAME(uprv_decNumberScaleB)
#define uprv_decNumberSetBCD U_ICU_ENTRY_POINT_RENAME(uprv_decNumberSetBCD)
#define uprv_decNumberShift U_ICU_ENTRY_POINT_RENAME(uprv_decNumberShift)
#define uprv_decNumberSquareRoot U_ICU_ENTRY_POINT_RENAME(uprv_decNumberSquareRoot)
#define uprv_decNumberSubtract U_ICU_ENTRY_POINT_RENAME(uprv_decNumberSubtract)
#define uprv_decNumberToEngString U_ICU_ENTRY_POINT_RENAME(uprv_decNumberToEngString)
#define uprv_decNumberToInt32 U_ICU_ENTRY_POINT_RENAME(uprv_decNumberToInt32)
#define uprv_decNumberToIntegralExact U_ICU_ENTRY_POINT_RENAME(uprv_decNumberToIntegralExact)
#define uprv_decNumberToIntegralValue U_ICU_ENTRY_POINT_RENAME(uprv_decNumberToIntegralValue)
#define uprv_decNumberToString U_ICU_ENTRY_POINT_RENAME(uprv_decNumberToString)
#define uprv_decNumberToUInt32 U_ICU_ENTRY_POINT_RENAME(uprv_decNumberToUInt32)
#define uprv_decNumberTrim U_ICU_ENTRY_POINT_RENAME(uprv_decNumberTrim)
#define uprv_decNumberVersion U_ICU_ENTRY_POINT_RENAME(uprv_decNumberVersion)
#define uprv_decNumberXor U_ICU_ENTRY_POINT_RENAME(uprv_decNumberXor)
#define uprv_decNumberZero U_ICU_ENTRY_POINT_RENAME(uprv_decNumberZero)
#define uprv_delete_collIterate U_ICU_ENTRY_POINT_RENAME(uprv_delete_collIterate)
#define uprv_dl_close U_ICU_ENTRY_POINT_RENAME(uprv_dl_close)
#define uprv_dl_open U_ICU_ENTRY_POINT_RENAME(uprv_dl_open)
#define uprv_dl_sym U_ICU_ENTRY_POINT_RENAME(uprv_dl_sym)
#define uprv_ebcdicFromAscii U_ICU_ENTRY_POINT_RENAME(uprv_ebcdicFromAscii)
#define uprv_ebcdictolower U_ICU_ENTRY_POINT_RENAME(uprv_ebcdictolower)
#define uprv_fabs U_ICU_ENTRY_POINT_RENAME(uprv_fabs)
#define uprv_floor U_ICU_ENTRY_POINT_RENAME(uprv_floor)
#define uprv_fmax U_ICU_ENTRY_POINT_RENAME(uprv_fmax)
#define uprv_fmin U_ICU_ENTRY_POINT_RENAME(uprv_fmin)
#define uprv_fmod U_ICU_ENTRY_POINT_RENAME(uprv_fmod)
#define uprv_free U_ICU_ENTRY_POINT_RENAME(uprv_free)
#define uprv_getCharNameCharacters U_ICU_ENTRY_POINT_RENAME(uprv_getCharNameCharacters)
#define uprv_getDefaultCodepage U_ICU_ENTRY_POINT_RENAME(uprv_getDefaultCodepage)
#define uprv_getDefaultLocaleID U_ICU_ENTRY_POINT_RENAME(uprv_getDefaultLocaleID)
#define uprv_getInfinity U_ICU_ENTRY_POINT_RENAME(uprv_getInfinity)
#define uprv_getMaxCharNameLength U_ICU_ENTRY_POINT_RENAME(uprv_getMaxCharNameLength)
#define uprv_getMaxValues U_ICU_ENTRY_POINT_RENAME(uprv_getMaxValues)
#define uprv_getNaN U_ICU_ENTRY_POINT_RENAME(uprv_getNaN)
#define uprv_getStaticCurrencyName U_ICU_ENTRY_POINT_RENAME(uprv_getStaticCurrencyName)
#define uprv_getUTCtime U_ICU_ENTRY_POINT_RENAME(uprv_getUTCtime)
#define uprv_haveProperties U_ICU_ENTRY_POINT_RENAME(uprv_haveProperties)
#define uprv_init_collIterate U_ICU_ENTRY_POINT_RENAME(uprv_init_collIterate)
#define uprv_init_pce U_ICU_ENTRY_POINT_RENAME(uprv_init_pce)
#define uprv_int32Comparator U_ICU_ENTRY_POINT_RENAME(uprv_int32Comparator)
#define uprv_isInfinite U_ICU_ENTRY_POINT_RENAME(uprv_isInfinite)
#define uprv_isInvariantString U_ICU_ENTRY_POINT_RENAME(uprv_isInvariantString)
#define uprv_isInvariantUString U_ICU_ENTRY_POINT_RENAME(uprv_isInvariantUString)
#define uprv_isNaN U_ICU_ENTRY_POINT_RENAME(uprv_isNaN)
#define uprv_isNegativeInfinity U_ICU_ENTRY_POINT_RENAME(uprv_isNegativeInfinity)
#define uprv_isPositiveInfinity U_ICU_ENTRY_POINT_RENAME(uprv_isPositiveInfinity)
#define uprv_isRuleWhiteSpace U_ICU_ENTRY_POINT_RENAME(uprv_isRuleWhiteSpace)
#define uprv_itou U_ICU_ENTRY_POINT_RENAME(uprv_itou)
#define uprv_log U_ICU_ENTRY_POINT_RENAME(uprv_log)
#define uprv_malloc U_ICU_ENTRY_POINT_RENAME(uprv_malloc)
#define uprv_mapFile U_ICU_ENTRY_POINT_RENAME(uprv_mapFile)
#define uprv_max U_ICU_ENTRY_POINT_RENAME(uprv_max)
#define uprv_maxMantissa U_ICU_ENTRY_POINT_RENAME(uprv_maxMantissa)
#define uprv_maximumPtr U_ICU_ENTRY_POINT_RENAME(uprv_maximumPtr)
#define uprv_min U_ICU_ENTRY_POINT_RENAME(uprv_min)
#define uprv_modf U_ICU_ENTRY_POINT_RENAME(uprv_modf)
#define uprv_new_collIterate U_ICU_ENTRY_POINT_RENAME(uprv_new_collIterate)
#define uprv_openRuleWhiteSpaceSet U_ICU_ENTRY_POINT_RENAME(uprv_openRuleWhiteSpaceSet)
#define uprv_parseCurrency U_ICU_ENTRY_POINT_RENAME(uprv_parseCurrency)
#define uprv_pathIsAbsolute U_ICU_ENTRY_POINT_RENAME(uprv_pathIsAbsolute)
#define uprv_pow U_ICU_ENTRY_POINT_RENAME(uprv_pow)
#define uprv_pow10 U_ICU_ENTRY_POINT_RENAME(uprv_pow10)
#define uprv_realloc U_ICU_ENTRY_POINT_RENAME(uprv_realloc)
#define uprv_round U_ICU_ENTRY_POINT_RENAME(uprv_round)
#define uprv_sortArray U_ICU_ENTRY_POINT_RENAME(uprv_sortArray)
#define uprv_strCompare U_ICU_ENTRY_POINT_RENAME(uprv_strCompare)
#define uprv_strdup U_ICU_ENTRY_POINT_RENAME(uprv_strdup)
#define uprv_strndup U_ICU_ENTRY_POINT_RENAME(uprv_strndup)
#define uprv_syntaxError U_ICU_ENTRY_POINT_RENAME(uprv_syntaxError)
#define uprv_timezone U_ICU_ENTRY_POINT_RENAME(uprv_timezone)
#define uprv_toupper U_ICU_ENTRY_POINT_RENAME(uprv_toupper)
#define uprv_trunc U_ICU_ENTRY_POINT_RENAME(uprv_trunc)
#define uprv_tzname U_ICU_ENTRY_POINT_RENAME(uprv_tzname)
#define uprv_tzset U_ICU_ENTRY_POINT_RENAME(uprv_tzset)
#define uprv_uca_addAnElement U_ICU_ENTRY_POINT_RENAME(uprv_uca_addAnElement)
#define uprv_uca_assembleTable U_ICU_ENTRY_POINT_RENAME(uprv_uca_assembleTable)
#define uprv_uca_canonicalClosure U_ICU_ENTRY_POINT_RENAME(uprv_uca_canonicalClosure)
#define uprv_uca_closeTempTable U_ICU_ENTRY_POINT_RENAME(uprv_uca_closeTempTable)
#define uprv_uca_getCodePointFromRaw U_ICU_ENTRY_POINT_RENAME(uprv_uca_getCodePointFromRaw)
#define uprv_uca_getImplicitFromRaw U_ICU_ENTRY_POINT_RENAME(uprv_uca_getImplicitFromRaw)
#define uprv_uca_getRawFromCodePoint U_ICU_ENTRY_POINT_RENAME(uprv_uca_getRawFromCodePoint)
#define uprv_uca_getRawFromImplicit U_ICU_ENTRY_POINT_RENAME(uprv_uca_getRawFromImplicit)
#define uprv_uca_initImplicitConstants U_ICU_ENTRY_POINT_RENAME(uprv_uca_initImplicitConstants)
#define uprv_uca_initTempTable U_ICU_ENTRY_POINT_RENAME(uprv_uca_initTempTable)
#define uprv_uint16Comparator U_ICU_ENTRY_POINT_RENAME(uprv_uint16Comparator)
#define uprv_uint32Comparator U_ICU_ENTRY_POINT_RENAME(uprv_uint32Comparator)
#define uprv_unmapFile U_ICU_ENTRY_POINT_RENAME(uprv_unmapFile)
#define upvec_cloneArray U_ICU_ENTRY_POINT_RENAME(upvec_cloneArray)
#define upvec_close U_ICU_ENTRY_POINT_RENAME(upvec_close)
#define upvec_compact U_ICU_ENTRY_POINT_RENAME(upvec_compact)
#define upvec_compactToUTrie2Handler U_ICU_ENTRY_POINT_RENAME(upvec_compactToUTrie2Handler)
#define upvec_compactToUTrie2WithRowIndexes U_ICU_ENTRY_POINT_RENAME(upvec_compactToUTrie2WithRowIndexes)
#define upvec_compactToUTrieHandler U_ICU_ENTRY_POINT_RENAME(upvec_compactToUTrieHandler)
#define upvec_getArray U_ICU_ENTRY_POINT_RENAME(upvec_getArray)
#define upvec_getRow U_ICU_ENTRY_POINT_RENAME(upvec_getRow)
#define upvec_getValue U_ICU_ENTRY_POINT_RENAME(upvec_getValue)
#define upvec_open U_ICU_ENTRY_POINT_RENAME(upvec_open)
#define upvec_setValue U_ICU_ENTRY_POINT_RENAME(upvec_setValue)
#define uregex_appendReplacement U_ICU_ENTRY_POINT_RENAME(uregex_appendReplacement)
#define uregex_appendReplacementUText U_ICU_ENTRY_POINT_RENAME(uregex_appendReplacementUText)
#define uregex_appendTail U_ICU_ENTRY_POINT_RENAME(uregex_appendTail)
#define uregex_appendTailUText U_ICU_ENTRY_POINT_RENAME(uregex_appendTailUText)
#define uregex_clone U_ICU_ENTRY_POINT_RENAME(uregex_clone)
#define uregex_close U_ICU_ENTRY_POINT_RENAME(uregex_close)
#define uregex_end U_ICU_ENTRY_POINT_RENAME(uregex_end)
#define uregex_find U_ICU_ENTRY_POINT_RENAME(uregex_find)
#define uregex_findNext U_ICU_ENTRY_POINT_RENAME(uregex_findNext)
#define uregex_flags U_ICU_ENTRY_POINT_RENAME(uregex_flags)
#define uregex_getMatchCallback U_ICU_ENTRY_POINT_RENAME(uregex_getMatchCallback)
#define uregex_getStackLimit U_ICU_ENTRY_POINT_RENAME(uregex_getStackLimit)
#define uregex_getText U_ICU_ENTRY_POINT_RENAME(uregex_getText)
#define uregex_getTimeLimit U_ICU_ENTRY_POINT_RENAME(uregex_getTimeLimit)
#define uregex_getUText U_ICU_ENTRY_POINT_RENAME(uregex_getUText)
#define uregex_group U_ICU_ENTRY_POINT_RENAME(uregex_group)
#define uregex_groupCount U_ICU_ENTRY_POINT_RENAME(uregex_groupCount)
#define uregex_groupUText U_ICU_ENTRY_POINT_RENAME(uregex_groupUText)
#define uregex_hasAnchoringBounds U_ICU_ENTRY_POINT_RENAME(uregex_hasAnchoringBounds)
#define uregex_hasTransparentBounds U_ICU_ENTRY_POINT_RENAME(uregex_hasTransparentBounds)
#define uregex_hitEnd U_ICU_ENTRY_POINT_RENAME(uregex_hitEnd)
#define uregex_lookingAt U_ICU_ENTRY_POINT_RENAME(uregex_lookingAt)
#define uregex_matches U_ICU_ENTRY_POINT_RENAME(uregex_matches)
#define uregex_open U_ICU_ENTRY_POINT_RENAME(uregex_open)
#define uregex_openC U_ICU_ENTRY_POINT_RENAME(uregex_openC)
#define uregex_openUText U_ICU_ENTRY_POINT_RENAME(uregex_openUText)
#define uregex_pattern U_ICU_ENTRY_POINT_RENAME(uregex_pattern)
#define uregex_patternUText U_ICU_ENTRY_POINT_RENAME(uregex_patternUText)
#define uregex_regionEnd U_ICU_ENTRY_POINT_RENAME(uregex_regionEnd)
#define uregex_regionStart U_ICU_ENTRY_POINT_RENAME(uregex_regionStart)
#define uregex_replaceAll U_ICU_ENTRY_POINT_RENAME(uregex_replaceAll)
#define uregex_replaceAllUText U_ICU_ENTRY_POINT_RENAME(uregex_replaceAllUText)
#define uregex_replaceFirst U_ICU_ENTRY_POINT_RENAME(uregex_replaceFirst)
#define uregex_replaceFirstUText U_ICU_ENTRY_POINT_RENAME(uregex_replaceFirstUText)
#define uregex_requireEnd U_ICU_ENTRY_POINT_RENAME(uregex_requireEnd)
#define uregex_reset U_ICU_ENTRY_POINT_RENAME(uregex_reset)
#define uregex_setMatchCallback U_ICU_ENTRY_POINT_RENAME(uregex_setMatchCallback)
#define uregex_setRegion U_ICU_ENTRY_POINT_RENAME(uregex_setRegion)
#define uregex_setStackLimit U_ICU_ENTRY_POINT_RENAME(uregex_setStackLimit)
#define uregex_setText U_ICU_ENTRY_POINT_RENAME(uregex_setText)
#define uregex_setTimeLimit U_ICU_ENTRY_POINT_RENAME(uregex_setTimeLimit)
#define uregex_setUText U_ICU_ENTRY_POINT_RENAME(uregex_setUText)
#define uregex_split U_ICU_ENTRY_POINT_RENAME(uregex_split)
#define uregex_splitUText U_ICU_ENTRY_POINT_RENAME(uregex_splitUText)
#define uregex_start U_ICU_ENTRY_POINT_RENAME(uregex_start)
#define uregex_ucstr_unescape_charAt U_ICU_ENTRY_POINT_RENAME(uregex_ucstr_unescape_charAt)
#define uregex_useAnchoringBounds U_ICU_ENTRY_POINT_RENAME(uregex_useAnchoringBounds)
#define uregex_useTransparentBounds U_ICU_ENTRY_POINT_RENAME(uregex_useTransparentBounds)
#define uregex_utext_unescape_charAt U_ICU_ENTRY_POINT_RENAME(uregex_utext_unescape_charAt)
#define ures_close U_ICU_ENTRY_POINT_RENAME(ures_close)
#define ures_copyResb U_ICU_ENTRY_POINT_RENAME(ures_copyResb)
#define ures_countArrayItems U_ICU_ENTRY_POINT_RENAME(ures_countArrayItems)
#define ures_findResource U_ICU_ENTRY_POINT_RENAME(ures_findResource)
#define ures_findSubResource U_ICU_ENTRY_POINT_RENAME(ures_findSubResource)
#define ures_getBinary U_ICU_ENTRY_POINT_RENAME(ures_getBinary)
#define ures_getByIndex U_ICU_ENTRY_POINT_RENAME(ures_getByIndex)
#define ures_getByKey U_ICU_ENTRY_POINT_RENAME(ures_getByKey)
#define ures_getByKeyWithFallback U_ICU_ENTRY_POINT_RENAME(ures_getByKeyWithFallback)
#define ures_getFunctionalEquivalent U_ICU_ENTRY_POINT_RENAME(ures_getFunctionalEquivalent)
#define ures_getInt U_ICU_ENTRY_POINT_RENAME(ures_getInt)
#define ures_getIntVector U_ICU_ENTRY_POINT_RENAME(ures_getIntVector)
#define ures_getKey U_ICU_ENTRY_POINT_RENAME(ures_getKey)
#define ures_getKeywordValues U_ICU_ENTRY_POINT_RENAME(ures_getKeywordValues)
#define ures_getLocale U_ICU_ENTRY_POINT_RENAME(ures_getLocale)
#define ures_getLocaleByType U_ICU_ENTRY_POINT_RENAME(ures_getLocaleByType)
#define ures_getName U_ICU_ENTRY_POINT_RENAME(ures_getName)
#define ures_getNextResource U_ICU_ENTRY_POINT_RENAME(ures_getNextResource)
#define ures_getNextString U_ICU_ENTRY_POINT_RENAME(ures_getNextString)
#define ures_getSize U_ICU_ENTRY_POINT_RENAME(ures_getSize)
#define ures_getString U_ICU_ENTRY_POINT_RENAME(ures_getString)
#define ures_getStringByIndex U_ICU_ENTRY_POINT_RENAME(ures_getStringByIndex)
#define ures_getStringByKey U_ICU_ENTRY_POINT_RENAME(ures_getStringByKey)
#define ures_getStringByKeyWithFallback U_ICU_ENTRY_POINT_RENAME(ures_getStringByKeyWithFallback)
#define ures_getType U_ICU_ENTRY_POINT_RENAME(ures_getType)
#define ures_getUInt U_ICU_ENTRY_POINT_RENAME(ures_getUInt)
#define ures_getUTF8String U_ICU_ENTRY_POINT_RENAME(ures_getUTF8String)
#define ures_getUTF8StringByIndex U_ICU_ENTRY_POINT_RENAME(ures_getUTF8StringByIndex)
#define ures_getUTF8StringByKey U_ICU_ENTRY_POINT_RENAME(ures_getUTF8StringByKey)
#define ures_getVersion U_ICU_ENTRY_POINT_RENAME(ures_getVersion)
#define ures_getVersionByKey U_ICU_ENTRY_POINT_RENAME(ures_getVersionByKey)
#define ures_getVersionNumber U_ICU_ENTRY_POINT_RENAME(ures_getVersionNumber)
#define ures_hasNext U_ICU_ENTRY_POINT_RENAME(ures_hasNext)
#define ures_initStackObject U_ICU_ENTRY_POINT_RENAME(ures_initStackObject)
#define ures_open U_ICU_ENTRY_POINT_RENAME(ures_open)
#define ures_openAvailableLocales U_ICU_ENTRY_POINT_RENAME(ures_openAvailableLocales)
#define ures_openDirect U_ICU_ENTRY_POINT_RENAME(ures_openDirect)
#define ures_openFillIn U_ICU_ENTRY_POINT_RENAME(ures_openFillIn)
#define ures_openU U_ICU_ENTRY_POINT_RENAME(ures_openU)
#define ures_resetIterator U_ICU_ENTRY_POINT_RENAME(ures_resetIterator)
#define ures_swap U_ICU_ENTRY_POINT_RENAME(ures_swap)
#define uscript_closeRun U_ICU_ENTRY_POINT_RENAME(uscript_closeRun)
#define uscript_getCode U_ICU_ENTRY_POINT_RENAME(uscript_getCode)
#define uscript_getName U_ICU_ENTRY_POINT_RENAME(uscript_getName)
#define uscript_getScript U_ICU_ENTRY_POINT_RENAME(uscript_getScript)
#define uscript_getShortName U_ICU_ENTRY_POINT_RENAME(uscript_getShortName)
#define uscript_nextRun U_ICU_ENTRY_POINT_RENAME(uscript_nextRun)
#define uscript_openRun U_ICU_ENTRY_POINT_RENAME(uscript_openRun)
#define uscript_resetRun U_ICU_ENTRY_POINT_RENAME(uscript_resetRun)
#define uscript_setRunText U_ICU_ENTRY_POINT_RENAME(uscript_setRunText)
#define usearch_close U_ICU_ENTRY_POINT_RENAME(usearch_close)
#define usearch_first U_ICU_ENTRY_POINT_RENAME(usearch_first)
#define usearch_following U_ICU_ENTRY_POINT_RENAME(usearch_following)
#define usearch_getAttribute U_ICU_ENTRY_POINT_RENAME(usearch_getAttribute)
#define usearch_getBreakIterator U_ICU_ENTRY_POINT_RENAME(usearch_getBreakIterator)
#define usearch_getCollator U_ICU_ENTRY_POINT_RENAME(usearch_getCollator)
#define usearch_getMatchedLength U_ICU_ENTRY_POINT_RENAME(usearch_getMatchedLength)
#define usearch_getMatchedStart U_ICU_ENTRY_POINT_RENAME(usearch_getMatchedStart)
#define usearch_getMatchedText U_ICU_ENTRY_POINT_RENAME(usearch_getMatchedText)
#define usearch_getOffset U_ICU_ENTRY_POINT_RENAME(usearch_getOffset)
#define usearch_getPattern U_ICU_ENTRY_POINT_RENAME(usearch_getPattern)
#define usearch_getText U_ICU_ENTRY_POINT_RENAME(usearch_getText)
#define usearch_handleNextCanonical U_ICU_ENTRY_POINT_RENAME(usearch_handleNextCanonical)
#define usearch_handleNextExact U_ICU_ENTRY_POINT_RENAME(usearch_handleNextExact)
#define usearch_handlePreviousCanonical U_ICU_ENTRY_POINT_RENAME(usearch_handlePreviousCanonical)
#define usearch_handlePreviousExact U_ICU_ENTRY_POINT_RENAME(usearch_handlePreviousExact)
#define usearch_last U_ICU_ENTRY_POINT_RENAME(usearch_last)
#define usearch_next U_ICU_ENTRY_POINT_RENAME(usearch_next)
#define usearch_open U_ICU_ENTRY_POINT_RENAME(usearch_open)
#define usearch_openFromCollator U_ICU_ENTRY_POINT_RENAME(usearch_openFromCollator)
#define usearch_preceding U_ICU_ENTRY_POINT_RENAME(usearch_preceding)
#define usearch_previous U_ICU_ENTRY_POINT_RENAME(usearch_previous)
#define usearch_reset U_ICU_ENTRY_POINT_RENAME(usearch_reset)
#define usearch_search U_ICU_ENTRY_POINT_RENAME(usearch_search)
#define usearch_searchBackwards U_ICU_ENTRY_POINT_RENAME(usearch_searchBackwards)
#define usearch_setAttribute U_ICU_ENTRY_POINT_RENAME(usearch_setAttribute)
#define usearch_setBreakIterator U_ICU_ENTRY_POINT_RENAME(usearch_setBreakIterator)
#define usearch_setCollator U_ICU_ENTRY_POINT_RENAME(usearch_setCollator)
#define usearch_setOffset U_ICU_ENTRY_POINT_RENAME(usearch_setOffset)
#define usearch_setPattern U_ICU_ENTRY_POINT_RENAME(usearch_setPattern)
#define usearch_setText U_ICU_ENTRY_POINT_RENAME(usearch_setText)
#define uset_add U_ICU_ENTRY_POINT_RENAME(uset_add)
#define uset_addAll U_ICU_ENTRY_POINT_RENAME(uset_addAll)
#define uset_addAllCodePoints U_ICU_ENTRY_POINT_RENAME(uset_addAllCodePoints)
#define uset_addRange U_ICU_ENTRY_POINT_RENAME(uset_addRange)
#define uset_addString U_ICU_ENTRY_POINT_RENAME(uset_addString)
#define uset_applyIntPropertyValue U_ICU_ENTRY_POINT_RENAME(uset_applyIntPropertyValue)
#define uset_applyPattern U_ICU_ENTRY_POINT_RENAME(uset_applyPattern)
#define uset_applyPropertyAlias U_ICU_ENTRY_POINT_RENAME(uset_applyPropertyAlias)
#define uset_charAt U_ICU_ENTRY_POINT_RENAME(uset_charAt)
#define uset_clear U_ICU_ENTRY_POINT_RENAME(uset_clear)
#define uset_clone U_ICU_ENTRY_POINT_RENAME(uset_clone)
#define uset_cloneAsThawed U_ICU_ENTRY_POINT_RENAME(uset_cloneAsThawed)
#define uset_close U_ICU_ENTRY_POINT_RENAME(uset_close)
#define uset_closeOver U_ICU_ENTRY_POINT_RENAME(uset_closeOver)
#define uset_compact U_ICU_ENTRY_POINT_RENAME(uset_compact)
#define uset_complement U_ICU_ENTRY_POINT_RENAME(uset_complement)
#define uset_complementAll U_ICU_ENTRY_POINT_RENAME(uset_complementAll)
#define uset_contains U_ICU_ENTRY_POINT_RENAME(uset_contains)
#define uset_containsAll U_ICU_ENTRY_POINT_RENAME(uset_containsAll)
#define uset_containsAllCodePoints U_ICU_ENTRY_POINT_RENAME(uset_containsAllCodePoints)
#define uset_containsNone U_ICU_ENTRY_POINT_RENAME(uset_containsNone)
#define uset_containsRange U_ICU_ENTRY_POINT_RENAME(uset_containsRange)
#define uset_containsSome U_ICU_ENTRY_POINT_RENAME(uset_containsSome)
#define uset_containsString U_ICU_ENTRY_POINT_RENAME(uset_containsString)
#define uset_equals U_ICU_ENTRY_POINT_RENAME(uset_equals)
#define uset_freeze U_ICU_ENTRY_POINT_RENAME(uset_freeze)
#define uset_getItem U_ICU_ENTRY_POINT_RENAME(uset_getItem)
#define uset_getItemCount U_ICU_ENTRY_POINT_RENAME(uset_getItemCount)
#define uset_getSerializedRange U_ICU_ENTRY_POINT_RENAME(uset_getSerializedRange)
#define uset_getSerializedRangeCount U_ICU_ENTRY_POINT_RENAME(uset_getSerializedRangeCount)
#define uset_getSerializedSet U_ICU_ENTRY_POINT_RENAME(uset_getSerializedSet)
#define uset_indexOf U_ICU_ENTRY_POINT_RENAME(uset_indexOf)
#define uset_isEmpty U_ICU_ENTRY_POINT_RENAME(uset_isEmpty)
#define uset_isFrozen U_ICU_ENTRY_POINT_RENAME(uset_isFrozen)
#define uset_open U_ICU_ENTRY_POINT_RENAME(uset_open)
#define uset_openEmpty U_ICU_ENTRY_POINT_RENAME(uset_openEmpty)
#define uset_openPattern U_ICU_ENTRY_POINT_RENAME(uset_openPattern)
#define uset_openPatternOptions U_ICU_ENTRY_POINT_RENAME(uset_openPatternOptions)
#define uset_remove U_ICU_ENTRY_POINT_RENAME(uset_remove)
#define uset_removeAll U_ICU_ENTRY_POINT_RENAME(uset_removeAll)
#define uset_removeAllStrings U_ICU_ENTRY_POINT_RENAME(uset_removeAllStrings)
#define uset_removeRange U_ICU_ENTRY_POINT_RENAME(uset_removeRange)
#define uset_removeString U_ICU_ENTRY_POINT_RENAME(uset_removeString)
#define uset_resemblesPattern U_ICU_ENTRY_POINT_RENAME(uset_resemblesPattern)
#define uset_retain U_ICU_ENTRY_POINT_RENAME(uset_retain)
#define uset_retainAll U_ICU_ENTRY_POINT_RENAME(uset_retainAll)
#define uset_serialize U_ICU_ENTRY_POINT_RENAME(uset_serialize)
#define uset_serializedContains U_ICU_ENTRY_POINT_RENAME(uset_serializedContains)
#define uset_set U_ICU_ENTRY_POINT_RENAME(uset_set)
#define uset_setSerializedToOne U_ICU_ENTRY_POINT_RENAME(uset_setSerializedToOne)
#define uset_size U_ICU_ENTRY_POINT_RENAME(uset_size)
#define uset_span U_ICU_ENTRY_POINT_RENAME(uset_span)
#define uset_spanBack U_ICU_ENTRY_POINT_RENAME(uset_spanBack)
#define uset_spanBackUTF8 U_ICU_ENTRY_POINT_RENAME(uset_spanBackUTF8)
#define uset_spanUTF8 U_ICU_ENTRY_POINT_RENAME(uset_spanUTF8)
#define uset_toPattern U_ICU_ENTRY_POINT_RENAME(uset_toPattern)
#define uspoof_areConfusable U_ICU_ENTRY_POINT_RENAME(uspoof_areConfusable)
#define uspoof_areConfusableUTF8 U_ICU_ENTRY_POINT_RENAME(uspoof_areConfusableUTF8)
#define uspoof_areConfusableUnicodeString U_ICU_ENTRY_POINT_RENAME(uspoof_areConfusableUnicodeString)
#define uspoof_check U_ICU_ENTRY_POINT_RENAME(uspoof_check)
#define uspoof_checkUTF8 U_ICU_ENTRY_POINT_RENAME(uspoof_checkUTF8)
#define uspoof_checkUnicodeString U_ICU_ENTRY_POINT_RENAME(uspoof_checkUnicodeString)
#define uspoof_clone U_ICU_ENTRY_POINT_RENAME(uspoof_clone)
#define uspoof_close U_ICU_ENTRY_POINT_RENAME(uspoof_close)
#define uspoof_getAllowedChars U_ICU_ENTRY_POINT_RENAME(uspoof_getAllowedChars)
#define uspoof_getAllowedLocales U_ICU_ENTRY_POINT_RENAME(uspoof_getAllowedLocales)
#define uspoof_getAllowedUnicodeSet U_ICU_ENTRY_POINT_RENAME(uspoof_getAllowedUnicodeSet)
#define uspoof_getChecks U_ICU_ENTRY_POINT_RENAME(uspoof_getChecks)
#define uspoof_getSkeleton U_ICU_ENTRY_POINT_RENAME(uspoof_getSkeleton)
#define uspoof_getSkeletonUTF8 U_ICU_ENTRY_POINT_RENAME(uspoof_getSkeletonUTF8)
#define uspoof_getSkeletonUnicodeString U_ICU_ENTRY_POINT_RENAME(uspoof_getSkeletonUnicodeString)
#define uspoof_open U_ICU_ENTRY_POINT_RENAME(uspoof_open)
#define uspoof_openFromSerialized U_ICU_ENTRY_POINT_RENAME(uspoof_openFromSerialized)
#define uspoof_openFromSource U_ICU_ENTRY_POINT_RENAME(uspoof_openFromSource)
#define uspoof_serialize U_ICU_ENTRY_POINT_RENAME(uspoof_serialize)
#define uspoof_setAllowedChars U_ICU_ENTRY_POINT_RENAME(uspoof_setAllowedChars)
#define uspoof_setAllowedLocales U_ICU_ENTRY_POINT_RENAME(uspoof_setAllowedLocales)
#define uspoof_setAllowedUnicodeSet U_ICU_ENTRY_POINT_RENAME(uspoof_setAllowedUnicodeSet)
#define uspoof_setChecks U_ICU_ENTRY_POINT_RENAME(uspoof_setChecks)
#define uspoof_swap U_ICU_ENTRY_POINT_RENAME(uspoof_swap)
#define usprep_close U_ICU_ENTRY_POINT_RENAME(usprep_close)
#define usprep_open U_ICU_ENTRY_POINT_RENAME(usprep_open)
#define usprep_openByType U_ICU_ENTRY_POINT_RENAME(usprep_openByType)
#define usprep_prepare U_ICU_ENTRY_POINT_RENAME(usprep_prepare)
#define usprep_swap U_ICU_ENTRY_POINT_RENAME(usprep_swap)
#define ustr_foldCase U_ICU_ENTRY_POINT_RENAME(ustr_foldCase)
#define ustr_toLower U_ICU_ENTRY_POINT_RENAME(ustr_toLower)
#define ustr_toTitle U_ICU_ENTRY_POINT_RENAME(ustr_toTitle)
#define ustr_toUpper U_ICU_ENTRY_POINT_RENAME(ustr_toUpper)
#define utext_caseCompare U_ICU_ENTRY_POINT_RENAME(utext_caseCompare)
#define utext_caseCompareNativeLimit U_ICU_ENTRY_POINT_RENAME(utext_caseCompareNativeLimit)
#define utext_char32At U_ICU_ENTRY_POINT_RENAME(utext_char32At)
#define utext_clone U_ICU_ENTRY_POINT_RENAME(utext_clone)
#define utext_close U_ICU_ENTRY_POINT_RENAME(utext_close)
#define utext_compare U_ICU_ENTRY_POINT_RENAME(utext_compare)
#define utext_compareNativeLimit U_ICU_ENTRY_POINT_RENAME(utext_compareNativeLimit)
#define utext_copy U_ICU_ENTRY_POINT_RENAME(utext_copy)
#define utext_current32 U_ICU_ENTRY_POINT_RENAME(utext_current32)
#define utext_equals U_ICU_ENTRY_POINT_RENAME(utext_equals)
#define utext_extract U_ICU_ENTRY_POINT_RENAME(utext_extract)
#define utext_freeze U_ICU_ENTRY_POINT_RENAME(utext_freeze)
#define utext_getNativeIndex U_ICU_ENTRY_POINT_RENAME(utext_getNativeIndex)
#define utext_getPreviousNativeIndex U_ICU_ENTRY_POINT_RENAME(utext_getPreviousNativeIndex)
#define utext_hasMetaData U_ICU_ENTRY_POINT_RENAME(utext_hasMetaData)
#define utext_isLengthExpensive U_ICU_ENTRY_POINT_RENAME(utext_isLengthExpensive)
#define utext_isWritable U_ICU_ENTRY_POINT_RENAME(utext_isWritable)
#define utext_moveIndex32 U_ICU_ENTRY_POINT_RENAME(utext_moveIndex32)
#define utext_nativeLength U_ICU_ENTRY_POINT_RENAME(utext_nativeLength)
#define utext_next32 U_ICU_ENTRY_POINT_RENAME(utext_next32)
#define utext_next32From U_ICU_ENTRY_POINT_RENAME(utext_next32From)
#define utext_openCharacterIterator U_ICU_ENTRY_POINT_RENAME(utext_openCharacterIterator)
#define utext_openConstUnicodeString U_ICU_ENTRY_POINT_RENAME(utext_openConstUnicodeString)
#define utext_openReplaceable U_ICU_ENTRY_POINT_RENAME(utext_openReplaceable)
#define utext_openUChars U_ICU_ENTRY_POINT_RENAME(utext_openUChars)
#define utext_openUTF8 U_ICU_ENTRY_POINT_RENAME(utext_openUTF8)
#define utext_openUnicodeString U_ICU_ENTRY_POINT_RENAME(utext_openUnicodeString)
#define utext_previous32 U_ICU_ENTRY_POINT_RENAME(utext_previous32)
#define utext_previous32From U_ICU_ENTRY_POINT_RENAME(utext_previous32From)
#define utext_replace U_ICU_ENTRY_POINT_RENAME(utext_replace)
#define utext_setNativeIndex U_ICU_ENTRY_POINT_RENAME(utext_setNativeIndex)
#define utext_setup U_ICU_ENTRY_POINT_RENAME(utext_setup)
#define utf8_appendCharSafeBody U_ICU_ENTRY_POINT_RENAME(utf8_appendCharSafeBody)
#define utf8_back1SafeBody U_ICU_ENTRY_POINT_RENAME(utf8_back1SafeBody)
#define utf8_countTrailBytes U_ICU_ENTRY_POINT_RENAME(utf8_countTrailBytes)
#define utf8_nextCharSafeBody U_ICU_ENTRY_POINT_RENAME(utf8_nextCharSafeBody)
#define utf8_prevCharSafeBody U_ICU_ENTRY_POINT_RENAME(utf8_prevCharSafeBody)
#define utmscale_fromInt64 U_ICU_ENTRY_POINT_RENAME(utmscale_fromInt64)
#define utmscale_getTimeScaleValue U_ICU_ENTRY_POINT_RENAME(utmscale_getTimeScaleValue)
#define utmscale_toInt64 U_ICU_ENTRY_POINT_RENAME(utmscale_toInt64)
#define utrace_cleanup U_ICU_ENTRY_POINT_RENAME(utrace_cleanup)
#define utrace_data U_ICU_ENTRY_POINT_RENAME(utrace_data)
#define utrace_entry U_ICU_ENTRY_POINT_RENAME(utrace_entry)
#define utrace_exit U_ICU_ENTRY_POINT_RENAME(utrace_exit)
#define utrace_format U_ICU_ENTRY_POINT_RENAME(utrace_format)
#define utrace_functionName U_ICU_ENTRY_POINT_RENAME(utrace_functionName)
#define utrace_getFunctions U_ICU_ENTRY_POINT_RENAME(utrace_getFunctions)
#define utrace_getLevel U_ICU_ENTRY_POINT_RENAME(utrace_getLevel)
#define utrace_level U_ICU_ENTRY_POINT_RENAME(utrace_level)
#define utrace_setFunctions U_ICU_ENTRY_POINT_RENAME(utrace_setFunctions)
#define utrace_setLevel U_ICU_ENTRY_POINT_RENAME(utrace_setLevel)
#define utrace_vformat U_ICU_ENTRY_POINT_RENAME(utrace_vformat)
#define utrans_clone U_ICU_ENTRY_POINT_RENAME(utrans_clone)
#define utrans_close U_ICU_ENTRY_POINT_RENAME(utrans_close)
#define utrans_countAvailableIDs U_ICU_ENTRY_POINT_RENAME(utrans_countAvailableIDs)
#define utrans_getAvailableID U_ICU_ENTRY_POINT_RENAME(utrans_getAvailableID)
#define utrans_getID U_ICU_ENTRY_POINT_RENAME(utrans_getID)
#define utrans_getUnicodeID U_ICU_ENTRY_POINT_RENAME(utrans_getUnicodeID)
#define utrans_open U_ICU_ENTRY_POINT_RENAME(utrans_open)
#define utrans_openIDs U_ICU_ENTRY_POINT_RENAME(utrans_openIDs)
#define utrans_openInverse U_ICU_ENTRY_POINT_RENAME(utrans_openInverse)
#define utrans_openU U_ICU_ENTRY_POINT_RENAME(utrans_openU)
#define utrans_register U_ICU_ENTRY_POINT_RENAME(utrans_register)
#define utrans_rep_caseContextIterator U_ICU_ENTRY_POINT_RENAME(utrans_rep_caseContextIterator)
#define utrans_setFilter U_ICU_ENTRY_POINT_RENAME(utrans_setFilter)
#define utrans_stripRules U_ICU_ENTRY_POINT_RENAME(utrans_stripRules)
#define utrans_trans U_ICU_ENTRY_POINT_RENAME(utrans_trans)
#define utrans_transIncremental U_ICU_ENTRY_POINT_RENAME(utrans_transIncremental)
#define utrans_transIncrementalUChars U_ICU_ENTRY_POINT_RENAME(utrans_transIncrementalUChars)
#define utrans_transUChars U_ICU_ENTRY_POINT_RENAME(utrans_transUChars)
#define utrans_transliterator_cleanup U_ICU_ENTRY_POINT_RENAME(utrans_transliterator_cleanup)
#define utrans_unregister U_ICU_ENTRY_POINT_RENAME(utrans_unregister)
#define utrans_unregisterID U_ICU_ENTRY_POINT_RENAME(utrans_unregisterID)
#define utrie2_clone U_ICU_ENTRY_POINT_RENAME(utrie2_clone)
#define utrie2_cloneAsThawed U_ICU_ENTRY_POINT_RENAME(utrie2_cloneAsThawed)
#define utrie2_close U_ICU_ENTRY_POINT_RENAME(utrie2_close)
#define utrie2_enum U_ICU_ENTRY_POINT_RENAME(utrie2_enum)
#define utrie2_enumForLeadSurrogate U_ICU_ENTRY_POINT_RENAME(utrie2_enumForLeadSurrogate)
#define utrie2_freeze U_ICU_ENTRY_POINT_RENAME(utrie2_freeze)
#define utrie2_fromUTrie U_ICU_ENTRY_POINT_RENAME(utrie2_fromUTrie)
#define utrie2_get32 U_ICU_ENTRY_POINT_RENAME(utrie2_get32)
#define utrie2_get32FromLeadSurrogateCodeUnit U_ICU_ENTRY_POINT_RENAME(utrie2_get32FromLeadSurrogateCodeUnit)
#define utrie2_getVersion U_ICU_ENTRY_POINT_RENAME(utrie2_getVersion)
#define utrie2_internalU8NextIndex U_ICU_ENTRY_POINT_RENAME(utrie2_internalU8NextIndex)
#define utrie2_internalU8PrevIndex U_ICU_ENTRY_POINT_RENAME(utrie2_internalU8PrevIndex)
#define utrie2_isFrozen U_ICU_ENTRY_POINT_RENAME(utrie2_isFrozen)
#define utrie2_open U_ICU_ENTRY_POINT_RENAME(utrie2_open)
#define utrie2_openDummy U_ICU_ENTRY_POINT_RENAME(utrie2_openDummy)
#define utrie2_openFromSerialized U_ICU_ENTRY_POINT_RENAME(utrie2_openFromSerialized)
#define utrie2_serialize U_ICU_ENTRY_POINT_RENAME(utrie2_serialize)
#define utrie2_set32 U_ICU_ENTRY_POINT_RENAME(utrie2_set32)
#define utrie2_set32ForLeadSurrogateCodeUnit U_ICU_ENTRY_POINT_RENAME(utrie2_set32ForLeadSurrogateCodeUnit)
#define utrie2_setRange32 U_ICU_ENTRY_POINT_RENAME(utrie2_setRange32)
#define utrie2_swap U_ICU_ENTRY_POINT_RENAME(utrie2_swap)
#define utrie_clone U_ICU_ENTRY_POINT_RENAME(utrie_clone)
#define utrie_close U_ICU_ENTRY_POINT_RENAME(utrie_close)
#define utrie_defaultGetFoldingOffset U_ICU_ENTRY_POINT_RENAME(utrie_defaultGetFoldingOffset)
#define utrie_enum U_ICU_ENTRY_POINT_RENAME(utrie_enum)
#define utrie_get32 U_ICU_ENTRY_POINT_RENAME(utrie_get32)
#define utrie_getData U_ICU_ENTRY_POINT_RENAME(utrie_getData)
#define utrie_open U_ICU_ENTRY_POINT_RENAME(utrie_open)
#define utrie_serialize U_ICU_ENTRY_POINT_RENAME(utrie_serialize)
#define utrie_set32 U_ICU_ENTRY_POINT_RENAME(utrie_set32)
#define utrie_setRange32 U_ICU_ENTRY_POINT_RENAME(utrie_setRange32)
#define utrie_swap U_ICU_ENTRY_POINT_RENAME(utrie_swap)
#define utrie_unserialize U_ICU_ENTRY_POINT_RENAME(utrie_unserialize)
#define utrie_unserializeDummy U_ICU_ENTRY_POINT_RENAME(utrie_unserializeDummy)
#define vzone_clone U_ICU_ENTRY_POINT_RENAME(vzone_clone)
#define vzone_close U_ICU_ENTRY_POINT_RENAME(vzone_close)
#define vzone_countTransitionRules U_ICU_ENTRY_POINT_RENAME(vzone_countTransitionRules)
#define vzone_equals U_ICU_ENTRY_POINT_RENAME(vzone_equals)
#define vzone_getDynamicClassID U_ICU_ENTRY_POINT_RENAME(vzone_getDynamicClassID)
#define vzone_getLastModified U_ICU_ENTRY_POINT_RENAME(vzone_getLastModified)
#define vzone_getNextTransition U_ICU_ENTRY_POINT_RENAME(vzone_getNextTransition)
#define vzone_getOffset U_ICU_ENTRY_POINT_RENAME(vzone_getOffset)
#define vzone_getOffset2 U_ICU_ENTRY_POINT_RENAME(vzone_getOffset2)
#define vzone_getOffset3 U_ICU_ENTRY_POINT_RENAME(vzone_getOffset3)
#define vzone_getPreviousTransition U_ICU_ENTRY_POINT_RENAME(vzone_getPreviousTransition)
#define vzone_getRawOffset U_ICU_ENTRY_POINT_RENAME(vzone_getRawOffset)
#define vzone_getStaticClassID U_ICU_ENTRY_POINT_RENAME(vzone_getStaticClassID)
#define vzone_getTZURL U_ICU_ENTRY_POINT_RENAME(vzone_getTZURL)
#define vzone_hasSameRules U_ICU_ENTRY_POINT_RENAME(vzone_hasSameRules)
#define vzone_inDaylightTime U_ICU_ENTRY_POINT_RENAME(vzone_inDaylightTime)
#define vzone_openData U_ICU_ENTRY_POINT_RENAME(vzone_openData)
#define vzone_openID U_ICU_ENTRY_POINT_RENAME(vzone_openID)
#define vzone_setLastModified U_ICU_ENTRY_POINT_RENAME(vzone_setLastModified)
#define vzone_setRawOffset U_ICU_ENTRY_POINT_RENAME(vzone_setRawOffset)
#define vzone_setTZURL U_ICU_ENTRY_POINT_RENAME(vzone_setTZURL)
#define vzone_useDaylightTime U_ICU_ENTRY_POINT_RENAME(vzone_useDaylightTime)
#define vzone_write U_ICU_ENTRY_POINT_RENAME(vzone_write)
#define vzone_writeFromStart U_ICU_ENTRY_POINT_RENAME(vzone_writeFromStart)
#define vzone_writeSimple U_ICU_ENTRY_POINT_RENAME(vzone_writeSimple)
#define zrule_close U_ICU_ENTRY_POINT_RENAME(zrule_close)
#define zrule_equals U_ICU_ENTRY_POINT_RENAME(zrule_equals)
#define zrule_getDSTSavings U_ICU_ENTRY_POINT_RENAME(zrule_getDSTSavings)
#define zrule_getName U_ICU_ENTRY_POINT_RENAME(zrule_getName)
#define zrule_getRawOffset U_ICU_ENTRY_POINT_RENAME(zrule_getRawOffset)
#define zrule_isEquivalentTo U_ICU_ENTRY_POINT_RENAME(zrule_isEquivalentTo)
#define ztrans_adoptFrom U_ICU_ENTRY_POINT_RENAME(ztrans_adoptFrom)
#define ztrans_adoptTo U_ICU_ENTRY_POINT_RENAME(ztrans_adoptTo)
#define ztrans_clone U_ICU_ENTRY_POINT_RENAME(ztrans_clone)
#define ztrans_close U_ICU_ENTRY_POINT_RENAME(ztrans_close)
#define ztrans_equals U_ICU_ENTRY_POINT_RENAME(ztrans_equals)
#define ztrans_getDynamicClassID U_ICU_ENTRY_POINT_RENAME(ztrans_getDynamicClassID)
#define ztrans_getFrom U_ICU_ENTRY_POINT_RENAME(ztrans_getFrom)
#define ztrans_getStaticClassID U_ICU_ENTRY_POINT_RENAME(ztrans_getStaticClassID)
#define ztrans_getTime U_ICU_ENTRY_POINT_RENAME(ztrans_getTime)
#define ztrans_getTo U_ICU_ENTRY_POINT_RENAME(ztrans_getTo)
#define ztrans_open U_ICU_ENTRY_POINT_RENAME(ztrans_open)
#define ztrans_openEmpty U_ICU_ENTRY_POINT_RENAME(ztrans_openEmpty)
#define ztrans_setFrom U_ICU_ENTRY_POINT_RENAME(ztrans_setFrom)
#define ztrans_setTime U_ICU_ENTRY_POINT_RENAME(ztrans_setTime)
#define ztrans_setTo U_ICU_ENTRY_POINT_RENAME(ztrans_setTo)


/* C++ class names renaming defines */

#ifdef XP_CPLUSPLUS
#if !U_HAVE_NAMESPACE

#define AbsoluteValueSubstitution U_ICU_ENTRY_POINT_RENAME(AbsoluteValueSubstitution)
#define AlternateSubstitutionSubtable U_ICU_ENTRY_POINT_RENAME(AlternateSubstitutionSubtable)
#define AnchorTable U_ICU_ENTRY_POINT_RENAME(AnchorTable)
#define AndConstraint U_ICU_ENTRY_POINT_RENAME(AndConstraint)
#define AnnualTimeZoneRule U_ICU_ENTRY_POINT_RENAME(AnnualTimeZoneRule)
#define AnyTransliterator U_ICU_ENTRY_POINT_RENAME(AnyTransliterator)
#define ArabicOpenTypeLayoutEngine U_ICU_ENTRY_POINT_RENAME(ArabicOpenTypeLayoutEngine)
#define ArabicShaping U_ICU_ENTRY_POINT_RENAME(ArabicShaping)
#define ArgExtractor U_ICU_ENTRY_POINT_RENAME(ArgExtractor)
#define BMPSet U_ICU_ENTRY_POINT_RENAME(BMPSet)
#define BackwardUTrie2StringIterator U_ICU_ENTRY_POINT_RENAME(BackwardUTrie2StringIterator)
#define BadCharacterTable U_ICU_ENTRY_POINT_RENAME(BadCharacterTable)
#define BasicCalendarFactory U_ICU_ENTRY_POINT_RENAME(BasicCalendarFactory)
#define BasicTimeZone U_ICU_ENTRY_POINT_RENAME(BasicTimeZone)
#define BinarySearchLookupTable U_ICU_ENTRY_POINT_RENAME(BinarySearchLookupTable)
#define BoyerMooreSearch U_ICU_ENTRY_POINT_RENAME(BoyerMooreSearch)
#define BreakIterator U_ICU_ENTRY_POINT_RENAME(BreakIterator)
#define BreakTransliterator U_ICU_ENTRY_POINT_RENAME(BreakTransliterator)
#define BuddhistCalendar U_ICU_ENTRY_POINT_RENAME(BuddhistCalendar)
#define BuildCompactTrieHorizontalNode U_ICU_ENTRY_POINT_RENAME(BuildCompactTrieHorizontalNode)
#define BuildCompactTrieNode U_ICU_ENTRY_POINT_RENAME(BuildCompactTrieNode)
#define BuildCompactTrieVerticalNode U_ICU_ENTRY_POINT_RENAME(BuildCompactTrieVerticalNode)
#define BuilderScriptSet U_ICU_ENTRY_POINT_RENAME(BuilderScriptSet)
#define ByteSink U_ICU_ENTRY_POINT_RENAME(ByteSink)
#define CEBuffer U_ICU_ENTRY_POINT_RENAME(CEBuffer)
#define CECalendar U_ICU_ENTRY_POINT_RENAME(CECalendar)
#define CEList U_ICU_ENTRY_POINT_RENAME(CEList)
#define CEToStringsMap U_ICU_ENTRY_POINT_RENAME(CEToStringsMap)
#define CFactory U_ICU_ENTRY_POINT_RENAME(CFactory)
#define Calendar U_ICU_ENTRY_POINT_RENAME(Calendar)
#define CalendarAstronomer U_ICU_ENTRY_POINT_RENAME(CalendarAstronomer)
#define CalendarCache U_ICU_ENTRY_POINT_RENAME(CalendarCache)
#define CalendarData U_ICU_ENTRY_POINT_RENAME(CalendarData)
#define CalendarService U_ICU_ENTRY_POINT_RENAME(CalendarService)
#define CanonMarkFilter U_ICU_ENTRY_POINT_RENAME(CanonMarkFilter)
#define CanonShaping U_ICU_ENTRY_POINT_RENAME(CanonShaping)
#define CanonicalIterator U_ICU_ENTRY_POINT_RENAME(CanonicalIterator)
#define CaseMapTransliterator U_ICU_ENTRY_POINT_RENAME(CaseMapTransliterator)
#define ChainingContextualSubstitutionFormat1Subtable U_ICU_ENTRY_POINT_RENAME(ChainingContextualSubstitutionFormat1Subtable)
#define ChainingContextualSubstitutionFormat2Subtable U_ICU_ENTRY_POINT_RENAME(ChainingContextualSubstitutionFormat2Subtable)
#define ChainingContextualSubstitutionFormat3Subtable U_ICU_ENTRY_POINT_RENAME(ChainingContextualSubstitutionFormat3Subtable)
#define ChainingContextualSubstitutionSubtable U_ICU_ENTRY_POINT_RENAME(ChainingContextualSubstitutionSubtable)
#define CharSubstitutionFilter U_ICU_ENTRY_POINT_RENAME(CharSubstitutionFilter)
#define CharacterIterator U_ICU_ENTRY_POINT_RENAME(CharacterIterator)
#define CharacterNode U_ICU_ENTRY_POINT_RENAME(CharacterNode)
#define CharsetDetector U_ICU_ENTRY_POINT_RENAME(CharsetDetector)
#define CharsetMatch U_ICU_ENTRY_POINT_RENAME(CharsetMatch)
#define CharsetRecog_2022 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_2022)
#define CharsetRecog_2022CN U_ICU_ENTRY_POINT_RENAME(CharsetRecog_2022CN)
#define CharsetRecog_2022JP U_ICU_ENTRY_POINT_RENAME(CharsetRecog_2022JP)
#define CharsetRecog_2022KR U_ICU_ENTRY_POINT_RENAME(CharsetRecog_2022KR)
#define CharsetRecog_8859_1 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1)
#define CharsetRecog_8859_1_da U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_da)
#define CharsetRecog_8859_1_de U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_de)
#define CharsetRecog_8859_1_en U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_en)
#define CharsetRecog_8859_1_es U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_es)
#define CharsetRecog_8859_1_fr U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_fr)
#define CharsetRecog_8859_1_it U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_it)
#define CharsetRecog_8859_1_nl U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_nl)
#define CharsetRecog_8859_1_no U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_no)
#define CharsetRecog_8859_1_pt U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_pt)
#define CharsetRecog_8859_1_sv U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_1_sv)
#define CharsetRecog_8859_2 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_2)
#define CharsetRecog_8859_2_cs U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_2_cs)
#define CharsetRecog_8859_2_hu U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_2_hu)
#define CharsetRecog_8859_2_pl U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_2_pl)
#define CharsetRecog_8859_2_ro U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_2_ro)
#define CharsetRecog_8859_5 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_5)
#define CharsetRecog_8859_5_ru U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_5_ru)
#define CharsetRecog_8859_6 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_6)
#define CharsetRecog_8859_6_ar U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_6_ar)
#define CharsetRecog_8859_7 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_7)
#define CharsetRecog_8859_7_el U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_7_el)
#define CharsetRecog_8859_8 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_8)
#define CharsetRecog_8859_8_I_he U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_8_I_he)
#define CharsetRecog_8859_8_he U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_8_he)
#define CharsetRecog_8859_9 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_9)
#define CharsetRecog_8859_9_tr U_ICU_ENTRY_POINT_RENAME(CharsetRecog_8859_9_tr)
#define CharsetRecog_IBM420_ar U_ICU_ENTRY_POINT_RENAME(CharsetRecog_IBM420_ar)
#define CharsetRecog_IBM420_ar_ltr U_ICU_ENTRY_POINT_RENAME(CharsetRecog_IBM420_ar_ltr)
#define CharsetRecog_IBM420_ar_rtl U_ICU_ENTRY_POINT_RENAME(CharsetRecog_IBM420_ar_rtl)
#define CharsetRecog_IBM424_he U_ICU_ENTRY_POINT_RENAME(CharsetRecog_IBM424_he)
#define CharsetRecog_IBM424_he_ltr U_ICU_ENTRY_POINT_RENAME(CharsetRecog_IBM424_he_ltr)
#define CharsetRecog_IBM424_he_rtl U_ICU_ENTRY_POINT_RENAME(CharsetRecog_IBM424_he_rtl)
#define CharsetRecog_KOI8_R U_ICU_ENTRY_POINT_RENAME(CharsetRecog_KOI8_R)
#define CharsetRecog_UTF8 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_UTF8)
#define CharsetRecog_UTF_16_BE U_ICU_ENTRY_POINT_RENAME(CharsetRecog_UTF_16_BE)
#define CharsetRecog_UTF_16_LE U_ICU_ENTRY_POINT_RENAME(CharsetRecog_UTF_16_LE)
#define CharsetRecog_UTF_32 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_UTF_32)
#define CharsetRecog_UTF_32_BE U_ICU_ENTRY_POINT_RENAME(CharsetRecog_UTF_32_BE)
#define CharsetRecog_UTF_32_LE U_ICU_ENTRY_POINT_RENAME(CharsetRecog_UTF_32_LE)
#define CharsetRecog_Unicode U_ICU_ENTRY_POINT_RENAME(CharsetRecog_Unicode)
#define CharsetRecog_big5 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_big5)
#define CharsetRecog_euc U_ICU_ENTRY_POINT_RENAME(CharsetRecog_euc)
#define CharsetRecog_euc_jp U_ICU_ENTRY_POINT_RENAME(CharsetRecog_euc_jp)
#define CharsetRecog_euc_kr U_ICU_ENTRY_POINT_RENAME(CharsetRecog_euc_kr)
#define CharsetRecog_gb_18030 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_gb_18030)
#define CharsetRecog_mbcs U_ICU_ENTRY_POINT_RENAME(CharsetRecog_mbcs)
#define CharsetRecog_sbcs U_ICU_ENTRY_POINT_RENAME(CharsetRecog_sbcs)
#define CharsetRecog_sjis U_ICU_ENTRY_POINT_RENAME(CharsetRecog_sjis)
#define CharsetRecog_windows_1251 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_windows_1251)
#define CharsetRecog_windows_1256 U_ICU_ENTRY_POINT_RENAME(CharsetRecog_windows_1256)
#define CharsetRecognizer U_ICU_ENTRY_POINT_RENAME(CharsetRecognizer)
#define CheckedArrayByteSink U_ICU_ENTRY_POINT_RENAME(CheckedArrayByteSink)
#define ChineseCalendar U_ICU_ENTRY_POINT_RENAME(ChineseCalendar)
#define ChoiceFormat U_ICU_ENTRY_POINT_RENAME(ChoiceFormat)
#define ClassDefFormat1Table U_ICU_ENTRY_POINT_RENAME(ClassDefFormat1Table)
#define ClassDefFormat2Table U_ICU_ENTRY_POINT_RENAME(ClassDefFormat2Table)
#define ClassDefinitionTable U_ICU_ENTRY_POINT_RENAME(ClassDefinitionTable)
#define ClockMath U_ICU_ENTRY_POINT_RENAME(ClockMath)
#define CollData U_ICU_ENTRY_POINT_RENAME(CollData)
#define CollDataCache U_ICU_ENTRY_POINT_RENAME(CollDataCache)
#define CollDataCacheEntry U_ICU_ENTRY_POINT_RENAME(CollDataCacheEntry)
#define CollationElementIterator U_ICU_ENTRY_POINT_RENAME(CollationElementIterator)
#define CollationKey U_ICU_ENTRY_POINT_RENAME(CollationKey)
#define CollationLocaleListEnumeration U_ICU_ENTRY_POINT_RENAME(CollationLocaleListEnumeration)
#define Collator U_ICU_ENTRY_POINT_RENAME(Collator)
#define CollatorFactory U_ICU_ENTRY_POINT_RENAME(CollatorFactory)
#define CompactTrieDictionary U_ICU_ENTRY_POINT_RENAME(CompactTrieDictionary)
#define CompactTrieEnumeration U_ICU_ENTRY_POINT_RENAME(CompactTrieEnumeration)
#define ComposeNormalizer2 U_ICU_ENTRY_POINT_RENAME(ComposeNormalizer2)
#define CompoundTransliterator U_ICU_ENTRY_POINT_RENAME(CompoundTransliterator)
#define ConfusabledataBuilder U_ICU_ENTRY_POINT_RENAME(ConfusabledataBuilder)
#define ContextualGlyphSubstitutionProcessor U_ICU_ENTRY_POINT_RENAME(ContextualGlyphSubstitutionProcessor)
#define ContextualSubstitutionBase U_ICU_ENTRY_POINT_RENAME(ContextualSubstitutionBase)
#define ContextualSubstitutionFormat1Subtable U_ICU_ENTRY_POINT_RENAME(ContextualSubstitutionFormat1Subtable)
#define ContextualSubstitutionFormat2Subtable U_ICU_ENTRY_POINT_RENAME(ContextualSubstitutionFormat2Subtable)
#define ContextualSubstitutionFormat3Subtable U_ICU_ENTRY_POINT_RENAME(ContextualSubstitutionFormat3Subtable)
#define ContextualSubstitutionSubtable U_ICU_ENTRY_POINT_RENAME(ContextualSubstitutionSubtable)
#define CopticCalendar U_ICU_ENTRY_POINT_RENAME(CopticCalendar)
#define CoverageFormat1Table U_ICU_ENTRY_POINT_RENAME(CoverageFormat1Table)
#define CoverageFormat2Table U_ICU_ENTRY_POINT_RENAME(CoverageFormat2Table)
#define CoverageTable U_ICU_ENTRY_POINT_RENAME(CoverageTable)
#define CurrencyAmount U_ICU_ENTRY_POINT_RENAME(CurrencyAmount)
#define CurrencyFormat U_ICU_ENTRY_POINT_RENAME(CurrencyFormat)
#define CurrencyPluralInfo U_ICU_ENTRY_POINT_RENAME(CurrencyPluralInfo)
#define CurrencyUnit U_ICU_ENTRY_POINT_RENAME(CurrencyUnit)
#define CursiveAttachmentSubtable U_ICU_ENTRY_POINT_RENAME(CursiveAttachmentSubtable)
#define DTRedundantEnumeration U_ICU_ENTRY_POINT_RENAME(DTRedundantEnumeration)
#define DTSkeletonEnumeration U_ICU_ENTRY_POINT_RENAME(DTSkeletonEnumeration)
#define DateFormat U_ICU_ENTRY_POINT_RENAME(DateFormat)
#define DateFormatSymbols U_ICU_ENTRY_POINT_RENAME(DateFormatSymbols)
#define DateInterval U_ICU_ENTRY_POINT_RENAME(DateInterval)
#define DateIntervalFormat U_ICU_ENTRY_POINT_RENAME(DateIntervalFormat)
#define DateIntervalInfo U_ICU_ENTRY_POINT_RENAME(DateIntervalInfo)
#define DateTimeMatcher U_ICU_ENTRY_POINT_RENAME(DateTimeMatcher)
#define DateTimePatternGenerator U_ICU_ENTRY_POINT_RENAME(DateTimePatternGenerator)
#define DateTimeRule U_ICU_ENTRY_POINT_RENAME(DateTimeRule)
#define DecimalFormat U_ICU_ENTRY_POINT_RENAME(DecimalFormat)
#define DecimalFormatSymbols U_ICU_ENTRY_POINT_RENAME(DecimalFormatSymbols)
#define DecimalNumberString U_ICU_ENTRY_POINT_RENAME(DecimalNumberString)
#define DecomposeNormalizer2 U_ICU_ENTRY_POINT_RENAME(DecomposeNormalizer2)
#define DefaultCalendarFactory U_ICU_ENTRY_POINT_RENAME(DefaultCalendarFactory)
#define DefaultCharMapper U_ICU_ENTRY_POINT_RENAME(DefaultCharMapper)
#define DeviceTable U_ICU_ENTRY_POINT_RENAME(DeviceTable)
#define DictionaryBreakEngine U_ICU_ENTRY_POINT_RENAME(DictionaryBreakEngine)
#define DigitList U_ICU_ENTRY_POINT_RENAME(DigitList)
#define DistanceInfo U_ICU_ENTRY_POINT_RENAME(DistanceInfo)
#define EnumToOffset U_ICU_ENTRY_POINT_RENAME(EnumToOffset)
#define ErrorCode U_ICU_ENTRY_POINT_RENAME(ErrorCode)
#define EscapeTransliterator U_ICU_ENTRY_POINT_RENAME(EscapeTransliterator)
#define EthiopicCalendar U_ICU_ENTRY_POINT_RENAME(EthiopicCalendar)
#define EventListener U_ICU_ENTRY_POINT_RENAME(EventListener)
#define ExtensionSubtable U_ICU_ENTRY_POINT_RENAME(ExtensionSubtable)
#define FCDNormalizer2 U_ICU_ENTRY_POINT_RENAME(FCDNormalizer2)
#define FCDTrieSingleton U_ICU_ENTRY_POINT_RENAME(FCDTrieSingleton)
#define FeatureListTable U_ICU_ENTRY_POINT_RENAME(FeatureListTable)
#define FieldPosition U_ICU_ENTRY_POINT_RENAME(FieldPosition)
#define FieldPositionHandler U_ICU_ENTRY_POINT_RENAME(FieldPositionHandler)
#define FieldPositionIterator U_ICU_ENTRY_POINT_RENAME(FieldPositionIterator)
#define FieldPositionIteratorHandler U_ICU_ENTRY_POINT_RENAME(FieldPositionIteratorHandler)
#define FieldPositionOnlyHandler U_ICU_ENTRY_POINT_RENAME(FieldPositionOnlyHandler)
#define FilteredNormalizer2 U_ICU_ENTRY_POINT_RENAME(FilteredNormalizer2)
#define FontRuns U_ICU_ENTRY_POINT_RENAME(FontRuns)
#define Format U_ICU_ENTRY_POINT_RENAME(Format)
#define Format1AnchorTable U_ICU_ENTRY_POINT_RENAME(Format1AnchorTable)
#define Format2AnchorTable U_ICU_ENTRY_POINT_RENAME(Format2AnchorTable)
#define Format3AnchorTable U_ICU_ENTRY_POINT_RENAME(Format3AnchorTable)
#define FormatNameEnumeration U_ICU_ENTRY_POINT_RENAME(FormatNameEnumeration)
#define FormatParser U_ICU_ENTRY_POINT_RENAME(FormatParser)
#define Formattable U_ICU_ENTRY_POINT_RENAME(Formattable)
#define ForwardCharacterIterator U_ICU_ENTRY_POINT_RENAME(ForwardCharacterIterator)
#define ForwardUTrie2StringIterator U_ICU_ENTRY_POINT_RENAME(ForwardUTrie2StringIterator)
#define FractionalPartSubstitution U_ICU_ENTRY_POINT_RENAME(FractionalPartSubstitution)
#define FunctionReplacer U_ICU_ENTRY_POINT_RENAME(FunctionReplacer)
#define GDEFMarkFilter U_ICU_ENTRY_POINT_RENAME(GDEFMarkFilter)
#define GXLayoutEngine U_ICU_ENTRY_POINT_RENAME(GXLayoutEngine)
#define GlyphDefinitionTableHeader U_ICU_ENTRY_POINT_RENAME(GlyphDefinitionTableHeader)
#define GlyphIterator U_ICU_ENTRY_POINT_RENAME(GlyphIterator)
#define GlyphLookupTableHeader U_ICU_ENTRY_POINT_RENAME(GlyphLookupTableHeader)
#define GlyphPositionAdjustments U_ICU_ENTRY_POINT_RENAME(GlyphPositionAdjustments)
#define GlyphPositioningLookupProcessor U_ICU_ENTRY_POINT_RENAME(GlyphPositioningLookupProcessor)
#define GlyphPositioningTableHeader U_ICU_ENTRY_POINT_RENAME(GlyphPositioningTableHeader)
#define GlyphSubstitutionLookupProcessor U_ICU_ENTRY_POINT_RENAME(GlyphSubstitutionLookupProcessor)
#define GlyphSubstitutionTableHeader U_ICU_ENTRY_POINT_RENAME(GlyphSubstitutionTableHeader)
#define GoodSuffixTable U_ICU_ENTRY_POINT_RENAME(GoodSuffixTable)
#define Grego U_ICU_ENTRY_POINT_RENAME(Grego)
#define GregorianCalendar U_ICU_ENTRY_POINT_RENAME(GregorianCalendar)
#define HanOpenTypeLayoutEngine U_ICU_ENTRY_POINT_RENAME(HanOpenTypeLayoutEngine)
#define HangulOpenTypeLayoutEngine U_ICU_ENTRY_POINT_RENAME(HangulOpenTypeLayoutEngine)
#define HebrewCalendar U_ICU_ENTRY_POINT_RENAME(HebrewCalendar)
#define ICUBreakIteratorFactory U_ICU_ENTRY_POINT_RENAME(ICUBreakIteratorFactory)
#define ICUBreakIteratorService U_ICU_ENTRY_POINT_RENAME(ICUBreakIteratorService)
#define ICUCollatorFactory U_ICU_ENTRY_POINT_RENAME(ICUCollatorFactory)
#define ICUCollatorService U_ICU_ENTRY_POINT_RENAME(ICUCollatorService)
#define ICUDataTable U_ICU_ENTRY_POINT_RENAME(ICUDataTable)
#define ICULanguageBreakFactory U_ICU_ENTRY_POINT_RENAME(ICULanguageBreakFactory)
#define ICULocaleService U_ICU_ENTRY_POINT_RENAME(ICULocaleService)
#define ICUNotifier U_ICU_ENTRY_POINT_RENAME(ICUNotifier)
#define ICUNumberFormatFactory U_ICU_ENTRY_POINT_RENAME(ICUNumberFormatFactory)
#define ICUNumberFormatService U_ICU_ENTRY_POINT_RENAME(ICUNumberFormatService)
#define ICUResourceBundleFactory U_ICU_ENTRY_POINT_RENAME(ICUResourceBundleFactory)
#define ICUService U_ICU_ENTRY_POINT_RENAME(ICUService)
#define ICUServiceFactory U_ICU_ENTRY_POINT_RENAME(ICUServiceFactory)
#define ICUServiceKey U_ICU_ENTRY_POINT_RENAME(ICUServiceKey)
#define ICU_Utility U_ICU_ENTRY_POINT_RENAME(ICU_Utility)
#define IndianCalendar U_ICU_ENTRY_POINT_RENAME(IndianCalendar)
#define IndicClassTable U_ICU_ENTRY_POINT_RENAME(IndicClassTable)
#define IndicOpenTypeLayoutEngine U_ICU_ENTRY_POINT_RENAME(IndicOpenTypeLayoutEngine)
#define IndicRearrangementProcessor U_ICU_ENTRY_POINT_RENAME(IndicRearrangementProcessor)
#define IndicReordering U_ICU_ENTRY_POINT_RENAME(IndicReordering)
#define InitialTimeZoneRule U_ICU_ENTRY_POINT_RENAME(InitialTimeZoneRule)
#define InputText U_ICU_ENTRY_POINT_RENAME(InputText)
#define IntegralPartSubstitution U_ICU_ENTRY_POINT_RENAME(IntegralPartSubstitution)
#define IslamicCalendar U_ICU_ENTRY_POINT_RENAME(IslamicCalendar)
#define IteratedChar U_ICU_ENTRY_POINT_RENAME(IteratedChar)
#define JapaneseCalendar U_ICU_ENTRY_POINT_RENAME(JapaneseCalendar)
#define KernTable U_ICU_ENTRY_POINT_RENAME(KernTable)
#define KeywordEnumeration U_ICU_ENTRY_POINT_RENAME(KeywordEnumeration)
#define KhmerClassTable U_ICU_ENTRY_POINT_RENAME(KhmerClassTable)
#define KhmerOpenTypeLayoutEngine U_ICU_ENTRY_POINT_RENAME(KhmerOpenTypeLayoutEngine)
#define KhmerReordering U_ICU_ENTRY_POINT_RENAME(KhmerReordering)
#define LECharMapper U_ICU_ENTRY_POINT_RENAME(LECharMapper)
#define LEFontInstance U_ICU_ENTRY_POINT_RENAME(LEFontInstance)
#define LEGlyphFilter U_ICU_ENTRY_POINT_RENAME(LEGlyphFilter)
#define LEGlyphStorage U_ICU_ENTRY_POINT_RENAME(LEGlyphStorage)
#define LEInsertionCallback U_ICU_ENTRY_POINT_RENAME(LEInsertionCallback)
#define LEInsertionList U_ICU_ENTRY_POINT_RENAME(LEInsertionList)
#define LXUtilities U_ICU_ENTRY_POINT_RENAME(LXUtilities)
#define LanguageBreakEngine U_ICU_ENTRY_POINT_RENAME(LanguageBreakEngine)
#define LanguageBreakFactory U_ICU_ENTRY_POINT_RENAME(LanguageBreakFactory)
#define LayoutEngine U_ICU_ENTRY_POINT_RENAME(LayoutEngine)
#define LigatureSubstitutionProcessor U_ICU_ENTRY_POINT_RENAME(LigatureSubstitutionProcessor)
#define LigatureSubstitutionSubtable U_ICU_ENTRY_POINT_RENAME(LigatureSubstitutionSubtable)
#define LocDataParser U_ICU_ENTRY_POINT_RENAME(LocDataParser)
#define Locale U_ICU_ENTRY_POINT_RENAME(Locale)
#define LocaleBased U_ICU_ENTRY_POINT_RENAME(LocaleBased)
#define LocaleDisplayNames U_ICU_ENTRY_POINT_RENAME(LocaleDisplayNames)
#define LocaleDisplayNamesImpl U_ICU_ENTRY_POINT_RENAME(LocaleDisplayNamesImpl)
#define LocaleKey U_ICU_ENTRY_POINT_RENAME(LocaleKey)
#define LocaleKeyFactory U_ICU_ENTRY_POINT_RENAME(LocaleKeyFactory)
#define LocaleRuns U_ICU_ENTRY_POINT_RENAME(LocaleRuns)
#define LocaleUtility U_ICU_ENTRY_POINT_RENAME(LocaleUtility)
#define LocalizationInfo U_ICU_ENTRY_POINT_RENAME(LocalizationInfo)
#define LookupListTable U_ICU_ENTRY_POINT_RENAME(LookupListTable)
#define LookupProcessor U_ICU_ENTRY_POINT_RENAME(LookupProcessor)
#define LookupSubtable U_ICU_ENTRY_POINT_RENAME(LookupSubtable)
#define LookupTable U_ICU_ENTRY_POINT_RENAME(LookupTable)
#define LowercaseTransliterator U_ICU_ENTRY_POINT_RENAME(LowercaseTransliterator)
#define MPreFixups U_ICU_ENTRY_POINT_RENAME(MPreFixups)
#define MarkArray U_ICU_ENTRY_POINT_RENAME(MarkArray)
#define MarkToBasePositioningSubtable U_ICU_ENTRY_POINT_RENAME(MarkToBasePositioningSubtable)
#define MarkToLigaturePositioningSubtable U_ICU_ENTRY_POINT_RENAME(MarkToLigaturePositioningSubtable)
#define MarkToMarkPositioningSubtable U_ICU_ENTRY_POINT_RENAME(MarkToMarkPositioningSubtable)
#define Measure U_ICU_ENTRY_POINT_RENAME(Measure)
#define MeasureFormat U_ICU_ENTRY_POINT_RENAME(MeasureFormat)
#define MeasureUnit U_ICU_ENTRY_POINT_RENAME(MeasureUnit)
#define MessageFormat U_ICU_ENTRY_POINT_RENAME(MessageFormat)
#define MessageFormatAdapter U_ICU_ENTRY_POINT_RENAME(MessageFormatAdapter)
#define ModulusSubstitution U_ICU_ENTRY_POINT_RENAME(ModulusSubstitution)
#define MoonRiseSetCoordFunc U_ICU_ENTRY_POINT_RENAME(MoonRiseSetCoordFunc)
#define MoonTimeAngleFunc U_ICU_ENTRY_POINT_RENAME(MoonTimeAngleFunc)
#define MorphSubtableHeader U_ICU_ENTRY_POINT_RENAME(MorphSubtableHeader)
#define MorphTableHeader U_ICU_ENTRY_POINT_RENAME(MorphTableHeader)
#define MultipleSubstitutionSubtable U_ICU_ENTRY_POINT_RENAME(MultipleSubstitutionSubtable)
#define MultiplierSubstitution U_ICU_ENTRY_POINT_RENAME(MultiplierSubstitution)
#define MutableTrieDictionary U_ICU_ENTRY_POINT_RENAME(MutableTrieDictionary)
#define MutableTrieEnumeration U_ICU_ENTRY_POINT_RENAME(MutableTrieEnumeration)
#define NFFactory U_ICU_ENTRY_POINT_RENAME(NFFactory)
#define NFKDBuffer U_ICU_ENTRY_POINT_RENAME(NFKDBuffer)
#define NFRule U_ICU_ENTRY_POINT_RENAME(NFRule)
#define NFRuleSet U_ICU_ENTRY_POINT_RENAME(NFRuleSet)
#define NFSubstitution U_ICU_ENTRY_POINT_RENAME(NFSubstitution)
#define NGramParser U_ICU_ENTRY_POINT_RENAME(NGramParser)
#define NameToEnum U_ICU_ENTRY_POINT_RENAME(NameToEnum)
#define NameUnicodeTransliterator U_ICU_ENTRY_POINT_RENAME(NameUnicodeTransliterator)
#define NonContextualGlyphSubstitutionProcessor U_ICU_ENTRY_POINT_RENAME(NonContextualGlyphSubstitutionProcessor)
#define NonContiguousEnumToOffset U_ICU_ENTRY_POINT_RENAME(NonContiguousEnumToOffset)
#define NoopNormalizer2 U_ICU_ENTRY_POINT_RENAME(NoopNormalizer2)
#define Norm2AllModes U_ICU_ENTRY_POINT_RENAME(Norm2AllModes)
#define NormalizationTransliterator U_ICU_ENTRY_POINT_RENAME(NormalizationTransliterator)
#define Normalizer U_ICU_ENTRY_POINT_RENAME(Normalizer)
#define Normalizer2 U_ICU_ENTRY_POINT_RENAME(Normalizer2)
#define Normalizer2Factory U_ICU_ENTRY_POINT_RENAME(Normalizer2Factory)
#define Normalizer2Impl U_ICU_ENTRY_POINT_RENAME(Normalizer2Impl)
#define Normalizer2WithImpl U_ICU_ENTRY_POINT_RENAME(Normalizer2WithImpl)
#define NullSubstitution U_ICU_ENTRY_POINT_RENAME(NullSubstitution)
#define NullTransliterator U_ICU_ENTRY_POINT_RENAME(NullTransliterator)
#define NumberFormat U_ICU_ENTRY_POINT_RENAME(NumberFormat)
#define NumberFormatFactory U_ICU_ENTRY_POINT_RENAME(NumberFormatFactory)
#define NumberingSystem U_ICU_ENTRY_POINT_RENAME(NumberingSystem)
#define NumeratorSubstitution U_ICU_ENTRY_POINT_RENAME(NumeratorSubstitution)
#define OlsonTimeZone U_ICU_ENTRY_POINT_RENAME(OlsonTimeZone)
#define OpenTypeLayoutEngine U_ICU_ENTRY_POINT_RENAME(OpenTypeLayoutEngine)
#define OpenTypeUtilities U_ICU_ENTRY_POINT_RENAME(OpenTypeUtilities)
#define OrConstraint U_ICU_ENTRY_POINT_RENAME(OrConstraint)
#define PCEBuffer U_ICU_ENTRY_POINT_RENAME(PCEBuffer)
#define PairPositioningFormat1Subtable U_ICU_ENTRY_POINT_RENAME(PairPositioningFormat1Subtable)
#define PairPositioningFormat2Subtable U_ICU_ENTRY_POINT_RENAME(PairPositioningFormat2Subtable)
#define PairPositioningSubtable U_ICU_ENTRY_POINT_RENAME(PairPositioningSubtable)
#define ParagraphLayout U_ICU_ENTRY_POINT_RENAME(ParagraphLayout)
#define ParseData U_ICU_ENTRY_POINT_RENAME(ParseData)
#define ParsePosition U_ICU_ENTRY_POINT_RENAME(ParsePosition)
#define PatternMap U_ICU_ENTRY_POINT_RENAME(PatternMap)
#define PatternMapIterator U_ICU_ENTRY_POINT_RENAME(PatternMapIterator)
#define PersianCalendar U_ICU_ENTRY_POINT_RENAME(PersianCalendar)
#define PluralFormat U_ICU_ENTRY_POINT_RENAME(PluralFormat)
#define PluralKeywordEnumeration U_ICU_ENTRY_POINT_RENAME(PluralKeywordEnumeration)
#define PluralRules U_ICU_ENTRY_POINT_RENAME(PluralRules)
#define PropertyAliases U_ICU_ENTRY_POINT_RENAME(PropertyAliases)
#define PtnElem U_ICU_ENTRY_POINT_RENAME(PtnElem)
#define PtnSkeleton U_ICU_ENTRY_POINT_RENAME(PtnSkeleton)
#define Quantifier U_ICU_ENTRY_POINT_RENAME(Quantifier)
#define RBBIDataWrapper U_ICU_ENTRY_POINT_RENAME(RBBIDataWrapper)
#define RBBINode U_ICU_ENTRY_POINT_RENAME(RBBINode)
#define RBBIRuleBuilder U_ICU_ENTRY_POINT_RENAME(RBBIRuleBuilder)
#define RBBIRuleScanner U_ICU_ENTRY_POINT_RENAME(RBBIRuleScanner)
#define RBBISetBuilder U_ICU_ENTRY_POINT_RENAME(RBBISetBuilder)
#define RBBIStateDescriptor U_ICU_ENTRY_POINT_RENAME(RBBIStateDescriptor)
#define RBBISymbolTable U_ICU_ENTRY_POINT_RENAME(RBBISymbolTable)
#define RBBISymbolTableEntry U_ICU_ENTRY_POINT_RENAME(RBBISymbolTableEntry)
#define RBBITableBuilder U_ICU_ENTRY_POINT_RENAME(RBBITableBuilder)
#define RCEBuffer U_ICU_ENTRY_POINT_RENAME(RCEBuffer)
#define RangeDescriptor U_ICU_ENTRY_POINT_RENAME(RangeDescriptor)
#define RegexCompile U_ICU_ENTRY_POINT_RENAME(RegexCompile)
#define RegexMatcher U_ICU_ENTRY_POINT_RENAME(RegexMatcher)
#define RegexPattern U_ICU_ENTRY_POINT_RENAME(RegexPattern)
#define RegexStaticSets U_ICU_ENTRY_POINT_RENAME(RegexStaticSets)
#define RegularExpression U_ICU_ENTRY_POINT_RENAME(RegularExpression)
#define RelativeDateFormat U_ICU_ENTRY_POINT_RENAME(RelativeDateFormat)
#define RemoveTransliterator U_ICU_ENTRY_POINT_RENAME(RemoveTransliterator)
#define ReorderingBuffer U_ICU_ENTRY_POINT_RENAME(ReorderingBuffer)
#define Replaceable U_ICU_ENTRY_POINT_RENAME(Replaceable)
#define ReplaceableGlue U_ICU_ENTRY_POINT_RENAME(ReplaceableGlue)
#define ResourceBundle U_ICU_ENTRY_POINT_RENAME(ResourceBundle)
#define RiseSetCoordFunc U_ICU_ENTRY_POINT_RENAME(RiseSetCoordFunc)
#define RuleBasedBreakIterator U_ICU_ENTRY_POINT_RENAME(RuleBasedBreakIterator)
#define RuleBasedCollator U_ICU_ENTRY_POINT_RENAME(RuleBasedCollator)
#define RuleBasedNumberFormat U_ICU_ENTRY_POINT_RENAME(RuleBasedNumberFormat)
#define RuleBasedTimeZone U_ICU_ENTRY_POINT_RENAME(RuleBasedTimeZone)
#define RuleBasedTransliterator U_ICU_ENTRY_POINT_RENAME(RuleBasedTransliterator)
#define RuleChain U_ICU_ENTRY_POINT_RENAME(RuleChain)
#define RuleCharacterIterator U_ICU_ENTRY_POINT_RENAME(RuleCharacterIterator)
#define RuleHalf U_ICU_ENTRY_POINT_RENAME(RuleHalf)
#define RuleParser U_ICU_ENTRY_POINT_RENAME(RuleParser)
#define RunArray U_ICU_ENTRY_POINT_RENAME(RunArray)
#define SPUString U_ICU_ENTRY_POINT_RENAME(SPUString)
#define SPUStringPool U_ICU_ENTRY_POINT_RENAME(SPUStringPool)
#define SafeZoneStringFormatPtr U_ICU_ENTRY_POINT_RENAME(SafeZoneStringFormatPtr)
#define SameValueSubstitution U_ICU_ENTRY_POINT_RENAME(SameValueSubstitution)
#define ScriptListTable U_ICU_ENTRY_POINT_RENAME(ScriptListTable)
#define ScriptRunIterator U_ICU_ENTRY_POINT_RENAME(ScriptRunIterator)
#define ScriptSet U_ICU_ENTRY_POINT_RENAME(ScriptSet)
#define ScriptTable U_ICU_ENTRY_POINT_RENAME(ScriptTable)
#define SearchIterator U_ICU_ENTRY_POINT_RENAME(SearchIterator)
#define SegmentArrayProcessor U_ICU_ENTRY_POINT_RENAME(SegmentArrayProcessor)
#define SegmentSingleProcessor U_ICU_ENTRY_POINT_RENAME(SegmentSingleProcessor)
#define SelectFormat U_ICU_ENTRY_POINT_RENAME(SelectFormat)
#define ServiceEnumeration U_ICU_ENTRY_POINT_RENAME(ServiceEnumeration)
#define ServiceListener U_ICU_ENTRY_POINT_RENAME(ServiceListener)
#define SimpleArrayProcessor U_ICU_ENTRY_POINT_RENAME(SimpleArrayProcessor)
#define SimpleDateFormat U_ICU_ENTRY_POINT_RENAME(SimpleDateFormat)
#define SimpleFactory U_ICU_ENTRY_POINT_RENAME(SimpleFactory)
#define SimpleLocaleKeyFactory U_ICU_ENTRY_POINT_RENAME(SimpleLocaleKeyFactory)
#define SimpleNumberFormatFactory U_ICU_ENTRY_POINT_RENAME(SimpleNumberFormatFactory)
#define SimpleSingleton U_ICU_ENTRY_POINT_RENAME(SimpleSingleton)
#define SimpleTimeZone U_ICU_ENTRY_POINT_RENAME(SimpleTimeZone)
#define SinglePositioningFormat1Subtable U_ICU_ENTRY_POINT_RENAME(SinglePositioningFormat1Subtable)
#define SinglePositioningFormat2Subtable U_ICU_ENTRY_POINT_RENAME(SinglePositioningFormat2Subtable)
#define SinglePositioningSubtable U_ICU_ENTRY_POINT_RENAME(SinglePositioningSubtable)
#define SingleSubstitutionFormat1Subtable U_ICU_ENTRY_POINT_RENAME(SingleSubstitutionFormat1Subtable)
#define SingleSubstitutionFormat2Subtable U_ICU_ENTRY_POINT_RENAME(SingleSubstitutionFormat2Subtable)
#define SingleSubstitutionSubtable U_ICU_ENTRY_POINT_RENAME(SingleSubstitutionSubtable)
#define SingleTableProcessor U_ICU_ENTRY_POINT_RENAME(SingleTableProcessor)
#define SpoofData U_ICU_ENTRY_POINT_RENAME(SpoofData)
#define SpoofImpl U_ICU_ENTRY_POINT_RENAME(SpoofImpl)
#define StateTableProcessor U_ICU_ENTRY_POINT_RENAME(StateTableProcessor)
#define StringCharacterIterator U_ICU_ENTRY_POINT_RENAME(StringCharacterIterator)
#define StringEnumeration U_ICU_ENTRY_POINT_RENAME(StringEnumeration)
#define StringList U_ICU_ENTRY_POINT_RENAME(StringList)
#define StringLocalizationInfo U_ICU_ENTRY_POINT_RENAME(StringLocalizationInfo)
#define StringMatcher U_ICU_ENTRY_POINT_RENAME(StringMatcher)
#define StringPair U_ICU_ENTRY_POINT_RENAME(StringPair)
#define StringPiece U_ICU_ENTRY_POINT_RENAME(StringPiece)
#define StringReplacer U_ICU_ENTRY_POINT_RENAME(StringReplacer)
#define StringSearch U_ICU_ENTRY_POINT_RENAME(StringSearch)
#define StringToCEsMap U_ICU_ENTRY_POINT_RENAME(StringToCEsMap)
#define StyleRuns U_ICU_ENTRY_POINT_RENAME(StyleRuns)
#define SubstitutionLookup U_ICU_ENTRY_POINT_RENAME(SubstitutionLookup)
#define SubtableProcessor U_ICU_ENTRY_POINT_RENAME(SubtableProcessor)
#define SunTimeAngleFunc U_ICU_ENTRY_POINT_RENAME(SunTimeAngleFunc)
#define SymbolTable U_ICU_ENTRY_POINT_RENAME(SymbolTable)
#define TZEnumeration U_ICU_ENTRY_POINT_RENAME(TZEnumeration)
#define TaiwanCalendar U_ICU_ENTRY_POINT_RENAME(TaiwanCalendar)
#define Target U_ICU_ENTRY_POINT_RENAME(Target)
#define TernaryNode U_ICU_ENTRY_POINT_RENAME(TernaryNode)
#define TextTrieMap U_ICU_ENTRY_POINT_RENAME(TextTrieMap)
#define TextTrieMapSearchResultHandler U_ICU_ENTRY_POINT_RENAME(TextTrieMapSearchResultHandler)
#define ThaiBreakEngine U_ICU_ENTRY_POINT_RENAME(ThaiBreakEngine)
#define ThaiLayoutEngine U_ICU_ENTRY_POINT_RENAME(ThaiLayoutEngine)
#define ThaiShaping U_ICU_ENTRY_POINT_RENAME(ThaiShaping)
#define TibetanClassTable U_ICU_ENTRY_POINT_RENAME(TibetanClassTable)
#define TibetanOpenTypeLayoutEngine U_ICU_ENTRY_POINT_RENAME(TibetanOpenTypeLayoutEngine)
#define TibetanReordering U_ICU_ENTRY_POINT_RENAME(TibetanReordering)
#define TimeArrayTimeZoneRule U_ICU_ENTRY_POINT_RENAME(TimeArrayTimeZoneRule)
#define TimeUnit U_ICU_ENTRY_POINT_RENAME(TimeUnit)
#define TimeUnitAmount U_ICU_ENTRY_POINT_RENAME(TimeUnitAmount)
#define TimeUnitFormat U_ICU_ENTRY_POINT_RENAME(TimeUnitFormat)
#define TimeZone U_ICU_ENTRY_POINT_RENAME(TimeZone)
#define TimeZoneRule U_ICU_ENTRY_POINT_RENAME(TimeZoneRule)
#define TimeZoneTransition U_ICU_ENTRY_POINT_RENAME(TimeZoneTransition)
#define TitlecaseTransliterator U_ICU_ENTRY_POINT_RENAME(TitlecaseTransliterator)
#define TransliterationRule U_ICU_ENTRY_POINT_RENAME(TransliterationRule)
#define TransliterationRuleData U_ICU_ENTRY_POINT_RENAME(TransliterationRuleData)
#define TransliterationRuleSet U_ICU_ENTRY_POINT_RENAME(TransliterationRuleSet)
#define Transliterator U_ICU_ENTRY_POINT_RENAME(Transliterator)
#define TransliteratorAlias U_ICU_ENTRY_POINT_RENAME(TransliteratorAlias)
#define TransliteratorEntry U_ICU_ENTRY_POINT_RENAME(TransliteratorEntry)
#define TransliteratorIDParser U_ICU_ENTRY_POINT_RENAME(TransliteratorIDParser)
#define TransliteratorParser U_ICU_ENTRY_POINT_RENAME(TransliteratorParser)
#define TransliteratorRegistry U_ICU_ENTRY_POINT_RENAME(TransliteratorRegistry)
#define TransliteratorSpec U_ICU_ENTRY_POINT_RENAME(TransliteratorSpec)
#define TriStateSingleton U_ICU_ENTRY_POINT_RENAME(TriStateSingleton)
#define TrieWordDictionary U_ICU_ENTRY_POINT_RENAME(TrieWordDictionary)
#define TrimmedArrayProcessor U_ICU_ENTRY_POINT_RENAME(TrimmedArrayProcessor)
#define UCharCharacterIterator U_ICU_ENTRY_POINT_RENAME(UCharCharacterIterator)
#define UCollationPCE U_ICU_ENTRY_POINT_RENAME(UCollationPCE)
#define ULocRuns U_ICU_ENTRY_POINT_RENAME(ULocRuns)
#define UMemory U_ICU_ENTRY_POINT_RENAME(UMemory)
#define UObject U_ICU_ENTRY_POINT_RENAME(UObject)
#define UStack U_ICU_ENTRY_POINT_RENAME(UStack)
#define UStringEnumeration U_ICU_ENTRY_POINT_RENAME(UStringEnumeration)
#define UTrie2Singleton U_ICU_ENTRY_POINT_RENAME(UTrie2Singleton)
#define UVector U_ICU_ENTRY_POINT_RENAME(UVector)
#define UVector32 U_ICU_ENTRY_POINT_RENAME(UVector32)
#define UVector64 U_ICU_ENTRY_POINT_RENAME(UVector64)
#define UnescapeTransliterator U_ICU_ENTRY_POINT_RENAME(UnescapeTransliterator)
#define UnhandledEngine U_ICU_ENTRY_POINT_RENAME(UnhandledEngine)
#define UnicodeArabicOpenTypeLayoutEngine U_ICU_ENTRY_POINT_RENAME(UnicodeArabicOpenTypeLayoutEngine)
#define UnicodeFilter U_ICU_ENTRY_POINT_RENAME(UnicodeFilter)
#define UnicodeFunctor U_ICU_ENTRY_POINT_RENAME(UnicodeFunctor)
#define UnicodeMatcher U_ICU_ENTRY_POINT_RENAME(UnicodeMatcher)
#define UnicodeNameTransliterator U_ICU_ENTRY_POINT_RENAME(UnicodeNameTransliterator)
#define UnicodeReplacer U_ICU_ENTRY_POINT_RENAME(UnicodeReplacer)
#define UnicodeSet U_ICU_ENTRY_POINT_RENAME(UnicodeSet)
#define UnicodeSetIterator U_ICU_ENTRY_POINT_RENAME(UnicodeSetIterator)
#define UnicodeSetStringSpan U_ICU_ENTRY_POINT_RENAME(UnicodeSetStringSpan)
#define UnicodeString U_ICU_ENTRY_POINT_RENAME(UnicodeString)
#define UppercaseTransliterator U_ICU_ENTRY_POINT_RENAME(UppercaseTransliterator)
#define VTZReader U_ICU_ENTRY_POINT_RENAME(VTZReader)
#define VTZWriter U_ICU_ENTRY_POINT_RENAME(VTZWriter)
#define VTimeZone U_ICU_ENTRY_POINT_RENAME(VTimeZone)
#define ValueRecord U_ICU_ENTRY_POINT_RENAME(ValueRecord)
#define ValueRuns U_ICU_ENTRY_POINT_RENAME(ValueRuns)
#define ZSFCache U_ICU_ENTRY_POINT_RENAME(ZSFCache)
#define ZSFCacheEntry U_ICU_ENTRY_POINT_RENAME(ZSFCacheEntry)
#define ZSFStringPool U_ICU_ENTRY_POINT_RENAME(ZSFStringPool)
#define ZSFStringPoolChunk U_ICU_ENTRY_POINT_RENAME(ZSFStringPoolChunk)
#define ZoneMeta U_ICU_ENTRY_POINT_RENAME(ZoneMeta)
#define ZoneStringFormat U_ICU_ENTRY_POINT_RENAME(ZoneStringFormat)
#define ZoneStringInfo U_ICU_ENTRY_POINT_RENAME(ZoneStringInfo)
#define ZoneStringSearchResultHandler U_ICU_ENTRY_POINT_RENAME(ZoneStringSearchResultHandler)
#define ZoneStrings U_ICU_ENTRY_POINT_RENAME(ZoneStrings)
#define locale_set_default_internal U_ICU_ENTRY_POINT_RENAME(locale_set_default_internal)
#define util64_fromDouble U_ICU_ENTRY_POINT_RENAME(util64_fromDouble)
#define util64_pow U_ICU_ENTRY_POINT_RENAME(util64_pow)
#define util64_tou U_ICU_ENTRY_POINT_RENAME(util64_tou)

#endif
#endif

#endif

#endif
