smooth.construct.tp.smooth.spec     package:mgcv     R Documentation

_P_e_n_a_l_i_z_e_d _t_h_i_n _p_l_a_t_e _r_e_g_r_e_s_s_i_o_n _s_p_l_i_n_e_s _i_n _G_A_M_s

_D_e_s_c_r_i_p_t_i_o_n:

     'gam' can use isotropic smooths of any number of variables,
     specified via terms like 's(x,z,bs="tp",m=3)' (or just 's(x,z)' as
     this is the default basis). These terms are based on thin plate 
     regression splines. 'm' specifies the order of the derivatives in
     the thin plate spline penalty.

     Thin plate regression splines are constructed by starting with the
     basis and penalty for a full thin plate spline and then truncating
     this basis in an optimal manner, to obtain a low rank smoother.
     Details are given in Wood (2003). One key advantage of the
     approach is that it avoids the knot placement problems of
     conventional regression spline modelling, but it also has the
     advantage that smooths of lower rank are nested within smooths of
     higher rank, so that it is legitimate to use conventional
     hypothesis testing methods to compare models based on pure
     regression splines. Note that the basis truncation does not change
     the  meaning of the thin plate spline penalty (it penalizes
     exactly what it  would have penalized for a full thin plate
     spline). 

     The t.p.r.s. basis and penalties can become expensive to calculate
     for large datasets. For this reason the default behaviour is to
     randomly subsample 'max.knots' unique data locations if there are
     more than 'max.knots' such, and to use the sub-sample for basis
     construction. The sampling is always done with the same random
     seed to ensure repeatability (does not reset R RNG). 'max.knots'
     is 3000, by default. Both seed and 'max.knots' can be modified
     using the 'xt' argument to 's'. Alternatively the user can supply
     knots from which to construct a basis. 

     The '"ts"' smooths are t.p.r.s. with a small multiple of the
     identity matrix added to the  spline penalty so that the term can
     be shrink to zero, and not just to a function in the t.p.r.s.
     penalty null space.

_U_s_a_g_e:

     ## S3 method for class 'tp.smooth.spec':
     smooth.construct(object, data, knots)
     ## S3 method for class 'ts.smooth.spec':
     smooth.construct(object, data, knots)

_A_r_g_u_m_e_n_t_s:

  object: a smooth specification object, usually generated by a term
          's(...,bs="tp",...)' or  's(...,bs="ts",...)'

    data: a list containing just the data (including any 'by' variable)
          required by this term,  with names corresponding to
          'object$term' (and 'object$by'). The 'by' variable  is the
          last element.

   knots: a list containing any knots supplied for basis setup - in
          same order and with same names as 'data'.  Can be 'NULL'

_D_e_t_a_i_l_s:

     The default basis dimension for this class is 'k=10*3^(d-1)' where
     'd' is the number of covariates for the term.

     The default is to set 'm' (the order of derivative in the thin
     plate spline penalty) to the smallest value satisfying '2m > d+1'
     where 'd' if the number of covariates of the term: this yields
     `visually smooth' functions. In any case '2m>d' must be satisfied. 

     The constructor is not normally called directly, but is rather
     used internally by 'gam'.  To use for basis setup it is
     recommended to use 'smooth.construct2'.  

     For these classes the specification 'object' will contain
     information on how to handle large datasets in their 'xt' field.
     The default is to randomly subsample 3000 `knots' from which to
     produce a tprs basis, if the number of unique predictor variable
     combinations in excess of 3000. The default can be modified via
     the 'xt' argument to 's'. This is supplied as a list with elements
     'max.knots' and 'seed' containing a number to use in place of
     3000, and the random number seed to use (either can be missing). 

     For these bases 'knots' has two uses. Firstly, as mentioned
     already, for large datasets  the calculation of the 'tp' basis can
     be time-consuming. The user can retain most of the advantages of
     the t.p.r.s.  approach by supplying  a reduced set of covariate
     values from which to obtain the basis -  typically the number of
     covariate values used will be substantially  smaller than the
     number of data, and substantially larger than the basis dimension,
     'k'. This approach is  the one taken automatically if the number
     of unique covariate values (combinations) exceeds 'max.knots'. The
     second possibility  is to avoid the eigen-decomposition used to
     find the t.p.r.s. basis altogether and simply use  the basis
     implied by the chosen knots: this will happen if the number of
     knots supplied matches the  basis dimension, 'k'. For a given
     basis dimension the second option is  faster, but gives poorer
     results (and the user must be quite careful in choosing knot
     locations).

_V_a_l_u_e:

     An object of class '"tprs.smooth"' or '"ts.smooth"'. In addition
     to the usual elements of a  smooth class documented under
     'smooth.construct', this object will contain: 

   shift: A record of the shift applied to each covariate in order to
          center it around zero and  avoid any co-linearity problems
          that might otehrwise occur in the penalty null space basis of
          the term. 

      Xu: A matrix of the unique covariate combinations for this smooth
          (the basis is constructed by first stripping  out duplicate
          locations).

      UZ: The matrix mapping the t.p.r.s. parameters back to the
          parameters of a full thin plate spline.

null.space.dimension: The dimension of the space of functions that have
          zero wiggliness according to the  wiggliness penalty for this
          term.

_A_u_t_h_o_r(_s):

     Simon N. Wood simon.wood@r-project.org

_R_e_f_e_r_e_n_c_e_s:

     Wood, S.N. (2003) Thin plate regression splines. J.R.Statist.Soc.B
     65(1):95-114

_E_x_a_m_p_l_e_s:

     ## see ?gam

