/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.ast.executable.Script;
import org.jruby.util.ClassCache;
import org.jruby.util.JRubyClassLoader;
import org.objectweb.asm.ClassReader;

public class CompiledScriptLoader {
    public static Script loadScriptFromFile(Ruby runtime2, InputStream inStream, String resourceName) {
        InputStream in = null;
        try {
            in = new BufferedInputStream(inStream, 8192);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8196];
            int read2 = 0;
            while ((read2 = in.read(buf)) != -1) {
                baos.write(buf, 0, read2);
            }
            buf = baos.toByteArray();
            JRubyClassLoader jcl = runtime2.getJRubyClassLoader();
            ClassCache.OneShotClassLoader oscl = new ClassCache.OneShotClassLoader(jcl);
            ClassReader cr = new ClassReader(buf);
            String className = cr.getClassName().replace('/', '.');
            Class<?> clazz = oscl.defineClass(className, buf);
            if (Script.class.isAssignableFrom(clazz)) {
                Script script = (Script)clazz.newInstance();
                return script;
            }
            try {
                throw runtime2.newLoadError("use `java_import' to load normal Java classes");
            }
            catch (IOException e) {
                throw runtime2.newIOErrorFromException(e);
            }
            catch (InstantiationException ie) {
                if (runtime2.getDebug().isTrue()) {
                    ie.printStackTrace();
                }
                throw runtime2.newLoadError("Error loading compiled script '" + resourceName + "': " + ie);
            }
            catch (IllegalAccessException iae) {
                if (runtime2.getDebug().isTrue()) {
                    iae.printStackTrace();
                }
                throw runtime2.newLoadError("Error loading compiled script '" + resourceName + "': " + iae);
            }
            catch (LinkageError le) {
                if (runtime2.getDebug().isTrue()) {
                    le.printStackTrace();
                }
                throw runtime2.newLoadError("Linkage error loading compiled script; you may need to recompile '" + resourceName + "': " + le);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                throw runtime2.newIOErrorFromException(ioe);
            }
        }
    }
}

