/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.DefaultMethodFactory;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.FastIntMethodFactory;
import org.jruby.ext.ffi.jffi.FastLongMethodFactory;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JFFIInvoker
extends AbstractInvoker {
    private static final Map<DynamicMethod, Object> libraryRefMap = Collections.synchronizedMap(new WeakHashMap());
    private final Object handle;
    private final Function function;
    private final Type returnType;
    private final Type[] parameterTypes;
    private final int parameterCount;
    private final CallingConvention convention;
    private final IRubyObject enums;
    private final RubyModule callModule;
    private final DynamicMethod callMethod;

    public static RubyClass createInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("Invoker", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(AbstractInvoker.class);
        result.defineAnnotatedMethods(JFFIInvoker.class);
        result.defineAnnotatedConstants(JFFIInvoker.class);
        return result;
    }

    JFFIInvoker(Ruby runtime2, long address2, Type returnType, Type[] parameterTypes) {
        this(runtime2, runtime2.fastGetModule("FFI").fastGetClass("Invoker"), null, address2, returnType, parameterTypes, "default", null);
    }

    JFFIInvoker(Ruby runtime2, RubyClass klass, Object handle, long address2, Type returnType, Type[] parameterTypes, String convention, IRubyObject enums) {
        super(runtime2, klass, parameterTypes.length);
        com.kenai.jffi.Type jffiReturnType = FFIUtil.getFFIType(returnType);
        if (jffiReturnType == null) {
            throw runtime2.newArgumentError("Invalid return type " + returnType);
        }
        com.kenai.jffi.Type[] jffiParamTypes = new com.kenai.jffi.Type[parameterTypes.length];
        for (int i = 0; i < jffiParamTypes.length; ++i) {
            jffiParamTypes[i] = FFIUtil.getFFIType(parameterTypes[i]);
            if (jffiParamTypes[i] != null) continue;
            throw runtime2.newArgumentError("Invalid parameter type " + parameterTypes[i]);
        }
        this.handle = handle;
        this.function = new Function(address2, jffiReturnType, jffiParamTypes);
        this.parameterTypes = new Type[parameterTypes.length];
        System.arraycopy(parameterTypes, 0, this.parameterTypes, 0, parameterTypes.length);
        this.parameterCount = parameterTypes.length;
        this.returnType = returnType;
        this.convention = "stdcall".equals(convention) ? CallingConvention.STDCALL : CallingConvention.DEFAULT;
        this.enums = enums;
        this.callModule = RubyModule.newModule(runtime2);
        this.callMethod = this.createDynamicMethod(this.callModule);
        this.callModule.addModuleFunction("call", this.callMethod);
    }

    @JRubyMethod(name={"new"}, meta=true, required=4)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (!(args2[0] instanceof BasePointer)) {
            throw context.getRuntime().newTypeError("Invalid function address " + args2[0].getMetaClass().getName() + " (expected FFI::Pointer)");
        }
        if (!(args2[1] instanceof RubyArray)) {
            throw context.getRuntime().newTypeError("Invalid parameter array " + args2[1].getMetaClass().getName() + " (expected Array)");
        }
        if (!(args2[2] instanceof Type)) {
            throw context.getRuntime().newTypeError("Invalid return type " + args2[2]);
        }
        BasePointer ptr = (BasePointer)args2[0];
        RubyArray paramTypes = (RubyArray)args2[1];
        Type returnType = (Type)args2[2];
        String convention = "default";
        IRubyObject enums = null;
        if (args2[3] instanceof RubyHash) {
            RubyHash options2 = (RubyHash)args2[3];
            convention = options2.fastARef(context.getRuntime().newSymbol("convention")).asJavaString();
            enums = options2.fastARef(context.getRuntime().newSymbol("enums"));
            if (!enums.isNil() && !(enums instanceof RubyHash)) {
                throw context.getRuntime().newTypeError("wrong type for options[:enum] " + enums.getMetaClass().getName() + " (expected Hash)");
            }
        } else {
            convention = args2[3].asJavaString();
        }
        Type[] parameterTypes = new Type[paramTypes.size()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            IRubyObject type2 = paramTypes.entry(i);
            if (!(type2 instanceof Type)) {
                throw context.getRuntime().newArgumentError("Invalid parameter type");
            }
            parameterTypes[i] = (Type)paramTypes.entry(i);
        }
        return new JFFIInvoker(context.getRuntime(), (RubyClass)recv2, ptr, ptr.getAddress(), returnType, parameterTypes, convention, enums);
    }

    @JRubyMethod(name={"invoke", "call", "call0", "call1", "call2", "call3"}, rest=true)
    public IRubyObject invoke(ThreadContext context, IRubyObject[] args2) {
        return this.callMethod.call(context, (IRubyObject)this.callModule, (RubyModule)this.callModule.getSingletonClass(), "call", args2, Block.NULL_BLOCK);
    }

    public DynamicMethod createDynamicMethod(RubyModule module) {
        DynamicMethod dm = this.convention == CallingConvention.DEFAULT && this.enums == null && FastIntMethodFactory.getFactory().isFastIntMethod(this.returnType, this.parameterTypes) ? FastIntMethodFactory.getFactory().createMethod(module, this.function, this.returnType, this.parameterTypes) : (this.convention == CallingConvention.DEFAULT && this.enums == null && FastLongMethodFactory.getFactory().isFastLongMethod(this.returnType, this.parameterTypes) ? FastLongMethodFactory.getFactory().createMethod(module, this.function, this.returnType, this.parameterTypes) : DefaultMethodFactory.getFactory().createMethod(module, this.function, this.returnType, this.parameterTypes, this.convention, this.enums));
        libraryRefMap.put(dm, this.handle);
        return dm;
    }
}

