/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.ActionRunner;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.data.AbstractExecutable;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.w3c.dom.Node;

public class Action
extends AbstractExecutable {
    private String actionClass;
    private String pluginID;
    private boolean hasClassAttr = false;
    private boolean hasPluginId = false;

    public String getActionClass() {
        return this.actionClass;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public void setClass(String aclass) {
        this.actionClass = aclass;
    }

    public void setPluginID(String pluginId) {
        this.pluginID = pluginId;
    }

    public boolean handleAttribute(Node attribute) {
        if (attribute.getNodeName().equals("pluginId")) {
            this.hasPluginId = true;
            this.setPluginID(attribute.getNodeValue());
            return true;
        }
        if (attribute.getNodeName().equals("class")) {
            this.hasClassAttr = true;
            this.setClass(attribute.getNodeValue());
            return true;
        }
        return false;
    }

    public String checkAttributes(Node node) {
        if (!this.hasClassAttr) {
            return NLS.bind((String)Messages.ERROR_PARSING_NO_CLASS, (Object[])new Object[]{node.getNodeName()});
        }
        if (!this.hasPluginId) {
            return NLS.bind((String)Messages.ERROR_PARSING_NO_PLUGINID, (Object[])new Object[]{node.getNodeName()});
        }
        return null;
    }

    public boolean isCheatSheetManagerUsed() {
        return true;
    }

    public IStatus execute(CheatSheetManager csm) {
        return new ActionRunner().runAction(this, csm);
    }

    public boolean hasParams() {
        return true;
    }
}

