/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.codemanipulation.AddCustomConstructorOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.GenerateConstructorUsingFieldsContentProvider;
import org.eclipse.jdt.internal.ui.actions.GenerateConstructorUsingFieldsSelectionDialog;
import org.eclipse.jdt.internal.ui.actions.GenerateConstructorUsingFieldsValidator;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class GenerateNewConstructorUsingFieldsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public GenerateNewConstructorUsingFieldsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public GenerateNewConstructorUsingFieldsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.GenerateConstructorUsingFieldsAction_label);
        this.setDescription(ActionMessages.GenerateConstructorUsingFieldsAction_description);
        this.setToolTipText(ActionMessages.GenerateConstructorUsingFieldsAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.create_new_constructor_action_context");
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (this.getSelectedFields(selection) != null) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && !type.isInterface() && !type.isAnnotation();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    private boolean canRunOn(IField[] fields) throws JavaModelException {
        if (fields != null && fields.length > 0) {
            int index = 0;
            while (index < fields.length) {
                if (JdtFlags.isEnum((IMember)fields[index])) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_enum_not_applicable);
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        if (elements.size() > 0) {
            IField[] fields = new IField[elements.size()];
            ICompilationUnit unit = null;
            int index = 0;
            while (index < elements.size()) {
                IField field;
                block7: {
                    if (elements.get(index) instanceof IField) {
                        field = (IField)elements.get(index);
                        if (index == 0 ? (unit = field.getCompilationUnit()) == null : !unit.equals(field.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            IType declaringType = field.getDeclaringType();
                            if (declaringType.isInterface() || declaringType.isAnnotation()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException exception) {
                            JavaPlugin.log(exception);
                            return null;
                        }
                    }
                    return null;
                }
                fields[index] = field;
                ++index;
            }
            return fields;
        }
        return null;
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        Object[] elements = selection.toArray();
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type = (IType)elements[0];
            if (type.getCompilationUnit() != null && !type.isInterface() && !type.isAnnotation()) {
                return type;
            }
        } else if (elements[0] instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)elements[0];
            IType type = unit.findPrimaryType();
            if (type != null && !type.isInterface() && !type.isAnnotation()) {
                return type;
            }
        } else if (elements[0] instanceof IField) {
            return ((IField)elements[0]).getCompilationUnit().findPrimaryType();
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        try {
            IType selectionType = this.getSelectedType(selection);
            if (selectionType == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_not_applicable);
                this.notifyResult(false);
                return;
            }
            IField[] selectedFields = this.getSelectedFields(selection);
            if (this.canRunOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                IType type = ((ICompilationUnit)firstElement).findPrimaryType();
                if (type.isAnnotation()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_annotation_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_interface_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                this.run(((ICompilationUnit)firstElement).findPrimaryType(), new IField[0], false);
            }
        }
        catch (CoreException exception) {
            ExceptionHandler.handle(exception, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, ActionMessages.GenerateConstructorUsingFieldsAction_error_actionfailed);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            this.notifyResult(false);
            return;
        }
        try {
            IType type;
            IJavaElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, false);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null) {
                if (type.getFields().length > 0) {
                    this.run(type, new IField[0], true);
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_typeContainsNoFields_message);
                }
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_not_applicable);
        }
        catch (CoreException exception) {
            ExceptionHandler.handle(exception, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, ActionMessages.GenerateConstructorUsingFieldsAction_error_actionfailed);
        }
        catch (InvocationTargetException exception) {
            ExceptionHandler.handle(exception, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, ActionMessages.GenerateConstructorUsingFieldsAction_error_actionfailed);
        }
        catch (InterruptedException interruptedException) {}
    }

    void run(IType type, IField[] selected, boolean activated) throws CoreException {
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, activated)) {
            this.notifyResult(false);
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), type)) {
            this.notifyResult(false);
            return;
        }
        IField[] candidates = type.getFields();
        ArrayList<IField> fields = new ArrayList<IField>();
        int index = 0;
        while (index < candidates.length) {
            boolean isStatic = Flags.isStatic((int)candidates[index].getFlags());
            boolean isFinal = Flags.isFinal((int)candidates[index].getFlags());
            if (!isStatic) {
                if (isFinal) {
                    try {
                        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                        scanner.setSource(candidates[index].getSource().toCharArray());
                        TokenScanner tokenScanner = new TokenScanner(scanner);
                        tokenScanner.getTokenStartOffset(167, 0);
                    }
                    catch (JavaModelException javaModelException) {
                    }
                    catch (CoreException coreException) {
                        fields.add(candidates[index]);
                    }
                } else {
                    fields.add(candidates[index]);
                }
            }
            ++index;
        }
        if (fields.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_typeContainsNoFields_message);
            this.notifyResult(false);
            return;
        }
        GenerateConstructorUsingFieldsContentProvider provider = new GenerateConstructorUsingFieldsContentProvider(type, fields, Arrays.asList(selected));
        IMethodBinding[] bindings = null;
        ITypeBinding provided = provider.getType();
        if (provided.isAnonymous()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_anonymous_class);
            this.notifyResult(false);
            return;
        }
        if (provided.isEnum()) {
            bindings = new IMethodBinding[]{this.getObjectConstructor(provider.getCompilationUnit())};
        } else {
            bindings = StubUtility2.getVisibleConstructors(provided, false, true);
            if (bindings.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_title, (String)ActionMessages.GenerateConstructorUsingFieldsAction_error_nothing_found);
                this.notifyResult(false);
                return;
            }
        }
        GenerateConstructorUsingFieldsSelectionDialog dialog = new GenerateConstructorUsingFieldsSelectionDialog(this.getShell(), (ILabelProvider)new BindingLabelProvider(), provider, this.fEditor, type, bindings);
        dialog.setCommentString(ActionMessages.SourceActionDialog_createConstructorComment);
        dialog.setTitle(ActionMessages.GenerateConstructorUsingFieldsAction_dialog_title);
        dialog.setInitialSelections(provider.getInitiallySelectedElements());
        dialog.setContainerMode(true);
        dialog.setSize(60, 18);
        dialog.setInput(new Object());
        dialog.setMessage(ActionMessages.GenerateConstructorUsingFieldsAction_dialog_label);
        dialog.setValidator(new GenerateConstructorUsingFieldsValidator(dialog, provided, fields.size()));
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            IRewriteTarget target;
            Object[] elements = dialog.getResult();
            if (elements == null) {
                this.notifyResult(false);
                return;
            }
            ArrayList<Object> result = new ArrayList<Object>(elements.length);
            int index2 = 0;
            while (index2 < elements.length) {
                if (elements[index2] instanceof IVariableBinding) {
                    result.add(elements[index2]);
                }
                ++index2;
            }
            IVariableBinding[] variables = new IVariableBinding[result.size()];
            result.toArray(variables);
            IEditorPart editor = EditorUtility.openInEditor(type.getCompilationUnit());
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject());
            settings.createComments = dialog.getGenerateComment();
            IMethodBinding constructor = dialog.getSuperConstructorChoice();
            IRewriteTarget iRewriteTarget = target = editor != null ? (IRewriteTarget)editor.getAdapter(IRewriteTarget.class) : null;
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                try {
                    Object context;
                    AddCustomConstructorOperation operation = new AddCustomConstructorOperation(type, dialog.getElementPosition(), provider.getCompilationUnit(), variables, constructor, settings, true, false);
                    operation.setVisibility(dialog.getVisibilityModifier());
                    if (constructor.getParameterTypes().length == 0) {
                        operation.setOmitSuper(dialog.isOmitSuper());
                    }
                    if ((context = JavaPlugin.getActiveWorkbenchWindow()) == null) {
                        context = new BusyIndicatorRunnableContext();
                    }
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation, operation.getSchedulingRule()), operation.getSchedulingRule());
                }
                catch (InvocationTargetException exception) {
                    ExceptionHandler.handle(exception, this.getShell(), ActionMessages.GenerateConstructorUsingFieldsAction_error_title, ActionMessages.GenerateConstructorUsingFieldsAction_error_actionfailed);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        this.notifyResult(dialogResult == 0);
    }

    private IMethodBinding getObjectConstructor(CompilationUnit compilationUnit) {
        ITypeBinding binding = compilationUnit.getAST().resolveWellKnownType("java.lang.Object");
        return Bindings.findMethodInType(binding, "Object", new ITypeBinding[0]);
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }
}

