/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class OpenEditorAction
extends Action {
    protected String fClassName;
    protected TestRunnerViewPart fTestRunner;
    private final boolean fActivate;

    protected OpenEditorAction(TestRunnerViewPart testRunner, String testClassName) {
        this(testRunner, testClassName, true);
    }

    public OpenEditorAction(TestRunnerViewPart testRunner, String className, boolean activate) {
        super(JUnitMessages.OpenEditorAction_action_label);
        this.fClassName = className;
        this.fTestRunner = testRunner;
        this.fActivate = activate;
    }

    public void run() {
        ITextEditor textEditor = null;
        try {
            IJavaElement element = this.findElement(this.getLaunchedProject(), this.fClassName);
            if (element == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)JUnitMessages.OpenEditorAction_error_cannotopen_title, (String)JUnitMessages.OpenEditorAction_error_cannotopen_message);
                return;
            }
            textEditor = (ITextEditor)EditorUtility.openInEditor((Object)element, (boolean)this.fActivate);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JUnitMessages.OpenEditorAction_error_dialog_title, (String)JUnitMessages.OpenEditorAction_error_dialog_message, (IStatus)e.getStatus());
            return;
        }
        if (textEditor == null) {
            this.fTestRunner.registerInfoMessage(JUnitMessages.OpenEditorAction_message_cannotopen);
            return;
        }
        this.reveal(textEditor);
    }

    protected Shell getShell() {
        return this.fTestRunner.getSite().getShell();
    }

    protected IJavaProject getLaunchedProject() {
        return this.fTestRunner.getLaunchedProject();
    }

    protected String getClassName() {
        return this.fClassName;
    }

    protected abstract IJavaElement findElement(IJavaProject var1, String var2) throws CoreException;

    protected abstract void reveal(ITextEditor var1);

    protected IType findType(IJavaProject project, String className) throws JavaModelException {
        return this.internalFindType(project, className, new HashSet());
    }

    private IType internalFindType(IJavaProject project, String className, Set visitedProjects) throws JavaModelException {
        if (visitedProjects.contains(project)) {
            return null;
        }
        IType type = project.findType(className, null);
        if (type != null) {
            return type;
        }
        visitedProjects.add(project);
        IJavaModel javaModel = project.getJavaModel();
        String[] requiredProjectNames = project.getRequiredProjectNames();
        int i = 0;
        while (i < requiredProjectNames.length) {
            IJavaProject requiredProject = javaModel.getJavaProject(requiredProjectNames[i]);
            if (requiredProject.exists() && (type = this.internalFindType(requiredProject, className, visitedProjects)) != null) {
                return type;
            }
            ++i;
        }
        return null;
    }
}

