/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.ITestSearchExtent;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfiguration;
import org.eclipse.jdt.internal.junit.launcher.SingleTypeTestSearchExtent;
import org.eclipse.jdt.internal.junit.launcher.TestKind;
import org.eclipse.jdt.internal.junit.launcher.TestSearchResult;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;

public class TestKindRegistry {
    public static final String JUNIT3_TEST_KIND_ID = "org.eclipse.jdt.junit.loader.junit3";
    public static final String JUNIT4_TEST_KIND_ID = "org.eclipse.jdt.junit.loader.junit4";
    private static TestKindRegistry fgRegistry;
    private final IExtensionPoint fPoint;
    private ArrayList fTestKinds;

    public static TestKindRegistry getDefault() {
        if (fgRegistry != null) {
            return fgRegistry;
        }
        fgRegistry = new TestKindRegistry(Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.junit.internal_testKinds"));
        return fgRegistry;
    }

    private TestKindRegistry(IExtensionPoint point) {
        this.fPoint = point;
    }

    public ArrayList getAllKinds() {
        this.loadKinds();
        return this.fTestKinds;
    }

    private void loadKinds() {
        if (this.fTestKinds != null) {
            return;
        }
        ArrayList<TestKind> items = new ArrayList<TestKind>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            items.add(new TestKind(element));
        }
        Collections.sort(items, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TestKind kind0 = (TestKind)arg0;
                TestKind kind1 = (TestKind)arg1;
                if (kind0.precedes(kind1)) {
                    return -1;
                }
                if (kind1.precedes(kind0)) {
                    return 1;
                }
                return 0;
            }
        });
        this.fTestKinds = items;
    }

    public ArrayList getDisplayNames() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList testTypes = this.getAllKinds();
        for (ITestKind type : testTypes) {
            result.add(type.getDisplayName());
        }
        return result;
    }

    public TestKind getKind(ILaunchConfiguration launchConfiguration) {
        String loaderId = "";
        try {
            loaderId = launchConfiguration.getAttribute("org.eclipse.jdt.junit.TEST_KIND", null);
        }
        catch (CoreException coreException) {}
        TestKind configuredKind = this.getKind(loaderId);
        if (configuredKind.isNull()) {
            try {
                IJavaProject javaProject = new JUnitLaunchConfiguration().getJavaProject(launchConfiguration);
                if (javaProject != null) {
                    return this.getKind(TestKindRegistry.getContainerTestKindId((IJavaElement)javaProject));
                }
            }
            catch (CoreException coreException) {}
        }
        return configuredKind;
    }

    private TestKind getKind(String testKindId) {
        if (testKindId != null) {
            for (TestKind kind : this.getAllKinds()) {
                if (!testKindId.equals(kind.getId())) continue;
                return kind;
            }
        }
        return ITestKind.NULL;
    }

    public ITestKind getKind(IType type) {
        TestKind projectKind = this.getKind(TestKindRegistry.getContainerTestKindId((IJavaElement)type));
        if (projectKind.isNull()) {
            return ITestKind.NULL;
        }
        try {
            TestSearchResult result = projectKind.search(new SingleTypeTestSearchExtent(type));
            if (!result.isEmpty()) {
                return projectKind;
            }
            return ITestKind.NULL;
        }
        catch (JavaModelException javaModelException) {
            return ITestKind.NULL;
        }
    }

    public static String getContainerTestKindId(IJavaElement element) {
        return element != null && TestSearchEngine.hasTestAnnotation(element.getJavaProject()) ? JUNIT4_TEST_KIND_ID : JUNIT3_TEST_KIND_ID;
    }

    private ArrayList getConfigurationElements() {
        ArrayList<IConfigurationElement> items = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = this.fPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                items.add(element);
                ++j;
            }
            ++i;
        }
        return items;
    }

    public String getAllKindIds() {
        ArrayList allKinds = this.getAllKinds();
        String returnThis = "";
        for (ITestKind kind : allKinds) {
            returnThis = String.valueOf(returnThis) + "(" + kind.getId() + ")";
        }
        return returnThis;
    }

    public TestSearchResult getTestTypes(ILaunchConfiguration configuration, ITestSearchExtent extent) throws JavaModelException {
        TestKind configuredKind = this.getKind(configuration);
        if (!configuredKind.isNull()) {
            return configuredKind.search(extent);
        }
        return new TestSearchResult(new IType[0], ITestKind.NULL);
    }
}

