/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.rubypeople.rdt.core.BufferChangedEvent;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IBufferChangedListener;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.codeassist.SelectionEngine;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.buffer.BufferManager;

public abstract class Openable
extends RubyElement
implements IOpenable,
IBufferChangedListener {
    public Openable(RubyElement rubyElement) {
        super(rubyElement);
    }

    public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
        if (bufferChangedEvent.getBuffer().isClosed()) {
            RubyModelManager.getRubyModelManager().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(bufferChangedEvent.getBuffer());
        } else {
            RubyModelManager.getRubyModelManager().getElementsOutOfSynchWithBuffers().put(this, this);
        }
    }

    public IBuffer getBuffer() throws RubyModelException {
        if (this.hasBuffer()) {
            this.getElementInfo();
            IBuffer iBuffer = this.getBufferManager().getBuffer(this);
            if (iBuffer == null) {
                iBuffer = this.openBuffer(null);
            }
            return iBuffer;
        }
        return null;
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor) {
        return null;
    }

    public boolean canBufferBeRemovedFromCache(IBuffer iBuffer) {
        return !iBuffer.hasUnsavedChanges();
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean isOpen() {
        return RubyModelManager.getRubyModelManager().getInfo(this) != null;
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    public IResource getCorrespondingResource() throws RubyModelException {
        return this.getUnderlyingResource();
    }

    public boolean canBeRemovedFromCache() {
        try {
            return !this.hasUnsavedChanges();
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
    }

    public boolean isConsistent() {
        return true;
    }

    public boolean isStructureKnown() throws RubyModelException {
        return ((OpenableElementInfo)this.getElementInfo()).isStructureKnown();
    }

    public boolean hasUnsavedChanges() throws RubyModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null && iBuffer.hasUnsavedChanges()) {
            return true;
        }
        int n = this.getElementType();
        if (n == 1 || n == 0) {
            Enumeration enumeration = this.getBufferManager().getOpenBuffers();
            while (enumeration.hasMoreElements()) {
                IRubyElement iRubyElement;
                IBuffer iBuffer2 = (IBuffer)enumeration.nextElement();
                if (!iBuffer2.hasUnsavedChanges() || !this.isAncestorOf(iRubyElement = (IRubyElement)((Object)iBuffer2.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    protected void closing(Object object) {
        this.closeBuffer();
    }

    public boolean exists() {
        RubyModelManager rubyModelManager = RubyModelManager.getRubyModelManager();
        if (rubyModelManager.getInfo(this) != null) {
            return true;
        }
        if (!this.parentExists()) {
            return false;
        }
        return super.exists();
    }

    protected boolean parentExists() {
        IRubyElement iRubyElement = this.getParent();
        if (iRubyElement == null) {
            return true;
        }
        return iRubyElement.exists();
    }

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer iBuffer = this.getBufferManager().getBuffer(this);
        if (iBuffer != null) {
            iBuffer.close();
            iBuffer.removeBufferChangedListener(this);
        }
    }

    protected void generateInfos(Object object, HashMap hashMap, IProgressMonitor iProgressMonitor) throws RubyModelException {
        Object object2;
        if (RubyModelManager.isVerbose()) {
            switch (this.getElementType()) {
                case 1: {
                    object2 = "project";
                    break;
                }
                case 2: {
                    object2 = "script";
                    break;
                }
                default: {
                    object2 = "element";
                }
            }
            System.out.println(Thread.currentThread() + " OPENING " + (String)object2 + " " + this.toString());
        }
        this.openParent(object, hashMap, iProgressMonitor);
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        hashMap.put(this, object);
        try {
            object2 = (OpenableElementInfo)object;
            boolean bl = this.buildStructure((OpenableElementInfo)object2, iProgressMonitor, hashMap, this.getResource());
            ((RubyElementInfo)object2).setIsStructureKnown(bl);
        }
        catch (RubyModelException rubyModelException) {
            hashMap.remove(this);
            throw rubyModelException;
        }
        RubyModelManager.getRubyModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        if (RubyModelManager.isVerbose()) {
            System.out.println(RubyModelManager.getRubyModelManager().cache.toStringFillingRation("-> "));
        }
    }

    protected abstract boolean buildStructure(OpenableElementInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws RubyModelException;

    protected void openParent(Object object, HashMap hashMap, IProgressMonitor iProgressMonitor) throws RubyModelException {
        Openable openable = (Openable)this.getOpenableParent();
        if (openable != null && !openable.isOpen()) {
            openable.generateInfos(openable.createElementInfo(), hashMap, iProgressMonitor);
        }
    }

    /*
     * Exception decompiling
     */
    public void makeConsistent(IProgressMonitor var1_1) throws RubyModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 132->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws RubyModelException {
        if (this.isReadOnly()) {
            throw new RubyModelException(new RubyModelStatus(976, this));
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null) {
            iBuffer.save(iProgressMonitor, bl);
            this.makeConsistent(iProgressMonitor);
        }
    }

    public void open(IProgressMonitor iProgressMonitor) throws RubyModelException {
        this.getElementInfo(iProgressMonitor);
    }

    protected IRubyElement[] codeSelect(IRubyScript iRubyScript, int n, int n2, WorkingCopyOwner workingCopyOwner) throws RubyModelException {
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer == null) {
            return new IRubyElement[0];
        }
        int n3 = iBuffer.getLength();
        if (n < 0 || n2 < 0 || n + n2 > n3) {
            throw new RubyModelException(new RubyModelStatus(980));
        }
        SelectionEngine selectionEngine = new SelectionEngine();
        return selectionEngine.select(iRubyScript, n, n + n2 - 1);
    }
}

