/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.Target;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetEnumeratingVisitor
extends EmptyVisitor
implements EdgeTypes {
    private InstructionHandle handle;
    private ConstantPoolGen constPoolGen;
    private LinkedList<Target> targetList;
    private boolean isBranch;
    private boolean isReturn;
    private boolean isThrow;
    private boolean isExit;

    public TargetEnumeratingVisitor(InstructionHandle handle, ConstantPoolGen constPoolGen) {
        this.handle = handle;
        this.constPoolGen = constPoolGen;
        this.targetList = new LinkedList();
        this.isExit = false;
        this.isThrow = false;
        this.isReturn = false;
        this.isBranch = false;
        handle.getInstruction().accept(this);
    }

    public boolean isEndOfBasicBlock() {
        return this.isBranch || this.isReturn || this.isThrow || this.isExit;
    }

    public boolean instructionIsReturn() {
        return this.isReturn;
    }

    public boolean instructionIsThrow() {
        return this.isThrow;
    }

    public boolean instructionIsExit() {
        return this.isExit;
    }

    public Iterator<Target> targetIterator() {
        return this.targetList.iterator();
    }

    @Override
    public void visitGotoInstruction(GotoInstruction ins) {
        this.isBranch = true;
        InstructionHandle target = ins.getTarget();
        if (target == null) {
            throw new IllegalStateException();
        }
        this.targetList.add(new Target(target, 6));
    }

    @Override
    public void visitIfInstruction(IfInstruction ins) {
        this.isBranch = true;
        InstructionHandle target = ins.getTarget();
        if (target == null) {
            throw new IllegalStateException();
        }
        this.targetList.add(new Target(target, 1));
        InstructionHandle fallThrough = this.handle.getNext();
        this.targetList.add(new Target(fallThrough, 0));
    }

    @Override
    public void visitSelect(Select ins) {
        InstructionHandle[] targets;
        this.isBranch = true;
        for (InstructionHandle target : targets = ins.getTargets()) {
            this.targetList.add(new Target(target, 2));
        }
        InstructionHandle defaultTarget = ins.getTarget();
        if (defaultTarget == null) {
            throw new IllegalStateException();
        }
        this.targetList.add(new Target(defaultTarget, 3));
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction ins) {
        this.isReturn = true;
    }

    @Override
    public void visitATHROW(ATHROW ins) {
        this.isThrow = true;
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC ins) {
        String className = ins.getClassName(this.constPoolGen);
        String methodName = ins.getName(this.constPoolGen);
        String methodSig = ins.getSignature(this.constPoolGen);
        if (className.equals("java.lang.System") && methodName.equals("exit") && methodSig.equals("(I)V")) {
            this.isExit = true;
        }
    }
}

