use strict;
use warnings;

package CouchDB::View;

our $VERSION = '0.003';

1;
__END__

=head1 NAME

CouchDB::View - handle and create CouchDB views in Perl

=head1 VERSION

Version 0.003

=head1 DESCRIPTION

See L<CouchDB::View::Document> for a convenient interface to defining CouchDB
views in Perl.

See L<CouchDB::View::Server> for instructions on how to use Perl as a CouchDB
view server.

You may also want to see L<the CouchDB home page|http://incubator.apache.org/couchdb/> or L<the CouchDB wiki|http://wiki.apache.org/couchdb/>.

=head1 AUTHOR

Hans Dieter Pearcey, C<< <hdp at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-couchdb-view at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=CouchDB-View>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc CouchDB::View


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=CouchDB-View>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/CouchDB-View>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/CouchDB-View>

=item * Search CPAN

L<http://search.cpan.org/dist/CouchDB-View>

=back

=head1 COPYRIGHT & LICENSE

Copyright 2008 Hans Dieter Pearcey, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.


=cut
