/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.attributes;

import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JLineNumberRecord;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class JLineNumberTableAttr
extends JAttribute {
    private JLineNumberRecord[] records;

    JLineNumberRecord[] getJLineNumberRecords() {
        return this.records;
    }

    JLineNumberTableAttr(JConstantPool jConstantPool) {
        super(jConstantPool);
    }

    @Override
    public void parse(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readUnsignedShort();
        this.records = new JLineNumberRecord[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = dataInputStream.readUnsignedShort();
            int n4 = dataInputStream.readUnsignedShort();
            this.records[i] = new JLineNumberRecord(n3, n4);
        }
    }

    public int getLineNumber(int n) {
        int n2 = -1;
        int n3 = -1;
        for (JLineNumberRecord jLineNumberRecord : this.records) {
            if (jLineNumberRecord.getStartPc() > n) continue;
            if (n3 == -1) {
                n3 = n - jLineNumberRecord.getStartPc();
                n2 = jLineNumberRecord.getSourceLineNumber();
                continue;
            }
            if (n - jLineNumberRecord.getStartPc() >= n3) continue;
            n3 = n - jLineNumberRecord.getStartPc();
            n2 = jLineNumberRecord.getSourceLineNumber();
        }
        return n2;
    }
}

