/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;

public class ScrollPaneSupport
extends AbstractLayoutSupport {
    @Override
    public Class getSupportedClass() {
        return ScrollPane.class;
    }

    @Override
    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        if (container.getComponentCount() > 1) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getAssistantContext() {
        return "scrollPaneLayout";
    }

    @Override
    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        Dimension sz = container.getSize();
        Insets insets = container.getInsets();
        sz.width -= insets.left + insets.right;
        sz.height -= insets.top + insets.bottom;
        g.drawRect(0, 0, sz.width, sz.height);
        return true;
    }

    @Override
    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        if (components.length == 0) {
            return;
        }
        if (container instanceof ScrollPane) {
            ScrollPane scroll = (ScrollPane)container;
            Component removedComp = null;
            if (scroll.getComponentCount() > 0) {
                removedComp = scroll.getComponent(0);
            }
            try {
                scroll.add(components[0]);
            }
            catch (NullPointerException npex) {
                // empty catch block
            }
            ScrollPaneSupport.ensureFakePeerAttached(removedComp);
        }
    }

    @Override
    public boolean removeComponentFromContainer(Container container, Container containerDelegate, Component component) {
        return false;
    }

    private static void ensureFakePeerAttached(Component comp) {
        FakePeerSupport.attachFakePeer(comp);
        if (comp instanceof Container) {
            FakePeerSupport.attachFakePeerRecursively((Container)comp);
        }
    }
}

