/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

abstract class ScopeImpl
extends ModelElementImpl
implements Scope {
    private OffsetRange blockRange = null;
    private final List<ModelElementImpl> elements = Collections.synchronizedList(new LinkedList());

    ScopeImpl(Scope inScope, ASTNodeInfo info, PhpModifiers modifiers, Block block) {
        super(inScope, info, modifiers);
        this.setBlockRange(block);
    }

    ScopeImpl(Scope inScope, PhpElement element, PhpElementKind kind) {
        super(inScope, element, kind);
    }

    ScopeImpl(Scope inScope, String name, Union2<String, FileObject> file, OffsetRange offsetRange, PhpElementKind kind) {
        super(inScope, name, file, offsetRange, kind);
        assert (ScopeImpl.isScopeKind(kind)) : kind.toString();
    }

    ScopeImpl(Scope inScope, String name, Union2<String, FileObject> file, OffsetRange offsetRange, PhpElementKind kind, PhpModifiers modifier) {
        super(inScope, name, file, offsetRange, kind, modifier);
        assert (ScopeImpl.isScopeKind(kind)) : kind.toString();
    }

    private static boolean isScopeKind(PhpElementKind kind) {
        switch (kind) {
            case PROGRAM: 
            case NAMESPACE_DECLARATION: 
            case INDEX: 
            case CLASS: 
            case FUNCTION: 
            case IFACE: 
            case METHOD: 
            case VARIABLE: 
            case FIELD: {
                return true;
            }
        }
        return false;
    }

    public List<? extends ModelElementImpl> getElements() {
        return new ArrayList<ModelElementImpl>(this.elements);
    }

    void addElement(ModelElementImpl element) {
        this.elements.add(element);
    }

    static <T extends ModelElement> Collection<? extends T> filter(Collection<? extends ModelElement> original, ElementFilter<T> filter) {
        HashSet<ModelElement> retval = new HashSet<ModelElement>();
        for (ModelElement modelElement : original) {
            boolean accepted = filter.isAccepted(modelElement);
            if (!accepted) continue;
            retval.add(modelElement);
        }
        return retval;
    }

    void setBlockRange(Block block) {
        if (block != null) {
            this.blockRange = new OffsetRange(block.getStartOffset(), block.getEndOffset());
        }
    }

    void setBlockRange(ASTNode program) {
        this.blockRange = new OffsetRange(program.getStartOffset(), program.getEndOffset());
    }

    @Override
    public OffsetRange getBlockRange() {
        return this.blockRange;
    }

    static interface ElementFilter<T extends ModelElement> {
        public boolean isAccepted(ModelElement var1);
    }
}

