/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.spi.support;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.JDKDerbyHelper;
import org.netbeans.modules.derby.RegisterDerby;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DerbySupport {
    private static final Logger LOGGER = Logger.getLogger(DerbySupport.class.getName());

    private DerbySupport() {
    }

    public static void setLocation(String location) {
        LOGGER.log(Level.FINE, "setLocation called for {0}", location);
        String jdkDerbyLocation = JDKDerbyHelper.forDefault().findDerbyLocation();
        String realLocation = jdkDerbyLocation != null ? jdkDerbyLocation : location;
        DerbyOptions.getDefault().trySetLocation(realLocation);
    }

    public static String getLocation() {
        return DerbyOptions.getDefault().getLocation();
    }

    public static void setSystemHome(String systemHome) {
        DerbyOptions.getDefault().setSystemHome(systemHome);
    }

    public static String getSystemHome() {
        return DerbyOptions.getDefault().getSystemHome();
    }

    public static String getDefaultSystemHome() {
        String propertySystemHome = System.getProperty("netbeans.derby.system.home");
        if (propertySystemHome != null) {
            return propertySystemHome;
        }
        String userHome = System.getProperty("user.home");
        return FileUtil.normalizeFile((File)new File(userHome, NbBundle.getMessage(DerbySupport.class, (String)"LBL_DerbyDatabaseDirectory"))).getAbsolutePath();
    }

    public static void ensureStarted() {
        RegisterDerby.getDefault().ensureStarted(false);
    }
}

