/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.Node;
import org.mozilla.nb.javascript.Token;
import org.openide.util.Enumerations;

class AstNodeAdapter
implements TreeNode {
    private Node node;
    private AstNodeAdapter parent;
    private AstNodeAdapter[] children;
    private List<AstNodeAdapter> childrenList;
    int endOffset = -1;

    AstNodeAdapter(AstNodeAdapter astNodeAdapter, Node node) {
        this.parent = astNodeAdapter;
        this.node = node;
    }

    private void ensureChildrenInitialized() {
        String string;
        if (this.children != null) {
            return;
        }
        ArrayList<AstNodeAdapter> arrayList = new ArrayList<AstNodeAdapter>();
        if (this.node.getType() == 108) {
            string = this.node instanceof FunctionNode ? ((FunctionNode)this.node).getFunctionName() : this.node.getString();
        }
        if (this.node.hasChildren()) {
            for (string = this.node.getFirstChild(); string != null; string = string.getNext()) {
                arrayList.add(new AstNodeAdapter(this, (Node)string));
            }
            this.children = arrayList.toArray(new AstNodeAdapter[arrayList.size()]);
        } else {
            this.children = new AstNodeAdapter[0];
        }
        if (this.children == null) {
            this.children = new AstNodeAdapter[0];
        }
    }

    @Override
    public TreeNode getChildAt(int n) {
        this.ensureChildrenInitialized();
        return this.children[n];
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenInitialized();
        return this.children.length;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        this.ensureChildrenInitialized();
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != treeNode) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        this.ensureChildrenInitialized();
        return this.children.length > 0;
    }

    @Override
    public boolean isLeaf() {
        this.ensureChildrenInitialized();
        return this.children.length == 0;
    }

    public Enumeration children() {
        this.ensureChildrenInitialized();
        return Enumerations.array((Object[])this.children);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Token.fullName((int)this.node.getType()));
        String string = null;
        if (this.node instanceof Node.StringNode) {
            stringBuffer.append(":\"");
            stringBuffer.append(this.node.getString());
            stringBuffer.append("\"");
        } else if (this.node instanceof Node.NumberNode) {
            stringBuffer.append(":");
            stringBuffer.append(this.node.getDouble());
        }
        if (string != null) {
            stringBuffer.append(" : ");
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        stringBuffer.append("(");
        stringBuffer.append(Integer.toString(this.getStartOffset()));
        stringBuffer.append("-");
        stringBuffer.append(Integer.toString(this.getEndOffset()));
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }

    public int getStartOffset() {
        return Math.max(0, this.node.getSourceStart());
    }

    public int getEndOffset() {
        return Math.max(0, this.node.getSourceEnd());
    }

    public Object getAstNode() {
        return this.node;
    }
}

