/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.support.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.FileChooserUI;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AntArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private String artifactType;
    private JFileChooser chooser;
    private JButton approveButton;
    private JLabel jLabelJarFiles;
    private JLabel jLabelName;
    private JList jListArtifacts;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;

    public AntArtifactChooser(String artifactType, JFileChooser chooser) {
        this.artifactType = artifactType;
        this.chooser = chooser;
        this.initComponents();
        this.initAccessibility();
        this.jListArtifacts.setModel(new DefaultListModel());
        chooser.addPropertyChangeListener(this);
        if (this.setValid(false)) {
            this.jListArtifacts.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    AntArtifactChooser.this.setValid(AntArtifactChooser.this.jListArtifacts.getSelectedIndex() >= 0);
                }
            });
        }
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelJarFiles = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListArtifacts = new JList();
        this.setLayout(new GridBagLayout());
        this.jLabelName.setLabelFor(this.jTextFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelName, (String)NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AAChooser_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelName, gridBagConstraints);
        this.jTextFieldName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabelJarFiles.setLabelFor(this.jListArtifacts);
        Mnemonics.setLocalizedText((JLabel)this.jLabelJarFiles, (String)NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AAChooser_JARFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelJarFiles, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jListArtifacts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void initAccessibility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setValid(boolean valid) {
        AntArtifactChooser antArtifactChooser = this;
        synchronized (antArtifactChooser) {
            if (this.approveButton == null) {
                try {
                    FileChooserUI ui = this.chooser.getUI();
                    Method m = ui.getClass().getDeclaredMethod("getApproveButton", JFileChooser.class);
                    m.setAccessible(true);
                    this.approveButton = (JButton)m.invoke((Object)ui, this.chooser);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.approveButton != null) {
            this.approveButton.setEnabled(valid);
        }
        return this.approveButton != null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("SelectedFileChangedProperty".equals(e.getPropertyName())) {
            JFileChooser chooser = (JFileChooser)e.getSource();
            File dir = chooser.getSelectedFile();
            Project project = this.getProject(dir);
            this.populateAccessory(project);
        }
    }

    private Project getProject(File projectDir) {
        if (projectDir == null) {
            return null;
        }
        try {
            File normProjectDir = FileUtil.normalizeFile((File)projectDir);
            FileObject fo = FileUtil.toFileObject((File)normProjectDir);
            if (fo != null) {
                return ProjectManager.getDefault().findProject(fo);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return null;
    }

    private void populateAccessory(Project project) {
        DefaultListModel model = (DefaultListModel)this.jListArtifacts.getModel();
        model.clear();
        this.jTextFieldName.setText(project == null ? "" : ProjectUtils.getInformation((Project)project).getDisplayName());
        if (project != null) {
            AntArtifact[] artifacts = AntArtifactQuery.findArtifactsByType((Project)project, (String)this.artifactType);
            for (int i = 0; i < artifacts.length; ++i) {
                URI[] uris = artifacts[i].getArtifactLocations();
                for (int j = 0; j < uris.length; ++j) {
                    model.addElement(new ArtifactItem(artifacts[i], uris[j]));
                }
            }
            this.jListArtifacts.setSelectionInterval(0, model.size() - 1);
        }
    }

    private static Container findParent() {
        return DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)new JPanel(), "")).getParent();
    }

    public static ArtifactItem[] showDialog(String artifactType) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        chooser.setDialogTitle(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AAChooserSelectProject"));
        chooser.setApproveButtonText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AAChooser_AddJARFiles"));
        AntArtifactChooser accessory = new AntArtifactChooser(artifactType, chooser);
        chooser.setAccessory(accessory);
        chooser.setPreferredSize(new Dimension(650, 380));
        int option = chooser.showOpenDialog(AntArtifactChooser.findParent());
        if (option == 0) {
            Object[] elements = accessory.jListArtifacts.getSelectedValues();
            ArtifactItem[] artifacts = new ArtifactItem[elements.length];
            System.arraycopy(elements, 0, artifacts, 0, elements.length);
            return artifacts;
        }
        return null;
    }

    public static class ArtifactItem {
        private final AntArtifact artifact;
        private final URI uri;

        ArtifactItem(AntArtifact artifact, URI uri) {
            this.artifact = artifact;
            this.uri = uri;
        }

        public AntArtifact getArtifact() {
            return this.artifact;
        }

        public URI getURI() {
            return this.uri;
        }

        public String toString() {
            return this.uri.getPath();
        }
    }
}

