/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.editor.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.options.editor.FolderBasedController;

public final class OptionsFilter {
    private final Document doc;
    private final AtomicBoolean used;

    private OptionsFilter(Document doc, AtomicBoolean used) {
        this.doc = doc;
        this.used = used;
    }

    public void installFilteringModel(JTree tree, TreeModel source, Acceptor acceptor) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not in AWT Event Dispatch Thread");
        }
        this.used.set(true);
        tree.setModel(new FilteringTreeModel(source, this.doc, acceptor));
    }

    static {
        FolderBasedController.setFilterAccessor(new FolderBasedController.OptionsFilterAccessor(){

            @Override
            public OptionsFilter create(Document doc, AtomicBoolean used) {
                return new OptionsFilter(doc, used);
            }
        });
    }

    private static final class FilteringTreeModel
    implements TreeModel,
    TreeModelListener,
    DocumentListener {
        private final TreeModel delegate;
        private final Document filter;
        private final Acceptor acceptor;
        private final Map<Object, List<Object>> category2Nodes = new HashMap<Object, List<Object>>();
        private final List<Object> categories;
        private final List<TreeModelListener> listeners = new LinkedList<TreeModelListener>();

        public FilteringTreeModel(TreeModel delegate, Document filter, Acceptor acceptor) {
            this.delegate = delegate;
            this.filter = filter;
            this.acceptor = acceptor;
            this.delegate.addTreeModelListener(this);
            this.filter.addDocumentListener(this);
            this.categories = new ArrayList<Object>(delegate.getChildCount(delegate.getRoot()));
            this.filter();
        }

        @Override
        public Object getRoot() {
            return this.delegate.getRoot();
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.getRoot()) {
                return this.categories.get(index);
            }
            return this.category2Nodes.get(parent).get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.getRoot()) {
                return this.categories.size();
            }
            return this.category2Nodes.get(parent).size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.delegate.isLeaf(node);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            this.delegate.valueForPathChanged(path, newValue);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this.getRoot()) {
                return this.categories.indexOf(child);
            }
            return this.category2Nodes.get(parent).indexOf(child);
        }

        @Override
        public synchronized void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public synchronized void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        private synchronized Iterable<? extends TreeModelListener> getListeners() {
            return new LinkedList<TreeModelListener>(this.listeners);
        }

        void filter() {
            final String[] term = new String[1];
            this.filter.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        term[0] = FilteringTreeModel.this.filter.getText(0, FilteringTreeModel.this.filter.getLength());
                    }
                    catch (BadLocationException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            });
            this.category2Nodes.clear();
            this.categories.clear();
            Object root = this.delegate.getRoot();
            for (int c = 0; c < this.delegate.getChildCount(root); ++c) {
                Object object = this.delegate.getChild(root, c);
                ArrayList<Object> filtered = new ArrayList<Object>(this.delegate.getChildCount(object));
                for (int h = 0; h < this.delegate.getChildCount(object); ++h) {
                    Object hint = this.delegate.getChild(object, h);
                    if (!term[0].isEmpty() && !this.acceptor.accept(hint, term[0])) continue;
                    filtered.add(hint);
                }
                if (!term[0].isEmpty() && filtered.isEmpty()) continue;
                this.category2Nodes.put(object, filtered);
                this.categories.add(object);
            }
            for (TreeModelListener treeModelListener : this.getListeners()) {
                treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.filter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.filter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            for (TreeModelListener treeModelListener : this.getListeners()) {
                treeModelListener.treeNodesChanged(e);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            throw new UnsupportedOperationException("Currently not supported.");
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            throw new UnsupportedOperationException("Currently not supported.");
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            throw new UnsupportedOperationException("Currently not supported.");
        }
    }

    public static interface Acceptor {
        public boolean accept(Object var1, String var2);
    }
}

