/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.winp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

class Native {
    private static final Logger LOGGER = Logger.getLogger(Native.class.getName());
    private static final String DLL_TARGET = "winp.folder.preferred";

    Native() {
    }

    static native boolean kill(int var0, boolean var1);

    static native int setPriority(int var0, int var1);

    static native int getProcessId(int var0);

    static native boolean exitWindowsEx(int var0, int var1);

    static native String getCmdLineAndEnvVars(int var0);

    static native int enumProcesses(int[] var0);

    static native void enableDebugPrivilege();

    static native void noop();

    private static void load() {
        boolean win64 = "64".equals(System.getProperty("sun.arch.data.model"));
        String dllName = win64 ? "winp.x64" : "winp";
        URL res = Native.class.getClassLoader().getResource(dllName + ".dll");
        if (res != null) {
            String url = res.toExternalForm();
            if (url.startsWith("jar:") || url.startsWith("wsjar:")) {
                int idx = url.lastIndexOf(33);
                String filePortion = url.substring(url.indexOf(58) + 1, idx);
                while (filePortion.startsWith("/")) {
                    filePortion = filePortion.substring(1);
                }
                if (filePortion.startsWith("file:/")) {
                    if ((filePortion = filePortion.substring(6)).startsWith("//")) {
                        filePortion = filePortion.substring(2);
                    }
                    filePortion = URLDecoder.decode(filePortion);
                    String preferred = System.getProperty(DLL_TARGET);
                    File jarFile = new File(filePortion);
                    File dllFile = new File(preferred != null ? new File(preferred) : jarFile.getParentFile(), dllName + ".dll");
                    if (!dllFile.exists() || jarFile.lastModified() > dllFile.lastModified()) {
                        try {
                            Native.copyStream(res.openStream(), new FileOutputStream(dllFile));
                            dllFile.setLastModified(jarFile.lastModified());
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Failed to write " + dllName + ".dll", e);
                        }
                    }
                    Native.loadDll(dllFile);
                    return;
                }
            }
            if (url.startsWith("file:")) {
                File f;
                try {
                    f = new File(res.toURI());
                }
                catch (URISyntaxException e) {
                    f = new File(res.getPath());
                }
                Native.loadDll(f);
                return;
            }
        }
        try {
            System.loadLibrary(dllName);
        }
        catch (Throwable cause) {
            if (res != null) {
                File dll = null;
                try {
                    dll = File.createTempFile(dllName, "dll");
                    Native.copyStream(res.openStream(), new FileOutputStream(dll));
                    Native.loadDll(dll);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to write " + dllName + ".dll", e);
                }
                catch (LinkageError e) {
                    LOGGER.log(Level.WARNING, "Failed to load winp.dll from " + dll, e);
                }
            }
            UnsatisfiedLinkError error = new UnsatisfiedLinkError("Unable to load " + dllName + ".dll");
            error.initCause(cause);
            throw error;
        }
    }

    private static void loadDll(File dllFile) {
        try {
            System.load(dllFile.getPath());
        }
        catch (LinkageError e) {
            for (int i = 0; i < 5; ++i) {
                try {
                    System.gc();
                    System.gc();
                    Thread.sleep(1000L);
                    System.load(dllFile.getPath());
                    return;
                }
                catch (InterruptedException x) {
                    throw e;
                }
                catch (LinkageError linkageError) {
                    continue;
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    static {
        Native.load();
    }
}

