/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Predicate;

public class ListUtils {
    public static List intersection(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!list.contains(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static List subtract(List list, List list2) {
        ArrayList arrayList = new ArrayList(list);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            arrayList.remove(iterator.next());
        }
        return arrayList;
    }

    public static List sum(List list, List list2) {
        return ListUtils.subtract(ListUtils.union(list, list2), ListUtils.intersection(list, list2));
    }

    public static List union(List list, List list2) {
        ArrayList arrayList = new ArrayList(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    public static List predicatedList(List list, Predicate predicate) {
        return new PredicatedList(list, predicate);
    }

    public static List lazyList(List list, Factory factory) {
        return new LazyList(list, factory);
    }

    public static List fixedSizeList(List list) {
        return new FixedSizeList(list);
    }

    static class LazyList
    extends CollectionUtils.CollectionWrapper
    implements List {
        protected final Factory factory;

        public LazyList(List list, Factory factory) {
            super(list);
            if (factory == null) {
                throw new IllegalArgumentException("Factory must not be null");
            }
            this.factory = factory;
        }

        public Object get(int n) {
            if (n < this.getList().size()) {
                Object object = this.getList().get(n);
                if (object == null) {
                    object = this.factory.create();
                    this.getList().set(n, object);
                    return object;
                }
                return object;
            }
            int n2 = this.getList().size();
            while (n2 < n) {
                this.getList().add(null);
                ++n2;
            }
            Object object = this.factory.create();
            this.getList().add(object);
            return object;
        }

        public List subList(int n, int n2) {
            return new LazyList(this.getList().subList(n, n2), this.factory);
        }

        public boolean addAll(int n, Collection collection) {
            return this.getList().addAll(n, collection);
        }

        public Object set(int n, Object object) {
            return this.getList().set(n, object);
        }

        public void add(int n, Object object) {
            this.getList().add(n, object);
        }

        public Object remove(int n) {
            return this.getList().remove(n);
        }

        public int indexOf(Object object) {
            return this.getList().indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.getList().lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.getList().listIterator();
        }

        public ListIterator listIterator(int n) {
            return this.getList().listIterator(n);
        }

        private List getList() {
            return (List)this.collection;
        }
    }

    static class FixedSizeList
    extends CollectionUtils.UnmodifiableCollection
    implements List {
        public FixedSizeList(List list) {
            super(list);
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public Object get(int n) {
            return this.getList().get(n);
        }

        public Object set(int n, Object object) {
            return this.getList().set(n, object);
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object object) {
            return this.getList().indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.getList().lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n) {
            return new ListIteratorWrapper(this, this.getList().listIterator(n)){
                private final /* synthetic */ FixedSizeList this$0;
                {
                    this.this$0 = fixedSizeList;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void add(Object object) {
                    throw new UnsupportedOperationException();
                }

                public void remove(Object object) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List subList(int n, int n2) {
            List list = this.getList().subList(n, n2);
            return new FixedSizeList(list);
        }

        private List getList() {
            return (List)this.collection;
        }
    }

    static class PredicatedList
    extends CollectionUtils.PredicatedCollection
    implements List {
        public PredicatedList(List list, Predicate predicate) {
            super(list, predicate);
        }

        public boolean addAll(int n, Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.validate(iterator.next());
            }
            return this.getList().addAll(n, collection);
        }

        public Object get(int n) {
            return this.getList().get(n);
        }

        public Object set(int n, Object object) {
            this.validate(object);
            return this.getList().set(n, object);
        }

        public void add(int n, Object object) {
            this.validate(object);
            this.getList().add(n, object);
        }

        public Object remove(int n) {
            return this.getList().remove(n);
        }

        public int indexOf(Object object) {
            return this.getList().indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.getList().lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n) {
            return new ListIteratorWrapper(this, this.getList().listIterator(n)){
                private final /* synthetic */ PredicatedList this$0;
                {
                    this.this$0 = predicatedList;
                }

                public void add(Object object) {
                    this.this$0.validate(object);
                    this.iterator.add(object);
                }

                public void set(Object object) {
                    this.this$0.validate(object);
                    this.iterator.set(object);
                }
            };
        }

        public List subList(int n, int n2) {
            List list = this.getList().subList(n, n2);
            return new PredicatedList(list, this.predicate);
        }

        private List getList() {
            return (List)this.collection;
        }
    }

    static class ListIteratorWrapper
    implements ListIterator {
        protected final ListIterator iterator;

        public ListIteratorWrapper(ListIterator listIterator) {
            this.iterator = listIterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object previous() {
            return this.iterator.previous();
        }

        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        public void remove() {
            this.iterator.remove();
        }

        public void set(Object object) {
            this.iterator.set(object);
        }

        public void add(Object object) {
            this.iterator.add(object);
        }
    }
}

