/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.util.Arrays;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public final class FileCommandAction
extends ProjectAction {
    private String presenterName;

    public FileCommandAction(String command, String namePattern, String iconResource, Lookup lookup) {
        this(command, namePattern, (Icon)ImageUtilities.loadImageIcon((String)iconResource, (boolean)false), lookup);
    }

    public FileCommandAction(String command, String namePattern, Icon icon, Lookup lookup) {
        super(command, namePattern, icon, lookup);
        assert (namePattern != null) : "Name patern must not be null";
        this.presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        this.setDisplayName(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    @Override
    protected void refresh(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.getCommand());
        if (projects.length != 1) {
            if (projects.length == 0 && this.globalProvider(context) != null) {
                this.setEnabled(true);
                Collection files = context.lookupAll(DataObject.class);
                this.presenterName = ActionsUtil.formatName(this.getNamePattern(), files.size(), files.isEmpty() ? "" : ((DataObject)files.iterator().next()).getPrimaryFile().getNameExt());
            } else {
                this.setEnabled(false);
                this.presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
            }
        } else {
            FileObject[] files = ActionsUtil.getFilesFromLookup(context, projects[0]);
            this.setEnabled(true);
            this.presenterName = ActionsUtil.formatName(this.getNamePattern(), files.length, files.length > 0 ? files[0].getNameExt() : "");
        }
        this.putValue("menuText", this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    @Override
    protected void actionPerformed(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.getCommand());
        if (projects.length == 1) {
            ActionProvider ap = (ActionProvider)projects[0].getLookup().lookup(ActionProvider.class);
            ap.invokeAction(this.getCommand(), context);
            return;
        }
        ActionProvider provider = this.globalProvider(context);
        if (provider != null) {
            provider.invokeAction(this.getCommand(), context);
        }
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new FileCommandAction(this.getCommand(), this.getNamePattern(), (Icon)this.getValue("SmallIcon"), actionContext);
    }

    private ActionProvider globalProvider(Lookup context) {
        for (ActionProvider ap : Lookup.getDefault().lookupAll(ActionProvider.class)) {
            if (!Arrays.asList(ap.getSupportedActions()).contains(this.getCommand()) || !ap.isActionEnabled(this.getCommand(), context)) continue;
            return ap;
        }
        return null;
    }
}

