/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.ui.top;

import java.util.Formatter;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.asm.model.lang.instruction.Instruction;
import org.netbeans.modules.cnd.asm.model.lang.instruction.InstructionArgs;

public class InstructionInfoPanel
extends JPanel {
    private String infoTemplate = "%s  -  %s\n";
    private JScrollPane jInfoScrollPanel;
    private JTextArea jInfoTextArea;

    public InstructionInfoPanel() {
        this.initComponents();
    }

    public void setInstruction(Instruction instr) {
        StringBuilder res = new StringBuilder();
        res.append(new Formatter().format(this.infoTemplate, instr.getName(), instr.getDescription()));
        for (InstructionArgs arg : instr.getArguments()) {
            res.append("\n").append(instr.getName());
            for (String mnemonic : arg.getParamMnemonic()) {
                res.append(" ").append(mnemonic);
            }
            res.append(" - ").append(arg.getDescription());
        }
        this.jInfoTextArea.setText(res.toString());
    }

    private void initComponents() {
        this.jInfoScrollPanel = new JScrollPane();
        this.jInfoTextArea = new JTextArea();
        this.setLayout(new BoxLayout(this, 1));
        this.jInfoTextArea.setColumns(50);
        this.jInfoTextArea.setRows(5);
        this.jInfoScrollPanel.setViewportView(this.jInfoTextArea);
        this.add(this.jInfoScrollPanel);
    }
}

