/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.Collections;
import java.util.Set;

public class MethodInfo {
    private Set marks;
    private String className;
    private String methodName;
    private String signature;
    private String threadName;
    private int methodId;

    public MethodInfo(int methodId, String className, String methodName, String signature, String threadName, Set marks) {
        this.methodId = methodId;
        this.methodName = methodName;
        this.className = className;
        this.signature = signature;
        this.marks = Collections.synchronizedSet(marks);
        this.threadName = threadName;
    }

    public String getClassName() {
        return this.className;
    }

    public Set getMarks() {
        return this.marks;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public boolean isUnmarked() {
        return this.marks == null || this.marks.size() == 0 || this.marks.size() == 1 && (this.marks.contains("PROJECT") || this.marks.contains("USER")) || this.marks.size() == 2 && this.marks.contains("PROJECT") && this.marks.contains("USER");
    }

    public boolean equals(Object anotherObj) {
        if (anotherObj == null) {
            return false;
        }
        if (anotherObj instanceof MethodInfo) {
            return this.methodId == ((MethodInfo)anotherObj).methodId && this.threadName.equals(((MethodInfo)anotherObj).threadName);
        }
        return false;
    }

    public int hashCode() {
        return this.methodId;
    }
}

