/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.ui.query.FindInQuerySupport;
import org.openide.util.NbBundle;

class FindInQueryBar
extends JPanel {
    private static final int MAX_SEARCH_MODEL_SIZE = 5;
    private FindInQuerySupport support;
    private boolean initialized;
    private DefaultComboBoxModel lastSearchModel;
    private JButton closeButton;
    private JComboBox findCombo;
    private JLabel findLabel;
    private JCheckBox highlightResultsChoice;
    private JCheckBox machCaseChoice;
    private JCheckBox regularExpressionChoice;
    private JCheckBox wholeWordsChoice;

    FindInQueryBar(FindInQuerySupport support) {
        this.support = support;
        this.initComponents();
        this.lastSearchModel = new DefaultComboBoxModel();
        this.findCombo.setModel(this.lastSearchModel);
        this.findCombo.setSelectedItem("");
        this.initialized = true;
        this.addComboEditorListener();
        InputMap inputMap = this.getInputMap(1);
        String closeKey = "close";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), closeKey);
        this.getActionMap().put(closeKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindInQueryBar.this.support.cancel();
            }
        });
    }

    private void addComboEditorListener() {
        Component editor = this.findCombo.getEditor().getEditorComponent();
        if (editor instanceof JTextComponent) {
            JTextComponent tcomp = (JTextComponent)editor;
            tcomp.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FindInQueryBar.this.support.updatePattern();
                }
            });
        }
    }

    String getText() {
        return this.findCombo.getEditor().getItem().toString();
    }

    boolean getMatchCase() {
        return this.machCaseChoice.isSelected();
    }

    boolean getWholeWords() {
        return this.wholeWordsChoice.isSelected();
    }

    boolean getRegularExpression() {
        return this.regularExpressionChoice.isSelected();
    }

    boolean getHighlightResults() {
        return this.highlightResultsChoice.isSelected();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.findCombo.requestFocusInWindow();
    }

    private void initComponents() {
        this.findLabel = new JLabel();
        this.findCombo = new JComboBox();
        this.machCaseChoice = new JCheckBox();
        this.closeButton = new JButton();
        this.wholeWordsChoice = new JCheckBox();
        this.regularExpressionChoice = new JCheckBox();
        this.highlightResultsChoice = new JCheckBox();
        this.findLabel.setText(NbBundle.getMessage(FindInQueryBar.class, (String)"FindInQueryBar.findLabel.text"));
        this.findCombo.setEditable(true);
        this.findCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindInQueryBar.this.findComboActionPerformed(evt);
            }
        });
        this.machCaseChoice.setText(NbBundle.getMessage(FindInQueryBar.class, (String)"FindInQueryBar.machCaseChoice.text"));
        this.machCaseChoice.setFocusable(false);
        this.machCaseChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindInQueryBar.this.machCaseChoiceActionPerformed(evt);
            }
        });
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugtracking/ui/resources/find_close.png")));
        this.closeButton.setBorderPainted(false);
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setFocusable(false);
        this.closeButton.setMargin(new Insets(2, 1, 0, 1));
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                FindInQueryBar.this.closeButtonMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                FindInQueryBar.this.closeButtonMouseEntered(evt);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindInQueryBar.this.closeButtonActionPerformed(evt);
            }
        });
        this.wholeWordsChoice.setText(NbBundle.getMessage(FindInQueryBar.class, (String)"FindInQueryBar.wholeWordsChoice.text"));
        this.wholeWordsChoice.setFocusable(false);
        this.wholeWordsChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindInQueryBar.this.wholeWordsChoiceActionPerformed(evt);
            }
        });
        this.regularExpressionChoice.setText(NbBundle.getMessage(FindInQueryBar.class, (String)"FindInQueryBar.regularExpressionChoice.text"));
        this.regularExpressionChoice.setFocusable(false);
        this.regularExpressionChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindInQueryBar.this.regularExpressionChoiceActionPerformed(evt);
            }
        });
        this.highlightResultsChoice.setText(NbBundle.getMessage(FindInQueryBar.class, (String)"FindInQueryBar.highlightResultsChoice.text"));
        this.highlightResultsChoice.setFocusable(false);
        this.highlightResultsChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindInQueryBar.this.highlightResultsChoiceActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.findLabel).addPreferredGap(0).add((Component)this.findCombo, 0, 105, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.machCaseChoice).addPreferredGap(0).add((Component)this.wholeWordsChoice).addPreferredGap(0).add((Component)this.regularExpressionChoice).addPreferredGap(0).add((Component)this.highlightResultsChoice).add(41, 41, 41).add((Component)this.closeButton)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.findLabel).add((Component)this.findCombo, -2, -1, -2).add((Component)this.machCaseChoice).add((Component)this.wholeWordsChoice).add((Component)this.regularExpressionChoice).add((Component)this.highlightResultsChoice)).add((Component)this.closeButton));
    }

    private void closeButtonMouseEntered(MouseEvent evt) {
        this.processMouseEvent(evt, true);
    }

    private void closeButtonMouseExited(MouseEvent evt) {
        this.processMouseEvent(evt, false);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.support.cancel();
    }

    private void findComboActionPerformed(ActionEvent evt) {
        if (this.initialized && this.isVisible()) {
            this.updateComboModel();
            this.support.updatePattern();
        }
    }

    private void machCaseChoiceActionPerformed(ActionEvent evt) {
        this.support.updatePattern();
    }

    private void wholeWordsChoiceActionPerformed(ActionEvent evt) {
        this.support.updatePattern();
    }

    private void regularExpressionChoiceActionPerformed(ActionEvent evt) {
        this.wholeWordsChoice.setEnabled(!this.regularExpressionChoice.isSelected());
        this.support.updatePattern();
    }

    private void highlightResultsChoiceActionPerformed(ActionEvent evt) {
        this.support.switchHighlight(this.highlightResultsChoice.isSelected());
    }

    private void processMouseEvent(MouseEvent evt, boolean over) {
        Object src = evt.getSource();
        if (src instanceof JButton) {
            JButton button = (JButton)src;
            button.setContentAreaFilled(over);
            button.setBorderPainted(over);
        }
    }

    private void updateComboModel() {
        String pattern = this.getText();
        int idx = -1;
        for (int i = 0; i < this.lastSearchModel.getSize(); ++i) {
            if (!pattern.equals(this.lastSearchModel.getElementAt(i))) continue;
            idx = i;
        }
        if (idx != 0) {
            if (idx != -1) {
                this.lastSearchModel.removeElementAt(idx);
            }
            this.lastSearchModel.insertElementAt(pattern, 0);
            if (this.lastSearchModel.getSize() > 5) {
                this.lastSearchModel.removeElementAt(5);
            }
            this.findCombo.setSelectedItem(pattern);
        }
    }
}

