/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.actions.RunDialogAction;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class DebugDialogAction
extends NodeAction {
    protected JButton runButton = null;
    private Object[] options;
    private ResourceBundle bundle;

    private void init() {
        if (this.runButton == null) {
            this.runButton = new JButton(this.getString("RunButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("RunButtonAD"));
            this.options = new Object[]{this.runButton, DialogDescriptor.CANCEL_OPTION};
        }
    }

    public String getName() {
        return this.getString("DEBUG_COMMAND");
    }

    protected void performAction(Node[] activatedNodes) {
        String path = null;
        if (activatedNodes != null && activatedNodes.length == 1) {
            File file;
            FileObject fo;
            DataObject dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class);
            String mime = this.getMime(dataObject);
            if (dataObject != null && dataObject.isValid() && MIMENames.isBinary((String)mime) && (fo = dataObject.getPrimaryFile()) != null && (file = FileUtil.toFile((FileObject)fo)) != null) {
                path = file.getPath();
            }
        }
        this.perform(path);
    }

    private String getMime(DataObject dob) {
        FileObject primaryFile = dob == null ? null : dob.getPrimaryFile();
        String mime = primaryFile == null ? "" : primaryFile.getMIMEType();
        return mime;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class);
        String mime = this.getMime(dataObject);
        return MIMENames.isBinary((String)mime) && !"application/x-core+elf".equals(mime);
    }

    public void perform(String executablePath) {
        if (this.runButton == null) {
            this.init();
        }
        this.perform(new RunDialogPanel(executablePath, true, this.runButton));
    }

    protected void perform(RunDialogPanel runDialogPanel) {
        Project project;
        MakeConfiguration conf;
        if (this.runButton == null) {
            this.init();
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runDialogPanel, this.getString("RunDialogTitle"), true, this.options, (Object)this.runButton, 0, null, null);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (ret == this.runButton && (conf = ConfigurationSupport.getProjectActiveConfiguration(project = runDialogPanel.getSelectedProject())) != null) {
            RunProfile profile = conf.getProfile();
            String path = runDialogPanel.getExecutablePath();
            path = CndPathUtilitities.toRelativePath((String)profile.getRunDirectory(), (String)path);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, ProjectActionEvent.PredefinedType.RUN, path, conf, profile, false);
            ProjectActionSupport.getInstance().fireActionPerformed(new ProjectActionEvent[]{projectActionEvent});
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunDialogAction.class);
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(RunDialogAction.class);
        }
        return this.bundle.getString(s);
    }
}

