/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.propdos;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import org.netbeans.modules.propdos.AntStyleResolvingProperties;
import org.netbeans.modules.propdos.PropertiesBasedDataObject;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;

abstract class SelfSavingProperties
extends AntStyleResolvingProperties {
    protected final DataObject dob;
    volatile boolean writing;

    SelfSavingProperties(DataObject ob) {
        this.dob = ob;
    }

    protected abstract void onWriteCompleted() throws IOException;

    @Override
    public String toString() {
        return this.dob.getPrimaryFile().getPath() + "[" + super.toString() + "]";
    }

    @Override
    void onChangeOccurred() throws IOException {
        if (PropertiesBasedDataObject.LOGGER.isLoggable(Level.FINEST)) {
            PropertiesBasedDataObject.LOGGER.log(Level.FINEST, "Begin write of " + this.dob.getPrimaryFile().getPath(), new Exception());
        }
        this.write();
        if (PropertiesBasedDataObject.LOGGER.isLoggable(Level.FINEST)) {
            PropertiesBasedDataObject.LOGGER.log(Level.FINEST, "Successful write of " + this.dob.getPrimaryFile().getPath() + " invoking onWriteCompleted() in " + this.getClass().getName());
        }
        this.onWriteCompleted();
    }

    private void write() throws IOException {
        if (this.writing || !this.dob.isValid()) {
            return;
        }
        final FileObject fo = this.dob.getPrimaryFile();
        fo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                SelfSavingProperties.this.writing = true;
                FileLock lock = fo.lock();
                OutputStream out = fo.getOutputStream(lock);
                try {
                    SelfSavingProperties.this.store(out, "");
                }
                catch (FileAlreadyLockedException locked) {
                    if (PropertiesBasedDataObject.LOGGER.isLoggable(Level.WARNING)) {
                        PropertiesBasedDataObject.LOGGER.log(Level.WARNING, "Could not write " + SelfSavingProperties.this.dob.getPrimaryFile().getPath() + " - already locked", locked);
                    }
                }
                finally {
                    SelfSavingProperties.this.writing = false;
                    out.close();
                    lock.releaseLock();
                }
            }
        });
    }
}

