/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DBSchemaFileList {
    private final Map<FileObject, String> dbschema2DisplayName = new HashMap<FileObject, String>();
    private final List dbschemaList;

    public DBSchemaFileList(Project project, FileObject fileObject) {
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project);
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            this.searchRoot(sourceGroupArray[i].getRootFolder(), sourceGroupArray[i].getDisplayName());
        }
        if (fileObject != null) {
            String string = NbBundle.getMessage(DBSchemaFileList.class, (String)"LBL_Node_DocBase");
            this.searchRoot(fileObject, string);
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.dbschema2DisplayName.keySet());
        Collections.sort(arrayList, new DBSchemaComparator());
        this.dbschemaList = Collections.unmodifiableList(arrayList);
    }

    private void searchRoot(FileObject fileObject, String string) {
        Enumeration enumeration = fileObject.getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.getExt().equals("dbschema") || fileObject2.isFolder() || this.dbschema2DisplayName.containsKey(fileObject2)) continue;
            String string2 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2.getParent()) + File.separator;
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            String string3 = string2 + fileObject2.getName();
            String string4 = NbBundle.getMessage(DBSchemaFileList.class, (String)"LBL_SchemaLocation", (Object)string, (Object)string3);
            this.dbschema2DisplayName.put(fileObject2, string4);
        }
    }

    public List<FileObject> getFileList() {
        return this.dbschemaList;
    }

    public String getDisplayName(FileObject fileObject) {
        return this.dbschema2DisplayName.get(fileObject);
    }

    private final class DBSchemaComparator
    implements Comparator {
        private DBSchemaComparator() {
        }

        public int compare(Object object, Object object2) {
            FileObject fileObject = (FileObject)object;
            FileObject fileObject2 = (FileObject)object2;
            String string = (String)DBSchemaFileList.this.dbschema2DisplayName.get(fileObject);
            String string2 = (String)DBSchemaFileList.this.dbschema2DisplayName.get(fileObject2);
            return string.compareTo(string2);
        }
    }
}

