/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion.db;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.explorer.MetaDataListener;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Catalog;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Schema;

public class DBMetaDataProvider {
    private static final Map CONN_TO_PROVIDER = new WeakHashMap();
    private final Reference conn;
    private final String driverClass;
    private Map catalogs;

    public static synchronized DBMetaDataProvider get(Connection connection, String string) {
        assert (connection != null);
        DBMetaDataProvider dBMetaDataProvider = (DBMetaDataProvider)CONN_TO_PROVIDER.get(connection);
        if (dBMetaDataProvider == null) {
            dBMetaDataProvider = new DBMetaDataProvider(connection, string);
            CONN_TO_PROVIDER.put(connection, dBMetaDataProvider);
        }
        return dBMetaDataProvider;
    }

    public static MetaDataListener createMetaDataListener() {
        return new MetaDataListenerImpl();
    }

    public DBMetaDataProvider(Connection connection, String string) {
        this.conn = new WeakReference<Connection>(connection);
        this.driverClass = string;
    }

    public String getDefaultCatalog() throws SQLException {
        return this.getConnection().getCatalog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Catalog[] getCatalogs() throws SQLException {
        if (this.catalogs == null) {
            Object object;
            this.catalogs = new TreeMap(new CatalogComparator());
            ResultSet resultSet = this.getMetaData().getCatalogs();
            try {
                while (resultSet.next()) {
                    object = resultSet.getString("TABLE_CAT");
                    Catalog catalog = new Catalog(this, (String)object);
                    this.catalogs.put(object, catalog);
                }
            }
            finally {
                resultSet.close();
            }
            if (this.catalogs.size() <= 0) {
                object = new Catalog(this, null);
                this.catalogs.put(null, object);
            }
        }
        return this.catalogs.values().toArray(new Catalog[this.catalogs.size()]);
    }

    public synchronized Catalog getCatalog(String string) throws SQLException {
        if (this.catalogs == null) {
            this.getCatalogs();
        }
        return (Catalog)this.catalogs.get(string);
    }

    Connection getConnection() {
        return (Connection)this.conn.get();
    }

    String getDriverClass() {
        return this.driverClass;
    }

    DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public String toString() {
        return "DBMetadataProvider[conn=" + this.getConnection() + "]";
    }

    private static final class MetaDataListenerImpl
    implements MetaDataListener {
        public void tablesChanged(DatabaseConnection databaseConnection) {
            try {
                Schema schema = this.getSchema(databaseConnection);
                if (schema != null) {
                    schema.refresh();
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger("global").log(Level.INFO, null, sQLException);
            }
        }

        public void tableChanged(DatabaseConnection databaseConnection, String string) {
            this.tablesChanged(databaseConnection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Schema getSchema(DatabaseConnection databaseConnection) throws SQLException {
            DBMetaDataProvider dBMetaDataProvider;
            Connection connection = databaseConnection.getJDBCConnection();
            if (connection == null) {
                return null;
            }
            Object object = this;
            synchronized (object) {
                dBMetaDataProvider = (DBMetaDataProvider)CONN_TO_PROVIDER.get(connection);
            }
            if (dBMetaDataProvider == null) {
                return null;
            }
            object = dBMetaDataProvider.getCatalog(connection.getCatalog());
            if (object == null) {
                return null;
            }
            return ((Catalog)object).getSchema(databaseConnection.getSchema());
        }
    }

    private static final class CatalogComparator
    implements Comparator {
        private CatalogComparator() {
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof CatalogComparator;
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            return string2 == null ? 1 : string.compareTo(string2);
        }
    }
}

