/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.ui.KenaiCombo;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.nodes.AddInstanceAction;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class KenaiTopComponent
extends TopComponent {
    private static KenaiTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/kenai/ui/resources/kenai-small.png";
    private static final String PREFERRED_ID = "KenaiTopComponent";
    private JComboBox combo;
    private JComponent dashboardComponent;

    private KenaiTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(KenaiTopComponent.class, (String)"CTL_KenaiTopComponent"));
        this.setToolTipText(NbBundle.getMessage(KenaiTopComponent.class, (String)"HINT_KenaiTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.setLayout(new BorderLayout());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized KenaiTopComponent getDefault() {
        if (instance == null) {
            instance = new KenaiTopComponent();
        }
        return instance;
    }

    public static synchronized KenaiTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(KenaiTopComponent.class.getName()).warning("Cannot find KenaiTopComponent component. It will not be located properly in the window system.");
            return KenaiTopComponent.getDefault();
        }
        if (win instanceof KenaiTopComponent) {
            return (KenaiTopComponent)win;
        }
        Logger.getLogger(KenaiTopComponent.class.getName()).warning("There seem to be multiple components with the 'KenaiTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return KenaiTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this.removeAll();
        this.dashboardComponent = DashboardImpl.getInstance().getComponent();
        this.add(this.dashboardComponent, "Center");
        this.add(this.getKenaiSwitcher(), "North");
    }

    Component getKenaiSwitcher() {
        this.combo = new KenaiCombo(false);
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent e) {
                if (KenaiTopComponent.this.combo.getSelectedItem() instanceof Kenai) {
                    DashboardImpl.getInstance().setKenai((Kenai)KenaiTopComponent.this.combo.getSelectedItem());
                } else if (KenaiTopComponent.this.combo.getSelectedItem() instanceof String) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new AddInstanceAction().actionPerformed(e);
                            DashboardImpl.getInstance().setKenai((Kenai)KenaiTopComponent.this.combo.getSelectedItem());
                        }
                    });
                } else {
                    DashboardImpl.getInstance().setKenai(null);
                }
            }
        });
        JLabel serverLabel = new JLabel();
        final JPanel panel = new JPanel();
        serverLabel = new JLabel();
        JSeparator jSeparator = new JSeparator();
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
        panel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)serverLabel, (String)NbBundle.getMessage(KenaiTopComponent.class, (String)"LBL_Server"));
        serverLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 3, 3));
        panel.add((Component)serverLabel, new GridBagConstraints());
        this.combo.setBorder(BorderFactory.createEmptyBorder(1, 1, 3, 3));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.combo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        panel.add((Component)jSeparator, gridBagConstraints);
        panel.setBackground(this.dashboardComponent.getBackground());
        this.combo.setOpaque(false);
        this.combo.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                panel.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                panel.setVisible(false);
            }
        });
        return panel;
    }

    public void setSelectedKenai(Kenai kenai) {
        if (this.combo != null) {
            this.combo.setSelectedItem(kenai);
        }
    }

    public void componentClosed() {
        DashboardImpl.getInstance().close();
        this.dashboardComponent = null;
        this.removeAll();
    }

    public void componentActivated() {
        super.componentActivated();
        Kenai pref = Utilities.getPreferredKenai();
        if (pref != null && pref.getPasswordAuthentication() != null || DashboardImpl.getInstance().getOpenProjects().length > 0) {
            UIUtils.logKenaiUsage("DASHBOARD");
        }
    }

    public boolean requestFocusInWindow() {
        boolean b = super.requestFocusInWindow();
        if (this.dashboardComponent != null) {
            b = this.dashboardComponent.requestFocusInWindow();
        }
        return b;
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.dashboardComponent != null) {
            this.dashboardComponent.requestFocus();
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return KenaiTopComponent.getDefault();
        }
    }
}

