/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.collab.chat.FilterItem;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;

public class FilterRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel groupLabel;
    private JLabel kenaiName;

    public FilterRenderer() {
        this.initComponents();
        this.setOpaque(true);
        this.groupLabel.setOpaque(true);
        this.groupLabel.setFont(this.groupLabel.getFont().deriveFont(1));
        this.kenaiName.setOpaque(true);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
    }

    private void initComponents() {
        this.groupLabel = new JLabel();
        this.kenaiName = new JLabel();
        this.setLayout(new GridBagLayout());
        this.groupLabel.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.groupLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.add((Component)this.kenaiName, gridBagConstraints);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            this.groupLabel.setText(value.toString());
            FilterItem item = (FilterItem)value;
            this.groupLabel.setBorder(new EmptyBorder(0, item.getIcon() == null ? 22 : 3, 0, 0));
            this.groupLabel.setIcon(item.getIcon());
            if (KenaiManager.getDefault().getKenais().size() > 1) {
                if (item.getKenaiProject() != null) {
                    this.kenaiName.setText(item.getKenaiProject().getKenai().getName());
                } else {
                    this.kenaiName.setText("");
                }
            } else {
                this.kenaiName.setText("");
            }
        }
        this.groupLabel.setOpaque(isSelected);
        if (isSelected) {
            this.groupLabel.setBackground(list.getSelectionBackground());
            this.groupLabel.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
            this.kenaiName.setBackground(list.getSelectionBackground());
            this.kenaiName.setForeground(list.getSelectionForeground());
        } else {
            this.groupLabel.setBackground(ColorManager.getDefault().getDefaultBackground());
            this.groupLabel.setForeground(list.getForeground());
            this.setBackground(ColorManager.getDefault().getDefaultBackground());
            this.kenaiName.setBackground(ColorManager.getDefault().getDefaultBackground());
            this.kenaiName.setForeground(Color.gray);
        }
        this.setPreferredSize(new Dimension(10, this.getPreferredSize().height));
        return this;
    }
}

