/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.testrunner;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.DefaultProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.spi.toolchain.CompilerLineConvertor;
import org.netbeans.modules.cnd.testrunner.spi.TestHandlerFactory;
import org.netbeans.modules.cnd.testrunner.spi.TestHandlerFactoryProvider;
import org.netbeans.modules.cnd.testrunner.ui.CndTestRunnerNodeFactory;
import org.netbeans.modules.cnd.testrunner.ui.CndUnitHandlerFactory;
import org.netbeans.modules.cnd.testrunner.ui.TestRunnerLineConvertor;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class TestRunnerActionHandler
implements ProjectActionHandler,
ExecutionListener,
RerunHandler {
    private ProjectActionEvent pae;
    private volatile Future<Integer> executorTask;
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private NativeExecutionService execution;
    private TestRunnerLineConvertor convertor;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private TestSession session;
    private Manager manager;

    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes) {
        this.pae = pae;
    }

    public void execute(final InputOutput io) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    TestRunnerActionHandler.this._execute(io);
                }
            });
        } else {
            this._execute(io);
        }
    }

    private void _execute(InputOutput io) {
        String path;
        ProjectActionEvent.Type actionType = this.pae.getType();
        if (actionType != ProjectActionEvent.PredefinedType.TEST) assert (false);
        String runDirectory = this.pae.getProfile().getRunDirectory();
        MakeConfiguration conf = this.pae.getConfiguration();
        PlatformInfo pi = conf.getPlatformInfo();
        ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
        String exe = this.pae.getExecutable();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.pae.getProfile().getArgsArray()));
        Map env = this.pae.getProfile().getEnvironment().getenvAsMap();
        boolean showInput = actionType == ProjectActionEvent.PredefinedType.RUN;
        boolean unbuffer = false;
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String csdirs = compilerSet.getDirectory();
        String commands = compilerSet.getCompilerFlavor().getCommandFolder(conf.getDevelopmentHost().getBuildPlatform());
        if (commands != null && commands.length() > 0) {
            csdirs = csdirs + pi.pathSeparator() + commands;
        }
        path = (path = (String)env.get(pi.getPathName())) == null ? csdirs + pi.pathSeparator() + pi.getPathAsString() : csdirs + pi.pathSeparator() + path;
        env.put(pi.getPathName(), path);
        CompilerLineConvertor converter = null;
        if (actionType == ProjectActionEvent.PredefinedType.BUILD) {
            converter = new CompilerLineConvertor(conf.getCompilerSet().getCompilerSet(), execEnv, FileUtil.toFileObject((File)new File(runDirectory)));
        }
        env.put("SPRO_EXPAND_ERRORS", "");
        String workingDirectory = TestRunnerActionHandler.convertToRemoteIfNeeded(execEnv, runDirectory);
        if (workingDirectory == null) {
            // empty if block
        }
        ProcessChangeListener processChangeListener = new ProcessChangeListener(this, null, (LineConvertor)converter, io, this.pae.getActionName(), false);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(workingDirectory).unbufferOutput(unbuffer).setExecutable(exe).setArguments(args.toArray(new String[args.size()])).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(env);
        NativeExecutionDescriptor descr = null;
        this.convertor = this.createTestRunnerConvertor(this.pae.getProject());
        descr = new NativeExecutionDescriptor().controllable(true).frontWindow(false).inputVisible(showInput).inputOutput(io).outLineBased(true).showProgress(true).postExecution((Runnable)processChangeListener).errConvertorFactory(new ExecutionDescriptor.LineConvertorFactory(){
            LineConvertor c;
            {
                this.c = TestRunnerActionHandler.this.convertor;
            }

            public LineConvertor newLineConvertor() {
                return this.c;
            }
        }).outConvertorFactory(new ExecutionDescriptor.LineConvertorFactory(){
            LineConvertor c;
            {
                this.c = TestRunnerActionHandler.this.convertor;
            }

            public LineConvertor newLineConvertor() {
                return this.c;
            }
        });
        this.execution = NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)this.pae.getActionName());
        this.runExecution();
    }

    private void runExecution() {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    TestRunnerActionHandler.this.executorTask = TestRunnerActionHandler.this.execution.run();
                }
            });
        } else {
            this.executorTask = this.execution.run();
        }
    }

    private TestRunnerLineConvertor createTestRunnerConvertor(Project project) {
        this.session = new TestSession("Test", project, TestSession.SessionType.TEST, (TestRunnerNodeFactory)new CndTestRunnerNodeFactory());
        this.session.setRerunHandler((RerunHandler)this);
        this.manager = Manager.getInstance();
        CndUnitHandlerFactory predefinedFactory = new CndUnitHandlerFactory();
        ArrayList<TestHandlerFactory> factories = new ArrayList<TestHandlerFactory>();
        Collection providers = Lookup.getDefault().lookupAll(TestHandlerFactoryProvider.class);
        for (TestHandlerFactoryProvider provider : providers) {
            factories.add(provider.getFactory());
        }
        factories.add(predefinedFactory);
        return new TestRunnerLineConvertor(this.manager, this.session, factories);
    }

    public synchronized void refresh() {
        if (this.convertor != null) {
            this.convertor.refreshSession();
        }
    }

    public void addExecutionListener(ExecutionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeExecutionListener(ExecutionListener l) {
        this.listeners.remove(l);
    }

    public boolean canCancel() {
        return true;
    }

    public void cancel() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Future et = TestRunnerActionHandler.this.executorTask;
                if (et != null) {
                    TestRunnerActionHandler.this.executorTask.cancel(true);
                }
            }
        });
    }

    protected static String convertToRemoteIfNeeded(ExecutionEnvironment execEnv, String localDir) {
        if (!TestRunnerActionHandler.checkConnection(execEnv)) {
            return null;
        }
        if (execEnv.isRemote()) {
            return HostInfoProvider.getMapper((ExecutionEnvironment)execEnv).getRemotePath(localDir, false);
        }
        return localDir;
    }

    protected static boolean checkConnection(ExecutionEnvironment execEnv) {
        if (execEnv.isRemote()) {
            try {
                ConnectionManager.getInstance().connectTo(execEnv);
                ServerRecord record = ServerList.get((ExecutionEnvironment)execEnv);
                if (record.isOffline()) {
                    record.validate(true);
                }
                return record.isOnline();
            }
            catch (IOException ex) {
                return false;
            }
            catch (CancellationException ex) {
                return false;
            }
        }
        return true;
    }

    public static String normalizeDriveLetter(CompilerSet cs, String path) {
        if (path.length() > 1 && path.charAt(1) == ':') {
            return cs.getCompilerFlavor().getToolchainDescriptor().getDriveLetterPrefix() + path.charAt(0) + path.substring(2);
        }
        return path;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(DefaultProjectActionHandler.class).getString(s);
    }

    protected static String getString(String key, String ... a1) {
        return NbBundle.getMessage(DefaultProjectActionHandler.class, (String)key, (Object[])a1);
    }

    public void executionStarted(int pid) {
        for (ExecutionListener l : this.listeners) {
            l.executionStarted(pid);
        }
        this.changeSupport.fireChange();
    }

    public void executionFinished(int rc) {
        for (ExecutionListener l : this.listeners) {
            l.executionFinished(rc);
        }
        this.changeSupport.fireChange();
    }

    public void rerun() {
        this.refresh();
        this.runExecution();
    }

    public boolean enabled() {
        return true;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private static final class ProcessChangeListener
    implements ChangeListener,
    Runnable,
    ExecutionDescriptor.LineConvertorFactory {
        private final ExecutionListener listener;
        private Writer outputListener;
        private final LineConvertor lineConvertor;
        private final InputOutput tab;
        private final String actionName;
        private long startTimeMillis;
        private Runnable postRunnable;
        private final boolean outSummary;

        public ProcessChangeListener(ExecutionListener listener, Writer outputListener, LineConvertor lineConvertor, InputOutput tab, String actionName, boolean outSummary) {
            this.listener = listener;
            this.outputListener = outputListener;
            this.lineConvertor = lineConvertor;
            this.tab = tab;
            this.actionName = actionName;
            this.outSummary = outSummary;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e instanceof NativeProcessChangeEvent)) {
                return;
            }
            NativeProcessChangeEvent event = (NativeProcessChangeEvent)e;
            final NativeProcess process = (NativeProcess)event.getSource();
            switch (event.state) {
                case INITIAL: {
                    break;
                }
                case STARTING: {
                    break;
                }
                case RUNNING: {
                    this.startTimeMillis = System.currentTimeMillis();
                    if (this.listener == null) break;
                    this.listener.executionStarted(event.pid);
                    break;
                }
                case CANCELLED: {
                    this.closeOutputListener();
                    this.postRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (ProcessChangeListener.this.outSummary) {
                                StringBuilder res = new StringBuilder();
                                res.append(MessageFormat.format(TestRunnerActionHandler.getString("TERMINATED"), ProcessChangeListener.this.actionName.toUpperCase()));
                                res.append(" (");
                                if (process.exitValue() != 0) {
                                    res.append(MessageFormat.format(TestRunnerActionHandler.getString("EXIT_VALUE"), process.exitValue()));
                                    res.append(' ');
                                }
                                res.append(MessageFormat.format(TestRunnerActionHandler.getString("TOTAL_TIME"), ProcessChangeListener.formatTime(System.currentTimeMillis() - ProcessChangeListener.this.startTimeMillis)));
                                res.append(')');
                                ProcessChangeListener.this.tab.getOut().println(res.toString());
                                ProcessChangeListener.this.tab.getOut().println();
                                ProcessChangeListener.this.closeIO();
                            }
                            if (ProcessChangeListener.this.listener != null) {
                                ProcessChangeListener.this.listener.executionFinished(process.exitValue());
                            }
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format("MSG_TERMINATED", ProcessChangeListener.this.actionName));
                        }
                    };
                    break;
                }
                case ERROR: {
                    this.closeOutputListener();
                    this.postRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (ProcessChangeListener.this.outSummary) {
                                StringBuilder res = new StringBuilder();
                                res.append(MessageFormat.format(TestRunnerActionHandler.getString("FAILED"), ProcessChangeListener.this.actionName.toUpperCase()));
                                res.append(" (");
                                if (process.exitValue() != 0) {
                                    res.append(MessageFormat.format(TestRunnerActionHandler.getString("EXIT_VALUE"), process.exitValue()));
                                    res.append(' ');
                                }
                                res.append(MessageFormat.format(TestRunnerActionHandler.getString("TOTAL_TIME"), ProcessChangeListener.formatTime(System.currentTimeMillis() - ProcessChangeListener.this.startTimeMillis)));
                                res.append(')');
                                ProcessChangeListener.this.tab.getErr().println(res.toString());
                                ProcessChangeListener.this.tab.getErr().println();
                                ProcessChangeListener.this.closeIO();
                            }
                            if (ProcessChangeListener.this.listener != null) {
                                ProcessChangeListener.this.listener.executionFinished(-1);
                            }
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(TestRunnerActionHandler.getString("MSG_FAILED"), ProcessChangeListener.this.actionName));
                        }
                    };
                    break;
                }
                case FINISHED: {
                    this.closeOutputListener();
                    this.postRunnable = new Runnable(){

                        @Override
                        public void run() {
                            int rc = process.exitValue();
                            if (ProcessChangeListener.this.outSummary) {
                                StringBuilder res = new StringBuilder();
                                res.append(MessageFormat.format(TestRunnerActionHandler.getString(rc == 0 ? "SUCCESSFUL" : "FAILED"), ProcessChangeListener.this.actionName.toUpperCase()));
                                res.append(" (");
                                if (rc != 0) {
                                    res.append(MessageFormat.format(TestRunnerActionHandler.getString("EXIT_VALUE"), process.exitValue()));
                                    res.append(' ');
                                }
                                res.append(MessageFormat.format(TestRunnerActionHandler.getString("TOTAL_TIME"), ProcessChangeListener.formatTime(System.currentTimeMillis() - ProcessChangeListener.this.startTimeMillis)));
                                res.append(')');
                                OutputWriter pw = rc == 0 ? ProcessChangeListener.this.tab.getOut() : ProcessChangeListener.this.tab.getErr();
                                pw.println(res.toString());
                                pw.println();
                                ProcessChangeListener.this.closeIO();
                            }
                            if (ProcessChangeListener.this.listener != null) {
                                ProcessChangeListener.this.listener.executionFinished(process.exitValue());
                            }
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(TestRunnerActionHandler.getString(rc == 0 ? "MSG_SUCCESSFUL" : "MSG_FAILED"), ProcessChangeListener.this.actionName));
                        }
                    };
                }
            }
        }

        @Override
        public void run() {
            if (this.postRunnable != null) {
                this.postRunnable.run();
            }
        }

        private void closeIO() {
        }

        public LineConvertor newLineConvertor() {
            return new LineConvertor(){

                public List<ConvertedLine> convert(String line) {
                    return ProcessChangeListener.this.convert(line);
                }
            };
        }

        private synchronized void closeOutputListener() {
            if (this.outputListener != null) {
                try {
                    this.outputListener.flush();
                    this.outputListener.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.outputListener = null;
            }
        }

        private synchronized List<ConvertedLine> convert(String line) {
            if (this.outputListener != null) {
                try {
                    this.outputListener.write(line);
                    this.outputListener.write("\n");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.lineConvertor != null) {
                return this.lineConvertor.convert(line);
            }
            return null;
        }

        private static String formatTime(long millis) {
            StringBuilder res = new StringBuilder();
            long seconds = millis / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            if (hours > 0L) {
                res.append(" ").append(hours).append(TestRunnerActionHandler.getString("HOUR"));
            }
            if (minutes > 0L) {
                res.append(" ").append(minutes - hours * 60L).append(TestRunnerActionHandler.getString("MINUTE"));
            }
            if (seconds > 0L) {
                res.append(" ").append(seconds - minutes * 60L).append(TestRunnerActionHandler.getString("SECOND"));
            } else {
                res.append(" ").append(millis - seconds * 1000L).append(TestRunnerActionHandler.getString("MILLISECOND"));
            }
            return res.toString();
        }
    }
}

