/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.openide.filesystems.FileObject;

public class CsmFinderImpl
implements CsmFinder {
    private boolean caseSensitive = false;
    private FileObject fo;
    private CsmFile csmFile;
    private String mimeType;

    public CsmFinderImpl(FileObject fo, String mimeType) {
        this.fo = fo;
        this.mimeType = mimeType;
        this.caseSensitive = this._getCaseSensitive();
    }

    public CsmFinderImpl(CsmFile csmFile, String mimeType) {
        this.csmFile = csmFile;
        this.mimeType = mimeType;
        this.caseSensitive = this._getCaseSensitive();
    }

    public CsmFinderImpl(CsmFile csmFile, String mimeType, boolean caseSensitive) {
        this.csmFile = csmFile;
        this.mimeType = mimeType;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public CsmFile getCsmFile() {
        return this.csmFile;
    }

    private boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    private boolean _getCaseSensitive() {
        return CsmCompletionUtils.isCaseSensitive(this.mimeType);
    }

    private boolean getNaturalSort() {
        return CsmCompletionUtils.isNaturalSort(this.mimeType);
    }

    private CsmNamespace resolveNamespace(String namespaceName, boolean caseSensitive) {
        LinkedList<CsmProject> queue = new LinkedList<CsmProject>();
        HashSet<CsmProject> seen = new HashSet<CsmProject>();
        queue.add(this.csmFile.getProject());
        CsmNamespace namespace = this.resolveNamespaceBfs(queue, seen, namespaceName);
        if (namespace != null) {
            return namespace;
        }
        for (CsmProject project : CsmModelAccessor.getModel().projects()) {
            if (seen.contains(project)) continue;
            queue.add(project);
        }
        return this.resolveNamespaceBfs(queue, seen, namespaceName);
    }

    private CsmNamespace resolveNamespaceBfs(Queue<CsmProject> queue, Set<CsmProject> seen, String namespace) {
        while (!queue.isEmpty()) {
            CsmProject project = queue.poll();
            CsmNamespace ns = project.findNamespace((CharSequence)namespace);
            if (ns != null) {
                return ns;
            }
            seen.add(project);
            for (CsmProject lib : project.getLibraries()) {
                if (seen.contains(lib)) continue;
                queue.offer(lib);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmNamespace getExactNamespace(String namespaceName) {
        CsmNamespace nmsp;
        CsmNamespace csmNamespace = nmsp = this.resolveNamespace(namespaceName, true);
        return csmNamespace;
    }

    @Override
    public CsmClassifier getExactClassifier(String classFullName) {
        CsmClassifier cls = CsmClassifierResolver.getDefault().findClassifierUsedInFile((CharSequence)classFullName, this.csmFile, false);
        return cls;
    }

    public List<CsmNamespace> findNamespaces(String name, boolean exactMatch, boolean subNamespaces) {
        ArrayList<CsmNamespace> ret = new ArrayList<CsmNamespace>();
        return ret;
    }

    @Override
    public List<CsmNamespace> findNestedNamespaces(CsmNamespace nmsp, String name, boolean exactMatch, boolean searchNested) {
        CsmProjectContentResolver contResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        return contResolver.getNestedNamespaces(nmsp, name, exactMatch);
    }

    @Override
    public List<CsmObject> findNamespaceElements(CsmNamespace nmsp, String name, boolean exactMatch, boolean searchNested, boolean searchFirst) {
        ArrayList<CsmObject> ret = new ArrayList<CsmObject>();
        CsmProjectContentResolver contResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        HashSet<CsmNamespace> vasitedNamespaces = new HashSet<CsmNamespace>();
        if (this.csmFile != null && this.csmFile.getProject() != null) {
            CsmNamespace ns;
            CsmProject prj = this.csmFile.getProject();
            CsmNamespace csmNamespace = ns = nmsp == null ? prj.getGlobalNamespace() : nmsp;
            if (this.checkStopAfterAppendAllNamespaceElements(ns, name, exactMatch, searchNested, searchFirst, true, this.csmFile, contResolver, ret, false, new HashSet<CharSequence>(), vasitedNamespaces)) {
                return ret;
            }
            ArrayList<CsmProject> projets = new ArrayList<CsmProject>();
            projets.add(prj);
            projets.addAll(this.getProjectsWithLibrary(prj));
            for (CsmProject csmProject : projets) {
                Collection libraries = csmProject.getLibraries();
                if (libraries.isEmpty()) continue;
                HashSet<CharSequence> set = new HashSet<CharSequence>();
                for (CsmObject o : ret) {
                    if (!CsmKindUtilities.isQualified((CsmObject)o)) continue;
                    set.add(((CsmQualifiedNamedElement)o).getQualifiedName());
                }
                for (CsmProject lib : libraries) {
                    CsmNamespace libNmsp = ns.isGlobal() ? lib.getGlobalNamespace() : lib.findNamespace(ns.getQualifiedName());
                    if (libNmsp == null || !this.checkStopAfterAppendAllNamespaceElements(libNmsp, name, exactMatch, searchNested, searchFirst, false, null, contResolver, ret, true, set, vasitedNamespaces)) continue;
                    return ret;
                }
            }
        }
        return ret;
    }

    public Collection<CsmProject> getProjectsWithLibrary(CsmProject lib) {
        ArrayList<CsmProject> res = new ArrayList<CsmProject>();
        Collection projects = CsmModelAccessor.getModel().projects();
        boolean changed = true;
        while (changed) {
            changed = false;
            block1: for (CsmProject project : projects) {
                if (res.contains(project)) continue;
                if (project.getLibraries().contains(lib)) {
                    res.add(project);
                    changed = true;
                    continue;
                }
                for (CsmProject resProject : res) {
                    if (!project.getLibraries().contains(resProject)) continue;
                    res.add(project);
                    changed = true;
                    continue block1;
                }
            }
        }
        return res;
    }

    @Override
    public List<CsmObject> findStaticNamespaceElements(CsmNamespace nmsp, String name, boolean exactMatch) {
        ArrayList<CsmObject> ret = new ArrayList<CsmObject>();
        CsmProjectContentResolver contResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        ret.addAll(contResolver.getFileLocalNamespaceFunctions(nmsp, this.csmFile, name, exactMatch));
        ret.addAll(contResolver.getFileLocalNamespaceVariables(nmsp, this.csmFile, name, exactMatch));
        return ret;
    }

    private boolean checkStopAfterAppendAllNamespaceElements(CsmNamespace nmsp, String name, boolean exactMatch, boolean searchNested, boolean searchFirst, boolean needFileLocal, CsmFile file, CsmProjectContentResolver contResolver, List ret, boolean merge, Set<CharSequence> set, HashSet<CsmNamespace> vasitedNamespaces) {
        if (vasitedNamespaces.contains(nmsp)) {
            return false;
        }
        vasitedNamespaces.add(nmsp);
        List<CsmClassifier> elements = contResolver.getNamespaceClassesEnums(nmsp, name, exactMatch, searchNested);
        if (this.checkStopAfterAppendElements(ret, elements, set, merge, searchFirst)) {
            return true;
        }
        elements = contResolver.getNamespaceEnumerators(nmsp, name, exactMatch, searchNested);
        if (this.checkStopAfterAppendElements(ret, elements, set, merge, searchFirst)) {
            return true;
        }
        elements = contResolver.getNamespaceVariables(nmsp, name, exactMatch, searchNested);
        if (this.checkStopAfterAppendElements(ret, elements, set, merge, searchFirst)) {
            return true;
        }
        elements = contResolver.getNamespaceFunctions(nmsp, name, exactMatch, searchNested);
        if (this.checkStopAfterAppendElements(ret, elements, set, merge, searchFirst)) {
            return true;
        }
        elements = contResolver.getNamespaceAliases(nmsp, name, exactMatch, searchNested);
        if (this.checkStopAfterAppendElements(ret, elements, set, merge, searchFirst)) {
            return true;
        }
        if (needFileLocal) {
            assert (file != null) : "file must be passed if needFileLocal is true";
            elements = contResolver.getFileLocalNamespaceVariables(nmsp, file, name, exactMatch);
            if (this.checkStopAfterAppendElements(ret, elements, set, merge, searchFirst)) {
                return true;
            }
            elements = contResolver.getFileLocalNamespaceFunctions(nmsp, file, name, exactMatch);
            if (this.checkStopAfterAppendElements(ret, elements, set, merge, searchFirst)) {
                return true;
            }
        }
        for (CsmNamespace ns : CsmUsingResolver.getDefault().findVisibleNamespaces(nmsp, file == null ? nmsp.getProject() : file.getProject())) {
            if (!this.checkStopAfterAppendAllNamespaceElements(ns, name, exactMatch, searchNested, searchFirst, needFileLocal, file, contResolver, ret, merge, set, vasitedNamespaces)) continue;
            return true;
        }
        return false;
    }

    private boolean checkStopAfterAppendElements(List<CsmObject> ret, Collection<CsmObject> elements, Set<CharSequence> set, boolean merge, boolean searchFirst) {
        if (merge) {
            this.merge(set, ret, elements);
        } else {
            ret.addAll(elements);
        }
        return searchFirst && ret.size() > 0;
    }

    private void merge(Set<CharSequence> set, List<CsmObject> ret, Collection<CsmObject> classes) {
        if (classes != null) {
            for (CsmObject o : classes) {
                if (!CsmKindUtilities.isQualified((CsmObject)o) || set.contains(((CsmQualifiedNamedElement)o).getQualifiedName())) continue;
                ret.add(o);
                set.add(((CsmQualifiedNamedElement)o).getQualifiedName());
            }
        }
    }

    @Override
    public List<CsmClassifier> findClasses(CsmNamespace nmsp, String name, boolean exactMatch, boolean searchNested) {
        ArrayList<CsmClassifier> ret = new ArrayList<CsmClassifier>();
        CsmProjectContentResolver contResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (this.csmFile != null && this.csmFile.getProject() != null) {
            CsmProject prj = this.csmFile.getProject();
            CsmNamespace ns = nmsp == null ? prj.getGlobalNamespace() : nmsp;
            List<CsmClassifier> classes = contResolver.getNamespaceClassesEnums(ns, name, exactMatch, searchNested);
            if (classes != null) {
                ret.addAll(classes);
            }
            Collection<CsmClassifier> collection = classes = prj.getGlobalNamespace() == ns ? null : contResolver.getLibClassesEnums(name, exactMatch);
            if (classes != null) {
                ret.addAll(classes);
            }
        }
        return ret;
    }

    private void addNestedNamespaces(List<CsmNamespace> list, CsmNamespace nmsp) {
        for (CsmNamespace n : nmsp.getNestedNamespaces()) {
            list.add(n);
            this.addNestedNamespaces(list, n);
        }
    }

    @Override
    public List<CsmField> findFields(CsmOffsetableDeclaration contextDeclaration, CsmClass classifier, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses, boolean inspectParentClasses, boolean scopeAccessedClassifier, boolean sort) {
        CsmProjectContentResolver contResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List<CsmField> classFields = contResolver.getFields(classifier, contextDeclaration, name, staticOnly, exactMatch, inspectParentClasses, inspectOuterClasses, scopeAccessedClassifier);
        return classFields;
    }

    @Override
    public List<CsmEnumerator> findEnumerators(CsmOffsetableDeclaration contextDeclaration, CsmClass classifier, String name, boolean exactMatch, boolean inspectOuterClasses, boolean inspectParentClasses, boolean scopeAccessedClassifier, boolean sort) {
        CsmProjectContentResolver contResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List<CsmEnumerator> classEnumerators = contResolver.getEnumerators(classifier, contextDeclaration, name, exactMatch, inspectParentClasses, inspectOuterClasses, scopeAccessedClassifier);
        return classEnumerators;
    }

    @Override
    public List<CsmMethod> findMethods(CsmOffsetableDeclaration contextDeclaration, CsmClass classifier, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses, boolean inspectParentClasses, boolean scopeAccessedClassifier, boolean sort) {
        CsmClass clazz = classifier;
        CsmProjectContentResolver contResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (contextDeclaration == null) {
            contextDeclaration = clazz;
        }
        List<CsmMethod> classMethods = contResolver.getMethods(clazz, contextDeclaration, name, staticOnly, exactMatch, inspectParentClasses, inspectOuterClasses, scopeAccessedClassifier);
        return classMethods;
    }

    @Override
    public List<CsmClassifier> findNestedClassifiers(CsmOffsetableDeclaration contextDeclaration, CsmClass c, String name, boolean exactMatch, boolean inspectParentClasses, boolean sort) {
        CsmClass clazz = c;
        CsmProjectContentResolver contResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List<CsmClassifier> classClassifiers = contResolver.getNestedClassifiers(clazz, contextDeclaration, name, exactMatch, inspectParentClasses, true);
        return classClassifiers;
    }

    @Override
    public List<CsmLabel> findLabel(CsmOffsetableDeclaration contextDeclaration, String name, boolean exactMatch, boolean sort) {
        ArrayList<CsmLabel> out = new ArrayList<CsmLabel>();
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)contextDeclaration)) {
            Collection res = CsmLabelResolver.getDefault().getLabels((CsmFunctionDefinition)contextDeclaration, null, EnumSet.of(CsmLabelResolver.LabelKind.Definiton));
            for (CsmReference ref : res) {
                CsmLabel label;
                if (!CsmKindUtilities.isLabel((CsmObject)ref.getReferencedObject()) || !CsmSortUtilities.matchName((CharSequence)(label = (CsmLabel)ref.getReferencedObject()).getLabel(), (CharSequence)name, (boolean)exactMatch, (boolean)this.caseSensitive)) continue;
                out.add(label);
            }
        }
        return out;
    }

    @Override
    public List<CsmClass> findBaseClasses(CsmOffsetableDeclaration contextDeclaration, CsmClassifier c, String name, boolean exactMatch, boolean sort) {
        CsmFile contextFile = this.getCsmFile();
        if (contextFile == null && contextDeclaration != null) {
            contextFile = contextDeclaration.getContainingFile();
        }
        if (CsmKindUtilities.isClass((CsmObject)(c = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)c, (CsmFile)contextFile)))) {
            CsmClass clazz = (CsmClass)c;
            CsmProjectContentResolver contResolver = new CsmProjectContentResolver(this.getCaseSensitive());
            List<CsmClass> classClassifiers = contResolver.getBaseClasses(clazz, contextDeclaration, name, exactMatch);
            return classClassifiers;
        }
        return new ArrayList<CsmClass>();
    }
}

