/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class SortColumnHeaderRenderer
implements TableCellRenderer,
UIResource {
    private UnitCategoryTableModel model;
    private TableCellRenderer textRenderer;
    private String sortColumn;
    private ImageIcon sortDescIcon;
    private static ImageIcon sortAscIcon;
    private boolean sortAscending;

    public SortColumnHeaderRenderer(UnitCategoryTableModel model, TableCellRenderer textRenderer) {
        this.model = model;
        this.textRenderer = textRenderer;
        this.sortColumn = SortColumnHeaderRenderer.getPreferences().get(this.keyForType("SortingColumn"), this.getDefaultColumnSelected());
        this.sortAscending = SortColumnHeaderRenderer.getPreferences().getBoolean(this.keyForType("SortAscending"), true);
        this.model.sort(this.sortColumn, this.sortAscending);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component text = this.textRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (text instanceof JLabel) {
            JLabel label = (JLabel)text;
            if (table.getColumnModel().getColumn(column).getIdentifier().equals(this.sortColumn)) {
                label.setIcon(this.sortAscending ? this.getSortAscIcon() : this.getSortDescIcon());
                label.setHorizontalTextPosition(2);
            } else {
                label.setIcon(null);
            }
        }
        return text;
    }

    public void setDefaultSorting() {
        this.setSorting(this.getDefaultColumnSelected());
    }

    private String getDefaultColumnSelected() {
        String retval = null;
        retval = this.model.getColumnName(2);
        return retval;
    }

    public void setSorting(Object column) {
        if (!column.equals(this.sortColumn)) {
            this.sortColumn = (String)column;
            this.sortAscending = true;
        } else {
            this.sortAscending = !this.sortAscending;
        }
        SortColumnHeaderRenderer.getPreferences().put(this.keyForType("SortingColumn"), this.sortColumn);
        SortColumnHeaderRenderer.getPreferences().putBoolean(this.keyForType("SortAscending"), this.sortAscending);
        this.model.sort(column, this.sortAscending);
    }

    private ImageIcon getSortAscIcon() {
        if (sortAscIcon == null) {
            sortAscIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/columnsSortedDesc.gif", (boolean)false);
        }
        return sortAscIcon;
    }

    private ImageIcon getSortDescIcon() {
        if (this.sortDescIcon == null) {
            this.sortDescIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/columnsSortedAsc.gif", (boolean)false);
        }
        return this.sortDescIcon;
    }

    private String keyForType(String key) {
        return key + (Object)((Object)this.model.getType());
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(SortColumnHeaderRenderer.class);
    }
}

