/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m2g;

import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.model.DocumentNode;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableImage;

public class ScalableGraphics {
    static final RGB CLEAR_PAINT = new RGB(0, 0, 0, 0);
    protected Graphics2D g2d = null;
    protected int qualityMode = 2;
    protected float alpha = 1.0f;
    protected BufferedImage offscreen;
    protected BufferedImage curOffscreen;
    protected RenderGraphics rg;
    public static final int RENDERING_QUALITY_LOW = 1;
    public static final int RENDERING_QUALITY_HIGH = 2;

    private ScalableGraphics() {
    }

    public void bindTarget(Object target) {
        if (target == null) {
            throw new NullPointerException();
        }
        if (!(target instanceof Graphics2D)) {
            throw new IllegalArgumentException();
        }
        if (this.g2d != null) {
            throw new IllegalStateException();
        }
        this.g2d = (Graphics2D)target;
    }

    public void releaseTarget() {
        if (this.g2d == null) {
            throw new IllegalStateException();
        }
        this.g2d = null;
    }

    public void render(int x, int y, ScalableImage image) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (this.g2d == null) {
            throw new IllegalStateException();
        }
        DocumentNode documentNode = (DocumentNode)((SVGImage)image).getDocument();
        int vpw = image.getViewportWidth();
        int vph = image.getViewportHeight();
        this.checkOffscreen(vpw, vph);
        this.rg.setRenderingQuality(this.qualityMode == 2);
        documentNode.applyAnimations();
        this.rg.clearRect(0, 0, vpw, vph, CLEAR_PAINT);
        documentNode.paint(this.rg);
        this.g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        this.g2d.drawImage((Image)this.curOffscreen, x, y, null);
    }

    protected void checkOffscreen(int width, int height) {
        int w = width;
        int h = height;
        if (w <= 0) {
            w = 1;
        }
        if (h <= 0) {
            h = 1;
        }
        if (this.offscreen == null || this.offscreen.getWidth() < w || this.offscreen.getHeight() < h) {
            this.curOffscreen = this.offscreen = new BufferedImage(w, h, 2);
            this.rg = new RenderGraphics(this.curOffscreen);
        } else if (this.offscreen.getWidth() > w || this.offscreen.getHeight() > h) {
            this.curOffscreen = this.offscreen.getSubimage(0, 0, w, h);
            this.rg = new RenderGraphics(this.curOffscreen);
        } else if (this.curOffscreen != this.offscreen) {
            this.curOffscreen = this.offscreen;
            this.rg = new RenderGraphics(this.curOffscreen);
        }
    }

    public void setRenderingQuality(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("" + mode);
        }
        this.qualityMode = mode;
    }

    public void setTransparency(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.alpha = alpha;
    }

    public static ScalableGraphics createInstance() {
        return new ScalableGraphics();
    }
}

