/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.util.Base64DecodeStream;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageLoaderUtil {
    static final String BASE64_JPG_HREF_PREFIX = "data:image/jpg;base64,";
    static final String BASE64_JPG_HREF_PREFIX2 = "data:image/jpeg;base64,";
    static final String BASE64_PNG_HREF_PREFIX = "data:image/png;base64,";
    static final String BASE64_HREF_PREFIX = "data:;base64,";
    static final int BASE64_JPG_HREF_PREFIX_LENGTH = "data:image/jpg;base64,".getBytes().length;
    static final int BASE64_JPG_HREF_PREFIX2_LENGTH = "data:image/jpeg;base64,".getBytes().length;
    static final int BASE64_PNG_HREF_PREFIX_LENGTH = "data:image/png;base64,".getBytes().length;
    static final int BASE64_HREF_PREFIX_LENGTH = "data:;base64,".getBytes().length;
    static final Color BROKEN_IMAGE_COLOR = new Color(0, 0, 0);
    static final Color LOADING_IMAGE_COLOR = Color.gray;
    static final float BROKEN_IMAGE_OPACITY = 0.0f;
    static final float LOADING_IMAGE_OPACITY = 1.0f;
    static final String BASE64_PREFIX = "data:";
    protected RasterImage brokenImage;
    protected RasterImage loadingImage;
    protected MediaTracker mediaTracker = new MediaTracker(new Component(){});

    public ImageLoaderUtil() {
        BufferedImage bi = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1, 3);
        Graphics2D g = (Graphics2D)((Image)bi).getGraphics();
        g.setColor(BROKEN_IMAGE_COLOR);
        g.setComposite(AlphaComposite.getInstance(3, 0.0f));
        g.fillRect(0, 0, 1, 1);
        g.dispose();
        this.brokenImage = new RasterImage(bi);
        bi = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1, 3);
        g = (Graphics2D)((Image)bi).getGraphics();
        g.setColor(LOADING_IMAGE_COLOR);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.fillRect(0, 0, 1, 1);
        g.dispose();
        this.loadingImage = new RasterImage(bi);
    }

    public RasterImage getLoadingImage() {
        return this.loadingImage;
    }

    public RasterImage getBrokenImage() {
        return this.brokenImage;
    }

    public boolean isDataURI(String uri) {
        return uri.startsWith(BASE64_PREFIX);
    }

    public RasterImage getExternalImage(String href) {
        URL url = null;
        try {
            url = new URL(href);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return this.brokenImage;
        }
        Image img = Toolkit.getDefaultToolkit().createImage(url);
        return this.loadImage(img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RasterImage loadImage(Image img) {
        this.mediaTracker.addImage(img, 0);
        try {
            this.mediaTracker.waitForAll();
            if (this.mediaTracker.isErrorAny()) {
                System.err.println(">>>>>>>>>>>>>>> error loading image....");
                RasterImage rasterImage = this.brokenImage;
                return rasterImage;
            }
            RasterImage rasterImage = new RasterImage(img);
            return rasterImage;
        }
        catch (InterruptedException e) {
            RasterImage rasterImage = this.brokenImage;
            return rasterImage;
        }
        finally {
            this.mediaTracker.removeImage(img);
        }
    }

    public RasterImage createImage(byte[] imageData) {
        Image img = Toolkit.getDefaultToolkit().createImage(imageData);
        return this.loadImage(img);
    }

    public RasterImage createImage(int[] imageData, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        bi.setRGB(0, 0, width, height, imageData, 0, width);
        return new RasterImage(bi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterImage getEmbededImage(String uri) {
        int startAt = 0;
        if (uri.startsWith(BASE64_PNG_HREF_PREFIX)) {
            startAt = BASE64_PNG_HREF_PREFIX_LENGTH;
        } else if (uri.startsWith(BASE64_JPG_HREF_PREFIX)) {
            startAt = BASE64_JPG_HREF_PREFIX_LENGTH;
        } else if (uri.startsWith(BASE64_JPG_HREF_PREFIX2)) {
            startAt = BASE64_JPG_HREF_PREFIX2_LENGTH;
        } else if (uri.startsWith(BASE64_HREF_PREFIX)) {
            startAt = BASE64_HREF_PREFIX_LENGTH;
        } else {
            return this.brokenImage;
        }
        InputStream is = new Base64StringStream(uri, startAt);
        is = new Base64DecodeStream(is);
        byte[] data = new byte[(uri.length() - startAt) * 3 / 4];
        try {
            int read = is.read(data);
            Image img = Toolkit.getDefaultToolkit().createImage(data, 0, read);
            RasterImage rasterImage = this.loadImage(img);
            return rasterImage;
        }
        catch (IOException e) {
            RasterImage rasterImage = this.brokenImage;
            return rasterImage;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {}
        }
    }

    static class Base64StringStream
    extends InputStream {
        private String str;
        private int len = 0;
        private int offset = 0;

        public int read() {
            return this.offset < this.len ? (int)this.str.charAt(this.offset++) : -1;
        }

        public Base64StringStream(String str, int offset) {
            this.str = str;
            this.offset = offset;
            this.len = str.length();
        }
    }
}

