/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class VCSHooksConfig {
    private static VCSHooksConfig instance = null;
    private static final String HG_HOOK_RESOLVE = "vcshook.hg_resolve";
    private static final String HG_HOOK_LINK = "vcshook.hg_link";
    private static final String HG_HOOK_AFTER_COMMIT = "vcshook.hg_after_commit";
    private static final String SVN_HOOK_RESOLVE = "vcshook.svn_resolve";
    private static final String SVN_HOOK_LINK = "vcshook.svn_link";
    private static final String HG_HOOK_ISSUE_INFO_TEMPLATE = "vcshook.hg_issue_format";
    private static final String HG_HOOK_REVISION_TEMPLATE = "vcshook.hg_comment_format";
    private static final String SVN_HOOK_ISSUE_INFO_TEMPLATE = "vcshook.svn_issue_format";
    private static final String SVN_HOOK_REVISION_TEMPLATE = "vcshook.svn_comment_format";
    private static final String HG_HOOK_PUSH_ = "vcshook.hg_push_hook_";
    private static final String DELIMITER = "<=>";

    private VCSHooksConfig() {
    }

    static VCSHooksConfig getInstance() {
        if (instance == null) {
            instance = new VCSHooksConfig();
        }
        return instance;
    }

    Preferences getPreferences() {
        return NbPreferences.forModule(VCSHooksConfig.class);
    }

    void setHgIssueInfoTemplate(Format format) {
        this.getPreferences().put(HG_HOOK_ISSUE_INFO_TEMPLATE, format.toString());
    }

    void setHgRevisionTemplate(Format format) {
        this.getPreferences().put(HG_HOOK_REVISION_TEMPLATE, format.toString());
    }

    void setSvnIssueInfoTemplate(Format format) {
        this.getPreferences().put(SVN_HOOK_ISSUE_INFO_TEMPLATE, format.toString());
    }

    void setSvnRevisionTemplate(Format format) {
        this.getPreferences().put(SVN_HOOK_REVISION_TEMPLATE, format.toString());
    }

    void setSvnResolve(boolean bl) {
        this.getPreferences().putBoolean(SVN_HOOK_RESOLVE, bl);
    }

    void setSvnLink(boolean bl) {
        this.getPreferences().putBoolean(SVN_HOOK_LINK, bl);
    }

    void setHgResolve(boolean bl) {
        this.getPreferences().putBoolean(HG_HOOK_RESOLVE, bl);
    }

    void setHgAfterCommit(boolean bl) {
        this.getPreferences().putBoolean(HG_HOOK_AFTER_COMMIT, bl);
    }

    void setHgLink(boolean bl) {
        this.getPreferences().putBoolean(HG_HOOK_LINK, bl);
    }

    boolean getSvnResolve() {
        return this.getPreferences().getBoolean(SVN_HOOK_RESOLVE, false);
    }

    boolean getSvnLink() {
        return this.getPreferences().getBoolean(SVN_HOOK_LINK, true);
    }

    boolean getHgResolve() {
        return this.getPreferences().getBoolean(HG_HOOK_RESOLVE, false);
    }

    boolean getHgLink() {
        return this.getPreferences().getBoolean(HG_HOOK_LINK, true);
    }

    boolean getHgAfterCommit() {
        return this.getPreferences().getBoolean(HG_HOOK_AFTER_COMMIT, false);
    }

    Format getHgRevisionTemplate() {
        return this.getFormat(this.getPreferences().get(HG_HOOK_REVISION_TEMPLATE, null), VCSHooksConfig.getDefaultHgRevisionTemplate());
    }

    Format getHgIssueInfoTemplate() {
        return this.getFormat(this.getPreferences().get(HG_HOOK_ISSUE_INFO_TEMPLATE, null), VCSHooksConfig.getDefaultIssueInfoTemplate());
    }

    Format getSvnRevisionTemplate() {
        return this.getFormat(this.getPreferences().get(SVN_HOOK_REVISION_TEMPLATE, null), VCSHooksConfig.getDefaultSvnRevisionTemplate());
    }

    Format getSvnIssueInfoTemplate() {
        return this.getFormat(this.getPreferences().get(SVN_HOOK_ISSUE_INFO_TEMPLATE, null), VCSHooksConfig.getDefaultIssueInfoTemplate());
    }

    void setHgPushAction(String changeset, PushOperation pushAction) {
        this.getPreferences().put(HG_HOOK_PUSH_ + changeset, pushAction.toString());
    }

    PushOperation popHGPushAction(String changeset) {
        String value = this.getPreferences().get(HG_HOOK_PUSH_ + changeset, null);
        if (value == null) {
            return null;
        }
        String[] values = value.split(DELIMITER);
        this.getPreferences().remove(HG_HOOK_PUSH_ + changeset);
        return new PushOperation(values[0], !values[1].equals("") ? values[1] : null, values[2].equals("1"));
    }

    static Format getDefaultHgRevisionTemplate() {
        return new Format(false, VCSHooksConfig.normalizeFormat(new String[]{NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Changeset"), "{changeset}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Author"), "{author}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Date"), "{date}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Message"), "{message}"}));
    }

    static Format getDefaultIssueInfoTemplate() {
        return new Format(false, NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Issue") + "{id} - {summary}");
    }

    static Format getDefaultSvnRevisionTemplate() {
        return new Format(false, VCSHooksConfig.normalizeFormat(new String[]{NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Revision"), "{revision}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Author"), "{author}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Date"), "{date}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Message"), "{message}"}));
    }

    private Format getFormat(String value, Format defaultFormat) {
        Format format;
        if (value == null) {
            format = defaultFormat;
        } else {
            String[] values = value.split(DELIMITER);
            format = new Format(values[0].equals("1"), values.length > 1 ? values[1] : "");
        }
        return format;
    }

    private static String normalizeFormat(String[] params) {
        int l = 0;
        for (int i = 0; i < params.length; i += 2) {
            if (l >= params[i].length()) continue;
            l = params[i].length();
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            ret.append(params[i]);
            StringBuilder s = new StringBuilder();
            for (int j = 0; j < l - params[i].length() + 1; ++j) {
                s.append(" ");
            }
            ret.append(s.toString());
            ret.append(params[++i]);
        }
        return ret.toString();
    }

    static void logHookUsage(String vcs, Repository bugRepository) {
        BugtrackingUtil.logBugtrackingUsage((Repository)bugRepository, (String)"COMMIT_HOOK");
        Utils.logVCSActionEvent((String)("COMMIT_HOOK_" + vcs));
    }

    static class Format {
        private boolean above;
        private String format;

        public Format(boolean above, String format) {
            this.above = above;
            this.format = format;
        }

        public boolean isAbove() {
            return this.above;
        }

        public String getFormat() {
            return this.format;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.above ? "1" : "0");
            sb.append(VCSHooksConfig.DELIMITER);
            sb.append(this.format);
            return sb.toString();
        }
    }

    static class PushOperation {
        private final String issueID;
        private final String msg;
        private final boolean close;

        public PushOperation(String issueID, String msg, boolean close) {
            this.issueID = issueID;
            this.msg = msg;
            this.close = close;
        }

        public String getIssueID() {
            return this.issueID;
        }

        public boolean isClose() {
            return this.close;
        }

        public String getMsg() {
            return this.msg;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String message = this.getMsg();
            sb.append(this.getIssueID());
            sb.append(VCSHooksConfig.DELIMITER);
            sb.append(message != null ? message.trim() : "");
            sb.append(VCSHooksConfig.DELIMITER);
            sb.append(this.isClose() ? "1" : "0");
            return sb.toString();
        }
    }
}

