/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.system;

import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2me.cdc.platform.system.EatingReader;
import org.netbeans.modules.j2me.cdc.platform.system.StreamReader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class ExternalProcessing {
    private static final Logger logger = Logger.getLogger(ExternalProcessing.class.getCanonicalName());

    public static String callExternal(FileObject executable, FileObject workdir, String ... params) throws IOException {
        StringBuffer sb = new StringBuffer();
        try {
            File executableFile = FileUtil.toFile((FileObject)executable);
            String[] command = new String[params.length + 1];
            command[0] = executableFile.getPath();
            for (int i = 0; i < params.length; ++i) {
                command[i + 1] = params[i];
            }
            File workdirFile = FileUtil.toFile((FileObject)workdir);
            Process process = Runtime.getRuntime().exec(command, null, workdirFile);
            StreamReader ior = new StreamReader(process.getInputStream(), sb);
            EatingReader irr = new EatingReader(process.getErrorStream());
            ior.join();
            irr.join();
            int exitValue = process.waitFor();
            process.getOutputStream().close();
            if (exitValue != 0) {
                throw new IOException();
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        return sb.toString();
    }

    public static void callExternalShowOutput(FileObject executable, FileObject workDirFo, String ... params) throws IOException {
        File executableFile = FileUtil.toFile((FileObject)executable);
        String[] command = new String[params.length + 1];
        command[0] = executableFile.getPath();
        for (int i = 0; i < params.length; ++i) {
            command[i + 1] = params[i];
        }
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Cannot be called from Event Dispatch Thread");
        }
        File workDir = FileUtil.toFile((FileObject)workDirFo);
        Process process = Runtime.getRuntime().exec(command, null, workDir);
        BufferedInputStream out = new BufferedInputStream(process.getInputStream(), 8192);
        BufferedInputStream err = new BufferedInputStream(process.getErrorStream(), 8192);
        BufferedReader outReader = new BufferedReader(new InputStreamReader(out));
        BufferedReader errReader = new BufferedReader(new InputStreamReader(err));
        StringBuilder sb = new StringBuilder();
        for (String string : command) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(string);
        }
        InputOutput io = IOProvider.getDefault().getIO(sb.toString(), false);
        io.select();
        io.getOut().println((Object)sb);
        io.getOut().println();
        OutHandler processSystemOut = new OutHandler(outReader, io.getOut());
        OutHandler processSystemErr = new OutHandler(errReader, io.getErr());
        RequestProcessor.getDefault().post((Runnable)processSystemOut);
        RequestProcessor.getDefault().post((Runnable)processSystemErr);
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "Interupted", ex);
        }
        processSystemOut.close();
        processSystemErr.close();
        io.getOut().println("Process exited with exit code " + process.exitValue());
    }

    static class OutHandler
    implements Runnable {
        private Reader out;
        private OutputWriter writer;

        public OutHandler(Reader out, OutputWriter writer) {
            this.out = out;
            this.writer = writer;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (!this.out.ready()) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            this.close();
                            return;
                        }
                    }
                    if (!this.readOneBuffer() || Thread.currentThread().isInterrupted()) break;
                }
                this.close();
                return;
            }
            catch (IOException ioe) {
                return;
            }
        }

        private boolean readOneBuffer() throws IOException {
            int read;
            char[] cbuf = new char[255];
            while ((read = this.out.read(cbuf)) != -1) {
                this.writer.write(cbuf, 0, read);
            }
            return read != -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Failed to close stream", ioe);
            }
            finally {
                this.writer.close();
            }
        }
    }
}

