/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import java.io.File;
import java.util.List;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.helper.Dependency;
import org.netbeans.installer.wizard.components.WizardAction;

public class SetInstallationLocationAction
extends WizardAction {
    public static final String SOURCE_UID_PROPERTY = "source.component";
    public static final String RELATIVE_LOCATION_PROPERTY = "relative.location";
    private static final String ERROR_SOURCE_UID_NOT_SET_KEY = "SILA.error.source.uid.not.set";
    private static final String ERROR_CANNOT_FIND_COMPONENT_KEY = "SILA.error.cannot.find.component";
    private static final String ERROR_CANNOT_GET_LOGIC_KEY = "SILA.error.cannot.get.logic";

    public void execute() {
        File location;
        String uid = this.getProperty(SOURCE_UID_PROPERTY);
        String relativeLocation = this.getProperty(RELATIVE_LOCATION_PROPERTY);
        if (uid == null) {
            ErrorManager.notifyError(ResourceUtils.getString(SetInstallationLocationAction.class, ERROR_SOURCE_UID_NOT_SET_KEY));
            return;
        }
        Product target = (Product)this.getWizard().getContext().get(Product.class);
        List<Dependency> dependencies = target.getDependencyByUid(uid);
        Product source = Registry.getInstance().getProducts(dependencies.get(0)).get(0);
        if (source == null) {
            ErrorManager.notifyError(ResourceUtils.getString(SetInstallationLocationAction.class, ERROR_CANNOT_FIND_COMPONENT_KEY, uid));
            return;
        }
        File sourceLocation = null;
        try {
            location = source.getInstallationLocation();
            sourceLocation = SystemUtils.isMacOS() && source.getLogic().wrapForMacOs() && location.getName().endsWith(".app") ? new File(location, "Contents/Resources/" + location.getName().replaceAll("\\.app$", "")) : location;
        }
        catch (InitializationException e) {
            ErrorManager.notifyError(ResourceUtils.getString(SetInstallationLocationAction.class, ERROR_CANNOT_GET_LOGIC_KEY, target.getDisplayName()), e);
        }
        location = relativeLocation != null ? new File(sourceLocation, relativeLocation) : sourceLocation;
        target.setInstallationLocation(location.getAbsoluteFile());
    }

    public WizardAction.WizardActionUi getWizardUi() {
        return null;
    }

    public boolean isCancellable() {
        return false;
    }
}

