/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.net.URL;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.AbstractEntryWithSources;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.filesystems.FileUtil;

final class NetBeansOrgEntry
extends AbstractEntryWithSources {
    private final File nball;
    private final String cnb;
    private final String path;
    private final File cluster;
    private final String module;
    private final String cpext;
    private final String releaseVersion;
    private final String[] providedTokens;
    private final ManifestManager.PackageExport[] publicPackages;
    private final String[] friends;
    private final boolean deprecated;
    private URL javadoc;
    private File sourceLocation;

    public NetBeansOrgEntry(File nball, String cnb, String path, File cluster, String module, String cpext, String releaseVersion, String[] providedTokens, ManifestManager.PackageExport[] publicPackages, String[] friends, boolean deprecated, String src) {
        super(src);
        this.nball = nball;
        this.cnb = cnb;
        this.path = path;
        this.cluster = cluster;
        this.module = module;
        this.cpext = cpext;
        this.releaseVersion = releaseVersion;
        this.providedTokens = providedTokens;
        this.publicPackages = publicPackages;
        this.friends = friends;
        this.deprecated = deprecated;
    }

    @Override
    public File getSourceLocation() {
        if (this.sourceLocation == null) {
            this.sourceLocation = FileUtil.normalizeFile((File)new File(this.nball, this.path.replace('/', File.separatorChar)));
        }
        return this.sourceLocation;
    }

    @Override
    public String getNetBeansOrgPath() {
        return this.path;
    }

    @Override
    public File getJarLocation() {
        return new File(this.getClusterDirectory(), this.module.replace('/', File.separatorChar));
    }

    @Override
    public String getCodeNameBase() {
        return this.cnb;
    }

    @Override
    public File getClusterDirectory() {
        return this.cluster;
    }

    @Override
    public String getClassPathExtensions() {
        return this.cpext;
    }

    @Override
    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    @Override
    public String[] getProvidedTokens() {
        return this.providedTokens;
    }

    @Override
    public ManifestManager.PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    @Override
    public boolean isDeclaredAsFriend(String cnb) {
        return NetBeansOrgEntry.isDeclaredAsFriend(this.friends, cnb);
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        return "NetBeansOrgEntry[" + this.getSourceLocation() + "]";
    }

    @Override
    public URL getJavadoc(NbPlatform platform) {
        if (this.javadoc == null) {
            this.javadoc = NetBeansOrgEntry.findJavadocForNetBeansOrgModules(this, ModuleList.findNetBeansOrgDestDir(this.nball));
        }
        return this.javadoc;
    }

    static URL findJavadocForNetBeansOrgModules(ModuleEntry entry, File destDir) {
        File nbOrg = null;
        if (destDir.getParent() != null) {
            nbOrg = destDir.getParentFile().getParentFile();
        }
        if (nbOrg == null) {
            throw new IllegalArgumentException("ModuleEntry " + entry + " doesn't represent nb.org module");
        }
        File builtJavadoc = new File(nbOrg, "nbbuild/build/javadoc");
        URL[] javadocURLs = null;
        if (builtJavadoc.exists()) {
            File[] javadocs = builtJavadoc.listFiles();
            javadocURLs = new URL[javadocs.length];
            for (int i = 0; i < javadocs.length; ++i) {
                javadocURLs[i] = FileUtil.urlForArchiveOrDir((File)javadocs[i]);
            }
        }
        return javadocURLs == null ? null : Util.findJavadocURL(entry.getCodeNameBase().replace('.', '-'), javadocURLs);
    }
}

