/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class TemplateAttributesProvider
implements CreateFromTemplateAttributesProvider {
    private final NbModuleProject project;
    private final AntProjectHelper helper;
    private final boolean netbeansOrg;

    public TemplateAttributesProvider(NbModuleProject p, AntProjectHelper helper, boolean netbeansOrg) {
        this.project = p;
        this.helper = helper;
        this.netbeansOrg = netbeansOrg;
    }

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        EditableProperties props = this.helper.getProperties("nbproject/project.properties");
        String license = props.getProperty("project.license");
        if (license == null && this.netbeansOrg) {
            license = "cddl-netbeans-sun";
        }
        if (license == null && this.project != null) {
            try {
                SuiteProject sp = SuiteUtils.findSuite(this.project);
                if (sp != null) {
                    TemplateAttributesProvider tap = (TemplateAttributesProvider)sp.getLookup().lookup(TemplateAttributesProvider.class);
                    return tap.attributesFor(template, target, name);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        HashMap<String, String> values = new HashMap<String, String>();
        if (license != null) {
            values.put("license", license);
        }
        values.put("encoding", "UTF-8");
        return Collections.singletonMap("project", values);
    }
}

